/*
 * Decompiled with CFR 0.152.
 */
package com.treemap;

import com.macrofocus.common.geom.Dimension;
import com.macrofocus.geom.Rectangle;
import com.macrofocus.geom.Shape;
import com.macrofocus.igraphics.CPFont;
import com.macrofocus.labeling.EnhancedLabel;
import com.treemap.DefaultTreeMapTooltipRenderer;
import com.treemap.TreeMapField;
import com.treemap.TreeMapFieldSettings;
import com.treemap.TreeMapModel;
import com.treemap.TreeMapView;
import com.treemap.crossplatform.PreferredSize;
import com.treemap.crossplatform.TGraphics;
import java.util.concurrent.Future;

public class ToolTipTreeMapRenderer<C, N, Row, Column, Color, Font> {
    final EnhancedLabel<Color, Font> a = new EnhancedLabel();

    public ToolTipTreeMapRenderer() {
        this.a.setInsets(DefaultTreeMapTooltipRenderer.DEFAULT_BORDER.top, DefaultTreeMapTooltipRenderer.DEFAULT_BORDER.left, DefaultTreeMapTooltipRenderer.DEFAULT_BORDER.bottom, DefaultTreeMapTooltipRenderer.DEFAULT_BORDER.right);
    }

    public void paint(TGraphics<Color, Font> g2, TreeMapView<C, N, Row, Column, Color, Font> view, N node, int width, int leftShift, int topShift, Future progress) {
        Shape shape;
        TreeMapModel<N, Row, Column, Color, Font> treeMapModel = view.getModel();
        if (node != null && (shape = view.getRenderedShape(treeMapModel.getCurrentRoot())) != null) {
            this.drawToolTip(g2, view, treeMapModel, node, width, leftShift, topShift, true);
        }
    }

    public Rectangle drawToolTip(TGraphics<Color, Font> g2, TreeMapView<C, N, Row, Column, Color, Font> view, TreeMapModel<N, Row, Column, Color, Font> model, N node, int width, int leftShift, int topShift, boolean paint) {
        Rectangle rectangle = model.getSettings().getToolTipTreeMapFields();
        if (rectangle != null && ((TreeMapField<N, Column>[])rectangle).length >= 0) {
            CPFont cPFont;
            EnhancedLabel<Color, Font> enhancedLabel;
            Object object;
            int n2 = 0;
            for (TreeMapField<N, Column> treeMapField : rectangle) {
                if (!treeMapField.isValid()) continue;
                TreeMapFieldSettings<Color, Font> treeMapFieldSettings = view.getModel().getSettings().getFieldSettings(treeMapField);
                Rectangle rectangle2 = view.getTooltipRenderer().getTooltipRendererComponent(view, treeMapField, treeMapFieldSettings, node, new Dimension(width, 1000));
                if (rectangle2 == null) continue;
                object = treeMapFieldSettings.getTooltipFont();
                enhancedLabel = object.deriveFontWeight(CPFont.Weight.BOLD);
                rectangle2.setFont((CPFont)enhancedLabel);
                rectangle2.setForeground(treeMapFieldSettings.getTooltipForeground());
                rectangle2.setBackground(null);
                int n3 = width - 2 - 1;
                if (model.getSettings().getFieldSettings(treeMapField).getShowLabel() && model.getSettings().getFieldSettings(treeMapField).getTooltipRendering() == EnhancedLabel.Rendering.WordWrap) {
                    this.a.setFont((CPFont)object);
                    this.a.setForeground(treeMapFieldSettings.getTooltipForeground());
                    this.a.setBackground(null);
                    this.a.setText(treeMapField.getName() + ": ");
                    cPFont = view.getHeadless().sizeLabel(this.a, g2, n3, 1000).getPreferredSize();
                } else {
                    cPFont = new Dimension(0, 0);
                }
                PreferredSize preferredSize = view.getHeadless().sizeLabel((EnhancedLabel<Color, Font>)rectangle2, g2, n3 - cPFont.width, 1000);
                n2 = (int)((double)n2 + preferredSize.getPreferredHeight());
            }
            Rectangle rectangle3 = new Rectangle(0, 0, width, n2);
            if (n2 <= 0) {
                return null;
            }
            int n4 = rectangle3.y;
            for (Rectangle rectangle2 : rectangle) {
                Rectangle rectangle4;
                Dimension dimension;
                if (!rectangle2.isValid()) continue;
                object = view.getModel().getSettings().getFieldSettings((TreeMapField)rectangle2);
                enhancedLabel = view.getTooltipRenderer().getTooltipRendererComponent(view, (TreeMapField<N, Column>)rectangle2, (TreeMapFieldSettings<Color, Font>)object, node, new Dimension(width, 1000));
                if (enhancedLabel == null) continue;
                CPFont cPFont2 = object.getTooltipFont();
                cPFont = cPFont2.deriveFontWeight(CPFont.Weight.BOLD);
                enhancedLabel.setFont(cPFont);
                enhancedLabel.setForeground(object.getTooltipForeground());
                enhancedLabel.setBackground(null);
                int n5 = rectangle3.width - 2 - 1;
                if (model.getSettings().getFieldSettings((TreeMapField)rectangle2).getShowLabel()) {
                    this.a.setFont(cPFont2);
                    this.a.setForeground(object.getTooltipForeground());
                    this.a.setBackground(null);
                    this.a.setText(rectangle2.getName() + ": ");
                    dimension = view.getHeadless().sizeLabel(this.a, g2, n5, 1000).getPreferredSize();
                } else {
                    dimension = new Dimension(0, 0);
                }
                PreferredSize preferredSize = view.getHeadless().sizeLabel(enhancedLabel, g2, n5 - dimension.width, 1000);
                Dimension dimension2 = preferredSize.getPreferredSize();
                if (n4 + dimension2.height > rectangle3.y + rectangle3.height) break;
                int n6 = rectangle3.x + 2;
                if (model.getSettings().getFieldSettings((TreeMapField)rectangle2).getShowLabel()) {
                    rectangle4 = new Rectangle(n6, n4, dimension.width, dimension.height);
                    if (paint && g2 != null) {
                        g2.paintLabel(this.a, rectangle4.x, rectangle4.y, rectangle4.width, rectangle4.height);
                    }
                    if (model.isNumericType((TreeMapField<N, Column>)rectangle2)) {
                        n6 += dimension.width;
                        n5 -= dimension.width;
                    } else {
                        n6 += dimension.width;
                        n5 -= dimension.width;
                    }
                }
                rectangle4 = new Rectangle(n6, n4, n5, dimension2.height);
                if (paint && g2 != null) {
                    g2.paintLabel(enhancedLabel, rectangle4.x, rectangle4.y, rectangle4.width, rectangle4.height);
                }
                n4 += dimension2.height;
            }
            return rectangle3;
        }
        return null;
    }
}

