/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.crossplatform;

import com.macrofocus.common.geom.Dimension;
import com.macrofocus.geom.Rectangle;
import com.macrofocus.geom.Rectangle2D;
import com.macrofocus.geom.Shape;
import com.macrofocus.igraphics.CPFont;
import com.macrofocus.igraphics.CPImage;
import com.macrofocus.labeling.EnhancedLabel;
import com.treemap.crossplatform.PreferredSize;
import com.treemap.crossplatform.TGraphics;

public abstract class AbstractTGraphics<Color, Font>
implements TGraphics<Color, Font> {
    public static final float MINIMUM_FONT_SIZE_TO_DISPLAY = 5.0f;
    private Rectangle a = null;

    @Override
    public double fitTextInsideRectangle(EnhancedLabel<Color, Font> elabel, PreferredSize pf, CPFont<Font> font, Rectangle2D bounds, double scaleFactor, boolean expand) {
        double d2;
        double d3 = d2 = this.findMaxFontSize(elabel, font, elabel.getDesiredWidth().intValue()) * scaleFactor;
        CPFont cPFont = elabel.getFont().deriveFontSize(d3);
        elabel.setFont(cPFont);
        Dimension dimension = pf.getPreferredSize();
        double d4 = dimension.getHeight() - (double)elabel.getInsetTop().intValue() - (double)elabel.getInsetBottom().intValue();
        int n2 = 0;
        while (d4 > (double)elabel.getDesiredHeight().intValue() && n2 < 5) {
            Dimension dimension2;
            ++n2;
            double d5 = Math.sqrt((double)elabel.getDesiredHeight().intValue() / d4);
            double d6 = elabel.getFont().getSize2D() * d5;
            if (d6 > d2) {
                d6 = d2;
            }
            d3 = d6;
            double d7 = elabel.getFont().getSize2D();
            cPFont = elabel.getFont().deriveFontSize(d3);
            if (cPFont.getSize2D() == d7) break;
            elabel.setFont(cPFont);
            if (d3 < 5.0) break;
            dimension = dimension2 = pf.getPreferredSize();
            d4 = dimension.getHeight() - (double)elabel.getInsetTop().intValue() - (double)elabel.getInsetBottom().intValue();
        }
        return d3;
    }

    @Override
    public double findMaxFontSize(EnhancedLabel<Color, Font> elabel, CPFont<Font> font, double maxWidth) {
        double d2;
        this.setFont(font.getNativeFont());
        String[] stringArray = elabel.getText().split(" ");
        double d3 = 0.0;
        String string = null;
        for (String string2 : stringArray) {
            d2 = this.getStringWidth(string2);
            if (!(d2 > d3)) continue;
            string = string2;
            d3 = d2;
        }
        double d4 = maxWidth;
        double d5 = d2 = font.getSize2D() * d4 / d3;
        return d5;
    }

    @Override
    public boolean drawClippedImage(CPImage img, int x2, int y2, int w2, int h2, int width, int height, Rectangle bounds, Shape shape) {
        this.save();
        this.clip(shape);
        boolean bl = this.drawImage(img, x2, y2, w2, h2);
        this.restore();
        return bl;
    }

    @Override
    public void softClip(Shape shape) {
        if (shape instanceof Rectangle2D) {
            this.a = shape.getBounds();
        }
    }

    @Override
    public boolean hitClip(Rectangle bounds) {
        return this.a == null || this.a.intersects((Rectangle2D)bounds);
    }
}

