/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.treeplot;

import com.macrofocus.common.interval.BoundedInterval;
import com.macrofocus.common.interval.MutableBoundedInterval;
import com.macrofocus.common.interval.SimpleBoundedInterval;
import com.macrofocus.common.selection.MutableSingleSelection;
import com.macrofocus.common.selection.SelectionEvent;
import com.macrofocus.common.selection.SelectionListener;
import com.macrofocus.common.selection.SimpleSingleSelection;
import com.macrofocus.common.selection.SingleSelectionEvent;
import com.macrofocus.common.selection.SingleSelectionListener;
import com.macrofocus.filter.FilterEvent;
import com.macrofocus.filter.FilterListener;
import com.macrofocus.geom.AffineTransform;
import com.macrofocus.geom.Ellipse2D;
import com.macrofocus.geom.GeneralPath;
import com.macrofocus.geom.Point;
import com.macrofocus.geom.Point2D;
import com.macrofocus.geom.Rectangle;
import com.macrofocus.geom.Rectangle2D;
import com.macrofocus.geom.ScreenTransformHelper;
import com.macrofocus.geom.Shape;
import com.macrofocus.igraphics.CPColor;
import com.macrofocus.plot.guide.Guide;
import com.macrofocus.rubberband.RubberBand;
import com.macrofocus.rubberband.ScreenTransformRubberBand;
import com.macrofocus.transform.MutableOneDScreenTransform;
import com.macrofocus.transform.OneDScreenTransform;
import com.macrofocus.transform.ScreenTransformEvent;
import com.macrofocus.transform.ScreenTransformListener;
import com.macrofocus.transform.SimpleOneDScreenTransform;
import com.macrofocus.transform.twod.MutableTwoDScreenTransform;
import com.macrofocus.transform.twod.SimpleTwoDScreenTransform;
import com.macrofocus.transform.twod.TwoDScreenTransform;
import com.treemap.TreeMapEvent;
import com.treemap.TreeMapField;
import com.treemap.TreeMapListener;
import com.treemap.TreeMapToolTip;
import com.treemap.crossplatform.Headless;
import com.treemap.treeplot.DefaultTreePlotToolTip;
import com.treemap.treeplot.DefaultTreePlotTooltipRenderer;
import com.treemap.treeplot.GridTreePlotRenderer;
import com.treemap.treeplot.LeafNodeRenderer;
import com.treemap.treeplot.NodesTreePlotRenderer;
import com.treemap.treeplot.ParentNodeRenderer;
import com.treemap.treeplot.SelectionNodeRenderer;
import com.treemap.treeplot.TreePlotModel;
import com.treemap.treeplot.TreePlotRenderer;
import com.treemap.treeplot.TreePlotTooltipRenderer;
import com.treemap.treeplot.TreePlotView;
import java.awt.Color;
import java.awt.Paint;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractTreePlotView<C, N, Row, Column, Color, Font>
implements TreePlotView<C, N, Row, Column, Color, Font> {
    private final Headless<Color, Font> g;
    protected TreePlotModel<N, Row, Column, Color, Font> model;
    private MutableSingleSelection<TreePlotView.BoundingMode> h = new SimpleSingleSelection((Object)TreePlotView.BoundingMode.None);
    private TreePlotTooltipRenderer<C, N, Row, Column, Color, Font> i;
    protected TreeMapToolTip probingToolTip = null;
    protected TreeMapToolTip selectionToolTip = null;
    private final List<TreePlotRenderer> j;
    private final List<TreePlotRenderer> k;
    protected Guide<C, Color, Font> xGuide;
    protected Guide<C, Color, Font> yGuide;
    protected final MutableBoundedInterval xRangeModel;
    protected final MutableBoundedInterval yRangeModel;
    protected final MutableTwoDScreenTransform screenTransform;
    private RubberBand l;
    protected final Map<N, Shape> shapes = new HashMap<N, Shape>();
    private boolean m = false;
    private boolean n = true;
    private final SingleSelectionListener<TreeMapField<N, Column>> o = new SingleSelectionListener<TreeMapField<N, Column>>(){

        public void selectionChanged(SingleSelectionEvent<TreeMapField<N, Column>> event) {
            AbstractTreePlotView.this.resetXAxis();
        }
    };
    private final SingleSelectionListener<TreeMapField<N, Column>> p = new SingleSelectionListener<TreeMapField<N, Column>>(){

        public void selectionChanged(SingleSelectionEvent<TreeMapField<N, Column>> event) {
            AbstractTreePlotView.this.resetYAxis();
        }
    };
    private final TreeMapListener q = new TreeMapListener(){

        @Override
        public void tableModelChanged() {
        }

        @Override
        public void treeMapChanged(TreeMapEvent event) {
            if (event.isLayoutChanged() || event.isGroupByChanged()) {
                AbstractTreePlotView.this.resetXAxis();
                AbstractTreePlotView.this.resetYAxis();
            }
            if (event.isGroupByChanged() || event.isLayoutChanged()) {
                AbstractTreePlotView.this.setDirtyShapes();
            } else {
                AbstractTreePlotView.this.repaint();
            }
        }
    };
    final SingleSelectionListener<N> a = new SingleSelectionListener<N>(){

        public void selectionChanged(SingleSelectionEvent<N> event) {
            TreeMapToolTip treeMapToolTip = AbstractTreePlotView.this.getToolTip();
            if (treeMapToolTip != null) {
                Object object = AbstractTreePlotView.this.getModel().getProbing().getSelected();
                AbstractTreePlotView.this.probingToolTip.showNode(object);
            }
            AbstractTreePlotView.this.repaint();
        }
    };
    final SelectionListener<N> b = new SelectionListener<N>(){

        public void selectionChanged(SelectionEvent<N> event) {
            AbstractTreePlotView.this.repaint();
        }
    };
    final SelectionListener<N> c = new SelectionListener<N>(){

        public void selectionChanged(SelectionEvent<N> event) {
            TreeMapToolTip treeMapToolTip = AbstractTreePlotView.this.getSelectionToolTip();
            if (treeMapToolTip != null) {
                if (AbstractTreePlotView.this.getModel().getSelection() != null && AbstractTreePlotView.this.getModel().getSelection().getSelectedCount() == 1) {
                    Object object = AbstractTreePlotView.this.getModel().getSelection().getSelectedSet().toArray()[0];
                    AbstractTreePlotView.this.selectionToolTip.showNode(object);
                } else {
                    AbstractTreePlotView.this.selectionToolTip.showNode(null);
                }
            }
            AbstractTreePlotView.this.repaint();
        }
    };
    private final FilterListener<N> r = new FilterListener<N>(){

        public void filterChanged(FilterEvent event) {
            AbstractTreePlotView.this.repaint(10L);
        }
    };
    private final PropertyChangeListener s = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            AbstractTreePlotView.this.resetXAxis();
            AbstractTreePlotView.this.resetYAxis();
            AbstractTreePlotView.this.setDirty(true);
            AbstractTreePlotView.this.repaint();
        }
    };
    private final PropertyChangeListener t = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            AbstractTreePlotView.this.setDirty(true);
        }
    };
    final PropertyChangeListener d = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            AbstractTreePlotView.this.setBackground(AbstractTreePlotView.this.model.getSettings().getBackground());
        }
    };
    final PropertyChangeListener e = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            AbstractTreePlotView.this.repaint();
        }
    };
    final PropertyChangeListener f = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            AbstractTreePlotView.this.setDirtyShapes();
        }
    };

    public AbstractTreePlotView(Headless<Color, Font> headless) {
        this.g = headless;
        this.probingToolTip = new DefaultTreePlotToolTip(this);
        this.selectionToolTip = null;
        this.i = new DefaultTreePlotTooltipRenderer();
        this.j = new ArrayList<TreePlotRenderer>();
        this.k = new ArrayList<TreePlotRenderer>();
        this.j.add(new GridTreePlotRenderer());
        this.j.add(new NodesTreePlotRenderer(new ParentNodeRenderer()));
        this.j.add(new NodesTreePlotRenderer(new LeafNodeRenderer()));
        this.k.add(new NodesTreePlotRenderer(new SelectionNodeRenderer()));
        this.xRangeModel = new SimpleBoundedInterval(0.0, 1.0, 0.0, 1.0);
        this.yRangeModel = new SimpleBoundedInterval(0.0, 1.0, 0.0, 1.0);
        int n2 = 0;
        int n3 = 0;
        this.screenTransform = new SimpleTwoDScreenTransform((MutableOneDScreenTransform)new SimpleOneDScreenTransform((BoundedInterval)this.xRangeModel, n2), (MutableOneDScreenTransform)new SimpleOneDScreenTransform((BoundedInterval)this.yRangeModel, n3, true, false), n2, n3, 1.0);
        this.l = new ScreenTransformRubberBand((TwoDScreenTransform)this.screenTransform);
        this.l.getRubberBand().addSingleSelectionListener((SingleSelectionListener)new SingleSelectionListener<Rectangle2D>(){

            public void selectionChanged(SingleSelectionEvent<Rectangle2D> event) {
                AbstractTreePlotView.this.repaint();
            }
        });
        this.screenTransform.addScreenTransformListener(new ScreenTransformListener(){

            public void transformChanged(ScreenTransformEvent event) {
                AbstractTreePlotView.this.setDirtyShapes();
                AbstractTreePlotView.this.repaint();
            }
        });
        this.h.addSingleSelectionListener((SingleSelectionListener)new SingleSelectionListener<TreePlotView.BoundingMode>(){

            public void selectionChanged(SingleSelectionEvent<TreePlotView.BoundingMode> boundingModeSingleSelectionEvent) {
                AbstractTreePlotView.this.setDirtyShapes();
            }
        });
    }

    @Override
    public TreePlotModel<N, Row, Column, Color, Font> getModel() {
        return this.model;
    }

    @Override
    public Paint getPaint(N node, Shape shape, Rectangle bounds, boolean allowGradientPaint) {
        CPColor<Color> cPColor = this.model.getColor(node);
        if (cPColor != null) {
            return new Color(cPColor.getRGB());
        }
        return null;
    }

    @Override
    public Guide<C, Color, Font> getXGuide() {
        return this.xGuide;
    }

    @Override
    public Guide<C, Color, Font> getYGuide() {
        return this.yGuide;
    }

    @Override
    public MutableBoundedInterval getXRangeModel() {
        return this.xRangeModel;
    }

    @Override
    public MutableBoundedInterval getYRangeModel() {
        return this.yRangeModel;
    }

    @Override
    public MutableOneDScreenTransform getXCoordinateAxis() {
        return this.screenTransform.getX();
    }

    @Override
    public MutableOneDScreenTransform getYCoordinateAxis() {
        return this.screenTransform.getY();
    }

    @Override
    public void zoom(double x1, double x2, double y1, double y2) {
        this.getXRangeModel().setValue(x1, x2 - x1);
        this.getYRangeModel().setValue(y1, y2 - y1);
    }

    protected void resetXAxis() {
        Double d2;
        Double d3;
        if (this.model.getSettings().getGroupBy().booleanValue()) {
            if (this.model.getXVariable().getSelected() instanceof TreeMapField) {
                d3 = this.model.getNumericMin((TreeMapField)this.model.getXVariable().getSelected(), this.model.getCurrentRoot());
                d2 = this.model.getNumericMax((TreeMapField)this.model.getXVariable().getSelected(), this.model.getCurrentRoot());
            } else {
                d3 = null;
                d2 = null;
            }
        } else {
            d3 = this.model.getNumericMin((TreeMapField)this.model.getXVariable().getSelected());
            d2 = this.model.getNumericMax((TreeMapField)this.model.getXVariable().getSelected());
        }
        if (d3 != null && d2 != null) {
            double d4 = d2 - d3;
            double d5 = d4 <= 0.0 ? 1.05 : d4 * 0.05;
            d3 = d3 - d5;
            d2 = d2 + d5;
            this.xRangeModel.setMinMax(d3.doubleValue(), d2.doubleValue());
            this.xRangeModel.setValue(d3.doubleValue(), d2 - d3);
            this.setDirty(true);
        }
    }

    protected void resetYAxis() {
        Double d2;
        Double d3;
        if (this.model.getSettings().getGroupBy().booleanValue()) {
            if (this.model.getYVariable().getSelected() instanceof TreeMapField) {
                d3 = this.model.getNumericMin((TreeMapField)this.model.getYVariable().getSelected(), this.model.getCurrentRoot());
                d2 = this.model.getNumericMax((TreeMapField)this.model.getYVariable().getSelected(), this.model.getCurrentRoot());
            } else {
                d3 = null;
                d2 = null;
            }
        } else {
            d3 = this.model.getNumericMin((TreeMapField)this.model.getYVariable().getSelected());
            d2 = this.model.getNumericMax((TreeMapField)this.model.getYVariable().getSelected());
        }
        if (d3 != null && d2 != null) {
            double d4 = d2 - d3;
            double d5 = d4 <= 0.0 ? 1.05 : d4 * 0.05;
            d3 = d3 - d5;
            d2 = d2 + d5;
            this.yRangeModel.setMinMax(d3.doubleValue(), d2.doubleValue());
            this.yRangeModel.setValue(d3.doubleValue(), d2 - d3);
            this.setDirty(true);
        }
    }

    @Override
    public float getZoomFactor() {
        float f2 = (float)((this.xRangeModel.getMaximum() - this.xRangeModel.getMinimum()) / this.xRangeModel.getExtent());
        float f3 = (float)((this.yRangeModel.getMaximum() - this.yRangeModel.getMinimum()) / this.yRangeModel.getExtent());
        return Math.min(f2, f3);
    }

    @Override
    public boolean isShowTiming() {
        return this.m;
    }

    @Override
    public void setShowTiming(boolean showTiming) {
        this.m = showTiming;
        this.repaint();
    }

    @Override
    public void setModel(TreePlotModel<N, Row, Column, Color, Font> model) {
        if (this.model != null) {
            model.getSettings().removePropertyChangeListener("tooltipBackground", this.d);
            this.model.getTreeMapModel().removeListener(this.q);
            this.model.getSelection().removeSelectionListener(this.c);
            this.model.getProbing().removeSingleSelectionListener(this.a);
            this.model.getHighlighting().removeSelectionListener(this.b);
            this.model.getFilter().removeFilterListener(this.r);
            this.model.getSearch().removeFilterListener(this.r);
            model.getXVariable().removeSingleSelectionListener(this.o);
            model.getYVariable().removeSingleSelectionListener(this.p);
            model.getSettings().removePropertyChangeListener("sizeField", this.t);
            model.getSettings().removePropertyChangeListener("colorField", this.t);
            model.getSettings().removePropertyChangeListener("gridColor", this.e);
            model.getSettings().removePropertyChangeListener("gridThickness", this.e);
            model.getSettings().removePropertyChangeListener("groupBy", this.s);
            model.getSettings().removePropertyChangeListener("bubbleSize", this.f);
        }
        this.model = model;
        if (this.model != null) {
            model.getSettings().addPropertyChangeListener("background", this.d);
            this.setBackground(model.getSettings().getBackground());
            model.getTreeMapModel().addListener(this.q);
            model.getSelection().addSelectionListener(this.c);
            model.getProbing().addSingleSelectionListener(this.a);
            model.getHighlighting().addSelectionListener(this.b);
            model.getFilter().addFilterListener(this.r);
            model.getSearch().addFilterListener(this.r);
            model.getXVariable().addSingleSelectionListener(this.o);
            model.getYVariable().addSingleSelectionListener(this.p);
            model.getSettings().addPropertyChangeListener("sizeField", this.t);
            model.getSettings().addPropertyChangeListener("colorField", this.t);
            model.getSettings().addPropertyChangeListener("gridColor", this.e);
            model.getSettings().addPropertyChangeListener("gridThickness", this.e);
            model.getSettings().addPropertyChangeListener("groupBy", this.s);
            model.getSettings().addPropertyChangeListener("bubbleSize", this.f);
        }
        this.resetXAxis();
        this.resetYAxis();
    }

    @Override
    public TreePlotTooltipRenderer<C, N, Row, Column, Color, Font> getTooltipRenderer() {
        return this.i;
    }

    @Override
    public synchronized Point getToolTipPreferredLocation(N node) {
        TreeMapToolTip<N, Row, Column, Color, Font> treeMapToolTip = this.getToolTip();
        N n2 = treeMapToolTip.getNode();
        treeMapToolTip.setNode(node);
        Point point = treeMapToolTip.getPreferredLocation();
        treeMapToolTip.setNode(n2);
        return point;
    }

    @Override
    public void addProgressiveRenderer(TreePlotRenderer renderer) {
        this.j.add(renderer);
        this.setDirty(true);
    }

    @Override
    public void addRenderer(TreePlotRenderer renderer) {
        this.k.add(renderer);
        this.repaint();
    }

    @Override
    public List<TreePlotRenderer> getProgressiveRenderers() {
        return this.j;
    }

    @Override
    public List<TreePlotRenderer> getRenderers() {
        return this.k;
    }

    @Override
    public Shape getScreenShape(N node) {
        Shape shape = this.shapes.get(node);
        if (shape == null) {
            TreeMapField treeMapField = (TreeMapField)this.model.getXVariable().getSelected();
            TreeMapField treeMapField2 = (TreeMapField)this.model.getYVariable().getSelected();
            if (treeMapField != null && treeMapField2 != null && treeMapField.isValid() && (this.model.isNumericType(treeMapField) || this.model.isTemporalType(treeMapField)) && treeMapField2.isValid() && (this.model.isNumericType(treeMapField2) || this.model.isTemporalType(treeMapField2))) {
                if (this.model.isLeaf(node) || this.model.getSettings().getGroupBy().booleanValue()) {
                    return this.getLeafScreenShape(node);
                }
                switch ((TreePlotView.BoundingMode)((Object)this.getBoundingMode().getSelected())) {
                    case MEC: {
                        Ellipse2D ellipse2D = this.model.getMEC(node, treeMapField, treeMapField2);
                        if (ellipse2D != null) {
                            double d2 = ellipse2D.getMinX();
                            double d3 = ellipse2D.getMaxX();
                            double d4 = ellipse2D.getMinY();
                            double d5 = ellipse2D.getMaxY();
                            int n2 = this.getXCoordinateAxis().worldToScreen(d2);
                            int n3 = this.getYCoordinateAxis().worldToScreen(d4);
                            int n4 = this.getXCoordinateAxis().worldToScreen(d3);
                            int n5 = this.getYCoordinateAxis().worldToScreen(d5);
                            Ellipse2D.Double double_ = new Ellipse2D.Double((double)n2, (double)n5, (double)(n4 - n2), (double)(n3 - n5));
                            shape = double_;
                            break;
                        }
                        shape = null;
                        break;
                    }
                    case CH: {
                        GeneralPath generalPath = this.model.getCH(node, treeMapField, treeMapField2);
                        AffineTransform affineTransform = ScreenTransformHelper.worldToScreen((OneDScreenTransform)this.screenTransform.getX(), (OneDScreenTransform)this.screenTransform.getY());
                        shape = generalPath.createTransformedShape(affineTransform);
                        break;
                    }
                    default: {
                        shape = null;
                        break;
                    }
                }
            } else {
                shape = null;
            }
            this.shapes.put(node, shape);
        }
        return shape;
    }

    public Shape getLeafScreenShape(N node) {
        Object object = this.shapes.get(node);
        if (object == null) {
            TreeMapField treeMapField = (TreeMapField)this.model.getXVariable().getSelected();
            TreeMapField treeMapField2 = (TreeMapField)this.model.getYVariable().getSelected();
            if (treeMapField != null && treeMapField2 != null && treeMapField.isValid() && (this.getModel().isNumericType(treeMapField) || this.getModel().isTemporalType(treeMapField)) && treeMapField2.isValid() && (this.getModel().isNumericType(treeMapField) || this.getModel().isTemporalType(treeMapField))) {
                if (this.model.isLeaf(node) && !this.model.getSettings().getGroupBy().booleanValue() || this.model.getSettings().getGroupBy().booleanValue() && this.model.getParent(node) == this.model.getCurrentRoot()) {
                    Object object2 = this.model.getAggregateValue(node, treeMapField);
                    Object object3 = this.model.getAggregateValue(node, treeMapField2);
                    Number number = object2 instanceof Number ? (Number)((Number)object2) : (Number)(object2 instanceof Date ? Long.valueOf(((Date)object2).getTime()) : null);
                    Number number2 = object3 instanceof Number ? (Number)((Number)object3) : (Number)(object3 instanceof Date ? Long.valueOf(((Date)object3).getTime()) : null);
                    if (number != null && number2 != null) {
                        Rectangle2D.Double double_;
                        int n2 = this.screenTransform.getX().worldToScreen(number.doubleValue());
                        int n3 = this.screenTransform.getY().worldToScreen(number2.doubleValue());
                        TreeMapField treeMapField3 = this.model.getSettings().getSizeTreeMapField();
                        if (treeMapField3.isValid()) {
                            double d2 = this.model.getSize(node);
                            if (!Double.isInfinite(d2) && !Double.isNaN(d2) && d2 > 0.0) {
                                double d3;
                                double d4;
                                if (this.model.getSettings().getGroupBy().booleanValue()) {
                                    d4 = 0.0;
                                    d3 = this.model.getMaximumSize(this.model.getCurrentRoot());
                                } else {
                                    d4 = 0.0;
                                    d3 = this.model.getMaximumSize();
                                }
                                double d5 = d3 - d4;
                                if (d5 > 0.0) {
                                    double d6 = Math.sqrt(d3 / Math.PI);
                                    double d7 = Math.sqrt(d2 / Math.PI);
                                    if (d7 > 0.0 && !Double.isInfinite(d7) && !Double.isNaN(d7)) {
                                        double d8 = d7 / d6 * (this.model.getSettings().getBubbleSizeInterval().getEnd() * (double)Math.min(this.screenTransform.getScreenWidth(), this.screenTransform.getScreenHeight())) * (double)this.getZoomFactor();
                                        double d9 = Math.max(1.0, d8);
                                        double d10 = Math.max(1.0, d8);
                                        double_ = new Rectangle2D.Double((double)n2 - d9 / 2.0, (double)n3 - d9 / 2.0, d9, d10);
                                    } else {
                                        double_ = null;
                                    }
                                } else {
                                    double d11 = this.model.getSettings().getBubbleSizeInterval().getEnd() * (double)Math.min(this.screenTransform.getScreenWidth(), this.screenTransform.getScreenHeight()) * (double)this.getZoomFactor();
                                    double d12 = Math.max(1.0, d11);
                                    double d13 = Math.max(1.0, d11);
                                    double_ = new Rectangle2D.Double((double)n2 - d12 / 2.0, (double)n3 - d12 / 2.0, d12, d13);
                                }
                            } else {
                                double_ = null;
                            }
                        } else {
                            double d14 = this.model.getSettings().getBubbleSizeInterval().getEnd() * (double)Math.min(this.screenTransform.getScreenWidth(), this.screenTransform.getScreenHeight()) * (double)this.getZoomFactor();
                            double d15 = Math.max(1.0, d14);
                            double d16 = Math.max(1.0, d14);
                            double_ = new Rectangle2D.Double((double)n2 - d15 / 2.0, (double)n3 - d15 / 2.0, d15, d16);
                        }
                        object = double_ != null ? new Ellipse2D.Double(double_.getX(), double_.getY(), double_.getWidth(), double_.getHeight()) : null;
                    } else {
                        object = null;
                    }
                } else {
                    object = null;
                }
            } else {
                object = null;
            }
            this.shapes.put(node, (Shape)object);
        }
        return object;
    }

    @Override
    public Shape getRenderedShape(N node) {
        return this.getScreenShape(node);
    }

    @Override
    public Rectangle getScreenBounds(N node) {
        Shape shape = this.getScreenShape(node);
        if (shape != null) {
            Rectangle2D rectangle2D = shape.getBounds2D();
            return new Rectangle((int)rectangle2D.getX(), (int)rectangle2D.getY(), (int)rectangle2D.getWidth(), (int)rectangle2D.getHeight());
        }
        return null;
    }

    @Override
    public N getNode(Point p2) {
        block6: {
            N n2;
            if (this.model == null || p2 == null || (n2 = this.model.getCurrentRoot()) == null) break block6;
            if (this.getModel().getSettings().getGroupBy().booleanValue()) {
                Shape shape;
                for (N n3 : this.model.getChildren(n2)) {
                    shape = this.getScreenShape(n3);
                    if (shape == null || !shape.contains((Point2D)new Point2D.Double(p2.getX(), p2.getY()))) continue;
                    return n3;
                }
                for (N n3 : this.model.getChildren(n2)) {
                    shape = this.getScreenBounds(n3);
                    if (shape == null || !(shape = new Rectangle(shape.x - 2, shape.y - 2, shape.width + 4, shape.height + 4)).contains(p2.getX(), p2.getY())) continue;
                    return n3;
                }
            } else {
                Shape shape;
                for (N n4 : this.model.depthFirstIterator(n2)) {
                    if (!this.model.isLeaf(n4) || (shape = this.getScreenShape(n4)) == null || !shape.contains((Point2D)new Point2D.Double(p2.getX(), p2.getY()))) continue;
                    return n4;
                }
                for (N n4 : this.model.depthFirstIterator(n2)) {
                    if (!this.model.isLeaf(n4) || (shape = this.getScreenBounds(n4)) == null || !(shape = new Rectangle(shape.x - 2, shape.y - 2, shape.width + 4, shape.height + 4)).contains(p2.getX(), p2.getY())) continue;
                    return n4;
                }
            }
        }
        return null;
    }

    @Override
    public List<N> getNodes(Rectangle rect) {
        if (this.model != null && rect != null) {
            ArrayList<N> arrayList = new ArrayList<N>();
            N n2 = this.model.getCurrentRoot();
            if (this.getModel().getSettings().getGroupBy().booleanValue()) {
                for (N n3 : this.model.getChildren(n2)) {
                    Shape shape = this.getScreenShape(n3);
                    if (shape == null || !shape.intersects((Rectangle2D)rect)) continue;
                    arrayList.add(n3);
                }
                return arrayList;
            }
            Shape shape = this.getScreenShape(n2);
            if (shape != null && shape.intersects((Rectangle2D)rect) && this.model.isLeaf(n2)) {
                arrayList.add(n2);
            }
            this.a(n2, rect, arrayList);
            return arrayList;
        }
        return null;
    }

    private N a(N n2, Rectangle rectangle, List<N> list) {
        for (N n3 : this.model.getChildren(n2)) {
            Shape shape = this.getScreenShape(n3);
            if (shape != null && shape.intersects((Rectangle2D)rectangle) && this.model.isLeaf(n3)) {
                list.add(n3);
            }
            this.a(n3, rectangle, list);
        }
        return n2;
    }

    @Override
    public void setDirty(boolean dirty) {
        this.n = dirty;
    }

    @Override
    public boolean isDirty() {
        return this.n;
    }

    @Override
    public void setDirtyShapes() {
        this.n = true;
        this.shapes.clear();
        this.repaint();
    }

    @Override
    public TreeMapToolTip<N, Row, Column, Color, Font> getToolTip() {
        return this.probingToolTip;
    }

    @Override
    public void setToolTip(TreeMapToolTip<N, Row, Column, Color, Font> tooltip) {
        if (this.probingToolTip != tooltip) {
            this.probingToolTip = tooltip;
            this.repaint();
        }
    }

    @Override
    public TreeMapToolTip<N, Row, Column, Color, Font> getSelectionToolTip() {
        return this.selectionToolTip;
    }

    @Override
    public void setSelectionToolTip(TreeMapToolTip<N, Row, Column, Color, Font> tooltip) {
        if (this.selectionToolTip != tooltip) {
            this.selectionToolTip = tooltip;
            this.repaint();
        }
    }

    @Override
    public void repaint() {
        this.repaint(0L);
    }

    protected abstract void repaint(long var1);

    protected abstract void setBackground(CPColor<Color> var1);

    @Override
    public RubberBand getRubberBand() {
        return this.l;
    }

    @Override
    public Headless<Color, Font> getHeadless() {
        return this.g;
    }

    @Override
    public MutableSingleSelection<TreePlotView.BoundingMode> getBoundingMode() {
        return this.h;
    }

    public Rectangle2D getWorld() {
        return Rectangle2D.Double.frameFromDiagonal((double)this.xRangeModel.getMinimum(), (double)this.yRangeModel.getMinimum(), (double)this.xRangeModel.getMaximum(), (double)this.yRangeModel.getMaximum());
    }

    @Override
    public void drill(int x2, int y2) {
        N n2;
        TreePlotModel<N, Row, Column, Color, Font> treePlotModel = this.getModel();
        N n3 = treePlotModel.getCurrentRoot();
        treePlotModel.getProbing().clearSelection();
        Point point = new Point(x2, y2);
        if (point != null && (n2 = this.getNode(point)) != null) {
            if (treePlotModel.hasNoChildren(n2)) {
                MutableBoundedInterval mutableBoundedInterval = this.getXRangeModel();
                MutableBoundedInterval mutableBoundedInterval2 = this.getYRangeModel();
                this.zoom(mutableBoundedInterval.getMinimum(), mutableBoundedInterval.getMaximum(), mutableBoundedInterval2.getMinimum(), mutableBoundedInterval2.getMaximum());
                treePlotModel.setCurrentRoot(treePlotModel.getRoot());
            } else {
                MutableBoundedInterval mutableBoundedInterval = this.getXRangeModel();
                MutableBoundedInterval mutableBoundedInterval3 = this.getYRangeModel();
                this.zoom(mutableBoundedInterval.getMinimum(), mutableBoundedInterval.getMaximum(), mutableBoundedInterval3.getMinimum(), mutableBoundedInterval3.getMaximum());
                treePlotModel.setCurrentRoot(n2);
            }
        }
    }

    @Override
    public void drillDown() {
        TreePlotModel<Object, Row, Column, Color, Font> treePlotModel = this.getModel();
        Object object = treePlotModel.getProbing().getSelected();
        if (object != null) {
            while (treePlotModel.getParent(object) != treePlotModel.getCurrentRoot() && (object = treePlotModel.getParent(object)) != null) {
            }
        }
        if (object != null && !treePlotModel.hasNoChildren(object)) {
            MutableBoundedInterval mutableBoundedInterval = this.getXRangeModel();
            MutableBoundedInterval mutableBoundedInterval2 = this.getYRangeModel();
            this.zoom(mutableBoundedInterval.getMinimum(), mutableBoundedInterval.getMaximum(), mutableBoundedInterval2.getMinimum(), mutableBoundedInterval2.getMaximum());
            treePlotModel.setCurrentRoot(object);
        }
    }

    @Override
    public void drillUp() {
        TreePlotModel<N, Row, Column, Color, Font> treePlotModel = this.getModel();
        treePlotModel.getProbing().clearSelection();
        if (!treePlotModel.isRoot(treePlotModel.getCurrentRoot())) {
            MutableBoundedInterval mutableBoundedInterval = this.getXRangeModel();
            MutableBoundedInterval mutableBoundedInterval2 = this.getYRangeModel();
            this.zoom(mutableBoundedInterval.getMinimum(), mutableBoundedInterval.getMaximum(), mutableBoundedInterval2.getMinimum(), mutableBoundedInterval2.getMaximum());
            N n2 = treePlotModel.getParent(treePlotModel.getCurrentRoot());
            treePlotModel.setCurrentRoot(n2);
        }
    }

    @Override
    public void zoomIn() {
        TreePlotModel<Object, Row, Column, Color, Font> treePlotModel = this.getModel();
        Object object = treePlotModel.getProbing().getSelected();
        if (object != null) {
            while (treePlotModel.getParent(object) != treePlotModel.getCurrentRoot() && (object = treePlotModel.getParent(object)) != null) {
            }
        }
        if (object != null && !treePlotModel.hasNoChildren(object)) {
            Rectangle rectangle = this.getScreenBounds(object);
            Rectangle2D rectangle2D = this.getWorld();
            double d2 = rectangle.getWidth();
            double d3 = rectangle.getHeight();
            double d4 = d2 / rectangle2D.getWidth();
            double d5 = d3 / rectangle2D.getHeight();
            double d6 = Math.max(d4, d5);
            d2 = d6 * rectangle2D.getWidth();
            d3 = d6 * rectangle2D.getHeight();
            double d7 = rectangle.getX();
            double d8 = d7 + d2;
            double d9 = rectangle2D.getMaxY() - (rectangle.getY() + d3);
            double d10 = rectangle2D.getMaxY() - rectangle.getY();
            if (d7 < rectangle2D.getMinX()) {
                d7 = rectangle2D.getMinX();
                d8 = d7 + d2;
            }
            if (d8 > rectangle2D.getMaxX()) {
                d7 = rectangle2D.getMaxX() - d2;
                d8 = rectangle2D.getMaxX();
            }
            if (d9 < rectangle2D.getMinY()) {
                d9 = rectangle2D.getMinY();
                d10 = d9 + d3;
            }
            if (d10 > rectangle2D.getMaxY()) {
                d9 = rectangle2D.getMaxY() - d3;
                d10 = rectangle2D.getMaxY();
            }
            this.zoom(d7, d8, d9, d10);
        }
    }

    @Override
    public void zoomOut() {
        MutableBoundedInterval mutableBoundedInterval = this.getXRangeModel();
        MutableBoundedInterval mutableBoundedInterval2 = this.getYRangeModel();
        this.zoom(mutableBoundedInterval.getMinimum(), mutableBoundedInterval.getMaximum(), mutableBoundedInterval2.getMinimum(), mutableBoundedInterval2.getMaximum());
    }
}

