/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.treeplot;

import com.macrofocus.geom.Rectangle;
import com.macrofocus.geom.Shape;
import com.treemap.crossplatform.TGraphics;
import com.treemap.treeplot.NodeRenderer;
import com.treemap.treeplot.TreePlotView;
import java.awt.Paint;

public class ParentNodeRenderer<N, Row, Column, Component, Color, Font>
implements NodeRenderer<N, Row, Column, Component, Color, Font> {
    @Override
    public void paintNode(TGraphics<Color, Font> g2, TreePlotView<Component, N, Row, Column, Color, Font> view, N node, Rectangle bounds, Shape shape, boolean useGradientPaint) {
        if (!view.getModel().isLeaf(node)) {
            if (!view.getModel().getSettings().getGroupBy().booleanValue()) {
                if (shape != null) {
                    if (view.getModel().getHighlighting().isSelected(node)) {
                        g2.save();
                        g2.setFill(view.getModel().getColor(node));
                        g2.setGlobalAlpha(0.5);
                        g2.fill(shape);
                        g2.setStroke(view.getModel().getColor(node));
                        g2.stroke(shape);
                        g2.restore();
                    } else {
                        g2.stroke(shape);
                    }
                }
            } else if (shape != null && !view.getModel().getFilter().isFiltered(node)) {
                if (useGradientPaint) {
                    Paint paint = view.getPaint(node, shape, bounds, useGradientPaint);
                    if (paint != null) {
                        g2.setPaint(paint);
                        g2.fill(shape);
                    } else {
                        g2.setFill(view.getModel().getColor(node));
                        g2.fill(shape);
                    }
                } else {
                    g2.setFill(view.getModel().getColor(node));
                    g2.fill(shape);
                }
            }
        }
    }
}

