/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.treeplot;

import java.util.Vector;

public final class Spoint {
    public final double x;
    public final double y;
    public Spoint next;
    public Spoint prev;
    private Spoint a;
    private Spoint b;
    private Spoint c;
    public Spoint chnext;
    public Spoint chprev;
    private Spoint d;
    private Vector e;
    private long f;
    private Vector g;
    private long h;

    public Spoint(double inx, double iny) {
        this.x = inx;
        this.y = iny;
        this.chnext = null;
        this.chprev = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.prev = null;
        this.next = null;
        this.e = null;
        this.g = null;
        this.f = 0L;
        this.h = 0L;
        this.d = null;
    }

    public boolean Insert(Spoint who) {
        if (who.x < this.x) {
            if (this.a == null) {
                this.a = who;
                who.c = this;
                who.prev = this.prev;
                who.next = this;
                this.prev = who;
                if (who.prev != null) {
                    who.prev.next = who;
                }
            } else {
                this.a.Insert(who);
            }
        } else if (this.b == null) {
            this.b = who;
            who.c = this;
            who.prev = this;
            who.next = this.next;
            this.next = who;
            if (who.next != null) {
                who.next.prev = who;
            }
        } else {
            this.b.Insert(who);
        }
        return true;
    }

    public Spoint VirtualInsert(Spoint who) {
        Spoint spoint = this;
        Spoint spoint2 = this;
        while (spoint2 != null) {
            spoint = spoint2;
            if (who.x < spoint2.x) {
                spoint2 = spoint2.a;
                continue;
            }
            spoint2 = spoint2.b;
        }
        return spoint;
    }

    public Spoint Delete() {
        Spoint spoint;
        if (this.a == null && this.b == null) {
            if (this.c != null) {
                if (this.c.a == this) {
                    this.c.a = null;
                } else {
                    this.c.b = null;
                }
            }
            spoint = null;
        } else if (this.a != null && this.b != null) {
            Spoint spoint2 = spoint = this.x <= this.y ? this.prev : this.next;
            if (this.c != null) {
                if (this.c.a == this) {
                    this.c.a = spoint;
                } else {
                    this.c.b = spoint;
                }
            }
            if (spoint.c.a == spoint) {
                spoint.c.a = null;
            } else {
                spoint.c.b = null;
            }
            this.a.c = spoint;
            this.b.c = spoint;
            spoint.c = this.c;
            spoint.a = this.a;
            spoint.b = this.b;
        } else {
            Spoint spoint3 = spoint = this.b != null ? this.b : this.a;
            if (this.c != null) {
                if (this.c.a == this) {
                    this.c.a = spoint;
                } else {
                    this.c.b = spoint;
                }
            }
            spoint.c = this.c;
        }
        if (this.prev != null) {
            this.prev.next = this.next;
        }
        if (this.next != null) {
            this.next.prev = this.prev;
        }
        this.b = null;
        this.a = null;
        this.c = null;
        this.prev = null;
        this.next = null;
        return spoint;
    }

    public void AddClosest(Spoint who, long col) {
        if (this.e == null || this.f != col) {
            this.e = new Vector(6);
            this.f = col;
        }
        this.e.addElement(who);
    }

    void a(Spoint spoint) {
        if (this.e == null) {
            this.e = new Vector(6);
        }
        this.e.addElement(spoint);
    }

    void a() {
        if (this.d != null) {
            this.d.e.removeElement(this);
        }
        this.d = this.b();
        if (this.d != null) {
            this.d.a(this);
        }
    }

    public void NNDelete() {
        if (this.d != null) {
            this.d.e.removeElement(this);
        }
        if (this.e != null) {
            while (this.e.size() > 0) {
                Spoint spoint = (Spoint)this.e.firstElement();
                spoint.a();
            }
        }
        this.d = null;
        this.e = null;
        this.f = 0L;
    }

    public void AddSpheresLink(Spoint who, long col) {
        if (this.g == null || this.h != col) {
            this.g = new Vector(10, 10);
            this.h = col;
        }
        this.g.addElement(who);
    }

    public void AddSpheresLink(Spoint who) {
        if (this.g == null) {
            this.g = new Vector(10, 10);
        }
        this.g.addElement(who);
    }

    Spoint b() {
        Spoint spoint;
        Spoint spoint2 = spoint = this.prev != null ? this.prev : this.next;
        if (spoint == null) {
            return null;
        }
        Spoint spoint3 = this.prev;
        Spoint spoint4 = this.next;
        double d2 = this.b(spoint);
        while (spoint3 != null || spoint4 != null) {
            double d3;
            if (spoint3 != null) {
                d3 = this.b(spoint3);
                if (d3 < d2) {
                    d2 = d3;
                    spoint = spoint3;
                }
                Spoint spoint5 = spoint3 = (this.x - spoint3.x) * (this.x - spoint3.x) < d2 ? spoint3.prev : null;
            }
            if (spoint4 == null) continue;
            d3 = this.b(spoint4);
            if (d3 < d2) {
                d2 = d3;
                spoint = spoint4;
            }
            spoint4 = (this.x - spoint4.x) * (this.x - spoint4.x) < d2 ? spoint4.next : null;
        }
        return spoint;
    }

    double b(Spoint spoint) {
        return (spoint.x - this.x) * (spoint.x - this.x) + (spoint.y - this.y) * (spoint.y - this.y);
    }

    public double distance(Spoint other) {
        return Math.sqrt(this.b(other));
    }

    public Spoint add(Spoint other) {
        return new Spoint(this.x + other.x, this.y + other.y);
    }

    public Spoint subtract(Spoint other) {
        return new Spoint(this.x - other.x, this.y - other.y);
    }

    public String toString() {
        return this.x + "," + this.y;
    }

    double c() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public Spoint scale(double byWhat) {
        return new Spoint(byWhat * this.x, byWhat * this.y);
    }

    public Spoint NormalRight() {
        return new Spoint(-this.y, this.x);
    }

    public Spoint normalLeft() {
        return new Spoint(this.y, -this.x);
    }

    public Spoint Normalize() {
        return this.scale(1.0 / this.c());
    }

    public Spoint Average(Spoint other) {
        return new Spoint((this.x + other.x) / 2.0, (this.y + other.y) / 2.0);
    }

    public Spoint Negate() {
        return new Spoint(-this.x, -this.y);
    }

    public static Spoint infiniteLineIntersection(Spoint base1, Spoint v1, Spoint base2, Spoint v2) {
        double d2;
        if (v1.x == 0.0 && v2.y == 0.0) {
            return new Spoint(base1.x, base2.y);
        }
        if (v1.y == 0.0 && v2.x == 0.0) {
            return new Spoint(base2.x, base1.y);
        }
        double d3 = v1.x != 0.0 ? v1.y / v1.x : 0.0;
        double d4 = d2 = v2.x != 0.0 ? v2.y / v2.x : 0.0;
        if (d3 == d2) {
            return null;
        }
        double d5 = base1.y - d3 * base1.x;
        double d6 = base2.y - d2 * base2.x;
        double d7 = (d6 - d5) / (d3 - d2);
        double d8 = d3 * d7 + d5;
        if (v1.x == 0.0) {
            return new Spoint(base1.x, base1.x * d2 + d6);
        }
        if (v2.x == 0.0) {
            return new Spoint(base2.x, base2.x * d3 + d5);
        }
        return new Spoint(d7, d8);
    }

    public static Spoint Polar2Vect(double r2, double theta) {
        if (theta < 0.0) {
            theta += 360.0;
        }
        double d2 = Spoint.a(theta);
        double d3 = Math.abs(r2 * Math.cos(d2));
        double d4 = Math.abs(r2 * Math.sin(d2));
        if (theta >= 90.0 && theta <= 270.0) {
            d3 = -d3;
        }
        if (theta >= 180.0) {
            d4 = -d4;
        }
        return new Spoint(d3, d4);
    }

    private static double c(Spoint spoint) {
        double d2;
        if (spoint.x == 0.0) {
            d2 = spoint.y > 0.0 ? 90.0 : (spoint.y < 0.0 ? 270.0 : 0.0);
        } else {
            d2 = Spoint.b(Math.atan(spoint.y / spoint.x));
            if (spoint.x < 0.0) {
                d2 += 180.0;
            }
            if (d2 < 0.0) {
                d2 += 360.0;
            }
        }
        return d2;
    }

    public static double angleBetweenPoints(Spoint a2, Spoint b2, Spoint c2) {
        Spoint spoint = a2.subtract(b2);
        Spoint spoint2 = c2.subtract(b2);
        double d2 = Spoint.c(spoint) - Spoint.c(spoint2);
        if (d2 < 0.0) {
            d2 += 360.0;
        }
        if (d2 > 180.0) {
            d2 = 360.0 - d2;
        }
        return d2;
    }

    private static double a(double d2) {
        return d2 * Math.PI / 180.0;
    }

    private static double b(double d2) {
        return d2 * 180.0 / Math.PI;
    }
}

