/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.colormap.editor;

import com.macrofocus.colormap.ColorMapFactory;
import com.macrofocus.colormap.MutableColorMap;
import com.macrofocus.colormap.editor.AbstractPredefinedColorMapEditor;
import com.macrofocus.common.command.AbstractUICommand;
import com.macrofocus.common.command.UICommand;
import com.macrofocus.common.properties.MutableProperty;
import com.macrofocus.common.properties.adapter.IntervalProperty;
import com.macrofocus.common.selection.MutableSingleSelection;
import com.macrofocus.common.selection.PropertySingleSelection;
import com.macrofocus.crossplatform.CPCanvas;
import com.macrofocus.crossplatform.CPCheckBox;
import com.macrofocus.crossplatform.CPColorPicker;
import com.macrofocus.crossplatform.CPComboBox;
import com.macrofocus.crossplatform.CPComponent;
import com.macrofocus.crossplatform.CPFactory;
import com.macrofocus.crossplatform.CPFormPanel;
import com.macrofocus.crossplatform.CPOverlayPanel;
import com.macrofocus.crossplatform.CPSlider;
import com.macrofocus.crossplatform.CPSpinner;
import com.macrofocus.crossplatform.CPSplitMenuButton;
import com.macrofocus.format.CPFormat;
import com.macrofocus.geom.Point2D;
import com.macrofocus.geom.Rectangle;
import com.macrofocus.geom.Rectangle2D;
import com.macrofocus.igraphics.CPColor;
import com.macrofocus.igraphics.IDrawing;
import com.macrofocus.igraphics.IDrawingListener;
import com.macrofocus.igraphics.IGraphics;
import com.macrofocus.palette.CustomPalette;
import com.macrofocus.palette.MutablePalette;
import com.macrofocus.palette.PaletteFactory;
import java.util.ArrayList;
import java.util.Iterator;

public class CPPredefinedColorMapEditor<Component, Color>
extends AbstractPredefinedColorMapEditor<Component, Color> {
    private final CPFactory<Component, ?, ?, Color> a;
    private final ColorMapFactory<Color> b;
    private CPFormPanel<Component> c;
    private CPSplitMenuButton d;
    private CPSpinner<Component, Double> e;
    private CPSpinner<Component, Double> f;
    private CPColorPicker<Component, Color> g;
    private CPColorPicker<Component, Color> h;
    private CPColorPicker<Component, Color> i;
    private CPComboBox<Component, MutablePalette<Color>> j;
    private CPOverlayPanel<Component, Component> k;
    private CPCheckBox<Component> l;
    private CPCheckBox<Component> m;
    private CPSpinner<Component, Integer> n;
    private CPCheckBox<Component> o;
    private CPCheckBox<Component> p;
    private CPSlider<Component> q;
    private CPSlider<Component> r;
    private CPFormPanel<Component> s;

    /*
     * WARNING - void declaration
     */
    public CPPredefinedColorMapEditor(CPFactory<Component, ?, ?, Color> factory, ColorMapFactory<Color> colorMapFactory) {
        void var1_1;
        void var2_2;
        this.a = factory;
        this.b = var2_2;
        this.c = factory.createFormPanel();
        this.d = factory.createSplitMenuButton();
        this.d.setStyleClass("setToFullRangeButton");
        this.d.setDefaultCommand((UICommand)new AbstractUICommand(this, "Set to Data Range"){
            private /* synthetic */ CPPredefinedColorMapEditor a;
            {
                this.a = cPPredefinedColorMapEditor;
                super(string);
            }

            public final void execute(Object source) {
                this.a.f.setValue(this.a.min != null ? Double.valueOf(this.a.min.doubleValue()) : null);
                this.a.e.setValue(this.a.max != null ? Double.valueOf(this.a.max.doubleValue()) : null);
            }
        });
        this.d.addCommand((UICommand)new AbstractUICommand(this, "Set to Data Range"){
            private /* synthetic */ CPPredefinedColorMapEditor a;
            {
                this.a = cPPredefinedColorMapEditor;
                super(string);
            }

            public final void execute(Object source) {
                this.a.f.setValue(this.a.min != null ? Double.valueOf(this.a.min.doubleValue()) : null);
                this.a.e.setValue(this.a.max != null ? Double.valueOf(this.a.max.doubleValue()) : null);
            }
        });
        this.d.addCommand((UICommand)new AbstractUICommand(this, "Set to Rounded Range"){
            private /* synthetic */ CPPredefinedColorMapEditor a;
            {
                this.a = cPPredefinedColorMapEditor;
                super(string);
            }

            public final void execute(Object source) {
                double d2 = Math.signum(this.a.min.doubleValue()) * Math.pow(10.0, Math.floor(Math.log10(Math.abs(this.a.min.doubleValue()))));
                this.a.f.setValue(d2);
                double d3 = Math.signum(this.a.max.doubleValue()) * Math.pow(10.0, Math.ceil(Math.log10(Math.abs(this.a.max.doubleValue()))));
                this.a.e.setValue(d3);
            }
        });
        this.d.addCommand((UICommand)new AbstractUICommand(this, "Set to Symmetrical Range around 0"){
            private /* synthetic */ CPPredefinedColorMapEditor a;
            {
                this.a = cPPredefinedColorMapEditor;
                super(string);
            }

            public final void execute(Object source) {
                Double d2;
                CPSpinner cPSpinner;
                if (this.a.min.doubleValue() < 0.0 && this.a.min.doubleValue() > 0.0) {
                    double d3 = 0.0 - this.a.min.doubleValue();
                    double d4 = this.a.max.doubleValue();
                    double d5 = Math.max(d3, d4);
                    this.a.f.setValue(0.0 - d5);
                    cPSpinner = this.a.e;
                    d2 = d5;
                } else {
                    this.a.f.setValue(-this.a.max.doubleValue());
                    cPSpinner = this.a.e;
                    d2 = this.a.max != null ? Double.valueOf(this.a.max.doubleValue()) : null;
                }
                cPSpinner.setValue(d2);
            }
        });
        this.e = factory.createDoubleSpinner();
        this.e.setStyleClass("spinner", "maximumSpinner");
        this.f = factory.createDoubleSpinner();
        this.g = factory.createColorPicker();
        this.h = factory.createColorPicker();
        this.i = factory.createColorPicker();
        this.j = factory.createComboBox();
        this.j.setRenderer(new CPComboBox.ItemRenderer<Component, MutablePalette<Color>>(){
            private /* synthetic */ CPFactory a;
            private /* synthetic */ CPPredefinedColorMapEditor b;
            {
                this.b = cPPredefinedColorMapEditor;
                this.a = cPFactory;
            }

            @Override
            public final /* synthetic */ CPComponent render(Object object) {
                MutablePalette mutablePalette = (MutablePalette)object;
                object = this;
                if (mutablePalette != null) {
                    CPCanvas cPCanvas = object.a.createCanvas();
                    cPCanvas.addLayer(new IDrawing(){
                        private CustomPalette.Mode a = CustomPalette.Mode.Ramps;
                        private /* synthetic */ MutablePalette b;
                        private /* synthetic */ 5 c;
                        {
                            this.c = var1_1;
                            this.b = mutablePalette;
                        }

                        @Override
                        public final boolean isActive() {
                            return true;
                        }

                        public final void draw(IGraphics g2, Point2D point, double width, double height, Rectangle clipBounds) {
                            switch (this.a) {
                                case Bands: {
                                    for (int i = 0; i < this.b.getColorCount(); ++i) {
                                        CPColor cPColor = this.b.getColorAt(i);
                                        int n = 0 + (int)(width * (double)i / (double)this.b.getColorCount());
                                        int n2 = 0 + (int)(width * (double)(i + 1) / (double)this.b.getColorCount());
                                        g2.setColor(cPColor);
                                        g2.fillRectangle2D(new Rectangle2D.Double(n, 0.0, n2 - n + 1, height));
                                    }
                                    return;
                                }
                                case Ramps: {
                                    for (int i = 0; i < 256; ++i) {
                                        CPColor cPColor = this.b.getColor((double)i / 255.0);
                                        int n = 0 + (int)(width * (double)i / 256.0);
                                        int n3 = 0 + (int)(width * (double)(i + 1) / 256.0);
                                        g2.setColor(cPColor);
                                        g2.fillRectangle2D(new Rectangle2D.Double(n, 0.0, n3 - n + 1, height));
                                    }
                                    break;
                                }
                            }
                        }

                        @Override
                        public final void addIDrawingListener(IDrawingListener listener) {
                        }

                        @Override
                        public final void removeIDrawingListener(IDrawingListener listener) {
                        }
                    });
                    return cPCanvas;
                }
                return object.a.createLabel("");
            }
        });
        this.k = factory.createOverlayPanel();
        this.l = factory.createCheckBox("Number of Steps:", null);
        this.m = factory.createCheckBox("Inverted", null);
        this.n = factory.createIntegerSpinner();
        this.o = factory.createCheckBox("Underflow Color:", null);
        this.p = factory.createCheckBox("Overflow Color:", null);
        this.q = factory.createSlider();
        this.q.setMinimum(-150.0);
        this.q.setMaximum(150.0);
        this.r = factory.createSlider();
        this.r.setMinimum(-150.0);
        this.r.setMaximum(150.0);
        this.s = factory.createFormPanel();
        this.c.add(factory.createLabel("Palette:"), this.j);
        this.c.add(factory.createLabel("Maximum:"), this.e);
        this.c.add(factory.createLabel("Minimum:"), this.f);
        this.c.add(null, this.d);
        this.c.add(this.l, this.n);
        this.c.add(this.m, null);
        this.c.add(factory.createLabel("Brightness:"), this.q);
        this.c.add(factory.createLabel("Saturation:"), this.r);
        this.c.add(this.p, this.i);
        this.c.add(this.o, this.g);
        this.c.add(var1_1.createLabel("Missing Values Color:"), this.h);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setColorMap(MutableColorMap<Color> colorMap, Number min, Number max, CPFormat format) {
        void var1_1;
        Iterator<PaletteFactory.Entry> iterator;
        ArrayList arrayList;
        this.colorMap = colorMap;
        this.min = arrayList;
        this.max = iterator;
        this.format = format;
        this.e.setProperty((MutableProperty<Double>)new IntervalProperty(colorMap.getInterval(), IntervalProperty.Value.End));
        this.e.setFormat(format);
        this.f.setProperty((MutableProperty<Double>)new IntervalProperty(colorMap.getInterval(), IntervalProperty.Value.Start));
        this.f.setFormat(format);
        this.g.setProperty(colorMap.underColorProperty());
        this.h.setProperty(colorMap.nullColorProperty());
        this.i.setProperty(colorMap.overColorProperty());
        arrayList = new ArrayList();
        for (PaletteFactory.Entry entry : this.b.getPaletteFactory().getEntries()) {
            if (entry.getType() == PaletteFactory.Type.QUALITATIVE) continue;
            arrayList.add(entry.getPalette());
        }
        this.j.setModel((MutableSingleSelection<MutablePalette<Color>>)new PropertySingleSelection(colorMap.paletteProperty()), arrayList);
        this.l.setProperty(colorMap.colorCountSetProperty());
        this.n.setProperty(colorMap.colorCountProperty());
        this.m.setProperty(colorMap.invertedProperty());
        this.o.setProperty(colorMap.underColorSetProperty());
        this.p.setProperty(colorMap.overColorSetProperty());
        this.q.setProperty(colorMap.brightnessProperty());
        this.r.setProperty(var1_1.saturationProperty());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setStyleClass(String ... styleClasses) {
        void var1_1;
        this.c.setStyleClass((String[])var1_1);
    }

    @Override
    public Component getNativeComponent() {
        return this.c.getNativeComponent();
    }
}

