/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.geom;

import com.macrofocus.geom.AffineTransform;
import com.macrofocus.geom.PathIterator;
import com.macrofocus.geom.Point2D;
import com.macrofocus.geom.RectIterator;
import com.macrofocus.geom.Rectangle;
import com.macrofocus.geom.Rectangle2D;

public abstract class AbstractRectangle2D
implements Rectangle2D {
    @Override
    public Rectangle getBounds() {
        double d2 = this.getWidth();
        double d3 = this.getHeight();
        if (d2 < 0.0 || d3 < 0.0) {
            return new Rectangle();
        }
        double d4 = this.getX();
        double d5 = this.getY();
        double d6 = Math.floor(d4);
        double d7 = Math.floor(d5);
        double d8 = Math.ceil(d4 + d2);
        double d9 = Math.ceil(d5 + d3);
        return new Rectangle((int)d6, (int)d7, (int)(d8 - d6), (int)(d9 - d7));
    }

    @Override
    public Rectangle2D getBounds2D() {
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean contains(Point2D point) {
        void var1_1;
        double d2 = point.getX();
        double d3 = var1_1.getY();
        double d4 = this.getX();
        double d5 = this.getY();
        return d2 >= d4 && d3 >= d5 && d2 < d4 + this.getWidth() && d3 < d5 + this.getHeight();
    }

    @Override
    public double getCenterX() {
        return this.getX() + this.getWidth() / 2.0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean intersects(Rectangle2D rect) {
        void var1_1;
        double d2 = rect.getX();
        double d3 = rect.getY();
        double d4 = rect.getWidth();
        double d5 = var1_1.getHeight();
        if (d4 <= 0.0 || d5 <= 0.0) {
            return false;
        }
        double d6 = this.getX();
        double d7 = this.getY();
        return d2 + d4 > d6 && d3 + d5 > d7 && d2 < d6 + this.getWidth() && d3 < d7 + this.getHeight();
    }

    @Override
    public double getCenterY() {
        return this.getY() + this.getHeight() / 2.0;
    }

    @Override
    public PathIterator getPathIterator() {
        return this.getPathIterator(null);
    }

    @Override
    public double getMinX() {
        return this.getX();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public PathIterator getPathIterator(AffineTransform at) {
        void var1_1;
        return new RectIterator(this, (AffineTransform)var1_1);
    }

    @Override
    public double getMinY() {
        return this.getY();
    }

    @Override
    public PathIterator getFlattenPathIterator(double flatness) {
        return new RectIterator(this, null);
    }

    @Override
    public double getMaxX() {
        return this.getX() + this.getWidth();
    }

    @Override
    public double getMaxY() {
        return this.getY() + this.getHeight();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Rectangle2D createIntersection(Rectangle2D r) {
        void var1_1;
        double d2 = Math.max(this.getMinX(), r.getMinX());
        double d3 = Math.max(this.getMinY(), r.getMinY());
        double d4 = Math.min(this.getMaxX(), r.getMaxX());
        double d5 = Math.min(this.getMaxY(), var1_1.getMaxY());
        return new Rectangle2D.Double(d2, d3, d4 - d2, d5 - d3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Rectangle2D createUnion(Rectangle2D r) {
        void var1_1;
        double d2 = Math.min(this.getMinX(), r.getMinX());
        double d3 = Math.min(this.getMinY(), r.getMinY());
        double d4 = Math.max(this.getMaxX(), r.getMaxX());
        double d5 = Math.max(this.getMaxY(), var1_1.getMaxY());
        return new Rectangle2D.Double(d2, d3, d4 - d2, d5 - d3);
    }

    @Override
    public boolean intersectsLine(double x1, double y1, double x2, double y2) {
        int n;
        int n2 = this.outcode(x2, y2);
        if (n2 == 0) {
            return true;
        }
        while ((n = this.outcode(x1, y1)) != 0) {
            double d2;
            if ((n & n2) != 0) {
                return false;
            }
            if ((n & 5) != 0) {
                d2 = this.getX();
                if ((n & 4) != 0) {
                    d2 += this.getWidth();
                }
                y1 += (d2 - x1) * (y2 - y1) / (x2 - x1);
                x1 = d2;
                continue;
            }
            d2 = this.getY();
            if ((n & 8) != 0) {
                d2 += this.getHeight();
            }
            x1 += (d2 - y1) * (x2 - x1) / (y2 - y1);
            y1 = d2;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public int outcode(double x, double y) {
        void var3_2;
        void var1_1;
        int n = 0;
        if (this.getWidth() <= 0.0) {
            n = 5;
        } else if (x < this.getX()) {
            n = 1;
        } else if (var1_1 > this.getX() + this.getWidth()) {
            n = 4;
        }
        if (this.getHeight() <= 0.0) {
            n |= 0xA;
        } else if (y < this.getY()) {
            n |= 2;
        } else if (var3_2 > this.getY() + this.getHeight()) {
            n |= 8;
        }
        return n;
    }
}

