/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.geom;

import com.macrofocus.common.annotations.GwtIncompatible;
import com.macrofocus.geom.Path2D;
import com.macrofocus.geom.Point2D;
import com.macrofocus.geom.Shape;
import com.macrofocus.igraphics.NoninvertibleTransformException;

public class AffineTransform {
    public static final int TYPE_IDENTITY = 0;
    public static final int TYPE_TRANSLATION = 1;
    public static final int TYPE_UNIFORM_SCALE = 2;
    public static final int TYPE_GENERAL_SCALE = 4;
    public static final int TYPE_MASK_SCALE = 6;
    public static final int TYPE_FLIP = 64;
    public static final int TYPE_QUADRANT_ROTATION = 8;
    public static final int TYPE_GENERAL_ROTATION = 16;
    public static final int TYPE_MASK_ROTATION = 24;
    public static final int TYPE_GENERAL_TRANSFORM = 32;
    private static final int[] a = new int[]{4, 5, 4, 5, 2, 3, 6, 7};
    private double b;
    private double c;
    private double d;
    private double e;
    private double f;
    private double g;
    private transient int h;
    private transient int i;

    /*
     * WARNING - void declaration
     */
    private AffineTransform(double m00, double m10, double m01, double m11, double m02, double m12, int state) {
        void var3_2;
        void var1_1;
        this.b = var1_1;
        this.c = var3_2;
        this.d = m01;
        this.e = m11;
        this.f = m02;
        this.g = m12;
        this.h = state;
        this.i = -1;
    }

    public AffineTransform() {
        AffineTransform affineTransform = this;
        affineTransform.e = 1.0;
        affineTransform.b = 1.0;
    }

    /*
     * WARNING - void declaration
     */
    public AffineTransform(AffineTransform Tx) {
        void var1_1;
        this.b = Tx.b;
        this.c = Tx.c;
        this.d = Tx.d;
        this.e = Tx.e;
        this.f = Tx.f;
        this.g = Tx.g;
        this.h = Tx.h;
        this.i = var1_1.i;
    }

    /*
     * WARNING - void declaration
     */
    public AffineTransform(float m00, float m10, float m01, float m11, float m02, float m12) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.b = (double)var1_1;
        this.c = (double)var2_2;
        this.d = (double)var3_3;
        this.e = m11;
        this.f = m02;
        this.g = m12;
        this.a();
    }

    private void a() {
        if (this.d == 0.0 && this.c == 0.0) {
            if (this.b == 1.0 && this.e == 1.0) {
                if (this.f == 0.0 && this.g == 0.0) {
                    this.h = 0;
                    this.i = 0;
                    return;
                }
                this.h = 1;
                this.i = 1;
                return;
            }
            if (this.f == 0.0 && this.g == 0.0) {
                this.h = 2;
                this.i = -1;
                return;
            }
            this.h = 3;
            this.i = -1;
            return;
        }
        if (this.b == 0.0 && this.e == 0.0) {
            if (this.f == 0.0 && this.g == 0.0) {
                this.h = 4;
                this.i = -1;
                return;
            }
            this.h = 5;
            this.i = -1;
            return;
        }
        if (this.f == 0.0 && this.g == 0.0) {
            this.h = 6;
            this.i = -1;
            return;
        }
        this.h = 7;
        this.i = -1;
    }

    /*
     * WARNING - void declaration
     */
    public AffineTransform(float[] flatmatrix) {
        this.b = flatmatrix[0];
        this.c = flatmatrix[1];
        this.d = flatmatrix[2];
        this.e = flatmatrix[3];
        if (flatmatrix.length > 5) {
            void var1_1;
            this.f = flatmatrix[4];
            this.g = (double)var1_1[5];
        }
        this.a();
    }

    /*
     * WARNING - void declaration
     */
    public AffineTransform(double m00, double m10, double m01, double m11, double m02, double m12) {
        void var3_2;
        void var1_1;
        this.b = var1_1;
        this.c = var3_2;
        this.d = m01;
        this.e = m11;
        this.f = m02;
        this.g = m12;
        this.a();
    }

    /*
     * WARNING - void declaration
     */
    public AffineTransform(double[] flatmatrix) {
        this.b = flatmatrix[0];
        this.c = flatmatrix[1];
        this.d = flatmatrix[2];
        this.e = flatmatrix[3];
        if (flatmatrix.length > 5) {
            void var1_1;
            this.f = flatmatrix[4];
            this.g = var1_1[5];
        }
        this.a();
    }

    /*
     * WARNING - void declaration
     */
    public static AffineTransform getTranslateInstance(double tx, double ty) {
        void var2_1;
        double d2;
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.setToTranslation(d2, (double)var2_1);
        return affineTransform;
    }

    /*
     * WARNING - void declaration
     */
    public void setToTranslation(double tx, double ty) {
        void var3_2;
        void var1_1;
        this.b = 1.0;
        this.c = 0.0;
        this.d = 0.0;
        this.e = 1.0;
        this.f = tx;
        this.g = ty;
        if (var1_1 != 0.0 || var3_2 != 0.0) {
            this.h = 1;
            this.i = 1;
            return;
        }
        this.h = 0;
        this.i = 0;
    }

    public static AffineTransform getRotateInstance(double theta) {
        double d2;
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.setToRotation(d2);
        return affineTransform;
    }

    /*
     * WARNING - void declaration
     */
    public void setToRotation(double theta) {
        double d2;
        double d3 = Math.sin(theta);
        if (d3 == 1.0 || d3 == -1.0) {
            d2 = 0.0;
            this.h = 4;
            this.i = 8;
        } else {
            void var1_1;
            d2 = Math.cos((double)var1_1);
            if (d2 == -1.0) {
                d3 = 0.0;
                this.h = 2;
                this.i = 8;
            } else if (d2 == 1.0) {
                d3 = 0.0;
                this.h = 0;
                this.i = 0;
            } else {
                this.h = 6;
                this.i = 16;
            }
        }
        this.b = d2;
        this.c = d3;
        this.d = -d3;
        this.e = d2;
        this.f = 0.0;
        this.g = 0.0;
    }

    /*
     * WARNING - void declaration
     */
    public static AffineTransform getRotateInstance(double theta, double anchorx, double anchory) {
        void var2_2;
        double d2;
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.setToRotation(d2, (double)var2_2, anchory);
        return affineTransform;
    }

    /*
     * WARNING - void declaration
     */
    public void setToRotation(double theta, double anchorx, double anchory) {
        void var3_2;
        void var1_1;
        this.setToRotation((double)var1_1);
        double d2 = this.c;
        double d3 = 1.0 - this.b;
        this.f = anchorx * d3 + anchory * d2;
        this.g = anchory * d3 - var3_2 * d2;
        if (this.f != 0.0 || this.g != 0.0) {
            this.h |= 1;
            this.i |= 1;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static AffineTransform getRotateInstance(double vecx, double vecy) {
        void var2_1;
        double d2;
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.setToRotation(d2, (double)var2_1);
        return affineTransform;
    }

    /*
     * WARNING - void declaration
     */
    public void setToRotation(double vecx, double vecy) {
        double d2;
        double d3;
        if (vecy == 0.0) {
            d3 = 0.0;
            if (vecx < 0.0) {
                d2 = -1.0;
                this.h = 2;
                this.i = 8;
            } else {
                d2 = 1.0;
                this.h = 0;
                this.i = 0;
            }
        } else if (vecx == 0.0) {
            d2 = 0.0;
            d3 = vecy > 0.0 ? 1.0 : -1.0;
            this.h = 4;
            this.i = 8;
        } else {
            void var3_2;
            void var1_1;
            double d4 = vecx;
            double d5 = vecy;
            double d6 = Math.sqrt(d4 * d4 + d5 * d5);
            d2 = var1_1 / d6;
            d3 = var3_2 / d6;
            this.h = 6;
            this.i = 16;
        }
        this.b = d2;
        this.c = d3;
        this.d = -d3;
        this.e = d2;
        this.f = 0.0;
        this.g = 0.0;
    }

    /*
     * WARNING - void declaration
     */
    public static AffineTransform getRotateInstance(double vecx, double vecy, double anchorx, double anchory) {
        void var2_1;
        double d2;
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.setToRotation(d2, (double)var2_1, anchorx, anchory);
        return affineTransform;
    }

    /*
     * WARNING - void declaration
     */
    public void setToRotation(double vecx, double vecy, double anchorx, double anchory) {
        void var3_2;
        void var1_1;
        this.setToRotation((double)var1_1, (double)var3_2);
        double d2 = this.c;
        double d3 = 1.0 - this.b;
        this.f = anchorx * d3 + anchory * d2;
        this.g = anchory * d3 - anchorx * d2;
        if (this.f != 0.0 || this.g != 0.0) {
            this.h |= 1;
            this.i |= 1;
        }
    }

    public static AffineTransform getQuadrantRotateInstance(int numquadrants) {
        int n;
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.setToQuadrantRotation(n);
        return affineTransform;
    }

    public void setToQuadrantRotation(int numquadrants) {
        switch (numquadrants & 3) {
            case 0: {
                this.b = 1.0;
                this.c = 0.0;
                this.d = 0.0;
                this.e = 1.0;
                this.f = 0.0;
                this.g = 0.0;
                this.h = 0;
                this.i = 0;
                return;
            }
            case 1: {
                this.b = 0.0;
                this.c = 1.0;
                this.d = -1.0;
                this.e = 0.0;
                this.f = 0.0;
                this.g = 0.0;
                this.h = 4;
                this.i = 8;
                return;
            }
            case 2: {
                this.b = -1.0;
                this.c = 0.0;
                this.d = 0.0;
                this.e = -1.0;
                this.f = 0.0;
                this.g = 0.0;
                this.h = 2;
                this.i = 8;
                return;
            }
            case 3: {
                this.b = 0.0;
                this.c = -1.0;
                this.d = 1.0;
                this.e = 0.0;
                this.f = 0.0;
                this.g = 0.0;
                this.h = 4;
                this.i = 8;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static AffineTransform getQuadrantRotateInstance(int numquadrants, double anchorx, double anchory) {
        void var3_2;
        void var1_1;
        int n;
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.setToQuadrantRotation(n, (double)var1_1, (double)var3_2);
        return affineTransform;
    }

    /*
     * WARNING - void declaration
     */
    public void setToQuadrantRotation(int numquadrants, double anchorx, double anchory) {
        switch (numquadrants & 3) {
            case 0: {
                this.b = 1.0;
                this.c = 0.0;
                this.d = 0.0;
                this.e = 1.0;
                this.f = 0.0;
                this.g = 0.0;
                this.h = 0;
                this.i = 0;
                return;
            }
            case 1: {
                this.b = 0.0;
                this.c = 1.0;
                this.d = -1.0;
                this.e = 0.0;
                this.f = anchorx + anchory;
                this.g = anchory - anchorx;
                if (this.f == 0.0 && this.g == 0.0) {
                    this.h = 4;
                    this.i = 8;
                    return;
                }
                this.h = 5;
                this.i = 9;
                return;
            }
            case 2: {
                this.b = -1.0;
                this.c = 0.0;
                this.d = 0.0;
                this.e = -1.0;
                double d2 = anchorx;
                this.f = d2 + d2;
                double d3 = anchory;
                this.g = d3 + d3;
                if (this.f == 0.0 && this.g == 0.0) {
                    this.h = 2;
                    this.i = 8;
                    return;
                }
                this.h = 3;
                this.i = 9;
                return;
            }
            case 3: {
                void var2_2;
                this.b = 0.0;
                this.c = -1.0;
                this.d = 1.0;
                this.e = 0.0;
                this.f = anchorx - anchory;
                this.g = anchory + var2_2;
                if (this.f == 0.0 && this.g == 0.0) {
                    this.h = 4;
                    this.i = 8;
                    return;
                }
                this.h = 5;
                this.i = 9;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static AffineTransform getScaleInstance(double sx, double sy) {
        void var2_1;
        double d2;
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.setToScale(d2, (double)var2_1);
        return affineTransform;
    }

    /*
     * WARNING - void declaration
     */
    public void setToScale(double sx, double sy) {
        void var3_2;
        void var1_1;
        this.b = sx;
        this.c = 0.0;
        this.d = 0.0;
        this.e = sy;
        this.f = 0.0;
        this.g = 0.0;
        if (var1_1 != 1.0 || var3_2 != 1.0) {
            this.h = 2;
            this.i = -1;
            return;
        }
        this.h = 0;
        this.i = 0;
    }

    /*
     * WARNING - void declaration
     */
    public static AffineTransform getShearInstance(double shx, double shy) {
        void var2_1;
        double d2;
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.setToShear(d2, (double)var2_1);
        return affineTransform;
    }

    /*
     * WARNING - void declaration
     */
    public void setToShear(double shx, double shy) {
        void var3_2;
        void var1_1;
        this.b = 1.0;
        this.d = shx;
        this.c = shy;
        this.e = 1.0;
        this.f = 0.0;
        this.g = 0.0;
        if (var1_1 != 0.0 || var3_2 != 0.0) {
            this.h = 6;
            this.i = -1;
            return;
        }
        this.h = 0;
        this.i = 0;
    }

    public double getDeterminant() {
        switch (this.h) {
            default: {
                AffineTransform.b();
            }
            case 6: 
            case 7: {
                return this.b * this.e - this.d * this.c;
            }
            case 4: 
            case 5: {
                return -(this.d * this.c);
            }
            case 2: 
            case 3: {
                return this.b * this.e;
            }
            case 0: 
            case 1: 
        }
        return 1.0;
    }

    private static void b() {
        throw new UnsupportedOperationException("missing case in transform state switch");
    }

    public void getMatrix(double[] flatmatrix) {
        flatmatrix[0] = this.b;
        flatmatrix[1] = this.c;
        flatmatrix[2] = this.d;
        flatmatrix[3] = this.e;
        if (flatmatrix.length > 5) {
            flatmatrix[4] = this.f;
            var1_1[5] = this.g;
        }
    }

    public double getScaleX() {
        return this.b;
    }

    public double getScaleY() {
        return this.e;
    }

    public double getShearX() {
        return this.d;
    }

    public double getShearY() {
        return this.c;
    }

    public double getTranslateX() {
        return this.f;
    }

    public double getTranslateY() {
        return this.g;
    }

    /*
     * WARNING - void declaration
     */
    public void rotate(double theta, double anchorx, double anchory) {
        void var3_2;
        void var1_1;
        this.translate(anchorx, anchory);
        this.rotate((double)var1_1);
        this.translate((double)(-var3_2), -anchory);
    }

    /*
     * WARNING - void declaration
     */
    public void translate(double tx, double ty) {
        void var3_2;
        void var1_1;
        switch (this.h) {
            default: {
                AffineTransform.b();
                return;
            }
            case 7: {
                this.f = tx * this.b + ty * this.d + this.f;
                this.g = tx * this.c + ty * this.e + this.g;
                if (this.f == 0.0 && this.g == 0.0) {
                    this.h = 6;
                    if (this.i != -1) {
                        --this.i;
                    }
                }
                return;
            }
            case 6: {
                this.f = tx * this.b + ty * this.d;
                this.g = tx * this.c + ty * this.e;
                if (this.f != 0.0 || this.g != 0.0) {
                    this.h = 7;
                    this.i |= 1;
                }
                return;
            }
            case 5: {
                this.f = ty * this.d + this.f;
                this.g = tx * this.c + this.g;
                if (this.f == 0.0 && this.g == 0.0) {
                    this.h = 4;
                    if (this.i != -1) {
                        --this.i;
                    }
                }
                return;
            }
            case 4: {
                this.f = ty * this.d;
                this.g = tx * this.c;
                if (this.f != 0.0 || this.g != 0.0) {
                    this.h = 5;
                    this.i |= 1;
                }
                return;
            }
            case 3: {
                this.f = tx * this.b + this.f;
                this.g = ty * this.e + this.g;
                if (this.f == 0.0 && this.g == 0.0) {
                    this.h = 2;
                    if (this.i != -1) {
                        --this.i;
                    }
                }
                return;
            }
            case 2: {
                this.f = tx * this.b;
                this.g = ty * this.e;
                if (this.f != 0.0 || this.g != 0.0) {
                    this.h = 3;
                    this.i |= 1;
                }
                return;
            }
            case 1: {
                this.f = tx + this.f;
                this.g = ty + this.g;
                if (this.f == 0.0 && this.g == 0.0) {
                    this.h = 0;
                    this.i = 0;
                }
                return;
            }
            case 0: 
        }
        this.f = tx;
        this.g = ty;
        if (var1_1 != 0.0 || var3_2 != 0.0) {
            this.h = 1;
            this.i = 1;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void rotate(double theta) {
        void var1_1;
        double d2 = Math.sin(theta);
        if (d2 == 1.0) {
            this.c();
            return;
        }
        if (d2 == -1.0) {
            this.e();
            return;
        }
        double d3 = Math.cos((double)var1_1);
        if (d3 == -1.0) {
            this.d();
            return;
        }
        if (d3 != 1.0) {
            double d4 = this.b;
            double d5 = this.d;
            this.b = d3 * d4 + d2 * d5;
            this.d = -d2 * d4 + d3 * d5;
            d4 = this.c;
            d5 = this.e;
            this.c = d3 * d4 + d2 * d5;
            this.e = -d2 * d4 + d3 * d5;
            this.a();
        }
    }

    private void c() {
        double d2 = this.b;
        this.b = this.d;
        this.d = -d2;
        d2 = this.c;
        this.c = this.e;
        this.e = -d2;
        int n = a[this.h];
        if ((n & 6) == 2 && this.b == 1.0 && this.e == 1.0) {
            n -= 2;
        }
        this.h = n;
        this.i = -1;
    }

    private void d() {
        this.b = -this.b;
        this.e = -this.e;
        int n = this.h;
        if ((n & 4) != 0) {
            this.d = -this.d;
            this.c = -this.c;
        } else {
            this.h = this.b == 1.0 && this.e == 1.0 ? n & 0xFFFFFFFD : n | 2;
        }
        this.i = -1;
    }

    private void e() {
        double d2 = this.b;
        this.b = -this.d;
        this.d = d2;
        d2 = this.c;
        this.c = -this.e;
        this.e = d2;
        int n = a[this.h];
        if ((n & 6) == 2 && this.b == 1.0 && this.e == 1.0) {
            n -= 2;
        }
        this.h = n;
        this.i = -1;
    }

    /*
     * WARNING - void declaration
     */
    public void rotate(double vecx, double vecy, double anchorx, double anchory) {
        void var3_2;
        void var1_1;
        this.translate(anchorx, anchory);
        this.rotate((double)var1_1, (double)var3_2);
        this.translate(-anchorx, -anchory);
    }

    /*
     * WARNING - void declaration
     */
    public void rotate(double vecx, double vecy) {
        if (vecy == 0.0) {
            if (vecx < 0.0) {
                this.d();
                return;
            }
        } else {
            void var3_2;
            void var1_1;
            if (vecx == 0.0) {
                if (vecy > 0.0) {
                    this.c();
                    return;
                }
                this.e();
                return;
            }
            double d2 = vecx;
            double d3 = vecy;
            double d4 = Math.sqrt(d2 * d2 + d3 * d3);
            double d5 = this.b;
            double d6 = this.d;
            void var11_6 = var1_1 / d4;
            void var13_7 = var3_2 / d4;
            this.b = var11_6 * d5 + var13_7 * d6;
            this.d = -var13_7 * d5 + var11_6 * d6;
            d5 = this.c;
            d6 = this.e;
            this.c = var11_6 * d5 + var13_7 * d6;
            this.e = -var13_7 * d5 + var11_6 * d6;
            this.a();
        }
    }

    public void quadrantRotate(int numquadrants) {
        switch (numquadrants & 3) {
            case 0: {
                return;
            }
            case 1: {
                this.c();
                return;
            }
            case 2: {
                this.d();
                return;
            }
            case 3: {
                this.e();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void quadrantRotate(int numquadrants, double anchorx, double anchory) {
        switch (numquadrants & 3) {
            case 0: {
                return;
            }
            case 1: {
                this.f += anchorx * (this.b - this.d) + anchory * (this.d + this.b);
                this.g += anchorx * (this.c - this.e) + anchory * (this.e + this.c);
                this.c();
                break;
            }
            case 2: {
                this.f += anchorx * (this.b + this.b) + anchory * (this.d + this.d);
                this.g += anchorx * (this.c + this.c) + anchory * (this.e + this.e);
                this.d();
                break;
            }
            case 3: {
                void var2_2;
                this.f += anchorx * (this.b + this.d) + anchory * (this.d - this.b);
                this.g += var2_2 * (this.c + this.e) + anchory * (this.e - this.c);
                this.e();
            }
        }
        if (this.f == 0.0 && this.g == 0.0) {
            this.h &= 0xFFFFFFFE;
            return;
        }
        this.h |= 1;
    }

    /*
     * WARNING - void declaration
     */
    public void shear(double shx, double shy) {
        void var3_2;
        void var1_1;
        int n = this.h;
        switch (n) {
            default: {
                AffineTransform.b();
                return;
            }
            case 6: 
            case 7: {
                double d2 = this.b;
                double d3 = this.d;
                this.b = d2 + d3 * shy;
                this.d = d2 * shx + d3;
                d2 = this.c;
                d3 = this.e;
                this.c = d2 + d3 * shy;
                this.e = d2 * shx + d3;
                this.a();
                return;
            }
            case 4: 
            case 5: {
                this.b = this.d * shy;
                this.e = this.c * shx;
                if (this.b != 0.0 || this.e != 0.0) {
                    this.h = n | 2;
                }
                this.i = -1;
                return;
            }
            case 2: 
            case 3: {
                this.d = this.b * shx;
                this.c = this.e * shy;
                if (this.d != 0.0 || this.c != 0.0) {
                    this.h = n | 4;
                }
                this.i = -1;
                return;
            }
            case 0: 
            case 1: 
        }
        this.d = var1_1;
        this.c = var3_2;
        if (this.d != 0.0 || this.c != 0.0) {
            this.h = n | 2 | 4;
            this.i = -1;
        }
    }

    public void setToIdentity() {
        AffineTransform affineTransform = this;
        affineTransform.e = 1.0;
        affineTransform.b = 1.0;
        AffineTransform affineTransform2 = this;
        AffineTransform affineTransform3 = this;
        affineTransform3.g = 0.0;
        affineTransform3.f = 0.0;
        affineTransform2.d = 0.0;
        affineTransform2.c = 0.0;
        this.h = 0;
        this.i = 0;
    }

    /*
     * WARNING - void declaration
     */
    public void setTransform(AffineTransform Tx) {
        void var1_1;
        this.b = Tx.b;
        this.c = Tx.c;
        this.d = Tx.d;
        this.e = Tx.e;
        this.f = Tx.f;
        this.g = Tx.g;
        this.h = Tx.h;
        this.i = var1_1.i;
    }

    /*
     * WARNING - void declaration
     */
    public void setTransform(double m00, double m10, double m01, double m11, double m02, double m12) {
        void var3_2;
        void var1_1;
        this.b = var1_1;
        this.c = var3_2;
        this.d = m01;
        this.e = m11;
        this.f = m02;
        this.g = m12;
        this.a();
    }

    /*
     * WARNING - void declaration
     */
    public void concatenate(AffineTransform Tx) {
        void var1_1;
        int n = this.h;
        int n2 = Tx.h;
        switch (n2 << 3 | n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return;
            }
            case 56: {
                this.d = Tx.d;
                this.c = Tx.c;
            }
            case 24: {
                this.b = Tx.b;
                this.e = Tx.e;
            }
            case 8: {
                this.f = Tx.f;
                this.g = Tx.g;
                this.h = n2;
                this.i = Tx.i;
                return;
            }
            case 48: {
                this.d = Tx.d;
                this.c = Tx.c;
            }
            case 16: {
                this.b = Tx.b;
                this.e = Tx.e;
                this.h = n2;
                this.i = Tx.i;
                return;
            }
            case 40: {
                this.f = Tx.f;
                this.g = Tx.g;
            }
            case 32: {
                this.d = Tx.d;
                this.c = Tx.c;
                AffineTransform affineTransform = this;
                affineTransform.e = 0.0;
                affineTransform.b = 0.0;
                this.h = n2;
                this.i = Tx.i;
                return;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                this.translate(Tx.f, Tx.g);
                return;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                this.scale(Tx.b, Tx.e);
                return;
            }
            case 38: 
            case 39: {
                double d2 = Tx.d;
                double d3 = Tx.c;
                double d4 = this.b;
                this.b = this.d * d3;
                this.d = d4 * d2;
                d4 = this.c;
                this.c = this.e * d3;
                this.e = d4 * d2;
                this.i = -1;
                return;
            }
            case 36: 
            case 37: {
                this.b = this.d * Tx.c;
                this.d = 0.0;
                this.e = this.c * Tx.d;
                this.c = 0.0;
                this.h = n ^ 6;
                this.i = -1;
                return;
            }
            case 34: 
            case 35: {
                this.d = this.b * Tx.d;
                this.b = 0.0;
                this.c = this.e * Tx.c;
                this.e = 0.0;
                this.h = n ^ 6;
                this.i = -1;
                return;
            }
            case 33: {
                this.b = 0.0;
                this.d = Tx.d;
                this.c = Tx.c;
                this.e = 0.0;
                this.h = 5;
                this.i = -1;
                return;
            }
        }
        double d5 = Tx.b;
        double d6 = Tx.d;
        double d7 = Tx.f;
        double d8 = Tx.c;
        double d9 = Tx.e;
        double d10 = var1_1.g;
        switch (n) {
            default: {
                AffineTransform.b();
            }
            case 6: {
                this.h = n | n2;
            }
            case 7: {
                double d11 = this.b;
                double d12 = this.d;
                this.b = d5 * d11 + d8 * d12;
                this.d = d6 * d11 + d9 * d12;
                this.f += d7 * d11 + d10 * d12;
                d11 = this.c;
                d12 = this.e;
                this.c = d5 * d11 + d8 * d12;
                this.e = d6 * d11 + d9 * d12;
                this.g += d7 * d11 + d10 * d12;
                this.i = -1;
                return;
            }
            case 4: 
            case 5: {
                double d13 = this.d;
                this.b = d8 * d13;
                this.d = d9 * d13;
                this.f += d10 * d13;
                d13 = this.c;
                this.c = d5 * d13;
                this.e = d6 * d13;
                this.g += d7 * d13;
                break;
            }
            case 2: 
            case 3: {
                double d14 = this.b;
                this.b = d5 * d14;
                this.d = d6 * d14;
                this.f += d7 * d14;
                d14 = this.e;
                this.c = d8 * d14;
                this.e = d9 * d14;
                this.g += d10 * d14;
                break;
            }
            case 1: {
                this.b = d5;
                this.d = d6;
                this.f += d7;
                this.c = d8;
                this.e = d9;
                this.g += d10;
                this.h = n2 | 1;
                this.i = -1;
                return;
            }
        }
        this.a();
    }

    /*
     * WARNING - void declaration
     */
    public void scale(double sx, double sy) {
        void var3_2;
        void var1_1;
        int n = this.h;
        switch (n) {
            default: {
                AffineTransform.b();
            }
            case 6: 
            case 7: {
                this.b *= sx;
                this.e *= sy;
            }
            case 4: 
            case 5: {
                this.d *= sy;
                this.c *= sx;
                if (this.d == 0.0 && this.c == 0.0) {
                    n &= 1;
                    if (this.b == 1.0 && this.e == 1.0) {
                        this.i = n == 0 ? 0 : 1;
                    } else {
                        n |= 2;
                        this.i = -1;
                    }
                    this.h = n;
                }
                return;
            }
            case 2: 
            case 3: {
                this.b *= sx;
                this.e *= sy;
                if (this.b == 1.0 && this.e == 1.0) {
                    this.h = n &= 1;
                    this.i = n == 0 ? 0 : 1;
                    return;
                }
                this.i = -1;
                return;
            }
            case 0: 
            case 1: 
        }
        this.b = sx;
        this.e = sy;
        if (var1_1 != 1.0 || var3_2 != 1.0) {
            this.h = n | 2;
            this.i = -1;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void preConcatenate(AffineTransform Tx) {
        var12_2 = this.h;
        var13_3 = Tx.h;
        switch (var13_3 << 3 | var12_2) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return;
            }
            case 8: 
            case 10: 
            case 12: 
            case 14: {
                this.f = Tx.f;
                this.g = Tx.g;
                this.h = var12_2 | 1;
                this.i |= 1;
                return;
            }
            case 9: 
            case 11: 
            case 13: 
            case 15: {
                this.f += Tx.f;
                this.g += Tx.g;
                return;
            }
            case 16: 
            case 17: {
                this.h = var12_2 | 2;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                var4_4 = Tx.b;
                var10_6 = Tx.e;
                if ((var12_2 & 4) == 0) ** GOTO lbl25
                this.d *= var4_4;
                this.c *= var10_6;
                if ((var12_2 & 2) == 0) ** GOTO lbl27
lbl25:
                // 2 sources

                this.b *= var4_4;
                this.e *= var10_6;
lbl27:
                // 2 sources

                if ((var12_2 & 1) != 0) {
                    this.f *= var4_4;
                    this.g *= var10_6;
                }
                this.i = -1;
                return;
            }
            case 36: 
            case 37: {
                var12_2 |= 2;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                this.h = var12_2 ^ 4;
            }
            case 38: 
            case 39: {
                var6_8 = Tx.d;
                var8_10 = Tx.c;
                var2_12 = this.b;
                this.b = this.c * var6_8;
                this.c = var2_12 * var8_10;
                var2_12 = this.d;
                this.d = this.e * var6_8;
                this.e = var2_12 * var8_10;
                var2_12 = this.f;
                this.f = this.g * var6_8;
                this.g = var2_12 * var8_10;
                this.i = -1;
                return;
            }
        }
        var4_5 = Tx.b;
        var6_9 = Tx.d;
        var14_17 = Tx.f;
        var8_11 = Tx.c;
        var10_7 = Tx.e;
        var16_18 = var1_1.g;
        switch (var12_2) {
            default: {
                AffineTransform.b();
            }
            case 7: {
                var2_13 = this.f;
                var18_19 = this.g;
                var14_17 += var2_13 * var4_5 + var18_19 * var6_9;
                var16_18 += var2_13 * var8_11 + var18_19 * var10_7;
            }
            case 6: {
                this.f = var14_17;
                this.g = var16_18;
                var2_13 = this.b;
                var18_19 = this.c;
                this.b = var2_13 * var4_5 + var18_19 * var6_9;
                this.c = var2_13 * var8_11 + var18_19 * var10_7;
                var2_13 = this.d;
                var18_19 = this.e;
                this.d = var2_13 * var4_5 + var18_19 * var6_9;
                this.e = var2_13 * var8_11 + var18_19 * var10_7;
                break;
            }
            case 5: {
                var2_14 = this.f;
                var18_20 = this.g;
                var14_17 += var2_14 * var4_5 + var18_20 * var6_9;
                var16_18 += var2_14 * var8_11 + var18_20 * var10_7;
            }
            case 4: {
                this.f = var14_17;
                this.g = var16_18;
                var2_14 = this.c;
                this.b = var2_14 * var6_9;
                this.c = var2_14 * var10_7;
                var2_14 = this.d;
                this.d = var2_14 * var4_5;
                this.e = var2_14 * var8_11;
                break;
            }
            case 3: {
                var2_15 = this.f;
                var18_21 = this.g;
                var14_17 += var2_15 * var4_5 + var18_21 * var6_9;
                var16_18 += var2_15 * var8_11 + var18_21 * var10_7;
            }
            case 2: {
                this.f = var14_17;
                this.g = var16_18;
                var2_15 = this.b;
                this.b = var2_15 * var4_5;
                this.c = var2_15 * var8_11;
                var2_15 = this.e;
                this.d = var2_15 * var6_9;
                this.e = var2_15 * var10_7;
                break;
            }
            case 1: {
                var2_16 = this.f;
                var18_22 = this.g;
                var14_17 += var2_16 * var4_5 + var18_22 * var6_9;
                var16_18 += var2_16 * var8_11 + var18_22 * var10_7;
            }
            case 0: {
                this.f = var14_17;
                this.g = var16_18;
                this.b = var4_5;
                this.c = var8_11;
                this.d = var6_9;
                this.e = var10_7;
                this.h = var12_2 | var13_3;
                this.i = -1;
                return;
            }
        }
        this.a();
    }

    public AffineTransform createInverse() throws NoninvertibleTransformException {
        switch (this.h) {
            default: {
                AffineTransform.b();
                return null;
            }
            case 7: {
                double d2;
                double d3 = this.b * this.e - this.d * this.c;
                if (Math.abs(d2) <= Double.MIN_VALUE) {
                    throw new NoninvertibleTransformException("Determinant is " + d3);
                }
                return new AffineTransform(this.e / d3, -this.c / d3, -this.d / d3, this.b / d3, (this.d * this.g - this.e * this.f) / d3, (this.c * this.f - this.b * this.g) / d3, 7);
            }
            case 6: {
                double d4;
                double d5 = this.b * this.e - this.d * this.c;
                if (Math.abs(d4) <= Double.MIN_VALUE) {
                    throw new NoninvertibleTransformException("Determinant is " + d5);
                }
                return new AffineTransform(this.e / d5, -this.c / d5, -this.d / d5, this.b / d5, 0.0, 0.0, 6);
            }
            case 5: {
                if (this.d == 0.0 || this.c == 0.0) {
                    throw new NoninvertibleTransformException("Determinant is 0");
                }
                return new AffineTransform(0.0, 1.0 / this.d, 1.0 / this.c, 0.0, -this.g / this.c, -this.f / this.d, 5);
            }
            case 4: {
                if (this.d == 0.0 || this.c == 0.0) {
                    throw new NoninvertibleTransformException("Determinant is 0");
                }
                return new AffineTransform(0.0, 1.0 / this.d, 1.0 / this.c, 0.0, 0.0, 0.0, 4);
            }
            case 3: {
                if (this.b == 0.0 || this.e == 0.0) {
                    throw new NoninvertibleTransformException("Determinant is 0");
                }
                return new AffineTransform(1.0 / this.b, 0.0, 0.0, 1.0 / this.e, -this.f / this.b, -this.g / this.e, 3);
            }
            case 2: {
                if (this.b == 0.0 || this.e == 0.0) {
                    throw new NoninvertibleTransformException("Determinant is 0");
                }
                return new AffineTransform(1.0 / this.b, 0.0, 0.0, 1.0 / this.e, 0.0, 0.0, 2);
            }
            case 1: {
                return new AffineTransform(1.0, 0.0, 0.0, 1.0, -this.f, -this.g, 1);
            }
            case 0: 
        }
        return new AffineTransform();
    }

    public void invert() throws NoninvertibleTransformException {
        switch (this.h) {
            default: {
                AffineTransform.b();
                return;
            }
            case 7: {
                double d2;
                double d3 = this.b;
                double d4 = this.d;
                double d5 = this.f;
                double d6 = this.c;
                double d7 = this.e;
                double d8 = this.g;
                double d9 = d3 * d7 - d4 * d6;
                if (Math.abs(d2) <= Double.MIN_VALUE) {
                    throw new NoninvertibleTransformException("Determinant is " + d9);
                }
                this.b = d7 / d9;
                this.c = -d6 / d9;
                this.d = -d4 / d9;
                this.e = d3 / d9;
                this.f = (d4 * d8 - d7 * d5) / d9;
                this.g = (d6 * d5 - d3 * d8) / d9;
                return;
            }
            case 6: {
                double d10;
                double d11 = this.b;
                double d12 = this.d;
                double d13 = this.c;
                double d14 = this.e;
                double d15 = d11 * d14 - d12 * d13;
                if (Math.abs(d10) <= Double.MIN_VALUE) {
                    throw new NoninvertibleTransformException("Determinant is " + d15);
                }
                this.b = d14 / d15;
                this.c = -d13 / d15;
                this.d = -d12 / d15;
                this.e = d11 / d15;
                return;
            }
            case 5: {
                double d16 = this.d;
                double d17 = this.f;
                double d18 = this.c;
                double d19 = this.g;
                if (d16 == 0.0 || d18 == 0.0) {
                    throw new NoninvertibleTransformException("Determinant is 0");
                }
                this.c = 1.0 / d16;
                this.d = 1.0 / d18;
                this.f = -d19 / d18;
                this.g = -d17 / d16;
                return;
            }
            case 4: {
                double d20 = this.d;
                double d21 = this.c;
                if (d20 == 0.0 || d21 == 0.0) {
                    throw new NoninvertibleTransformException("Determinant is 0");
                }
                this.c = 1.0 / d20;
                this.d = 1.0 / d21;
                return;
            }
            case 3: {
                double d22 = this.b;
                double d23 = this.f;
                double d24 = this.e;
                double d25 = this.g;
                if (d22 == 0.0 || d24 == 0.0) {
                    throw new NoninvertibleTransformException("Determinant is 0");
                }
                this.b = 1.0 / d22;
                this.e = 1.0 / d24;
                this.f = -d23 / d22;
                this.g = -d25 / d24;
                return;
            }
            case 2: {
                double d26 = this.b;
                double d27 = this.e;
                if (d26 == 0.0 || d27 == 0.0) {
                    throw new NoninvertibleTransformException("Determinant is 0");
                }
                this.b = 1.0 / d26;
                this.e = 1.0 / d27;
                return;
            }
            case 1: {
                this.f = -this.f;
                this.g = -this.g;
            }
            case 0: 
        }
    }

    /*
     * WARNING - void declaration
     */
    public Point2D transform(Point2D ptSrc, Point2D ptDst) {
        void var2_2;
        void var1_1;
        if (ptDst == null) {
            ptDst = ptSrc instanceof Point2D.Double ? new Point2D.Double() : new Point2D.Float();
        }
        double d2 = ptSrc.getX();
        double d3 = var1_1.getY();
        switch (this.h) {
            default: {
                AffineTransform.b();
                return null;
            }
            case 7: {
                ptDst.setLocation(d2 * this.b + d3 * this.d + this.f, d2 * this.c + d3 * this.e + this.g);
                return ptDst;
            }
            case 6: {
                ptDst.setLocation(d2 * this.b + d3 * this.d, d2 * this.c + d3 * this.e);
                return ptDst;
            }
            case 5: {
                ptDst.setLocation(d3 * this.d + this.f, d2 * this.c + this.g);
                return ptDst;
            }
            case 4: {
                ptDst.setLocation(d3 * this.d, d2 * this.c);
                return ptDst;
            }
            case 3: {
                ptDst.setLocation(d2 * this.b + this.f, d3 * this.e + this.g);
                return ptDst;
            }
            case 2: {
                ptDst.setLocation(d2 * this.b, d3 * this.e);
                return ptDst;
            }
            case 1: {
                ptDst.setLocation(d2 + this.f, d3 + this.g);
                return ptDst;
            }
            case 0: 
        }
        ptDst.setLocation(d2, d3);
        return var2_2;
    }

    public void transform(Point2D[] ptSrc, int srcOff, Point2D[] ptDst, int dstOff, int numPts) {
        int n = this.h;
        block10: while (--numPts >= 0) {
            Point2D point2D;
            Point2D point2D2 = ptSrc[srcOff++];
            double d2 = point2D2.getX();
            double d3 = point2D2.getY();
            if ((point2D = ptDst[dstOff++]) == null) {
                point2D = point2D2 instanceof Point2D.Double ? new Point2D.Double() : new Point2D.Float();
                ptDst[dstOff - 1] = point2D;
            }
            switch (n) {
                default: {
                    AffineTransform.b();
                    return;
                }
                case 7: {
                    point2D.setLocation(d2 * this.b + d3 * this.d + this.f, d2 * this.c + d3 * this.e + this.g);
                    continue block10;
                }
                case 6: {
                    point2D.setLocation(d2 * this.b + d3 * this.d, d2 * this.c + d3 * this.e);
                    continue block10;
                }
                case 5: {
                    point2D.setLocation(d3 * this.d + this.f, d2 * this.c + this.g);
                    continue block10;
                }
                case 4: {
                    point2D.setLocation(d3 * this.d, d2 * this.c);
                    continue block10;
                }
                case 3: {
                    point2D.setLocation(d2 * this.b + this.f, d3 * this.e + this.g);
                    continue block10;
                }
                case 2: {
                    point2D.setLocation(d2 * this.b, d3 * this.e);
                    continue block10;
                }
                case 1: {
                    point2D.setLocation(d2 + this.f, d3 + this.g);
                    continue block10;
                }
                case 0: 
            }
            point2D.setLocation(d2, d3);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void transform(float[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) {
        if (dstPts == srcPts && dstOff > srcOff && dstOff < srcOff + (numPts << 1)) {
            System.arraycopy(srcPts, srcOff, dstPts, dstOff, numPts << 1);
            srcOff = dstOff;
        }
        switch (this.h) {
            default: {
                AffineTransform.b();
                return;
            }
            case 7: {
                double d2 = this.b;
                double d3 = this.d;
                double d4 = this.f;
                double d5 = this.c;
                double d6 = this.e;
                double d7 = this.g;
                while (--numPts >= 0) {
                    double d8 = srcPts[srcOff++];
                    double d9 = srcPts[srcOff++];
                    dstPts[dstOff++] = (float)(d2 * d8 + d3 * d9 + d4);
                    dstPts[dstOff++] = (float)(d5 * d8 + d6 * d9 + d7);
                }
                return;
            }
            case 6: {
                double d10 = this.b;
                double d11 = this.d;
                double d12 = this.c;
                double d13 = this.e;
                while (--numPts >= 0) {
                    double d14 = srcPts[srcOff++];
                    double d15 = srcPts[srcOff++];
                    dstPts[dstOff++] = (float)(d10 * d14 + d11 * d15);
                    dstPts[dstOff++] = (float)(d12 * d14 + d13 * d15);
                }
                return;
            }
            case 5: {
                double d16 = this.d;
                double d17 = this.f;
                double d18 = this.c;
                double d19 = this.g;
                while (--numPts >= 0) {
                    double d20 = srcPts[srcOff++];
                    dstPts[dstOff++] = (float)(d16 * (double)srcPts[srcOff++] + d17);
                    dstPts[dstOff++] = (float)(d18 * d20 + d19);
                }
                return;
            }
            case 4: {
                double d21 = this.d;
                double d22 = this.c;
                while (--numPts >= 0) {
                    double d23 = srcPts[srcOff++];
                    dstPts[dstOff++] = (float)(d21 * (double)srcPts[srcOff++]);
                    dstPts[dstOff++] = (float)(d22 * d23);
                }
                return;
            }
            case 3: {
                double d24 = this.b;
                double d25 = this.f;
                double d26 = this.e;
                double d27 = this.g;
                while (--numPts >= 0) {
                    dstPts[dstOff++] = (float)(d24 * (double)srcPts[srcOff++] + d25);
                    dstPts[dstOff++] = (float)(d26 * (double)srcPts[srcOff++] + d27);
                }
                return;
            }
            case 2: {
                double d28 = this.b;
                double d29 = this.e;
                while (--numPts >= 0) {
                    dstPts[dstOff++] = (float)(d28 * (double)srcPts[srcOff++]);
                    dstPts[dstOff++] = (float)(d29 * (double)srcPts[srcOff++]);
                }
                return;
            }
            case 1: {
                double d30 = this.f;
                double d31 = this.g;
                while (--numPts >= 0) {
                    dstPts[dstOff++] = (float)((double)srcPts[srcOff++] + d30);
                    dstPts[dstOff++] = (float)((double)srcPts[srcOff++] + d31);
                }
                return;
            }
            case 0: 
        }
        if (srcPts != dstPts || srcOff != dstOff) {
            void var3_3;
            void var2_2;
            void var1_1;
            System.arraycopy(var1_1, (int)var2_2, var3_3, dstOff, numPts << 1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) {
        if (dstPts == srcPts && dstOff > srcOff && dstOff < srcOff + (numPts << 1)) {
            System.arraycopy(srcPts, srcOff, dstPts, dstOff, numPts << 1);
            srcOff = dstOff;
        }
        switch (this.h) {
            default: {
                AffineTransform.b();
                return;
            }
            case 7: {
                double d2 = this.b;
                double d3 = this.d;
                double d4 = this.f;
                double d5 = this.c;
                double d6 = this.e;
                double d7 = this.g;
                while (--numPts >= 0) {
                    double d8 = srcPts[srcOff++];
                    double d9 = srcPts[srcOff++];
                    dstPts[dstOff++] = d2 * d8 + d3 * d9 + d4;
                    dstPts[dstOff++] = d5 * d8 + d6 * d9 + d7;
                }
                return;
            }
            case 6: {
                double d10 = this.b;
                double d11 = this.d;
                double d12 = this.c;
                double d13 = this.e;
                while (--numPts >= 0) {
                    double d14 = srcPts[srcOff++];
                    double d15 = srcPts[srcOff++];
                    dstPts[dstOff++] = d10 * d14 + d11 * d15;
                    dstPts[dstOff++] = d12 * d14 + d13 * d15;
                }
                return;
            }
            case 5: {
                double d16 = this.d;
                double d17 = this.f;
                double d18 = this.c;
                double d19 = this.g;
                while (--numPts >= 0) {
                    double d20 = srcPts[srcOff++];
                    dstPts[dstOff++] = d16 * srcPts[srcOff++] + d17;
                    dstPts[dstOff++] = d18 * d20 + d19;
                }
                return;
            }
            case 4: {
                double d21 = this.d;
                double d22 = this.c;
                while (--numPts >= 0) {
                    double d23 = srcPts[srcOff++];
                    dstPts[dstOff++] = d21 * srcPts[srcOff++];
                    dstPts[dstOff++] = d22 * d23;
                }
                return;
            }
            case 3: {
                double d24 = this.b;
                double d25 = this.f;
                double d26 = this.e;
                double d27 = this.g;
                while (--numPts >= 0) {
                    dstPts[dstOff++] = d24 * srcPts[srcOff++] + d25;
                    dstPts[dstOff++] = d26 * srcPts[srcOff++] + d27;
                }
                return;
            }
            case 2: {
                double d28 = this.b;
                double d29 = this.e;
                while (--numPts >= 0) {
                    dstPts[dstOff++] = d28 * srcPts[srcOff++];
                    dstPts[dstOff++] = d29 * srcPts[srcOff++];
                }
                return;
            }
            case 1: {
                double d30 = this.f;
                double d31 = this.g;
                while (--numPts >= 0) {
                    dstPts[dstOff++] = srcPts[srcOff++] + d30;
                    dstPts[dstOff++] = srcPts[srcOff++] + d31;
                }
                return;
            }
            case 0: 
        }
        if (srcPts != dstPts || srcOff != dstOff) {
            void var3_3;
            void var2_2;
            void var1_1;
            System.arraycopy(var1_1, (int)var2_2, var3_3, dstOff, numPts << 1);
        }
    }

    public void transform(float[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) {
        switch (this.h) {
            default: {
                AffineTransform.b();
                return;
            }
            case 7: {
                double d2 = this.b;
                double d3 = this.d;
                double d4 = this.f;
                double d5 = this.c;
                double d6 = this.e;
                double d7 = this.g;
                while (--numPts >= 0) {
                    double d8 = srcPts[srcOff++];
                    double d9 = srcPts[srcOff++];
                    dstPts[dstOff++] = d2 * d8 + d3 * d9 + d4;
                    dstPts[dstOff++] = d5 * d8 + d6 * d9 + d7;
                }
                return;
            }
            case 6: {
                double d10 = this.b;
                double d11 = this.d;
                double d12 = this.c;
                double d13 = this.e;
                while (--numPts >= 0) {
                    double d14 = srcPts[srcOff++];
                    double d15 = srcPts[srcOff++];
                    dstPts[dstOff++] = d10 * d14 + d11 * d15;
                    dstPts[dstOff++] = d12 * d14 + d13 * d15;
                }
                return;
            }
            case 5: {
                double d16 = this.d;
                double d17 = this.f;
                double d18 = this.c;
                double d19 = this.g;
                while (--numPts >= 0) {
                    double d20 = srcPts[srcOff++];
                    dstPts[dstOff++] = d16 * (double)srcPts[srcOff++] + d17;
                    dstPts[dstOff++] = d18 * d20 + d19;
                }
                return;
            }
            case 4: {
                double d21 = this.d;
                double d22 = this.c;
                while (--numPts >= 0) {
                    double d23 = srcPts[srcOff++];
                    dstPts[dstOff++] = d21 * (double)srcPts[srcOff++];
                    dstPts[dstOff++] = d22 * d23;
                }
                return;
            }
            case 3: {
                double d24 = this.b;
                double d25 = this.f;
                double d26 = this.e;
                double d27 = this.g;
                while (--numPts >= 0) {
                    dstPts[dstOff++] = d24 * (double)srcPts[srcOff++] + d25;
                    dstPts[dstOff++] = d26 * (double)srcPts[srcOff++] + d27;
                }
                return;
            }
            case 2: {
                double d28 = this.b;
                double d29 = this.e;
                while (--numPts >= 0) {
                    dstPts[dstOff++] = d28 * (double)srcPts[srcOff++];
                    dstPts[dstOff++] = d29 * (double)srcPts[srcOff++];
                }
                return;
            }
            case 1: {
                double d30 = this.f;
                double d31 = this.g;
                while (--numPts >= 0) {
                    dstPts[dstOff++] = (double)srcPts[srcOff++] + d30;
                    dstPts[dstOff++] = (double)srcPts[srcOff++] + d31;
                }
                return;
            }
            case 0: 
        }
        while (--numPts >= 0) {
            dstPts[dstOff++] = srcPts[srcOff++];
            dstPts[dstOff++] = srcPts[srcOff++];
        }
    }

    public void transform(double[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) {
        switch (this.h) {
            default: {
                AffineTransform.b();
                return;
            }
            case 7: {
                double d2 = this.b;
                double d3 = this.d;
                double d4 = this.f;
                double d5 = this.c;
                double d6 = this.e;
                double d7 = this.g;
                while (--numPts >= 0) {
                    double d8 = srcPts[srcOff++];
                    double d9 = srcPts[srcOff++];
                    dstPts[dstOff++] = (float)(d2 * d8 + d3 * d9 + d4);
                    dstPts[dstOff++] = (float)(d5 * d8 + d6 * d9 + d7);
                }
                return;
            }
            case 6: {
                double d10 = this.b;
                double d11 = this.d;
                double d12 = this.c;
                double d13 = this.e;
                while (--numPts >= 0) {
                    double d14 = srcPts[srcOff++];
                    double d15 = srcPts[srcOff++];
                    dstPts[dstOff++] = (float)(d10 * d14 + d11 * d15);
                    dstPts[dstOff++] = (float)(d12 * d14 + d13 * d15);
                }
                return;
            }
            case 5: {
                double d16 = this.d;
                double d17 = this.f;
                double d18 = this.c;
                double d19 = this.g;
                while (--numPts >= 0) {
                    double d20 = srcPts[srcOff++];
                    dstPts[dstOff++] = (float)(d16 * srcPts[srcOff++] + d17);
                    dstPts[dstOff++] = (float)(d18 * d20 + d19);
                }
                return;
            }
            case 4: {
                double d21 = this.d;
                double d22 = this.c;
                while (--numPts >= 0) {
                    double d23 = srcPts[srcOff++];
                    dstPts[dstOff++] = (float)(d21 * srcPts[srcOff++]);
                    dstPts[dstOff++] = (float)(d22 * d23);
                }
                return;
            }
            case 3: {
                double d24 = this.b;
                double d25 = this.f;
                double d26 = this.e;
                double d27 = this.g;
                while (--numPts >= 0) {
                    dstPts[dstOff++] = (float)(d24 * srcPts[srcOff++] + d25);
                    dstPts[dstOff++] = (float)(d26 * srcPts[srcOff++] + d27);
                }
                return;
            }
            case 2: {
                double d28 = this.b;
                double d29 = this.e;
                while (--numPts >= 0) {
                    dstPts[dstOff++] = (float)(d28 * srcPts[srcOff++]);
                    dstPts[dstOff++] = (float)(d29 * srcPts[srcOff++]);
                }
                return;
            }
            case 1: {
                double d30 = this.f;
                double d31 = this.g;
                while (--numPts >= 0) {
                    dstPts[dstOff++] = (float)(srcPts[srcOff++] + d30);
                    dstPts[dstOff++] = (float)(srcPts[srcOff++] + d31);
                }
                return;
            }
            case 0: 
        }
        while (--numPts >= 0) {
            dstPts[dstOff++] = (float)srcPts[srcOff++];
            dstPts[dstOff++] = (float)srcPts[srcOff++];
        }
    }

    /*
     * WARNING - void declaration
     */
    public Point2D inverseTransform(Point2D ptSrc, Point2D ptDst) throws NoninvertibleTransformException {
        void var2_2;
        void var1_1;
        if (ptDst == null) {
            ptDst = ptSrc instanceof Point2D.Double ? new Point2D.Double() : new Point2D.Float();
        }
        double d2 = ptSrc.getX();
        double d3 = var1_1.getY();
        switch (this.h) {
            default: {
                AffineTransform.b();
            }
            case 7: {
                d2 -= this.f;
                d3 -= this.g;
            }
            case 6: {
                double d4;
                double d5 = this.b * this.e - this.d * this.c;
                if (Math.abs(d4) <= Double.MIN_VALUE) {
                    throw new NoninvertibleTransformException("Determinant is " + d5);
                }
                ptDst.setLocation((d2 * this.e - d3 * this.d) / d5, (d3 * this.b - d2 * this.c) / d5);
                return ptDst;
            }
            case 5: {
                d2 -= this.f;
                d3 -= this.g;
            }
            case 4: {
                if (this.d == 0.0 || this.c == 0.0) {
                    throw new NoninvertibleTransformException("Determinant is 0");
                }
                ptDst.setLocation(d3 / this.c, d2 / this.d);
                return ptDst;
            }
            case 3: {
                d2 -= this.f;
                d3 -= this.g;
            }
            case 2: {
                if (this.b == 0.0 || this.e == 0.0) {
                    throw new NoninvertibleTransformException("Determinant is 0");
                }
                ptDst.setLocation(d2 / this.b, d3 / this.e);
                return ptDst;
            }
            case 1: {
                ptDst.setLocation(d2 - this.f, d3 - this.g);
                return ptDst;
            }
            case 0: 
        }
        ptDst.setLocation(d2, d3);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public void inverseTransform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) throws NoninvertibleTransformException {
        if (dstPts == srcPts && dstOff > srcOff && dstOff < srcOff + (numPts << 1)) {
            System.arraycopy(srcPts, srcOff, dstPts, dstOff, numPts << 1);
            srcOff = dstOff;
        }
        switch (this.h) {
            default: {
                AffineTransform.b();
                return;
            }
            case 7: {
                double d2;
                double d3 = this.b;
                double d4 = this.d;
                double d5 = this.f;
                double d6 = this.c;
                double d7 = this.e;
                double d8 = this.g;
                double d9 = d3 * d7 - d4 * d6;
                if (Math.abs(d2) <= Double.MIN_VALUE) {
                    throw new NoninvertibleTransformException("Determinant is " + d9);
                }
                while (--numPts >= 0) {
                    double d10 = srcPts[srcOff++] - d5;
                    double d11 = srcPts[srcOff++] - d8;
                    dstPts[dstOff++] = (d10 * d7 - d11 * d4) / d9;
                    dstPts[dstOff++] = (d11 * d3 - d10 * d6) / d9;
                }
                return;
            }
            case 6: {
                double d12;
                double d13 = this.b;
                double d14 = this.d;
                double d15 = this.c;
                double d16 = this.e;
                double d17 = d13 * d16 - d14 * d15;
                if (Math.abs(d12) <= Double.MIN_VALUE) {
                    throw new NoninvertibleTransformException("Determinant is " + d17);
                }
                while (--numPts >= 0) {
                    double d18 = srcPts[srcOff++];
                    double d19 = srcPts[srcOff++];
                    dstPts[dstOff++] = (d18 * d16 - d19 * d14) / d17;
                    dstPts[dstOff++] = (d19 * d13 - d18 * d15) / d17;
                }
                return;
            }
            case 5: {
                double d20 = this.d;
                double d21 = this.f;
                double d22 = this.c;
                double d23 = this.g;
                if (d20 == 0.0 || d22 == 0.0) {
                    throw new NoninvertibleTransformException("Determinant is 0");
                }
                while (--numPts >= 0) {
                    double d24 = srcPts[srcOff++] - d21;
                    dstPts[dstOff++] = (srcPts[srcOff++] - d23) / d22;
                    dstPts[dstOff++] = d24 / d20;
                }
                return;
            }
            case 4: {
                double d25 = this.d;
                double d26 = this.c;
                if (d25 == 0.0 || d26 == 0.0) {
                    throw new NoninvertibleTransformException("Determinant is 0");
                }
                while (--numPts >= 0) {
                    double d27 = srcPts[srcOff++];
                    dstPts[dstOff++] = srcPts[srcOff++] / d26;
                    dstPts[dstOff++] = d27 / d25;
                }
                return;
            }
            case 3: {
                double d28 = this.b;
                double d29 = this.f;
                double d30 = this.e;
                double d31 = this.g;
                if (d28 == 0.0 || d30 == 0.0) {
                    throw new NoninvertibleTransformException("Determinant is 0");
                }
                while (--numPts >= 0) {
                    dstPts[dstOff++] = (srcPts[srcOff++] - d29) / d28;
                    dstPts[dstOff++] = (srcPts[srcOff++] - d31) / d30;
                }
                return;
            }
            case 2: {
                double d32 = this.b;
                double d33 = this.e;
                if (d32 == 0.0 || d33 == 0.0) {
                    throw new NoninvertibleTransformException("Determinant is 0");
                }
                while (--numPts >= 0) {
                    dstPts[dstOff++] = srcPts[srcOff++] / d32;
                    dstPts[dstOff++] = srcPts[srcOff++] / d33;
                }
                return;
            }
            case 1: {
                double d34 = this.f;
                double d35 = this.g;
                while (--numPts >= 0) {
                    dstPts[dstOff++] = srcPts[srcOff++] - d34;
                    dstPts[dstOff++] = srcPts[srcOff++] - d35;
                }
                return;
            }
            case 0: 
        }
        if (srcPts != dstPts || srcOff != dstOff) {
            void var3_3;
            void var2_2;
            void var1_1;
            System.arraycopy(var1_1, (int)var2_2, var3_3, dstOff, numPts << 1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public Point2D deltaTransform(Point2D ptSrc, Point2D ptDst) {
        void var2_2;
        void var1_1;
        if (ptDst == null) {
            ptDst = ptSrc instanceof Point2D.Double ? new Point2D.Double() : new Point2D.Float();
        }
        double d2 = ptSrc.getX();
        double d3 = var1_1.getY();
        switch (this.h) {
            default: {
                AffineTransform.b();
                return null;
            }
            case 6: 
            case 7: {
                ptDst.setLocation(d2 * this.b + d3 * this.d, d2 * this.c + d3 * this.e);
                return ptDst;
            }
            case 4: 
            case 5: {
                ptDst.setLocation(d3 * this.d, d2 * this.c);
                return ptDst;
            }
            case 2: 
            case 3: {
                ptDst.setLocation(d2 * this.b, d3 * this.e);
                return ptDst;
            }
            case 0: 
            case 1: 
        }
        ptDst.setLocation(d2, d3);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public void deltaTransform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) {
        if (dstPts == srcPts && dstOff > srcOff && dstOff < srcOff + (numPts << 1)) {
            System.arraycopy(srcPts, srcOff, dstPts, dstOff, numPts << 1);
            srcOff = dstOff;
        }
        switch (this.h) {
            default: {
                AffineTransform.b();
                return;
            }
            case 6: 
            case 7: {
                double d2 = this.b;
                double d3 = this.d;
                double d4 = this.c;
                double d5 = this.e;
                while (--numPts >= 0) {
                    double d6 = srcPts[srcOff++];
                    double d7 = srcPts[srcOff++];
                    dstPts[dstOff++] = d6 * d2 + d7 * d3;
                    dstPts[dstOff++] = d6 * d4 + d7 * d5;
                }
                return;
            }
            case 4: 
            case 5: {
                double d8 = this.d;
                double d9 = this.c;
                while (--numPts >= 0) {
                    double d10 = srcPts[srcOff++];
                    dstPts[dstOff++] = srcPts[srcOff++] * d8;
                    dstPts[dstOff++] = d10 * d9;
                }
                return;
            }
            case 2: 
            case 3: {
                double d11 = this.b;
                double d12 = this.e;
                while (--numPts >= 0) {
                    dstPts[dstOff++] = srcPts[srcOff++] * d11;
                    dstPts[dstOff++] = srcPts[srcOff++] * d12;
                }
                return;
            }
            case 0: 
            case 1: 
        }
        if (srcPts != dstPts || srcOff != dstOff) {
            void var3_3;
            void var2_2;
            void var1_1;
            System.arraycopy(var1_1, (int)var2_2, var3_3, dstOff, numPts << 1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public Shape createTransformedShape(Shape pSrc) {
        void var1_1;
        if (pSrc == null) {
            return null;
        }
        return new Path2D.Double((Shape)var1_1, this);
    }

    public boolean isIdentity() {
        return this.h == 0 || this.getType() == 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int getType() {
        if (this.i != -1) return this.i;
        AffineTransform affineTransform = this;
        affineTransform.a();
        int n = 0;
        switch (affineTransform.h) {
            default: {
                AffineTransform.b();
            }
            case 7: {
                n = 1;
            }
            case 6: {
                boolean bl;
                double d2 = affineTransform.b;
                double d3 = affineTransform.d;
                double d4 = affineTransform.c;
                double d5 = affineTransform.e;
                if (d2 * d3 + d4 * d5 != 0.0) {
                    affineTransform.i = 32;
                    return this.i;
                }
                boolean bl2 = d2 >= 0.0;
                boolean bl3 = bl = d5 >= 0.0;
                if (bl2 == bl) {
                    if (d2 != d5 || d3 != -d4) {
                        n |= 0x14;
                        break;
                    }
                    if (d2 * d5 - d3 * d4 != 1.0) {
                        n |= 0x12;
                        break;
                    }
                    n |= 0x10;
                    break;
                }
                if (d2 != -d5 || d3 != d4) {
                    n |= 0x54;
                    break;
                }
                if (d2 * d5 - d3 * d4 != 1.0) {
                    n |= 0x52;
                    break;
                }
                n |= 0x50;
                break;
            }
            case 5: {
                n = 1;
            }
            case 4: {
                double d6;
                boolean bl;
                double d7;
                double d8 = affineTransform.d;
                boolean bl4 = d7 >= 0.0;
                double d9 = affineTransform.c;
                boolean bl5 = bl = d6 >= 0.0;
                if (bl4 != bl) {
                    if (d8 != -d9) {
                        n |= 0xC;
                        break;
                    }
                    if (d8 != 1.0 && d8 != -1.0) {
                        n |= 0xA;
                        break;
                    }
                    n |= 8;
                    break;
                }
                if (d8 == d9) {
                    n |= 0x4A;
                    break;
                }
                n |= 0x4C;
                break;
            }
            case 3: {
                n = 1;
            }
            case 2: {
                double d10;
                boolean bl;
                double d11;
                double d12 = affineTransform.b;
                boolean bl6 = d11 >= 0.0;
                double d13 = affineTransform.e;
                boolean bl7 = bl = d10 >= 0.0;
                if (bl6 == bl) {
                    if (bl6) {
                        if (d12 == d13) {
                            n |= 2;
                            break;
                        }
                        n |= 4;
                        break;
                    }
                    if (d12 != d13) {
                        n |= 0xC;
                        break;
                    }
                    if (d12 != -1.0) {
                        n |= 0xA;
                        break;
                    }
                    n |= 8;
                    break;
                }
                if (d12 == -d13) {
                    if (d12 == 1.0 || d12 == -1.0) {
                        n |= 0x40;
                        break;
                    }
                    n |= 0x42;
                    break;
                }
                n |= 0x44;
                break;
            }
            case 1: {
                n = 1;
            }
            case 0: 
        }
        affineTransform.i = n;
        return this.i;
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.b);
        l = l * 31L + Double.doubleToLongBits(this.d);
        l = l * 31L + Double.doubleToLongBits(this.f);
        l = l * 31L + Double.doubleToLongBits(this.c);
        l = l * 31L + Double.doubleToLongBits(this.e);
        l = l * 31L + Double.doubleToLongBits(this.g);
        return (int)l ^ (int)(l >> 32);
    }

    public boolean equals(Object obj) {
        AffineTransform affineTransform;
        if (!(obj instanceof AffineTransform)) {
            return false;
        }
        affineTransform = affineTransform;
        return this.b == affineTransform.b && this.d == affineTransform.d && this.f == affineTransform.f && this.c == affineTransform.c && this.e == affineTransform.e && this.g == affineTransform.g;
    }

    @GwtIncompatible
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new UnsupportedOperationException(cloneNotSupportedException);
        }
    }

    public String toString() {
        return "AffineTransform[[" + AffineTransform.a(this.b) + ", " + AffineTransform.a(this.d) + ", " + AffineTransform.a(this.f) + "], [" + AffineTransform.a(this.c) + ", " + AffineTransform.a(this.e) + ", " + AffineTransform.a(this.g) + "]]";
    }

    private static double a(double d2) {
        return Math.rint(d2 * 1.0E15) / 1.0E15;
    }
}

