/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.geom;

import com.macrofocus.geom.AbstractRectangle2D;
import com.macrofocus.geom.Path;
import com.macrofocus.geom.Point2D;
import com.macrofocus.geom.Rectangle2D;

public class Rectangle
extends AbstractRectangle2D {
    public int x;
    public int y;
    public int width;
    public int height;

    public Rectangle() {
    }

    /*
     * WARNING - void declaration
     */
    public Rectangle(Rectangle rectangle) {
        void var1_1;
        this.x = rectangle.x;
        this.y = rectangle.y;
        this.width = rectangle.width;
        this.height = var1_1.height;
    }

    /*
     * WARNING - void declaration
     */
    public Rectangle(int x, int y, int width, int height) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.x = var1_1;
        this.y = var2_2;
        this.width = var3_3;
        this.height = height;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Rectangle2D add(double x, double y) {
        void var3_2;
        void var1_1;
        double d2 = Math.min(this.getMinX(), x);
        double d3 = Math.max(this.getMaxX(), (double)var1_1);
        double d4 = Math.min(this.getMinY(), y);
        double d5 = Math.max(this.getMaxY(), (double)var3_2);
        return new Rectangle2D.Double(d2, d4, d3 - d2, d5 - d4);
    }

    public Path toPath() {
        Path path = new Path();
        path.moveTo(this.x, this.y);
        path.lineTo(this.x + this.width, this.y);
        path.lineTo(this.x + this.width, this.y + this.height);
        path.lineTo(this.x, this.y + this.height);
        path.close();
        return path;
    }

    @Override
    public double getX() {
        return this.x;
    }

    /*
     * WARNING - void declaration
     */
    public Rectangle intersection(Rectangle r) {
        void var1_1;
        int n = this.x;
        int n2 = this.y;
        int n3 = r.x;
        int n4 = r.y;
        long l = n;
        l += (long)this.width;
        long l2 = n2;
        l2 += (long)this.height;
        long l3 = n3;
        l3 += (long)r.width;
        long l4 = n4;
        l4 += (long)var1_1.height;
        if (n < n3) {
            n = n3;
        }
        if (n2 < n4) {
            n2 = n4;
        }
        if (l > l3) {
            l = l3;
        }
        if (l2 > l4) {
            l2 = l4;
        }
        l2 -= (long)n2;
        if ((l -= (long)n) < Integer.MIN_VALUE) {
            l = Integer.MIN_VALUE;
        }
        if (l2 < Integer.MIN_VALUE) {
            l2 = Integer.MIN_VALUE;
        }
        return new Rectangle(n, n2, (int)l, (int)l2);
    }

    /*
     * WARNING - void declaration
     */
    public void setX(int x) {
        void var1_1;
        this.x = var1_1;
    }

    public String toString() {
        return "Rectangle{x=" + this.x + ", y=" + this.y + ", width=" + this.width + ", height=" + this.height + "}";
    }

    @Override
    public double getY() {
        return this.y;
    }

    /*
     * WARNING - void declaration
     */
    public void setY(int y) {
        void var1_1;
        this.y = var1_1;
    }

    @Override
    public double getWidth() {
        return this.width;
    }

    /*
     * WARNING - void declaration
     */
    public void setWidth(int width) {
        void var1_1;
        this.width = var1_1;
    }

    @Override
    public double getHeight() {
        return this.height;
    }

    /*
     * WARNING - void declaration
     */
    public void setHeight(int height) {
        void var1_1;
        this.height = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean contains(Point2D point) {
        void var1_1;
        return point.getY() >= (double)this.y && point.getY() <= (double)(this.y + this.height) && point.getX() >= (double)this.x && var1_1.getX() <= (double)(this.x + this.width);
    }

    @Override
    public Rectangle2D normalize() {
        Rectangle rectangle = this;
        if (rectangle.width >= 0 && rectangle.height >= 0) {
            return this;
        }
        int n = this.x;
        int n2 = this.y;
        int n3 = this.width;
        int n4 = this.height;
        if (n3 < 0) {
            n3 = -n3;
            n -= n3;
        }
        if (n4 < 0) {
            n4 = -n4;
            n2 -= this.height;
        }
        return new Rectangle(n, n2, n3, n4);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean intersects(double x, double y, double w, double h2) {
        void var3_2;
        void var1_1;
        return this.intersects(new Rectangle2D.Double((double)var1_1, (double)var3_2, w, h2));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean contains(double x, double y, double w, double h2) {
        void var3_2;
        void var1_1;
        if (this.isEmpty() || w <= 0.0 || h2 <= 0.0) {
            return false;
        }
        double d2 = this.getX();
        double d3 = this.getY();
        return x >= d2 && y >= d3 && var1_1 + w <= d2 + this.getWidth() && var3_2 + h2 <= d3 + this.getHeight();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean contains(double x, double y) {
        void var3_2;
        void var1_1;
        return ((AbstractRectangle2D)this).contains(new Point2D.Double((double)var1_1, (double)var3_2));
    }

    public boolean isEmpty() {
        return this.width <= 0 || this.height <= 0;
    }
}

