/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.geom;

import com.macrofocus.geom.AbstractRectangle2D;
import com.macrofocus.geom.Point2D;
import com.macrofocus.geom.Shape;

public interface Rectangle2D
extends Shape {
    public double getX();

    public double getY();

    public double getWidth();

    public double getHeight();

    public double getMinX();

    public double getMinY();

    public double getMaxX();

    public double getMaxY();

    public double getCenterX();

    public double getCenterY();

    public boolean intersectsLine(double var1, double var3, double var5, double var7);

    public Rectangle2D createIntersection(Rectangle2D var1);

    public Rectangle2D createUnion(Rectangle2D var1);

    public Rectangle2D normalize();

    public Rectangle2D add(double var1, double var3);

    public boolean intersects(double var1, double var3, double var5, double var7);

    public boolean contains(double var1, double var3, double var5, double var7);

    public boolean contains(double var1, double var3);

    public static class Double
    extends AbstractRectangle2D {
        private final double a;
        private final double b;
        private final double c;
        private final double d;

        /*
         * WARNING - void declaration
         */
        public Double(double x, double y, double width, double height) {
            void var3_2;
            void var1_1;
            this.a = var1_1;
            this.b = var3_2;
            this.c = width;
            this.d = height;
        }

        /*
         * WARNING - void declaration
         */
        public static Double frameFromDiagonal(double x1, double y1, double x2, double y2) {
            void var2_1;
            double d2;
            double d3;
            if (x2 < x1) {
                d3 = x1;
                x1 = x2;
                x2 = d3;
            }
            if (y2 < y1) {
                d3 = y1;
                y1 = y2;
                y2 = d3;
            }
            return new Double(x1, y1, x2 - d2, y2 - var2_1);
        }

        /*
         * WARNING - void declaration
         */
        public Double add(Rectangle2D r) {
            void var1_1;
            double d2 = Math.min(this.getMinX(), r.getMinX());
            double d3 = Math.max(this.getMaxX(), r.getMaxX());
            double d4 = Math.min(this.getMinY(), r.getMinY());
            double d5 = Math.max(this.getMaxY(), var1_1.getMaxY());
            return new Double(d2, d4, d3 - d2, d5 - d4);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Rectangle2D add(double x, double y) {
            void var3_2;
            void var1_1;
            double d2 = Math.min(this.getMinX(), x);
            double d3 = Math.max(this.getMaxX(), (double)var1_1);
            double d4 = Math.min(this.getMinY(), y);
            double d5 = Math.max(this.getMaxY(), (double)var3_2);
            return new Double(d2, d4, d3 - d2, d5 - d4);
        }

        @Override
        public double getX() {
            return this.a;
        }

        public String toString() {
            return "Rectangle2D.Double{x=" + this.a + ", y=" + this.b + ", width=" + this.c + ", height=" + this.d + "}";
        }

        @Override
        public double getY() {
            return this.b;
        }

        @Override
        public double getWidth() {
            return this.c;
        }

        @Override
        public double getHeight() {
            return this.d;
        }

        @Override
        public Double normalize() {
            double d2;
            Double double_;
            Double double_2 = this;
            if (double_.c >= 0.0 && double_2.d >= 0.0) {
                return this;
            }
            double d3 = this.a;
            double d4 = this.c;
            if (d2 < 0.0) {
                d4 = -d4;
                d3 -= d4;
            }
            double d5 = this.d;
            double d6 = this.b;
            if (d5 < 0.0) {
                d5 = -d5;
                d6 -= d5;
            }
            return new Double(d3, d6, d4, d5);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean intersects(double x, double y, double w, double h2) {
            void var3_2;
            void var1_1;
            return this.intersects(new Double((double)var1_1, (double)var3_2, w, h2));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean contains(double x, double y, double w, double h2) {
            void var3_2;
            void var1_1;
            if (this.isEmpty() || w <= 0.0 || h2 <= 0.0) {
                return false;
            }
            double d2 = this.getX();
            double d3 = this.getY();
            return x >= d2 && y >= d3 && var1_1 + w <= d2 + this.getWidth() && var3_2 + h2 <= d3 + this.getHeight();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean contains(double x, double y) {
            void var3_2;
            void var1_1;
            return this.contains(new Point2D.Double((double)var1_1, (double)var3_2));
        }

        public boolean isEmpty() {
            return this.c <= 0.0 || this.d <= 0.0;
        }
    }
}

