/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.palette;

import com.macrofocus.igraphics.CPColor;
import com.macrofocus.igraphics.CPColorFactory;
import com.macrofocus.palette.AbstractMutablePalette;
import com.macrofocus.palette.AbstractPalette;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import jsinterop.annotations.JsIgnore;

public class DynamicPalette<Color>
extends AbstractMutablePalette<Color> {
    protected List<CPColor<Color>> colors;
    private boolean a = false;

    protected DynamicPalette() {
    }

    /*
     * WARNING - void declaration
     */
    @JsIgnore
    public DynamicPalette(CPColorFactory<Color> factory, int ... colors) {
        this((CPColorFactory<Color>)var1_1, false, (int[])var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @JsIgnore
    public DynamicPalette(CPColorFactory<Color> factory, boolean inverted, int ... colors) {
        void var3_4;
        void var2_2;
        this.a = var2_2;
        this.colors = new ArrayList<CPColor<Color>>(colors.length);
        for (void var5_7 : var3_4) {
            this.colors.add(factory.createColor((int)var5_7));
        }
        this.colorCount = this.colors.size();
    }

    /*
     * WARNING - void declaration
     */
    public DynamicPalette(CPColor<Color> ... colors) {
        void var1_1;
        this.colors = Arrays.asList(var1_1);
        this.colorCount = this.colors.size();
    }

    /*
     * WARNING - void declaration
     */
    public DynamicPalette(boolean inverted, CPColor<Color> ... colors) {
        void var1_1;
        void var2_2;
        this.colors = Arrays.asList(var2_2);
        this.colorCount = this.colors.size();
        this.a = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DynamicPalette(List<CPColor<Color>> colors) {
        void var1_1;
        this.colors = new ArrayList<CPColor<Color>>(var1_1);
        this.colorCount = this.colors.size();
    }

    @Override
    public boolean isInverted() {
        return this.a;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CPColor<Color> getColor(double fraction) {
        void var1_1;
        boolean bl = ((AbstractPalette)this).isInverted();
        switch (this.getCycle()) {
            case REFLECT: {
                bl = (int)fraction % 2 == 0;
            }
            case REPEAT: {
                double d2 = fraction;
                fraction = d2 - (double)((int)d2);
            }
        }
        if (fraction < this.getLowestFraction()) {
            DynamicPalette dynamicPalette = this;
            return dynamicPalette.getColor(dynamicPalette.getLowestFraction());
        }
        if (fraction > this.getHighestFraction()) {
            DynamicPalette dynamicPalette = this;
            return dynamicPalette.getColor(dynamicPalette.getHighestFraction());
        }
        int n = this.getEntry(!bl ? fraction : 1.0 - var1_1, this.colorCount, this.colors.size());
        return this.colors.get(n);
    }

    protected double getLowestFraction() {
        return 0.0;
    }

    protected double getHighestFraction() {
        return 1.0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CPColor<Color> getColorAt(int index) {
        void var1_1;
        if (this.colorCount == this.colors.size()) {
            if (index < 0) {
                return this.getColorAt(0);
            }
            if (index > this.colorCount - 1) {
                DynamicPalette dynamicPalette = this;
                return dynamicPalette.getColorAt(dynamicPalette.colorCount - 1);
            }
            return this.colors.get(index);
        }
        DynamicPalette dynamicPalette = this;
        return dynamicPalette.getColor((double)dynamicPalette.colorCount / (double)var1_1);
    }

    @Override
    public int getColorCount() {
        return this.colorCount;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("DynamicPalette{");
        for (int i = 0; i < this.colors.size(); ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            CPColor<Color> cPColor = this.colors.get(i);
            stringBuffer.append("color[").append(i).append("]=").append(cPColor.toJavaScriptColor());
        }
        stringBuffer.append(", inverted=").append(this.a);
        stringBuffer.append('}');
        return stringBuffer.toString();
    }
}

