/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.palette;

import com.macrofocus.common.properties.MutableProperty;
import com.macrofocus.common.properties.SimpleProperty;
import com.macrofocus.igraphics.CPColor;
import com.macrofocus.igraphics.CPColorFactory;
import com.macrofocus.palette.FixedPalette;
import com.macrofocus.palette.Palette;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import jsinterop.annotations.JsIgnore;
import jsinterop.annotations.JsType;

@JsType
public class InterpolatedPalette<Color>
extends FixedPalette<Color> {
    private final CPColorFactory<Color> a;
    private MutableProperty<Mode> b = new SimpleProperty((Object)Mode.Ramps);
    private final SortedSet<Entry> c;

    /*
     * WARNING - void declaration
     */
    @JsIgnore
    private InterpolatedPalette(CPColorFactory<Color> factory, SortedSet<Entry> entries) {
        super(false, null);
        void var2_2;
        void var1_1;
        this.a = var1_1;
        this.c = var2_2;
        this.a();
    }

    /*
     * WARNING - void declaration
     */
    @JsIgnore
    public InterpolatedPalette(CPColorFactory<Color> factory, Palette<Color> palette) {
        this((CPColorFactory<Color>)var1_1, (SortedSet<Entry>)new TreeSet<Entry>());
        void var1_1;
        for (int i = 0; i < palette.getColorCount(); ++i) {
            CPColor<Color> cPColor = palette.getColorAt(i);
            this.c.add(new Entry<Color>((double)i / (double)(palette.getColorCount() - 1), cPColor));
        }
        this.a();
    }

    /*
     * WARNING - void declaration
     */
    @JsIgnore
    public InterpolatedPalette(CPColorFactory<Color> factory, Entry ... entries) {
        this((CPColorFactory<Color>)var1_1, (SortedSet<Entry>)new TreeSet<Entry>(Arrays.asList(var2_2)));
        void var2_2;
        void var1_1;
        this.a();
    }

    private void a() {
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < 256; ++i) {
            double d2 = 1.0 * (double)i / 255.0;
            CPColor<Color> cPColor = this.a(d2);
            arrayList.add(cPColor);
        }
        this.colors = arrayList;
        this.colorCount = this.colors.size();
    }

    private CPColor<Color> a(double d2) {
        if (!this.c.isEmpty()) {
            Entry entry = null;
            for (Entry entry2 : this.c) {
                if (entry != null && entry.getFraction() <= d2 && d2 <= entry2.getFraction()) {
                    double d3 = (d2 - entry.getFraction()) / (entry2.getFraction() - entry.getFraction());
                    return this.a(entry.getColor(), entry2.getColor(), d3);
                }
                entry = entry2;
            }
            if (d2 < this.c.first().getFraction()) {
                return this.c.first().getColor();
            }
            if (d2 > this.c.last().getFraction()) {
                return this.c.last().getColor();
            }
        }
        return null;
    }

    private CPColor<Color> a(CPColor<Color> cPColor, CPColor<Color> cPColor2, double d2) {
        switch (((Mode)((Object)this.b.getValue())).ordinal()) {
            case 0: {
                if (d2 == 0.0) {
                    return cPColor;
                }
                if (d2 == 1.0) {
                    return cPColor2;
                }
                return this.a.createRGBAColor((int)((double)cPColor.getRed() * (1.0 - d2) + (double)cPColor2.getRed() * d2), (int)((double)cPColor.getGreen() * (1.0 - d2) + (double)cPColor2.getGreen() * d2), (int)((double)cPColor.getBlue() * (1.0 - d2) + (double)cPColor2.getBlue() * d2), (int)((double)cPColor.getAlpha() * (1.0 - d2) + (double)cPColor2.getAlpha() * d2));
            }
            case 1: {
                return cPColor;
            }
        }
        return null;
    }

    public Set<Entry> getEntries() {
        return this.c;
    }

    @Override
    protected double getLowestFraction() {
        if (!this.c.isEmpty()) {
            return this.c.first().getFraction();
        }
        return super.getLowestFraction();
    }

    @Override
    protected double getHighestFraction() {
        if (!this.c.isEmpty()) {
            return this.c.last().getFraction();
        }
        return super.getHighestFraction();
    }

    private static enum Mode {
        Ramps,
        Bands;

    }

    @JsType
    public static class Entry<Color>
    implements Comparable<Entry> {
        private final double a;
        private final CPColor<Color> b;

        /*
         * WARNING - void declaration
         */
        public Entry(double fraction, CPColor<Color> color) {
            void var3_2;
            void var1_1;
            this.a = var1_1;
            this.b = var3_2;
        }

        public double getFraction() {
            return this.a;
        }

        public CPColor<Color> getColor() {
            return this.b;
        }

        public boolean equals(Object o) {
            Entry entry;
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            entry = entry;
            return Double.compare(entry.a, this.a) == 0;
        }

        public int hashCode() {
            long l = this.a != 0.0 ? Double.doubleToLongBits(this.a) : 0L;
            return (int)(l ^ l >>> 32);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int compareTo(Entry o) {
            void var1_1;
            return Double.compare(this.a, var1_1.a);
        }
    }
}

