/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.colormap.swing;

import com.macrofocus.colormap.ColorMap;
import com.macrofocus.colormap.swing.ColormapUI;
import com.macrofocus.colormap.swing.ColormapView;
import com.macrofocus.format.CPFormat;
import com.macrofocus.format.swing.SwingFormatFactory;
import com.macrofocus.igraphics.CPColor;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;

public class BasicColormapUI
extends ColormapUI {
    @Override
    public void paint(Graphics g, JComponent c) {
        block7: {
            double range;
            double min;
            double width;
            Dimension size;
            ColorMap colorMap;
            int y;
            block8: {
                Graphics2D g2 = (Graphics2D)g;
                ColormapView view = (ColormapView)c;
                if (view.getColorMap() == null) break block7;
                if (view.isDisplayValues()) {
                    CPFormat format = view.getFormat();
                    if (format == null) {
                        format = SwingFormatFactory.getInstance().createDecimalFormat();
                    }
                    String min2 = format.formatHtml((Object)view.getMin(), false);
                    String max = format.formatHtml((Object)view.getMax(), false);
                    g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                    FontMetrics fm = c.getFontMetrics(c.getFont());
                    int maxWidth = fm.stringWidth(max);
                    g.drawString(min2, 0, fm.getLeading() + fm.getAscent());
                    g.drawString(max, view.getWidth() - maxWidth, fm.getLeading() + fm.getAscent());
                    y = fm.getHeight();
                } else {
                    y = 0;
                }
                if (!view.isDisplayColors()) break block7;
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                colorMap = view.getColorMap();
                if (colorMap == null) break block7;
                size = view.getSize();
                width = size.width;
                min = view.getMin();
                double max = view.getMax();
                range = max - min;
                if (range != 0.0) break block8;
                CPColor color = colorMap.getColor((Object)min);
                if (color == null) break block7;
                g.setColor((Color)color.getNativeColor());
                g.fillRect(0, y, size.width, size.height - y);
                break block7;
            }
            if (colorMap.getInterval() != null) {
                int i = 0;
                while ((double)i < width) {
                    double v = min + range * (double)i / (width - 1.0);
                    Color color = (Color)colorMap.getColor((Object)v).getNativeColor();
                    g.setColor(color);
                    g.fillRect(i, y, 1, size.height - y);
                    ++i;
                }
            } else {
                int i = 0;
                while ((double)i < width) {
                    double v = min + range * (double)i / (width - 1.0);
                    Color color = (Color)colorMap.getColor((Object)((int)Math.round(v))).getNativeColor();
                    g.setColor(color);
                    g.fillRect(i, y, 1, size.height - y);
                    ++i;
                }
            }
        }
    }

    @Override
    public void installUI(JComponent c) {
        LookAndFeel.installColorsAndFont(c, "Label.background", "Label.foreground", "Label.font");
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return new Dimension(-1, this.getPreferredColorsHeight(c) + this.getPreferredValuesHeight(c));
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        return new Dimension(Integer.MAX_VALUE, this.getPreferredColorsHeight(c) + this.getPreferredValuesHeight(c));
    }

    public int getPreferredValuesHeight(JComponent c) {
        if (((ColormapView)c).isDisplayValues()) {
            FontMetrics fm = c.getFontMetrics(c.getFont());
            return fm.getHeight();
        }
        return 0;
    }

    public int getPreferredColorsHeight(JComponent c) {
        return ((ColormapView)c).isDisplayColors() ? 24 : 0;
    }
}

