/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.crossplatform.swing;

import com.macrofocus.crossplatform.CPCanvas;
import com.macrofocus.helper.OSHelper;
import com.macrofocus.utils.SwingUtils;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class SwingCanvasHandler {
    private JComponent canvas;
    private boolean popupTrigger = false;
    private boolean keyListenerRegistered = false;
    private List<CPCanvas.ContextMenuListener> contextMenuListeners;

    public SwingCanvasHandler(JComponent canvas) {
        this.canvas = canvas;
    }

    public void addMouseListener(final CPCanvas.MouseListener l) {
        this.canvas.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(final MouseEvent e) {
                if (SwingCanvasHandler.this.popupTrigger && e.getClickCount() == 1) {
                    for (CPCanvas.ContextMenuListener contextMenuListener : SwingCanvasHandler.this.contextMenuListeners) {
                        CPCanvas.ContextMenuEvent event = new CPCanvas.ContextMenuEvent(){

                            public int getX() {
                                return e.getX();
                            }

                            public int getY() {
                                return e.getY();
                            }
                        };
                        contextMenuListener.contextMenu(event);
                    }
                } else {
                    l.mouseClicked((CPCanvas.MouseEvent)new SwingMouseEvent(e));
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                SwingCanvasHandler.this.popupTrigger = e.isPopupTrigger();
                l.mousePressed((CPCanvas.MouseEvent)new SwingMouseEvent(e));
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (!SwingCanvasHandler.this.popupTrigger) {
                    SwingCanvasHandler.this.popupTrigger = e.isPopupTrigger();
                }
                l.mouseReleased((CPCanvas.MouseEvent)new SwingMouseEvent(e));
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if (SwingCanvasHandler.this.keyListenerRegistered) {
                    SwingCanvasHandler.this.canvas.requestFocusInWindow();
                }
                l.mouseEntered((CPCanvas.MouseEvent)new SwingMouseEvent(e));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                l.mouseExited((CPCanvas.MouseEvent)new SwingMouseEvent(e));
            }
        });
    }

    public void addMouseMotionListener(final CPCanvas.MouseMotionListener l) {
        this.canvas.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                l.mouseDragged((CPCanvas.MouseEvent)new SwingMouseEvent(e));
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                l.mouseMoved((CPCanvas.MouseEvent)new SwingMouseEvent(e));
            }
        });
    }

    public void addMouseWheelListener(final CPCanvas.MouseWheelListener l) {
        this.canvas.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                l.mouseWheelMoved((CPCanvas.MouseWheelEvent)new SwingMouseWheelEvent(e));
            }
        });
    }

    public void addKeyListener(final CPCanvas.KeyListener l) {
        this.keyListenerRegistered = true;
        this.canvas.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
                l.keyTyped((CPCanvas.KeyEvent)new SwingKeyEvent(e));
            }

            @Override
            public void keyPressed(KeyEvent e) {
                l.keyPressed((CPCanvas.KeyEvent)new SwingKeyEvent(e));
            }

            @Override
            public void keyReleased(KeyEvent e) {
                l.keyReleased((CPCanvas.KeyEvent)new SwingKeyEvent(e));
            }
        });
    }

    public void addContextMenuListener(CPCanvas.ContextMenuListener l) {
        if (this.contextMenuListeners == null) {
            this.contextMenuListeners = new ArrayList<CPCanvas.ContextMenuListener>();
        }
        this.contextMenuListeners.add(l);
    }

    public static class SwingKeyEvent
    implements CPCanvas.KeyEvent {
        private final KeyEvent event;

        public SwingKeyEvent(KeyEvent event) {
            this.event = event;
        }

        public int getKeyCode() {
            return this.event.getKeyCode();
        }
    }

    public static class SwingMouseWheelEvent
    implements CPCanvas.MouseWheelEvent {
        private final MouseWheelEvent event;

        public SwingMouseWheelEvent(MouseWheelEvent event) {
            this.event = event;
        }

        public int getX() {
            return this.event.getX();
        }

        public int getY() {
            return this.event.getY();
        }

        public int getWheelRotation() {
            return this.event.getWheelRotation();
        }
    }

    public static class SwingMouseEvent
    implements CPCanvas.MouseEvent {
        private final MouseEvent event;

        public SwingMouseEvent(MouseEvent event) {
            this.event = event;
        }

        public int getX() {
            return this.event.getX();
        }

        public int getY() {
            return this.event.getY();
        }

        public boolean isMenuShortcutKeyDown() {
            return SwingUtils.isMenuShortcutKeyDown((InputEvent)this.event);
        }

        public boolean isAltKeyDown() {
            return this.event.isAltDown();
        }

        public boolean isShiftKeyDown() {
            return this.event.isShiftDown();
        }

        public boolean isMultipleSelectionKey() {
            if (OSHelper.isMacOSX()) {
                return this.event.isMetaDown();
            }
            return this.event.isControlDown();
        }

        public boolean isPopupTrigger() {
            return this.event.isPopupTrigger();
        }

        public boolean isLeftMouseButton() {
            return SwingUtilities.isLeftMouseButton(this.event);
        }

        public boolean isMiddleMouseButton() {
            return SwingUtilities.isMiddleMouseButton(this.event);
        }

        public void stopPropagation() {
            this.event.consume();
        }

        public int getClickCount() {
            return this.event.getClickCount();
        }
    }
}

