/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.crossplatform.swing;

import com.macrofocus.common.properties.MutableProperty;
import com.macrofocus.crossplatform.CPCheckBox;
import com.macrofocus.crossplatform.swing.AbstractSwingComponent;
import com.macrofocus.properties.swing.BooleanPropertyButtonModel;
import javax.swing.ButtonModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;

public class SwingCheckBox
extends AbstractSwingComponent<JComponent>
implements CPCheckBox<JComponent> {
    private final JCheckBox nativeComponent;

    public SwingCheckBox(String label, MutableProperty<Boolean> property) {
        this.nativeComponent = label != null ? new JCheckBox(label) : new JCheckBox();
        this.setProperty(property);
    }

    public SwingCheckBox(MutableProperty<Boolean> property) {
        this(null, property);
    }

    public void setProperty(MutableProperty<Boolean> property) {
        if (property != null) {
            this.nativeComponent.setModel((ButtonModel)new BooleanPropertyButtonModel(property));
        }
        this.nativeComponent.setEnabled(property != null);
    }

    public CPCheckBox.State getState() {
        if (this.nativeComponent.isSelected()) {
            return CPCheckBox.State.Checked;
        }
        return CPCheckBox.State.Unchecked;
    }

    public void setState(CPCheckBox.State state) {
        switch (state) {
            case Checked: {
                this.nativeComponent.setSelected(true);
                break;
            }
            case Unchecked: {
                this.nativeComponent.setSelected(false);
                break;
            }
            case Undefined: {
                this.nativeComponent.setSelected(false);
            }
        }
    }

    public void setEnabled(boolean enabled) {
        this.nativeComponent.setEnabled(enabled);
    }

    public JComponent getNativeComponent() {
        return this.nativeComponent;
    }
}

