/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.crossplatform.swing;

import com.macrofocus.common.command.UICommand;
import com.macrofocus.common.properties.PropertyEvent;
import com.macrofocus.common.properties.PropertyListener;
import com.macrofocus.crossplatform.CPPopupMenu;
import com.macrofocus.helper.WeakActionListeners;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;

public class SwingPopupMenu
implements CPPopupMenu<JComponent> {
    JPopupMenu popupMenu = new JPopupMenu("");
    private final WeakActionListeners actionListeners = new WeakActionListeners();

    public void add(UICommand command) {
        JMenuItem menuItem = SwingPopupMenu.createUICommandMenuItem(command, this.actionListeners);
        this.popupMenu.add(menuItem);
    }

    public void show(JComponent component, int x, int y) {
        this.popupMenu.show(component, x, y);
    }

    public static JMenuItem createUICommandMenuItem(final UICommand command, WeakActionListeners actionListeners) {
        final JMenuItem menuItem = new JMenuItem((String)command.titleProperty().getValue());
        command.titleProperty().addPropertyListener((PropertyListener)new PropertyListener<String>(){

            public void propertyChanged(PropertyEvent<String> event) {
                menuItem.setText((String)event.getNewValue());
            }
        });
        if (command.keystrokeProperty() != null) {
            menuItem.setAccelerator(KeyStroke.getKeyStroke((String)command.keystrokeProperty().getValue()));
            command.keystrokeProperty().addPropertyListener((PropertyListener)new PropertyListener<String>(){

                public void propertyChanged(PropertyEvent<String> event) {
                    menuItem.setAccelerator(KeyStroke.getKeyStroke((String)event.getNewValue()));
                }
            });
        }
        if (command.iconProperty() != null) {
            Object value = command.iconProperty().getValue();
            if (value instanceof Icon) {
                menuItem.setIcon((Icon)value);
            }
            command.iconProperty().addPropertyListener((PropertyListener)new PropertyListener<Object>(){

                public void propertyChanged(PropertyEvent<Object> event) {
                    if (event.getNewValue() instanceof Icon) {
                        menuItem.setIcon((Icon)event.getNewValue());
                    }
                }
            });
        }
        menuItem.setEnabled((Boolean)command.enabledProperty().getValue() != false && command != null);
        command.enabledProperty().addPropertyListener((PropertyListener)new PropertyListener<Boolean>(){

            public void propertyChanged(PropertyEvent<Boolean> event) {
                menuItem.setEnabled((Boolean)event.getNewValue());
            }
        });
        menuItem.addActionListener(actionListeners.create(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                command.execute(e.getSource());
            }
        }, (Object)menuItem));
        return menuItem;
    }
}

