/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.crossplatform.swing.layer;

import com.macrofocus.crossplatform.CPCanvas;
import com.macrofocus.crossplatform.swing.layer.SwingLayer;
import com.macrofocus.igraphics.CPColor;
import com.macrofocus.igraphics.IDrawing;
import com.macrofocus.igraphics.IGraphics;
import com.macrofocus.igraphics.swing.SwingIGraphics;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;

public class DirectSwingLayer
implements SwingLayer {
    private final IDrawing iDrawing;
    private final CPColor<Color> color;
    private double width = 0.0;
    private double height = 0.0;

    public DirectSwingLayer(IDrawing iDrawing) {
        this(iDrawing, null);
    }

    public DirectSwingLayer(IDrawing iDrawing, CPColor<Color> color) {
        this.iDrawing = iDrawing;
        this.color = color;
    }

    static void draw(Graphics2D g2, IDrawing iDrawing, double width, double height, boolean antialiasing, CPCanvas.PaletteProvider paletteProvider, CPColor<Color> color, Composite composite) {
        Rectangle clipBounds;
        Composite oldComposite = g2.getComposite();
        RenderingHints hints = g2.getRenderingHints();
        if (antialiasing) {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        }
        Color oldColor = g2.getColor();
        if (color == null && paletteProvider != null) {
            CPColor start = paletteProvider.getPalette().getColor(0.0);
            CPColor end = paletteProvider.getPalette().getColor(1.0);
            float s = (float)start.getRed() / 255.0f;
            float e = (float)end.getRed() / 255.0f;
            if (e > s) {
                color = end;
                if (composite == null) {
                    float alpha = e > 0.0f ? s / e : 0.0f;
                    assert (alpha >= 0.0f && alpha <= 1.0f) : "alpha value of " + alpha + " out of range";
                    g2.setComposite(AlphaComposite.getInstance(3, alpha));
                }
            } else {
                color = end;
                if (composite == null) {
                    float alpha = e < 1.0f ? (1.0f - s) / (1.0f - e) : 0.0f;
                    assert (alpha >= 0.0f && alpha <= 1.0f) : "alpha value of " + alpha + " out of range " + (1.0f - s) + "/" + (1.0f - e);
                    g2.setComposite(AlphaComposite.getInstance(3, alpha));
                }
            }
        } else if (color != null) {
            g2.setColor((Color)color.getNativeColor());
        }
        if (composite != null) {
            g2.setComposite(composite);
        }
        com.macrofocus.geom.Rectangle bounds = (clipBounds = g2.getClipBounds()) != null ? new com.macrofocus.geom.Rectangle(clipBounds.x, clipBounds.y, clipBounds.width, clipBounds.height) : new com.macrofocus.geom.Rectangle(0, 0, (int)width, (int)height);
        iDrawing.draw((IGraphics)new SwingIGraphics(g2), null, width, height, bounds);
        g2.setRenderingHints(hints);
        g2.setColor(oldColor);
        g2.setComposite(oldComposite);
    }

    @Override
    public void prepare(int width, int height) {
        this.width = width;
        this.height = height;
    }

    @Override
    public void render(Graphics2D g) {
        if (this.iDrawing.isActive()) {
            DirectSwingLayer.draw(g, this.iDrawing, this.width, this.height, true, null, this.color, null);
        }
    }
}

