/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.igraphics.swing;

import com.macrofocus.geom.Arc2D;
import com.macrofocus.geom.Ellipse2D;
import com.macrofocus.geom.Point2D;
import com.macrofocus.geom.Rectangle2D;
import com.macrofocus.geom.Shape;
import com.macrofocus.igraphics.AbstractIGraphics;
import com.macrofocus.igraphics.CPColor;
import com.macrofocus.igraphics.CPFont;
import com.macrofocus.igraphics.CPFontMetrics;
import com.macrofocus.igraphics.IGraphics;
import com.macrofocus.igraphics.swing.GeometryShape;
import com.macrofocus.igraphics.swing.HeadlessGraphics2D;
import com.macrofocus.igraphics.swing.SwingColor;
import com.macrofocus.igraphics.swing.SwingFontMetrics;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.LineMetrics;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;

public class SwingIGraphics
extends AbstractIGraphics<Color, Font> {
    private final Graphics2D context;
    private IGraphics.TextBaseline baseline = IGraphics.TextBaseline.Alphabetic;
    private GeneralPath path;

    public SwingIGraphics(Graphics2D context) {
        this.context = context != null ? context : new HeadlessGraphics2D();
        this.context.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        this.context.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    }

    public double getLineWidth() {
        return ((BasicStroke)this.context.getStroke()).getLineWidth();
    }

    public void setLineWidth(double lineWidth) {
        this.context.setStroke(new BasicStroke((float)lineWidth, 0, 0));
    }

    public void setLineDash(float[] dashPattern) {
        BasicStroke stroke = new BasicStroke(1.0f, 0, 0, 10.0f, dashPattern, 0.0f);
        this.context.setStroke(stroke);
    }

    public void setGlobalAlpha(double alpha) {
        this.context.setComposite(AlphaComposite.getInstance(3, (float)alpha));
    }

    public CPColor<Color> getColor() {
        return new SwingColor(this.context.getColor());
    }

    public void setColor(CPColor<Color> color) {
        this.context.setColor((Color)color.getNativeColor());
    }

    public void draw(Shape geometry) {
        if (geometry instanceof com.macrofocus.geom.Rectangle2D) {
            com.macrofocus.geom.Rectangle2D r = (com.macrofocus.geom.Rectangle2D)geometry;
            this.context.draw(new Rectangle2D.Double(r.getX(), r.getY(), r.getWidth(), r.getHeight()));
        } else if (geometry instanceof Arc2D) {
            Arc2D arc = (Arc2D)geometry;
            this.context.draw(new Arc2D.Double(arc.getX(), arc.getY(), arc.getWidth(), arc.getHeight(), arc.getAngleStart(), arc.getAngleExtent(), arc.getArcType()));
        } else if (geometry != null) {
            GeometryShape shape = new GeometryShape(geometry);
            this.context.draw(shape);
        }
    }

    public void fill(Shape geometry) {
        if (geometry instanceof com.macrofocus.geom.Rectangle2D) {
            com.macrofocus.geom.Rectangle2D r = (com.macrofocus.geom.Rectangle2D)geometry;
            this.context.fill(new Rectangle2D.Double(r.getX(), r.getY(), r.getWidth(), r.getHeight()));
        } else if (geometry instanceof Ellipse2D) {
            Ellipse2D r = (Ellipse2D)geometry;
            this.context.fill(new Ellipse2D.Double(r.getX(), r.getY(), r.getWidth(), r.getHeight()));
        } else {
            GeometryShape shape = new GeometryShape(geometry);
            this.context.fill(shape);
        }
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        this.context.drawLine(x1, y1, x2, y2);
    }

    public void drawLine(double x1, double y1, double x2, double y2) {
        this.context.draw(new Line2D.Double(x1, y1, x2, y2));
    }

    public void fillRectangle(int x, int y, int width, int height) {
        this.context.fillRect(x, y, width, height);
    }

    public void drawRectange(int x, int y, int width, int height) {
        this.context.drawRect(x, y, width, height);
    }

    public Graphics2D getContext() {
        return this.context;
    }

    public void drawPoint(Point2D point) {
        this.context.fill(new Rectangle2D.Double(point.getX(), point.getY(), 1.0, 1.0));
    }

    public void setTextBaseline(IGraphics.TextBaseline baseline) {
        this.baseline = baseline;
    }

    public void setFont(CPFont<Font> font) {
        this.context.setFont((Font)font.getNativeFont());
    }

    public com.macrofocus.geom.Rectangle2D getStringBounds(String text) {
        Rectangle2D stringBounds = this.context.getFontMetrics().getStringBounds(text, this.context);
        return new Rectangle2D.Double(stringBounds.getX(), stringBounds.getY(), stringBounds.getWidth(), stringBounds.getHeight());
    }

    public float getStringWidth(String text) {
        if (text != null) {
            return this.context.getFontMetrics().stringWidth(text);
        }
        return 0.0f;
    }

    public float getStringHeight(String text) {
        if (text != null) {
            LineMetrics metrics = this.context.getFont().getLineMetrics(text, this.context.getFontRenderContext());
            return metrics.getHeight();
        }
        return 0.0f;
    }

    public double getAscent() {
        return this.context.getFontMetrics().getAscent();
    }

    public double getDescent() {
        return this.context.getFontMetrics().getDescent();
    }

    public CPFontMetrics getFontMetrics() {
        return new SwingFontMetrics(this.context);
    }

    public void drawString(String text, float x, float y) {
        switch (this.baseline) {
            case Alphabetic: {
                break;
            }
            case Top: {
                y -= (float)this.context.getFontMetrics().getAscent();
                break;
            }
            case Bottom: {
                y += (float)this.context.getFontMetrics().getDescent();
                break;
            }
            case Middle: {
                FontMetrics fm = this.context.getFontMetrics();
                LineMetrics lm = fm.getLineMetrics(text, this.context);
                y = y - (lm.getAscent() + lm.getDescent()) / 2.0f + lm.getAscent();
                break;
            }
            case Hanging: {
                throw new UnsupportedOperationException();
            }
            case Ideographic: {
                throw new UnsupportedOperationException();
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.context.drawString(text, x, y);
    }

    public void translate(int x, int y) {
        this.context.translate(x, y);
    }

    public void rotate(double theta) {
        this.context.rotate(theta);
    }

    public void beginPath() {
        this.path = new GeneralPath();
    }

    public void moveTo(double x, double y) {
        this.path.moveTo(x, y);
    }

    public void lineTo(double x, double y) {
        this.path.lineTo(x, y);
    }

    public void closePath() {
        this.path.closePath();
    }

    public void stroke() {
        this.context.draw(this.path);
    }

    public void fill() {
        this.context.fill(this.path);
    }
}

