/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.interaction.implementation;

import com.macrofocus.coloring.Coloring;
import com.macrofocus.coloring.MutableColoring;
import com.macrofocus.common.selection.MutableSelection;
import com.macrofocus.common.selection.MutableSingleSelection;
import com.macrofocus.common.selection.Selection;
import com.macrofocus.common.selection.SingleSelection;
import com.macrofocus.filter.Filter;
import com.macrofocus.filter.MutableFilter;
import com.macrofocus.igraphics.CPColor;
import com.macrofocus.igraphics.swing.SwingColor;
import com.macrofocus.interaction.Interaction;
import com.macrofocus.interaction.MutableInteraction;
import com.macrofocus.interaction.implementation.AbstractInteraction;
import java.awt.Color;
import java.util.List;

public final class SimpleInteraction<E>
extends AbstractInteraction<Color, E>
implements MutableInteraction<Color, E> {
    private final MutableSingleSelection<E> probing;
    private final MutableSelection<E> selection;
    private final MutableFilter<E> filter;
    private final MutableColoring<Color, E> coloring;

    public SimpleInteraction(MutableSingleSelection<E> probing, MutableSelection<E> selection, MutableFilter<E> filter, MutableColoring<Color, E> coloring) {
        this.probing = probing;
        this.selection = selection;
        this.filter = filter;
        this.coloring = coloring;
    }

    @Override
    public SingleSelection<E> getProbing() {
        return this.probing;
    }

    @Override
    public Selection<E> getSelection() {
        return this.selection;
    }

    @Override
    public Filter<E> getFilter() {
        return this.filter;
    }

    @Override
    public Coloring<Color, E> getColoring() {
        return this.coloring;
    }

    @Override
    public Interaction.State getState(E element) {
        if (this.filter.isFiltered(element)) {
            return Interaction.State.Filtered;
        }
        if (this.coloring.isColored(element)) {
            return Interaction.State.Colored;
        }
        if (this.selection.isSelected(element)) {
            return Interaction.State.Selected;
        }
        if (this.probing.isSelected(element)) {
            return Interaction.State.Probed;
        }
        return Interaction.State.Normal;
    }

    @Override
    public Interaction.ExtendedState getExtendedState(E element) {
        if (this.filter.isFiltered(element)) {
            return Interaction.ExtendedState.Filtered;
        }
        if (this.coloring.isColored(element)) {
            if (this.probing.isSelected(element)) {
                return Interaction.ExtendedState.ColoredProbed;
            }
            return Interaction.ExtendedState.Colored;
        }
        if (this.selection.isSelected(element)) {
            if (this.probing.isSelected(element)) {
                return Interaction.ExtendedState.SelectedProbed;
            }
            return Interaction.ExtendedState.Selected;
        }
        if (this.probing.isSelected(element)) {
            return Interaction.ExtendedState.Probed;
        }
        return Interaction.ExtendedState.Normal;
    }

    @Override
    public void setProbed(E element) {
        this.probing.setSelected(element);
    }

    @Override
    public void setSelected(E element, boolean selected) {
        this.selection.setSelectedState(element, selected);
    }

    @Override
    public void setSelected(List<E> elements) {
        for (E element : elements) {
            this.selection.setSelectedState(element, true);
        }
    }

    @Override
    public void setColoring(E element, Color color) {
        this.coloring.setColor(element, (CPColor)new SwingColor(color));
    }

    @Override
    public void setFiltered(E element, boolean filtered, Object lock) {
        this.filter.setFiltered(element, filtered, lock);
    }
}

