/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.molap.exporter.java;

import com.macrofocus.data.typemap.DefaultTypemapModel;
import com.macrofocus.data.typemap.TypemapModel;
import com.macrofocus.molap.dataframe.DataFrame;
import com.macrofocus.molap.exporter.java.AbstractDataFrameWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Date;

public class DelimitedStreamDataFrameWriter
extends AbstractDataFrameWriter {
    private TypemapModel typemapModel = new DefaultTypemapModel();
    private final OutputStreamWriter writer;
    private int columnCount;
    private String delimiter;
    private String newLine;
    private int row = 0;
    private int column = 0;

    public DelimitedStreamDataFrameWriter(OutputStreamWriter writer, int columnCount, String delimiter, String newLine) {
        this.writer = writer;
        this.columnCount = columnCount;
        this.delimiter = delimiter;
        this.newLine = newLine;
    }

    public void writeColumnName(String value, boolean hasMore) throws IOException {
        if (value != null) {
            if (((String)value).contains(this.delimiter) || ((String)value).contains("\"") || ((String)value).contains("\n") || ((String)value).contains(";")) {
                value = "\"" + ((String)value).replaceAll("\"", "\"\"") + "\"";
            }
            this.writer.write((String)value);
        }
        this.nextColumn(hasMore);
    }

    public boolean includeType() {
        return false;
    }

    public void writeType(Class cl, boolean hasMore) throws IOException {
        Object value = this.typemapModel.getType(cl);
        if (value != null) {
            if (((String)value).contains(this.delimiter) || ((String)value).contains("\"") || ((String)value).contains("\n") || ((String)value).contains(";")) {
                value = "\"" + ((String)value).replaceAll("\"", "\"\"") + "\"";
            }
            this.writer.write((String)value);
        }
        this.nextColumn(hasMore);
    }

    public void writeCell(Object value, DataFrame dataFrame, Object rowKey, Object columnKey) throws IOException {
        if (value != null) {
            Object str;
            if (value instanceof String[]) {
                String[] array = (String[])value;
                str = "";
                for (int i = 0; i < array.length; ++i) {
                    String s = array[i];
                    str = (String)str + s;
                    if (i >= array.length - 1) continue;
                    str = (String)str + ".";
                }
            } else {
                str = value instanceof java.sql.Date ? value.toString() : (value instanceof Date ? this.dateToString(dataFrame, columnKey, (Date)value) : (value instanceof Number ? DelimitedStreamDataFrameWriter.numberToString((Number)value) : value.toString()));
                if (((String)str).contains(this.delimiter) || ((String)str).contains("\"") || ((String)str).contains("\n") || ((String)str).contains(";")) {
                    str = "\"" + ((String)str).replaceAll("\"", "\"\"") + "\"";
                }
            }
            this.writer.write((String)str);
        }
    }

    public void nextColumn(boolean hasMore) throws IOException {
        ++this.column;
        if (hasMore) {
            this.writer.write(this.delimiter);
        }
    }

    public void nextRow() throws IOException {
        this.column = 0;
        ++this.row;
        this.writer.write(this.newLine);
    }

    public void close() throws IOException {
        this.writer.close();
    }
}

