/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.molap.exporter.java;

import com.macrofocus.molap.exporter.java.SQLDialect;
import java.math.BigDecimal;
import java.net.URL;
import java.util.Date;
import org.locationtech.jts.geom.Geometry;

public enum SQLDialectEnum implements SQLDialect
{
    STANDARD{

        @Override
        public String getColumnType(Class type, int precision) {
            if (type == Boolean.class) {
                return "boolean";
            }
            if (type == Integer.class) {
                return "int";
            }
            if (type == Long.class) {
                return "bigint";
            }
            if (type == Float.class) {
                return "real";
            }
            if (type == Double.class) {
                return "double";
            }
            if (type == BigDecimal.class) {
                return "decimal";
            }
            if (type == String.class) {
                if (precision > 0) {
                    if (precision > 255) {
                        return "text";
                    }
                    return "varchar(" + precision + ")";
                }
                return "varchar";
            }
            if (type == java.sql.Date.class) {
                return "date";
            }
            if (type == URL.class) {
                return "text";
            }
            if (type == byte[].class) {
                return "binary";
            }
            if (Geometry.class.isAssignableFrom(type)) {
                return "binary";
            }
            throw new UnsupportedOperationException("Unknown type " + String.valueOf(type));
        }
    }
    ,
    POSTGIS{

        @Override
        public String getColumnType(Class type, int precision) {
            if (type == Boolean.class) {
                return "boolean";
            }
            if (type == Integer.class) {
                return "int";
            }
            if (type == Long.class) {
                return "bigint";
            }
            if (type == Float.class) {
                return "real";
            }
            if (type == Double.class) {
                return "double precision";
            }
            if (type == BigDecimal.class) {
                return "decimal";
            }
            if (type == String.class) {
                if (precision > 0) {
                    if (precision > 255) {
                        return "text";
                    }
                    return "varchar(" + precision + ")";
                }
                return "varchar";
            }
            if (type == java.sql.Date.class || type == Date.class) {
                return "date";
            }
            if (type == URL.class) {
                return "text";
            }
            if (type == byte[].class) {
                return "binary";
            }
            if (Geometry.class.isAssignableFrom(type)) {
                return "geometry";
            }
            throw new UnsupportedOperationException("Unknown type " + String.valueOf(type));
        }
    };

}

