/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.molap.aggregates.cube;

import com.macrofocus.molap.aggregates.cube.Statistics;
import com.macrofocus.molap.dataframe.matrix.Matrix;
import com.macrofocus.molap.series.Series;
import java.util.Iterator;
import java.util.Objects;

public class DistributiveStatistics
implements Statistics {
    private long a;
    private long b;
    private Double c;
    private Double d;
    private Number e;
    private Number f;

    public DistributiveStatistics() {
        this.a = 0L;
        this.b = 0L;
        this.c = null;
        this.d = null;
        this.e = null;
        this.f = null;
    }

    /*
     * WARNING - void declaration
     */
    public <R> DistributiveStatistics(Series<R, ?> series) {
        void var1_1;
        void v0 = var1_1;
        this((Series<R, ?>)v0, v0.keys());
    }

    /*
     * WARNING - void declaration
     */
    public <R> DistributiveStatistics(Series<R, ?> series, Iterable<R> keys) {
        this((Series<R, ?>)var1_1, (Iterable<R>)var2_2, null);
        void var2_2;
        void var1_1;
    }

    public <R> DistributiveStatistics(Series<R, ?> series, Iterable<R> keys, RowFilter<R> filter) {
        this();
        Iterator iterator;
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            assert (object != null) : "Missing row for series " + String.valueOf(series);
            if (filter != null && !filter.accept(object)) continue;
            if ((object = series.get(object)) != null) {
                if (!(object instanceof Number)) continue;
                this.addNumber((Number)object);
                continue;
            }
            this.addMissing();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void addStatistics(Statistics v2) {
        void var1_1;
        if (this.c != null) {
            if (v2.getSum() != null) {
                this.c = this.c + v2.getSum();
            }
        } else {
            this.c = v2.getSum();
        }
        if (this.d != null) {
            if (v2.getUncorrectedSumOfSquares() != null) {
                this.d = this.d + v2.getUncorrectedSumOfSquares();
            }
        } else {
            this.d = v2.getUncorrectedSumOfSquares();
        }
        if (this.e == null || v2.getMinimum() != null && v2.getMinimum().doubleValue() < this.e.doubleValue()) {
            this.e = v2.getMinimum();
        }
        if (this.f == null || v2.getMaximum() != null && v2.getMaximum().doubleValue() > this.f.doubleValue()) {
            this.f = v2.getMaximum();
        }
        this.a += var1_1.getCount();
    }

    /*
     * WARNING - void declaration
     */
    public void addNumber(Number value) {
        double d2 = value.doubleValue();
        this.c = this.c != null ? Double.valueOf(this.c + d2) : Double.valueOf(d2);
        if (this.d != null) {
            double d3 = d2;
            this.d = this.d + d3 * d3;
        } else {
            double d4 = d2;
            this.d = d4 * d4;
        }
        if (this.e == null || d2 < this.e.doubleValue()) {
            this.e = value;
        }
        if (this.f == null || d2 > this.f.doubleValue()) {
            void var1_1;
            this.f = var1_1;
        }
        ++this.a;
    }

    public <R, C> DistributiveStatistics(Matrix<R, C> matrix) {
        this();
        for (Object Row2 : matrix.rows()) {
            for (Object Column2 : matrix.columns()) {
                if (matrix.isAvailable(Row2, Column2)) {
                    double d2 = matrix.getDouble(Row2, Column2);
                    this.addValue(d2);
                    continue;
                }
                this.addMissing();
            }
        }
    }

    public void addMissing() {
        ++this.b;
    }

    /*
     * WARNING - void declaration
     */
    public void addValue(double v2) {
        this.c = this.c != null ? Double.valueOf(this.c + v2) : Double.valueOf(v2);
        if (this.d != null) {
            double d2 = v2;
            this.d = this.d + d2 * d2;
        } else {
            double d3 = v2;
            this.d = d3 * d3;
        }
        if (this.e == null || v2 < this.e.doubleValue()) {
            this.e = v2;
        }
        if (this.f == null || v2 > this.f.doubleValue()) {
            void var1_1;
            this.f = (double)var1_1;
        }
        ++this.a;
    }

    public void add(DistributiveStatistics distributiveStatistics) {
        Number number;
        this.a += distributiveStatistics.getCount();
        this.b += distributiveStatistics.getCountOfMissing();
        Number number2 = distributiveStatistics.getSum();
        if (number2 != null) {
            this.c = this.c != null ? (Number)(this.c + (Double)number2) : (Number)number2;
        }
        if ((number2 = distributiveStatistics.getUncorrectedSumOfSquares()) != null) {
            this.d = this.d != null ? (Number)(this.d + (Double)number2) : (Number)number2;
        }
        number2 = distributiveStatistics.getMinimum();
        if (this.e == null || number2 != null && number2.doubleValue() < this.e.doubleValue()) {
            this.e = number2;
        }
        number = ((DistributiveStatistics)((Object)number)).getMaximum();
        if (this.f == null || number != null && number.doubleValue() > this.f.doubleValue()) {
            this.f = number;
        }
    }

    @Override
    public long getCount() {
        return this.a;
    }

    @Override
    public Double getSum() {
        return this.c;
    }

    @Override
    public Double getUncorrectedSumOfSquares() {
        return this.d;
    }

    @Override
    public long getCountOfMissing() {
        return this.b;
    }

    @Override
    public Number getMinimum() {
        return this.e;
    }

    @Override
    public Number getMaximum() {
        return this.f;
    }

    public Double getMean() {
        if (this.a > 0L) {
            return this.getSum() / (double)this.getCount();
        }
        return null;
    }

    public Double getRange() {
        return this.getMaximum().doubleValue() - this.getMinimum().doubleValue();
    }

    public Double getCorrectedSumOfSquares() {
        return null;
    }

    public Double getVariance() {
        Double d2 = this.getMean();
        if (d2 != null) {
            return this.getUncorrectedSumOfSquares() / (double)this.getCount() - d2 * d2;
        }
        return null;
    }

    public Double getStandardDeviation() {
        Double d2 = this.getVariance();
        if (d2 != null) {
            return Math.sqrt(d2);
        }
        return null;
    }

    public Double getStandardErrorOfMean() {
        return null;
    }

    public Double getCoefficientOfVariance() {
        return null;
    }

    public Double getTValue() {
        return null;
    }

    public Double getProbabilityOfGreaterAbsoluteValue() {
        return null;
    }

    public Double getLowerConfidenceLimit() {
        return null;
    }

    public Double getUpperConfidenceLimit() {
        return null;
    }

    public String toString() {
        return "DistributiveStatistics{count=" + this.a + ", countOfMissing=" + this.b + ", sum=" + this.c + ", uncorrectedSumOfSquares=" + this.d + ", minimum=" + String.valueOf(this.e) + ", maximum=" + String.valueOf(this.f) + ", mean=" + this.getMean() + ", variance=" + this.getVariance() + ", stdDev=" + this.getStandardDeviation() + "}";
    }

    public boolean equals(Object o2) {
        DistributiveStatistics distributiveStatistics;
        if (this == o2) {
            return true;
        }
        if (!(o2 instanceof DistributiveStatistics)) {
            return false;
        }
        distributiveStatistics = distributiveStatistics;
        return this.getCount() == distributiveStatistics.getCount() && this.getCountOfMissing() == distributiveStatistics.getCountOfMissing() && Objects.equals(this.getSum(), distributiveStatistics.getSum()) && Objects.equals(this.getUncorrectedSumOfSquares(), distributiveStatistics.getUncorrectedSumOfSquares()) && Objects.equals(this.getMinimum(), distributiveStatistics.getMinimum()) && Objects.equals(this.getMaximum(), distributiveStatistics.getMaximum());
    }

    public int hashCode() {
        return Objects.hash(this.getCount(), this.getCountOfMissing(), this.getSum(), this.getUncorrectedSumOfSquares(), this.getMinimum(), this.getMaximum());
    }

    public static interface RowFilter<R> {
        public boolean accept(R var1);
    }
}

