/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.molap.network;

import com.macrofocus.molap.dataframe.matrix.AbstractMatrix;
import com.macrofocus.molap.dataframe.matrix.Matrix;
import com.macrofocus.molap.index.IntegerRangeUniqueIndex;
import com.macrofocus.molap.index.UniqueIndex;
import com.macrofocus.molap.network.Network;
import java.util.Stack;

public class FloydWarshall<Node, Link> {
    private final Network<Node, Link, ?, ?> a;
    private boolean b;
    private final double[][] c;
    private final Link[][] d;
    private final Mode e = Mode.Min;
    private double f = 0.0;
    private final boolean g = true;

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public FloydWarshall(Network<Node, Link, ?, ?> G) {
        super();
        var4_3 = var2_2 = System.currentTimeMillis();
        this.a = G;
        v0 = var6_4 = G.getVerticesCount();
        this.c = new double[v0][v0];
        v1 = var6_4;
        this.d = new Object[v1][v1];
        System.out.println("Starting Floyd-Warshall algorithm on network with " + var6_4 + " vertices");
        for (var7_5 = 0; var7_5 < var6_4; ++var7_5) {
            for (var8_7 = 0; var8_7 < var6_4; ++var8_7) {
                this.c[var7_5][var8_7] = var7_5 == var8_7 ? 0.0 : Infinity;
            }
        }
        var7_6 = G.getWeightSelection().isActive() != false ? G.getWeightDistributiveStatistics() : null;
        var8_8 = -1.7976931348623157E308;
        System.out.println("Initialized distance matrix in " + (System.currentTimeMillis() - var4_3) + " ms");
        var4_3 = System.currentTimeMillis();
        switch (this.e.ordinal()) {
            case 0: {
                for (var10_9 = 0; var10_9 < G.getVerticesCount(); ++var10_9) {
                    var11_11 = G.getVerticesIndex().getKey(var10_9);
                    for (Vertex var13_15 : G.getEdgesFrom(var11_11)) {
                        var14_17 = G.getVerticesIndex().getAddress(G.getFrom(var13_15 /* !! */ ));
                        var15_18 = G.getVerticesIndex().getAddress(G.getTo(var13_15 /* !! */ ));
                        if (var14_17 < 0 || var15_18 < 0) continue;
                        var18_20 = ((Number)G.getWeight(var13_15 /* !! */ )).doubleValue();
                        var16_19 = var7_6 != null ? var7_6.getMaximum().doubleValue() - var18_20 : var18_20;
                        this.c[var14_17][var15_18] = var16_19;
                        this.d[var14_17][var15_18] = var13_15 /* !! */ ;
                        var8_8 = Math.max(var8_8, var16_19);
                    }
                    if (!(this.c[var10_9][var10_9] >= 0.0)) continue;
                    this.c[var10_9][var10_9] = 0.0;
                    this.d[var10_9][var10_9] = null;
                }
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                for (Object var11_11 : G.getLinksDataFrame().rows()) {
                    var12_13 /* !! */  = G.getFrom(var11_11);
                    if (var12_13 /* !! */ .equals(var13_15 /* !! */  = G.getTo(var11_11))) continue;
                    var14_17 = G.getVerticesIndex().getAddress(var12_13 /* !! */ );
                    var15_18 = G.getVerticesIndex().getAddress(var13_15 /* !! */ );
                    var18_21 = (Number)G.getWeight(var11_11);
                    var16_19 = var18_21 != null ? ((var19_22 = var18_21.doubleValue()) == 0.0 ? 0.0 : 1.0 / var19_22) : NaN;
                    if (this.d[var15_18][var14_17] == null) ** GOTO lbl61
                    switch (this.e.ordinal()) {
                        case 1: {
                            var16_19 = Math.min(var16_19, this.c[var15_18][var14_17]);
                            ** GOTO lbl62
                        }
                        case 2: {
                            var16_19 = Math.max(var16_19, this.c[var15_18][var14_17]);
                            ** GOTO lbl62
                        }
                        case 3: {
                            var16_19 = (var16_19 + this.c[var15_18][var14_17]) / 2.0;
                            ** GOTO lbl62
                        }
                        default: {
                            throw new IllegalStateException();
                        }
                    }
lbl61:
                    // 1 sources

                    this.d[var15_18][var14_17] = var11_11;
lbl62:
                    // 4 sources

                    this.c[var14_17][var15_18] = var16_19;
                    this.c[var15_18][var14_17] = var16_19;
                    this.d[var14_17][var15_18] = var11_11;
                    var8_8 = Math.max(var8_8, var16_19);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        System.out.println("Initialized distances using edge-weighted digraph's " + (System.currentTimeMillis() - var4_3) + " ms");
        var4_3 = System.currentTimeMillis();
        for (var10_9 = 0; var10_9 < var6_4; ++var10_9) {
            for (var11_12 = 0; var11_12 < var6_4; ++var11_12) {
                if (this.d[var11_12][var10_9] == null) continue;
                for (var12_14 = 0; var12_14 < var6_4; ++var12_14) {
                    var13_16 = this.c[var11_12][var10_9] + this.c[var10_9][var12_14];
                    if (!(this.c[var11_12][var12_14] > var13_16)) continue;
                    this.c[var11_12][var12_14] = var13_16;
                    if (Double.isFinite(var13_16)) {
                        var8_8 = Math.max(var8_8, var13_16);
                    }
                    this.d[var11_12][var12_14] = this.d[var10_9][var12_14];
                }
                if (!(this.c[var11_12][var11_12] < 0.0)) continue;
                this.b = true;
                System.err.println("Negative cycle");
                return;
            }
        }
        System.out.println("Floyd-Warshall updates completed in " + (System.currentTimeMillis() - var4_3) + " ms");
        System.currentTimeMillis();
        this.f = Infinity;
        System.out.println("Completed Floyd-Warshall algorithm in " + (System.currentTimeMillis() - var2_2) + " ms");
    }

    public Matrix getDistanceMatrix() {
        return new AbstractMatrix<Integer, Integer>(this){
            private UniqueIndex<Integer> a;
            private /* synthetic */ FloydWarshall b;
            {
                this.b = floydWarshall;
                this.a = new IntegerRangeUniqueIndex(0, this.b.c.length - 1);
            }

            @Override
            public final UniqueIndex<Integer> getRowIndex() {
                return this.a;
            }

            @Override
            public final UniqueIndex<Integer> getColumnIndex() {
                return this.a;
            }

            @Override
            public final /* synthetic */ boolean isAvailable(Object object, Object object2) {
                boolean bl;
                Integer n2 = (Integer)object2;
                object2 = (Integer)object;
                object = this;
                switch (object.b.e.ordinal()) {
                    case 0: {
                        return Double.isFinite(object.b.c[(Integer)object2][n2]);
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        if (Double.isFinite(object.b.c[(Integer)object2][n2]) || Double.isFinite(object.b.c[n2][(Integer)object2])) {
                            bl = true;
                            break;
                        }
                        return false;
                    }
                    default: {
                        bl = false;
                    }
                }
                return bl;
            }

            @Override
            public final /* synthetic */ double getDouble(Object object, Object object2) {
                double d2;
                Integer n2 = (Integer)object2;
                object2 = (Integer)object;
                object = this;
                switch (object.b.e.ordinal()) {
                    case 0: {
                        d2 = object.b.c[(Integer)object2][n2];
                        break;
                    }
                    case 1: {
                        double d3 = object.b.c[(Integer)object2][n2];
                        double d4 = object.b.c[n2][(Integer)object2];
                        if (Double.isInfinite(d3)) {
                            if (Double.isInfinite(d4)) {
                                d2 = object.b.f;
                                break;
                            }
                            d2 = d4;
                            break;
                        }
                        if (Double.isInfinite(d4)) {
                            d2 = d3;
                            break;
                        }
                        d2 = Math.min(d3, d4);
                        break;
                    }
                    case 2: {
                        double d5 = object.b.c[(Integer)object2][n2];
                        double d6 = object.b.c[n2][(Integer)object2];
                        if (Double.isInfinite(d5)) {
                            if (Double.isInfinite(d6)) {
                                d2 = object.b.f;
                                break;
                            }
                            d2 = d6;
                            break;
                        }
                        if (Double.isInfinite(d6)) {
                            d2 = d5;
                            break;
                        }
                        d2 = Math.max(d5, d6);
                        break;
                    }
                    case 3: {
                        double d7 = object.b.c[(Integer)object2][n2];
                        double d8 = object.b.c[n2][(Integer)object2];
                        if (Double.isInfinite(d7)) {
                            if (Double.isInfinite(d8)) {
                                d2 = object.b.f;
                                break;
                            }
                            d2 = d8;
                            break;
                        }
                        if (Double.isInfinite(d8)) {
                            d2 = d7;
                            break;
                        }
                        d2 = (d7 + d8) / 2.0;
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                return d2;
            }
        };
    }

    public Matrix getNodeDistanceMatrix() {
        return new AbstractMatrix<Node, Node>(this){
            private /* synthetic */ FloydWarshall a;
            {
                this.a = floydWarshall;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final boolean isAvailable(Node row, Node column) {
                switch (this.a.e.ordinal()) {
                    case 0: {
                        return Double.isFinite(this.a.c[this.a.a.getVerticesIndex().getAddress(row)][this.a.a.getVerticesIndex().getAddress(column)]);
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        void var1_1;
                        void var2_2;
                        return Double.isFinite(this.a.c[this.a.a.getVerticesIndex().getAddress(row)][this.a.a.getVerticesIndex().getAddress(column)]) || Double.isFinite(this.a.c[this.a.a.getVerticesIndex().getAddress(var2_2)][this.a.a.getVerticesIndex().getAddress(var1_1)]);
                    }
                }
                return false;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final double getDouble(Node row, Node column) {
                double d2;
                switch (this.a.e.ordinal()) {
                    case 0: {
                        d2 = this.a.c[this.a.a.getVerticesIndex().getAddress(row)][this.a.a.getVerticesIndex().getAddress(column)];
                        break;
                    }
                    case 1: {
                        double d3 = this.a.c[this.a.a.getVerticesIndex().getAddress(row)][this.a.a.getVerticesIndex().getAddress(column)];
                        double d4 = this.a.c[this.a.a.getVerticesIndex().getAddress(column)][this.a.a.getVerticesIndex().getAddress(row)];
                        if (Double.isInfinite(d3)) {
                            if (Double.isInfinite(d4)) {
                                d2 = this.a.f;
                                break;
                            }
                            d2 = d4;
                            break;
                        }
                        if (Double.isInfinite(d4)) {
                            d2 = d3;
                            break;
                        }
                        d2 = Math.min(d3, d4);
                        break;
                    }
                    case 2: {
                        double d5 = this.a.c[this.a.a.getVerticesIndex().getAddress(row)][this.a.a.getVerticesIndex().getAddress(column)];
                        double d6 = this.a.c[this.a.a.getVerticesIndex().getAddress(column)][this.a.a.getVerticesIndex().getAddress(row)];
                        if (Double.isInfinite(d5)) {
                            if (Double.isInfinite(d6)) {
                                d2 = this.a.f;
                                break;
                            }
                            d2 = d6;
                            break;
                        }
                        if (Double.isInfinite(d6)) {
                            d2 = d5;
                            break;
                        }
                        d2 = Math.max(d5, d6);
                        break;
                    }
                    case 3: {
                        void var1_1;
                        void var2_2;
                        double d7 = this.a.c[this.a.a.getVerticesIndex().getAddress(row)][this.a.a.getVerticesIndex().getAddress(column)];
                        double d8 = this.a.c[this.a.a.getVerticesIndex().getAddress(var2_2)][this.a.a.getVerticesIndex().getAddress(var1_1)];
                        if (Double.isInfinite(d7)) {
                            if (Double.isInfinite(d8)) {
                                d2 = this.a.f;
                                break;
                            }
                            d2 = d8;
                            break;
                        }
                        if (Double.isInfinite(d8)) {
                            d2 = d7;
                            break;
                        }
                        d2 = (d7 + d8) / 2.0;
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                return d2;
            }

            @Override
            public final UniqueIndex<Node> getRowIndex() {
                return this.a.a.getVerticesIndex();
            }

            @Override
            public final UniqueIndex<Node> getColumnIndex() {
                return this.a.a.getVerticesIndex();
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    public double dist(int s2, int t2) {
        void var2_2;
        void var1_1;
        this.a(s2);
        this.a(t2);
        FloydWarshall floydWarshall = this;
        if (floydWarshall.b) {
            throw new UnsupportedOperationException("Negative cost cycle exists");
        }
        return this.c[var1_1][var2_2];
    }

    /*
     * WARNING - void declaration
     */
    public Iterable<Link> path(int s2, int t2) {
        void var2_2;
        this.a(s2);
        this.a(t2);
        Object object = this;
        if (((FloydWarshall)object).b) {
            throw new UnsupportedOperationException("Negative cost cycle exists");
        }
        int n2 = t2;
        int n3 = s2;
        object = this;
        ((FloydWarshall)object).a(n3);
        ((FloydWarshall)object).a(n2);
        if (!(((FloydWarshall)object).c[n3][n2] < Double.POSITIVE_INFINITY)) {
            return null;
        }
        object = new Stack();
        Link Link = this.d[s2][var2_2];
        while (Link != null) {
            ((Stack)object).push(Link);
            Link = this.d[s2][this.a.getVerticesIndex().getAddress(this.a.getFrom(Link))];
        }
        return object;
    }

    private void a(int n2) {
        int n3 = this.c.length;
        if (n2 < 0 || n2 >= n3) {
            throw new IllegalArgumentException("vertex " + n2 + " is not between 0 and " + (n3 - 1));
        }
    }

    private static enum Mode {
        Directed,
        Min,
        Max,
        Mean;

    }
}

