/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.molap.subset;

import com.macrofocus.common.collection.Iterables;
import com.macrofocus.common.selection.MutableSelection;
import com.macrofocus.common.selection.NullSelection;
import com.macrofocus.common.selection.SelectionEvent;
import com.macrofocus.common.selection.SelectionListener;
import com.macrofocus.filter.Filter;
import com.macrofocus.molap.subset.AbstractDimension;
import com.macrofocus.molap.subset.BinningDimension;
import com.macrofocus.molap.subset.Group;
import com.macrofocus.molap.subset.Reducer;
import com.macrofocus.molap.subset.SortedArraySetOperations;
import com.macrofocus.molap.subset.SubsetDataFrame;
import com.macrofocus.molap.util.CollectionFactory;
import com.macrofocus.molap.util.ObjectIntMap;
import com.macrofocus.utils.RandomAccessIterable;
import com.macrofocus.utils.RandomAccessIterables;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.util.ArrayList;
import java.util.Map;

public abstract class AbstractBinningDimension<Row, Column, Value, Bin>
extends AbstractDimension<Row>
implements BinningDimension<Row, Bin> {
    private Operation a;
    protected SubsetDataFrame<Row, Column, Value> dataFrame;
    protected Map<Bin, int[]> index;
    protected int maxValueCount;
    protected int sumValueCount;
    protected ObjectIntMap<Bin> filterCounts;
    protected ObjectIntMap<Bin> selectedCounts;
    private double b = -1.0;
    private double c = -1.0;
    protected RandomAccessIterable<Bin> bins;
    private RandomAccessIterable<Bin> d;
    private boolean e = false;
    protected int[] otherActiveIndices;
    protected int[] activeIndices;
    protected Map<Reducer, Group> groups;
    private MutableSelection<Bin> f = new NullSelection();
    protected boolean inverseFilter = false;
    private final AbstractDimension.FilteringCallback<Row> g;
    protected final MutableSelection<Row> selection;
    protected boolean updateFilterImmediately = false;

    /*
     * WARNING - void declaration
     */
    public AbstractBinningDimension(SubsetDataFrame<Row, Column, Value> dataFrame, AbstractDimension.FilteringCallback<Row> filteringCallback, MutableSelection<Row> selection, Operation operation) {
        void var3_3;
        void var2_2;
        RandomAccessIterable<Bin> randomAccessIterable;
        this.dataFrame = randomAccessIterable;
        this.g = var2_2;
        this.selection = var3_3;
        this.a = operation;
        randomAccessIterable = this.getBins();
        this.filterCounts = CollectionFactory.getInstance().createObjectIntMap(randomAccessIterable != null ? randomAccessIterable.size() : 10, 0.5f, 0);
        this.selectedCounts = CollectionFactory.getInstance().createObjectIntMap(randomAccessIterable != null ? randomAccessIterable.size() : 10, 0.5f, 0);
        this.f.addSelectionListener(new SelectionListener<Bin>(this){
            private /* synthetic */ AbstractBinningDimension a;
            {
                this.a = abstractBinningDimension;
            }

            public final void selectionChanged(SelectionEvent<Bin> event) {
                this.a.scheduleUpdateFilter();
            }
        });
    }

    @Override
    public boolean isReducable() {
        return true;
    }

    protected void updateActive() {
        RandomAccessIterable randomAccessIterable;
        double d2 = 0.0;
        double d3 = 0.0;
        if (this.filterCounts != null && this.filterCounts.size() > 0) {
            ArrayList arrayList = new ArrayList();
            randomAccessIterable = RandomAccessIterables.forList(arrayList);
            for (Object e2 : this.getBins()) {
                double d4 = this.getActiveDensity(e2);
                d2 = Math.max(d4, d2);
                d3 += d4;
                if (!(d4 > 0.0)) continue;
                arrayList.add(e2);
            }
        } else {
            d2 = this.getMaxDensity();
            d3 = this.getSumDensity();
            randomAccessIterable = this.getBins();
        }
        this.d = randomAccessIterable;
        this.b = d2;
        this.c = d3;
    }

    @Override
    public RandomAccessIterable<Bin> getActiveBins() {
        if (this.d != null) {
            return this.d;
        }
        return this.getBins();
    }

    @Override
    public RandomAccessIterable<Bin> getBins() {
        RandomAccessIterable<Bin> randomAccessIterable = this.bins;
        if (randomAccessIterable != null) {
            return randomAccessIterable;
        }
        this.materializeIndex();
        assert (this.bins != null) : "Not indexed";
        return this.bins;
    }

    protected Map<Bin, int[]> getIndex() {
        Map<Bin, int[]> map = this.index;
        if (map != null) {
            return map;
        }
        this.materializeIndex();
        return this.index;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Iterable<Row> getRows(Bin bin) {
        void var1_1;
        return Iterables.conditional(new AbstractDimension.IndicesIterable<Row>(this.dataFrame.getUnfilteredDataFrame(), new AbstractDimension.IndicesSupplier(){
            private /* synthetic */ Object a;
            private /* synthetic */ AbstractBinningDimension b;
            {
                this.b = abstractBinningDimension;
                this.a = object;
            }

            @Override
            public final int[] get() {
                return this.b.getIndex().get(this.a);
            }
        }), (Iterables.Condition)new Iterables.Condition<Row>(this){
            private /* synthetic */ AbstractBinningDimension a;
            {
                this.a = abstractBinningDimension;
            }

            /*
             * WARNING - void declaration
             */
            public final boolean apply(Row row) {
                void var1_1;
                return !this.a.getFilter().isFiltered((Object)var1_1);
            }
        });
    }

    @Override
    public MutableSelection<Row> getSelection() {
        return this.selection;
    }

    public Filter<Row> getFilter() {
        return this.dataFrame.getOutputFilter();
    }

    @Override
    public MutableSelection<Bin> getFilterExact() {
        return this.f;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void filterExact(Bin ... bins) {
        void var1_1;
        this.getFilterExact().setSelectedElements((Object[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void filterExactIterable(Iterable<Bin> bins) {
        void var1_1;
        this.getFilterExact().setSelectedIterable((Iterable)var1_1);
    }

    @Override
    public boolean getInverseFilter() {
        return this.inverseFilter;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setInverseFilter(boolean inverse) {
        if (this.inverseFilter != inverse) {
            void var1_1;
            this.inverseFilter = var1_1;
            this.scheduleUpdateFilter();
        }
    }

    @Override
    public void filterAll() {
        this.getFilterExact().clearSelection();
    }

    @Override
    protected synchronized void scheduleUpdateFilter() {
        if (this.updateFilterImmediately || this.updateTimer == null) {
            this.updateFilter();
            return;
        }
        this.updateTimer.restart();
    }

    @Override
    protected synchronized void updateFilter() {
        int[] nArray = this.activeIndices;
        int[] nArray2 = this.activeIndices = this.updateActiveIndices();
        this.g.filteringChanged(new AbstractDimension.FilteringEvent<Row>(this, new AbstractDimension.IndicesIterable<Row>(this.dataFrame.getUnfilteredDataFrame(), new AbstractDimension.IndicesSupplier(){
            private /* synthetic */ int[] a;
            private /* synthetic */ int[] b;
            private /* synthetic */ AbstractBinningDimension c;
            {
                this.c = abstractBinningDimension;
                this.a = nArray;
                this.b = nArray2;
            }

            @Override
            public final int[] get() {
                return this.c.dataFrame.computeFiltered(this.a, this.b);
            }
        }), new AbstractDimension.IndicesIterable<Row>(this.dataFrame.getUnfilteredDataFrame(), new AbstractDimension.IndicesSupplier(){
            private /* synthetic */ int[] a;
            private /* synthetic */ int[] b;
            private /* synthetic */ AbstractBinningDimension c;
            {
                this.c = abstractBinningDimension;
                this.a = nArray;
                this.b = nArray2;
            }

            @Override
            public final int[] get() {
                return this.c.dataFrame.computeUnfiltered(this.a, this.b);
            }
        })));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public double getDensity(Bin bin) {
        void var1_1;
        assert (this.getIndex().containsKey(bin)) : String.valueOf(bin) + " not found for " + this.getName();
        return this.getIndex().get(var1_1).length;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public double getActiveDensity(Bin bin) {
        void var1_1;
        double d2 = this.getDensity(bin) - this.getFilterDensity(bin);
        assert (d2 >= 0.0);
        assert (d2 <= this.getDensity(var1_1));
        return d2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public double getFilterDensity(Bin bin) {
        void var1_1;
        return this.filterCounts.get(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public double getSelectionDensity(Bin bin) {
        void var1_1;
        return this.selectedCounts.get(var1_1);
    }

    @Override
    public double getMaxDensity() {
        this.getIndex();
        return this.maxValueCount;
    }

    @Override
    public double getMaxActiveDensity() {
        this.getIndex();
        if (this.b >= 0.0) {
            return this.b;
        }
        return this.getMaxDensity();
    }

    @Override
    public double getSumDensity() {
        this.getIndex();
        return this.sumValueCount;
    }

    @Override
    public double getSumActiveDensity() {
        this.getIndex();
        if (this.c >= 0.0) {
            return this.c;
        }
        return this.getSumDensity();
    }

    @Override
    public void markDirty() {
        this.index = null;
        this.bins = null;
        this.d = null;
        this.b = 0.0;
        this.maxValueCount = 0;
        this.c = 0.0;
        this.sumValueCount = 0;
        this.e = true;
    }

    @Override
    public int[] getActiveIndices() {
        if (this.e) {
            this.activeIndices = this.updateActiveIndices();
            this.e = false;
        }
        return this.activeIndices;
    }

    public int[] updateActiveIndices() {
        if (!this.inverseFilter) {
            if (this.getFilterExact().isActive()) {
                Map<Bin, int[]> map = this.getIndex();
                assert (map != null) : "Dimension \"" + String.valueOf(this) + "\" is not indexed";
                Object object = null;
                for (Object object2 : this.getFilterExact()) {
                    int[] nArray = map.get(object2);
                    object2 = nArray;
                    if (nArray != null) {
                        if (object == null) {
                            object = object2;
                            continue;
                        }
                        object = this.a.a((int[])object, (int[])object2);
                        continue;
                    }
                    object = new int[]{};
                    break;
                }
                return object;
            }
            return null;
        }
        if (this.getFilterExact().isActive()) {
            Map<Bin, int[]> map = this.getIndex();
            assert (map != null) : "Dimension \"" + String.valueOf(this) + "\" is not indexed";
            int[] nArray = null;
            for (Object object : this.getFilterExact()) {
                int[] nArray2 = map.get(object);
                object = nArray2;
                if (nArray2 != null) {
                    object = SortedArraySetOperations.diffSortedTIntArrays(this.dataFrame.getUnfilteredDataFrame().getRowCount(), object);
                    if (nArray == null) {
                        nArray = (int[])object;
                        continue;
                    }
                    nArray = this.a.a(nArray, (int[])object);
                    continue;
                }
                nArray = null;
                break;
            }
            return nArray;
        }
        return new int[0];
    }

    @Override
    public int[] getActiveIndicesUsingArrays() {
        if (this.getFilterExact().isActive()) {
            Map<Bin, int[]> map = this.getIndex();
            assert (map != null) : "Dimension \"" + String.valueOf(this) + "\" is not indexed";
            int[] nArray = null;
            for (Object object : this.getFilterExact()) {
                int[] nArray2 = map.get(object);
                object = nArray2;
                if (nArray2 == null) continue;
                if (nArray == null) {
                    nArray = (int[])object;
                    continue;
                }
                nArray = this.a.a(nArray, (int[])object);
            }
            return nArray;
        }
        return null;
    }

    @Override
    public TIntSet getActiveIndicesUsingHashSet() {
        if (this.getFilterExact().isActive()) {
            Map<Bin, int[]> map = this.getIndex();
            assert (map != null) : "Dimension \"" + String.valueOf(this) + "\" is not indexed";
            TIntHashSet tIntHashSet = new TIntHashSet();
            for (Object object : this.getFilterExact()) {
                int[] nArray = map.get(object);
                object = nArray;
                if (nArray == null) continue;
                tIntHashSet.addAll((int[])object);
            }
            return tIntHashSet;
        }
        return null;
    }

    protected static enum Operation {
        And{

            @Override
            public final int[] a(int[] nArray, int[] nArray2) {
                return SortedArraySetOperations.intersectSortedArrays(nArray, nArray2);
            }
        }
        ,
        Or{

            @Override
            public final int[] a(int[] nArray, int[] nArray2) {
                return SortedArraySetOperations.unionSortedArrays(nArray, nArray2);
            }
        };


        abstract int[] a(int[] var1, int[] var2);
    }
}

