/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove.impl;

public final class HashFunctions {
    public static int hash(double value) {
        double d2;
        assert (!Double.isNaN(value)) : "Values of NaN are not supported.";
        long l2 = Double.doubleToLongBits(d2);
        return (int)(l2 ^ l2 >>> 32);
    }

    public static int hash(float value) {
        float f2;
        assert (!Float.isNaN(value)) : "Values of NaN are not supported.";
        return Float.floatToIntBits(f2 * 6.6360896E8f);
    }

    public static int hash(int value) {
        return value;
    }

    public static int hash(long value) {
        long l2 = value;
        return (int)(l2 ^ l2 >>> 32);
    }

    public static int hash(Object object) {
        Object object2;
        if (object == null) {
            return 0;
        }
        return object2.hashCode();
    }

    public static int fastCeil(float v2) {
        float f2;
        int n2 = (int)v2;
        if (f2 - (float)n2 > 0.0f) {
            ++n2;
        }
        return n2;
    }
}

