/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove.impl.hash;

import gnu.trove.impl.hash.THash;
import gnu.trove.procedure.TObjectProcedure;
import java.util.Arrays;
import java.util.HashSet;

public abstract class TObjectHash<T>
extends THash {
    public transient Object[] _set;
    public static final Object REMOVED = new Object();
    public static final Object FREE = new Object();
    protected boolean consumeFreeSlot;

    public TObjectHash() {
    }

    /*
     * WARNING - void declaration
     */
    public TObjectHash(int initialCapacity) {
        super((int)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public TObjectHash(int initialCapacity, float loadFactor) {
        super((int)var1_1, (float)var2_2);
        void var2_2;
        void var1_1;
    }

    @Override
    public int capacity() {
        return this._set.length;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void removeAt(int index) {
        void var1_1;
        this._set[index] = REMOVED;
        super.removeAt((int)var1_1);
    }

    @Override
    public int setUp(int initialCapacity) {
        int n2;
        n2 = super.setUp(n2);
        this._set = new Object[n2];
        Arrays.fill(this._set, FREE);
        return n2;
    }

    public boolean forEach(TObjectProcedure<? super T> procedure) {
        Object[] objectArray = this._set;
        int n2 = this._set.length;
        while (n2-- > 0) {
            if (objectArray[n2] == FREE || objectArray[n2] == REMOVED || procedure.execute(objectArray[n2])) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public boolean contains(Object obj) {
        void var1_1;
        return this.index(var1_1) >= 0;
    }

    protected int index(Object obj) {
        TObjectHash tObjectHash;
        if (obj == null) {
            obj = this;
            int n2 = 0;
            Object[] objectArray = ((TObjectHash)obj)._set;
            int n3 = ((TObjectHash)obj)._set.length;
            for (int i2 = 0; i2 < n3; ++i2) {
                Object object = objectArray[i2];
                if (object == null) {
                    return n2;
                }
                if (object == FREE) break;
                ++n2;
            }
            return -1;
        }
        int n4 = this.hash(obj) & Integer.MAX_VALUE;
        int n5 = n4 % this._set.length;
        Object object = this._set[n5];
        if (object == FREE) {
            return -1;
        }
        if (object == obj || this.equalsNotNull(obj, object)) {
            return n5;
        }
        int n6 = n4;
        void var2_4 = tObjectHash;
        tObjectHash = this;
        Object[] objectArray = tObjectHash._set;
        int n7 = tObjectHash._set.length;
        n6 = 1 + n6 % (n7 - 2);
        int n8 = n5;
        do {
            Object object2;
            if ((n5 -= n6) < 0) {
                n5 += n7;
            }
            if ((object2 = objectArray[n5]) == FREE) {
                return -1;
            }
            if (object2 != var2_4 && !tObjectHash.equalsNotNull(var2_4, object2)) continue;
            return n5;
        } while (n5 != n8);
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    protected int insertionIndex(T obj) {
        void var1_1;
        return this.insertKey(var1_1);
    }

    protected int insertKey(T key) {
        TObjectHash tObjectHash;
        this.consumeFreeSlot = false;
        if (key == null) {
            key = this;
            int n2 = 0;
            int n3 = -1;
            Object[] objectArray = ((TObjectHash)key)._set;
            int n4 = ((TObjectHash)key)._set.length;
            for (int i2 = 0; i2 < n4; ++i2) {
                Object object = objectArray[i2];
                if (object == REMOVED && n3 == -1) {
                    n3 = n2;
                }
                if (object == FREE) {
                    if (n3 != -1) {
                        ((TObjectHash)key)._set[n3] = null;
                        return n3;
                    }
                    ((TObjectHash)key).consumeFreeSlot = true;
                    ((TObjectHash)key)._set[n2] = null;
                    return n2;
                }
                if (object == null) {
                    return -n2 - 1;
                }
                ++n2;
            }
            if (n3 != -1) {
                ((TObjectHash)key)._set[n3] = null;
                return n3;
            }
            throw new IllegalStateException("Could not find insertion index for null key. Key set full!?!!");
        }
        int n5 = this.hash(key) & Integer.MAX_VALUE;
        int n6 = n5 % this._set.length;
        Object object = this._set[n6];
        if (object == FREE) {
            this.consumeFreeSlot = true;
            this._set[n6] = key;
            return n6;
        }
        if (object == key || this.equalsNotNull(key, object)) {
            return -n6 - 1;
        }
        Object object2 = object;
        int n7 = n5;
        void var2_4 = tObjectHash;
        tObjectHash = this;
        Object[] objectArray = tObjectHash._set;
        int n8 = tObjectHash._set.length;
        n7 = 1 + n7 % (n8 - 2);
        int n9 = n6;
        int n10 = -1;
        do {
            if (object2 == REMOVED && n10 == -1) {
                n10 = n6;
            }
            if ((n6 -= n7) < 0) {
                n6 += n8;
            }
            if ((object2 = objectArray[n6]) == FREE) {
                if (n10 != -1) {
                    tObjectHash._set[n10] = var2_4;
                    return n10;
                }
                tObjectHash.consumeFreeSlot = true;
                tObjectHash._set[n6] = var2_4;
                return n6;
            }
            if (object2 != var2_4 && !tObjectHash.equalsNotNull(var2_4, object2)) continue;
            return -n6 - 1;
        } while (n6 != n9);
        if (n10 != -1) {
            tObjectHash._set[n10] = var2_4;
            return n10;
        }
        throw new IllegalStateException("No free or removed slots available. Key set full?!!");
    }

    /*
     * WARNING - void declaration
     */
    protected final void throwObjectContractViolation(Object o1, Object o2) throws IllegalArgumentException {
        void var2_2;
        void var1_1;
        throw this.buildObjectContractViolation(var1_1, var2_2, "");
    }

    /*
     * WARNING - void declaration
     */
    protected final void throwObjectContractViolation(Object o1, Object o2, int size, int oldSize, Object[] oldKeys) throws IllegalArgumentException {
        void var2_2;
        void var1_1;
        String string = this.dumpExtraInfo(o1, o2, this.size(), oldSize, oldKeys);
        throw this.buildObjectContractViolation(var1_1, var2_2, string);
    }

    /*
     * WARNING - void declaration
     */
    protected final IllegalArgumentException buildObjectContractViolation(Object o1, Object o2, String extra) {
        void var3_3;
        void var2_2;
        void var1_1;
        return new IllegalArgumentException("Equal objects must have equal hashcodes. During rehashing, Trove discovered that the following two objects claim to be equal (as in java.lang.Object.equals()) but their hashCodes (or those calculated by your TObjectHashingStrategy) are not equal.This violates the general contract of java.lang.Object.hashCode().  See bullet point two in that method's documentation. object #1 =" + TObjectHash.objectInfo(var1_1) + "; object #2 =" + TObjectHash.objectInfo(var2_2) + "\n" + (String)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    protected boolean equalsNotNull(Object notnull, Object two) {
        void var2_2;
        void var1_1;
        if (two == null || two == REMOVED) {
            return false;
        }
        return var1_1.equals(var2_2);
    }

    protected int hash(Object notnull) {
        return notnull.hashCode();
    }

    /*
     * WARNING - void declaration
     */
    protected static String reportPotentialConcurrentMod(int newSize, int oldSize) {
        if (newSize != oldSize) {
            int n2;
            void var1_1;
            return "[Warning] apparent concurrent modification of the key set. Size before and after rehash() do not match " + (int)var1_1 + " vs " + n2;
        }
        return "";
    }

    /*
     * WARNING - void declaration
     */
    protected String dumpExtraInfo(Object newVal, Object oldVal, int currentSize, int oldSize, Object[] oldKeys) {
        void var1_1;
        void var3_3;
        int n2;
        StringBuilder stringBuilder = new StringBuilder();
        Object object = oldVal;
        Object object2 = newVal;
        Object object3 = this;
        Object object4 = new StringBuilder();
        Object object5 = new HashSet();
        object3 = ((TObjectHash)object3)._set;
        int n3 = ((TObjectHash)object3)._set.length;
        for (n2 = 0; n2 < n3; ++n2) {
            Object object6 = object3[n2];
            if (object6 == FREE || object6 == REMOVED) continue;
            if (object6 != null) {
                object5.add(object6.getClass());
                continue;
            }
            object5.add(null);
        }
        if (object5.size() > 1) {
            String string;
            ((StringBuilder)object4).append("\nMore than one type used for keys. Watch out for asymmetric equals(). Read about the 'Liskov substitution principle' and the implications for equals() in java.");
            ((StringBuilder)object4).append("\nKey types: ").append(object5);
            object3 = object;
            object5 = object2;
            object2 = new StringBuilder();
            if (object5 == object3) {
                string = "a == b";
            } else {
                if (object5.getClass() != object3.getClass()) {
                    ((StringBuilder)object2).append("Class of objects differ a=").append(object5.getClass()).append(" vs b=").append(object3.getClass());
                    boolean bl = object5.equals(object3);
                    boolean bl2 = object3.equals(object5);
                    if (bl != bl2) {
                        ((StringBuilder)object2).append("\nequals() of a or b object are asymmetric");
                        ((StringBuilder)object2).append("\na.equals(b) =").append(bl);
                        ((StringBuilder)object2).append("\nb.equals(a) =").append(bl2);
                    }
                }
                string = ((StringBuilder)object2).toString();
            }
            ((StringBuilder)object4).append(string);
        }
        stringBuilder.append(((StringBuilder)object4).toString());
        stringBuilder.append(TObjectHash.reportPotentialConcurrentMod((int)var3_3, oldSize));
        int n4 = oldSize;
        Object object7 = oldKeys;
        object = new StringBuilder();
        object5 = object7;
        object7 = new HashSet();
        Object[] objectArray = object5;
        n2 = ((Object[])object5).length;
        for (int i2 = 0; i2 < n2; ++i2) {
            object5 = objectArray[i2];
            if (object5 == FREE || object5 == REMOVED) continue;
            object7.add(object5);
        }
        object4 = object7;
        if (object4.size() != n4) {
            ((StringBuilder)object).append("\nhashCode() and/or equals() have inconsistent implementation");
            ((StringBuilder)object).append("\nKey set lost entries, now got ").append(object4.size()).append(" instead of ").append(n4);
            ((StringBuilder)object).append(". This can manifest itself as an apparent duplicate key.");
        }
        stringBuilder.append(((StringBuilder)object).toString());
        if (var1_1 == oldVal) {
            void var2_2;
            stringBuilder.append("Inserting same object twice, rehashing bug. Object= ").append(var2_2);
        }
        return stringBuilder.toString();
    }

    protected static String objectInfo(Object o2) {
        Object object;
        return String.valueOf(o2 == null ? "class null" : o2.getClass()) + " id= " + System.identityHashCode(o2) + " hashCode= " + (o2 == null ? 0 : o2.hashCode()) + " toString= " + String.valueOf(object);
    }
}

