/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove.map.hash;

import gnu.trove.func.TObjectFunction;
import gnu.trove.impl.HashFunctions;
import gnu.trove.impl.hash.THash;
import gnu.trove.impl.hash.TObjectHash;
import gnu.trove.iterator.hash.TObjectHashIterator;
import gnu.trove.map.TMap;
import gnu.trove.procedure.TObjectObjectProcedure;
import gnu.trove.procedure.TObjectProcedure;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class THashMap<K, V>
extends TObjectHash<K>
implements TMap<K, V> {
    protected transient V[] _values;

    public THashMap() {
    }

    /*
     * WARNING - void declaration
     */
    public THashMap(int initialCapacity) {
        super((int)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public THashMap(int initialCapacity, float loadFactor) {
        super((int)var1_1, (float)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public THashMap(Map<? extends K, ? extends V> map) {
        this(map.size());
        void var1_1;
        this.putAll((Map<K, V>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public THashMap(THashMap<? extends K, ? extends V> map) {
        this(map.size());
        void var1_1;
        this.putAll((Map<K, V>)var1_1);
    }

    @Override
    public int setUp(int initialCapacity) {
        int n2;
        n2 = super.setUp(n2);
        this._values = new Object[n2];
        return n2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V put(K key, V value) {
        void var2_3;
        void var1_1;
        int n2 = this.insertKey(var1_1);
        return this.a(var2_3, n2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V putIfAbsent(K key, V value) {
        void var2_3;
        void var1_1;
        int n2 = this.insertKey(var1_1);
        if (n2 < 0) {
            return this._values[-n2 - 1];
        }
        return this.a(var2_3, n2);
    }

    private V a(V v2, int n2) {
        V v3 = null;
        boolean bl = true;
        if (n2 < 0) {
            n2 = -n2 - 1;
            v3 = this._values[n2];
            bl = false;
        }
        this._values[n2] = v2;
        if (bl) {
            THashMap tHashMap = this;
            tHashMap.postInsertHook(tHashMap.consumeFreeSlot);
        }
        return v3;
    }

    @Override
    public boolean equals(Object other) {
        return false;
    }

    @Override
    public int hashCode() {
        b b2 = new b(this);
        this.forEachEntry(b2);
        return b2.a();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("{");
        d d2 = new d(this, stringBuilder);
        this.forEachEntry(d2);
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean forEachKey(TObjectProcedure<? super K> procedure) {
        void var1_1;
        return this.forEach(var1_1);
    }

    @Override
    public boolean forEachValue(TObjectProcedure<? super V> procedure) {
        V[] VArray = this._values;
        Object[] objectArray = this._set;
        int n2 = VArray.length;
        while (n2-- > 0) {
            if (objectArray[n2] == FREE || objectArray[n2] == REMOVED || procedure.execute(VArray[n2])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean forEachEntry(TObjectObjectProcedure<? super K, ? super V> procedure) {
        Object[] objectArray = this._set;
        V[] VArray = this._values;
        int n2 = objectArray.length;
        while (n2-- > 0) {
            if (objectArray[n2] == FREE || objectArray[n2] == REMOVED || procedure.execute(objectArray[n2], VArray[n2])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean retainEntries(TObjectObjectProcedure<? super K, ? super V> procedure) {
        boolean bl = false;
        Object[] objectArray = this._set;
        V[] VArray = this._values;
        this.tempDisableAutoCompaction();
        try {
            int n2 = objectArray.length;
            while (n2-- > 0) {
                if (objectArray[n2] == FREE || objectArray[n2] == REMOVED || procedure.execute(objectArray[n2], VArray[n2])) continue;
                this.removeAt(n2);
                bl = true;
            }
        }
        finally {
            this.reenableAutoCompaction(true);
        }
        return bl;
    }

    @Override
    public void transformValues(TObjectFunction<V, V> func) {
        V[] VArray = this._values;
        Object[] objectArray = this._set;
        int n2 = VArray.length;
        while (n2-- > 0) {
            if (objectArray[n2] == FREE || objectArray[n2] == REMOVED) continue;
            VArray[n2] = func.execute(VArray[n2]);
        }
    }

    @Override
    protected void rehash(int newCapacity) {
        int n2;
        int n3 = this._set.length;
        int n4 = this.size();
        Object[] objectArray = this._set;
        V[] VArray = this._values;
        this._set = new Object[newCapacity];
        Arrays.fill(this._set, FREE);
        this._values = new Object[n2];
        n2 = n3;
        while (n2-- > 0) {
            Object object = objectArray[n2];
            if (object == FREE || object == REMOVED) continue;
            int n5 = this.insertKey(object);
            if (n5 < 0) {
                THashMap tHashMap = this;
                tHashMap.throwObjectContractViolation(tHashMap._set[-n5 - 1], object, this.size(), n4, objectArray);
            }
            this._values[n5] = VArray[n2];
        }
        THashMap.reportPotentialConcurrentMod(this.size(), n4);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V get(Object key) {
        void var1_1;
        int n2 = this.index(var1_1);
        if (n2 < 0) {
            return null;
        }
        return this._values[n2];
    }

    @Override
    public void clear() {
        if (this.size() == 0) {
            return;
        }
        super.clear();
        Arrays.fill(this._set, 0, this._set.length, FREE);
        Arrays.fill(this._values, 0, this._values.length, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V remove(Object key) {
        void var1_1;
        V v2 = null;
        int n2 = this.index(var1_1);
        if (n2 >= 0) {
            v2 = this._values[n2];
            this.removeAt(n2);
        }
        return v2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void removeAt(int index) {
        void var1_1;
        this._values[index] = null;
        super.removeAt((int)var1_1);
    }

    @Override
    public Collection<V> values() {
        return new ValueView();
    }

    @Override
    public Set<K> keySet() {
        return new KeyView(this);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new EntryView();
    }

    @Override
    public boolean containsValue(Object val) {
        Object[] objectArray = this._set;
        V[] VArray = this._values;
        if (val == null) {
            int n2 = VArray.length;
            while (n2-- > 0) {
                if (objectArray[n2] == FREE || objectArray[n2] == REMOVED || val != VArray[n2]) continue;
                return true;
            }
        } else {
            int n3 = VArray.length;
            while (n3-- > 0) {
                if (objectArray[n3] == FREE || objectArray[n3] == REMOVED || val != VArray[n3] && !this.equalsNotNull(val, VArray[n3])) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean containsKey(Object key) {
        void var1_1;
        return this.contains(var1_1);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        Iterator iterator;
        this.ensureCapacity(map.size());
        for (Map.Entry entry : iterator.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    private final class b
    implements TObjectObjectProcedure<K, V> {
        private int a = 0;
        private /* synthetic */ THashMap b;

        private b(THashMap tHashMap) {
            this.b = tHashMap;
        }

        public final int a() {
            return this.a;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean execute(K key, V value) {
            void var2_2;
            void var1_1;
            this.a += HashFunctions.hash(var1_1) ^ (value == null ? 0 : var2_2.hashCode());
            return true;
        }
    }

    private final class d
    implements TObjectObjectProcedure<K, V> {
        private final StringBuilder a;
        private boolean b;
        private /* synthetic */ THashMap c;

        public d(THashMap tHashMap, StringBuilder stringBuilder) {
            this.c = tHashMap;
            this.a = stringBuilder;
            this.b = true;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean execute(K key, V value) {
            void var2_2;
            void var1_1;
            if (this.b) {
                this.b = false;
            } else {
                this.a.append(", ");
            }
            this.a.append(var1_1);
            this.a.append("=");
            this.a.append(var2_2);
            return true;
        }
    }

    protected class ValueView
    extends c<V> {
        /*
         * WARNING - void declaration
         */
        protected ValueView() {
            void var1_1;
            super((THashMap)var1_1);
        }

        @Override
        public Iterator<V> iterator() {
            ValueView valueView = this;
            return new TObjectHashIterator(valueView, valueView.THashMap.this){
                private /* synthetic */ ValueView a;
                {
                    this.a = valueView;
                    super(tHashMap);
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                protected final V objectAtIndex(int index) {
                    void var1_1;
                    return this.a.THashMap.this._values[var1_1];
                }
            };
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean containsElement(V value) {
            void var1_1;
            return THashMap.this.containsValue(var1_1);
        }

        @Override
        public boolean removeElement(V value) {
            V[] VArray = THashMap.this._values;
            Object[] objectArray = THashMap.this._set;
            int n2 = VArray.length;
            while (n2-- > 0) {
                if ((objectArray[n2] == TObjectHash.FREE || objectArray[n2] == TObjectHash.REMOVED || value != VArray[n2]) && (null == VArray[n2] || !THashMap.this.equalsNotNull(VArray[n2], value))) continue;
                THashMap.this.removeAt(n2);
                return true;
            }
            return false;
        }
    }

    protected class KeyView
    extends c<K> {
        private /* synthetic */ THashMap a;

        /*
         * WARNING - void declaration
         */
        protected KeyView(THashMap this$0) {
            void var1_1;
            this.a = this$0;
            super((THashMap)var1_1);
        }

        @Override
        public Iterator<K> iterator() {
            return new TObjectHashIterator(this.a);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean removeElement(K key) {
            void var1_1;
            return null != this.a.remove(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean containsElement(K key) {
            void var1_1;
            return this.a.contains(var1_1);
        }
    }

    protected class EntryView
    extends c<Map.Entry<K, V>> {
        /*
         * WARNING - void declaration
         */
        protected EntryView() {
            void var1_1;
            super((THashMap)var1_1);
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            EntryView entryView = this;
            return new a(entryView, entryView.THashMap.this);
        }

        @Override
        public boolean removeElement(Map.Entry<K, V> entry) {
            Object v2;
            if (entry == null) {
                return false;
            }
            Object k2 = this.keyForEntry(entry);
            int n2 = THashMap.this.index(k2);
            if (n2 >= 0 && ((v2 = this.valueForEntry((Map.Entry)v2)) == THashMap.this._values[n2] || v2 != null && THashMap.this.equalsNotNull(v2, THashMap.this._values[n2]))) {
                THashMap.this.removeAt(n2);
                return true;
            }
            return false;
        }

        @Override
        public boolean containsElement(Map.Entry<K, V> entry) {
            Object v2;
            Object v3 = THashMap.this.get(this.keyForEntry(entry));
            return (v2 = v2.getValue()) == v3 || v3 != null && THashMap.this.equalsNotNull(v3, v2);
        }

        protected V valueForEntry(Map.Entry<K, V> entry) {
            return entry.getValue();
        }

        protected K keyForEntry(Map.Entry<K, V> entry) {
            return entry.getKey();
        }

        private final class a
        extends TObjectHashIterator {
            private /* synthetic */ EntryView a;

            a(EntryView entryView, THashMap<K, V> tHashMap) {
                this.a = entryView;
                super(tHashMap);
            }

            @Override
            public final /* synthetic */ Object objectAtIndex(int n2) {
                int n3 = n2;
                a a2 = this;
                return new gnu.trove.map.hash.THashMap$a(a2.a.THashMap.this, a2.a.THashMap.this._set[n3], a2.a.THashMap.this._values[n3], n3);
            }
        }
    }

    final class a
    implements Map.Entry<K, V> {
        private K a;
        private V b;
        private final int c;
        private /* synthetic */ THashMap d;

        a(THashMap tHashMap, K k2, V v2, int n2) {
            this.d = tHashMap;
            this.a = k2;
            this.b = v2;
            this.c = n2;
        }

        @Override
        public final K getKey() {
            return this.a;
        }

        @Override
        public final V getValue() {
            return this.b;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final V setValue(V o2) {
            void var1_1;
            if (this.d._values[this.c] != this.b) {
                throw new ConcurrentModificationException();
            }
            Object v2 = this.b;
            this.d._values[this.c] = o2;
            this.b = var1_1;
            return v2;
        }

        @Override
        public final boolean equals(Object o2) {
            if (o2 instanceof Map.Entry) {
                Map.Entry entry;
                a a2 = this;
                entry = entry;
                return this.d.equalsNotNull(a2.getKey(), entry.getKey()) && this.d.equalsNotNull(a2.getValue(), a2.getValue());
            }
            return false;
        }

        @Override
        public final int hashCode() {
            return (this.getKey() == null ? 0 : this.getKey().hashCode()) ^ (this.getValue() == null ? 0 : this.getValue().hashCode());
        }

        public final String toString() {
            return String.valueOf(this.a) + "=" + String.valueOf(this.b);
        }
    }

    private abstract class c<E>
    extends AbstractSet<E>
    implements Iterable<E>,
    Set<E> {
        private /* synthetic */ THashMap a;

        private c(THashMap tHashMap) {
            this.a = tHashMap;
        }

        @Override
        public abstract Iterator<E> iterator();

        public abstract boolean removeElement(E var1);

        public abstract boolean containsElement(E var1);

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean contains(Object key) {
            void var1_1;
            return this.containsElement(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean remove(Object o2) {
            try {
                void var1_1;
                return this.removeElement(var1_1);
            }
            catch (ClassCastException classCastException) {
                return false;
            }
        }

        @Override
        public void clear() {
            ((THash)this.a).clear();
        }

        @Override
        public boolean add(E obj) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return this.a.size();
        }

        @Override
        public Object[] toArray() {
            Object[] objectArray = new Object[this.size()];
            Iterator<E> iterator = this.iterator();
            int n2 = 0;
            while (iterator.hasNext()) {
                objectArray[n2] = iterator.next();
                ++n2;
            }
            return objectArray;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public <T> T[] toArray(T[] a2) {
            void var1_1;
            int n2 = this.size();
            if (a2.length < n2) {
                throw new IllegalArgumentException();
            }
            Iterator<E> iterator = this.iterator();
            T[] TArray = a2;
            for (int i2 = 0; i2 < n2; ++i2) {
                TArray[i2] = iterator.next();
            }
            if (a2.length > n2) {
                a2[n2] = null;
            }
            return var1_1;
        }

        @Override
        public boolean isEmpty() {
            return this.a.isEmpty();
        }

        @Override
        public boolean addAll(Collection<? extends E> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            boolean bl = false;
            Iterator<E> iterator = this.iterator();
            while (iterator.hasNext()) {
                if (collection.contains(iterator.next())) continue;
                iterator.remove();
                bl = true;
            }
            return bl;
        }

        @Override
        public String toString() {
            Iterator<E> iterator = this.iterator();
            if (!iterator.hasNext()) {
                return "{}";
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append('{');
            while (true) {
                E e2;
                stringBuilder.append((Object)((e2 = iterator.next()) == this ? "(this Collection)" : e2));
                if (!iterator.hasNext()) {
                    return stringBuilder.append('}').toString();
                }
                stringBuilder.append(", ");
            }
        }
    }
}

