/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.expression;

import java.util.Comparator;
import prefuse.data.Schema;
import prefuse.data.Tuple;
import prefuse.data.expression.AbstractExpression;
import prefuse.data.expression.BinaryExpression;
import prefuse.data.expression.Expression;
import prefuse.data.expression.ExpressionVisitor;
import prefuse.data.expression.Predicate;
import prefuse.util.TypeLib;
import prefuse.util.collections.DefaultLiteralComparator;
import prefuse.util.collections.LiteralComparator;

public class RangePredicate
extends BinaryExpression
implements Predicate {
    public static final int IN_IN = 0;
    public static final int IN_EX = 1;
    public static final int EX_IN = 2;
    public static final int EX_EX = 3;
    private Expression a;
    private Comparator b;

    /*
     * WARNING - void declaration
     */
    public RangePredicate(Expression middle, Expression left, Expression right) {
        this(0, (Expression)var1_1, (Expression)var2_2, (Expression)var3_3, DefaultLiteralComparator.getInstance());
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public RangePredicate(Expression middle, Expression left, Expression right, Comparator cmp) {
        this(0, (Expression)var1_1, (Expression)var2_2, (Expression)var3_3, cmp);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public RangePredicate(int operation, Expression middle, Expression left, Expression right) {
        this((int)var1_1, (Expression)var2_2, (Expression)var3_3, right, DefaultLiteralComparator.getInstance());
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public RangePredicate(int operation, Expression middle, Expression left, Expression right, Comparator cmp) {
        super((int)var1_1, 0, 3, (Expression)var3_3, right);
        void var2_2;
        void var3_3;
        void var1_1;
        this.a = var2_2;
        this.b = cmp;
    }

    public Expression getMiddleExpression() {
        return this.a;
    }

    public Comparator getComparator() {
        return this.b;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean getBoolean(Tuple t2) {
        void var1_1;
        int n2;
        int n3;
        Object object = this.m_left.getType(t2.getSchema());
        Class clazz = this.m_right.getType(t2.getSchema());
        Class clazz2 = this.a.getType(t2.getSchema());
        Class clazz3 = null;
        if (((Class)object).isAssignableFrom(clazz)) {
            clazz3 = object;
        } else if (clazz.isAssignableFrom((Class<?>)object)) {
            clazz3 = clazz;
        }
        if (clazz3 != null && TypeLib.isNumericType(clazz3) && TypeLib.isNumericType(clazz2)) {
            object = TypeLib.getNumericType(clazz3, clazz2);
            if (object == Integer.TYPE) {
                int n4 = this.m_left.getInt(t2);
                int n5 = this.m_right.getInt(t2);
                int n6 = this.a.getInt(t2);
                n3 = ((LiteralComparator)this.b).compare(n6, n4);
                n2 = ((LiteralComparator)this.b).compare(n6, n5);
            } else if (object == Long.TYPE) {
                long l2 = this.m_left.getLong((Tuple)var1_1);
                long l3 = this.m_right.getLong((Tuple)var1_1);
                long l4 = this.a.getLong((Tuple)var1_1);
                n3 = ((LiteralComparator)this.b).compare(l4, l2);
                n2 = ((LiteralComparator)this.b).compare(l4, l3);
            } else if (object == Float.TYPE) {
                float f2 = this.m_left.getFloat((Tuple)var1_1);
                float f3 = this.m_right.getFloat((Tuple)var1_1);
                float f4 = this.a.getFloat((Tuple)var1_1);
                n3 = ((LiteralComparator)this.b).compare(f4, f2);
                n2 = ((LiteralComparator)this.b).compare(f4, f3);
            } else {
                if (object != Double.TYPE) throw new IllegalStateException();
                double d2 = this.m_left.getDouble((Tuple)var1_1);
                double d3 = this.m_right.getDouble((Tuple)var1_1);
                double d4 = this.a.getDouble((Tuple)var1_1);
                n3 = ((LiteralComparator)this.b).compare(d4, d2);
                n2 = ((LiteralComparator)this.b).compare(d4, d3);
            }
        } else {
            object = this.m_left.get((Tuple)var1_1);
            Object object2 = this.m_right.get((Tuple)var1_1);
            Object object3 = this.a.get((Tuple)var1_1);
            n3 = this.b.compare(object3, object);
            n2 = this.b.compare(object3, object2);
        }
        switch (this.m_op) {
            case 0: {
                return n3 >= 0 && n2 <= 0;
            }
            case 1: {
                return n3 >= 0 && n2 < 0;
            }
            case 2: {
                return n3 > 0 && n2 <= 0;
            }
            case 3: {
                return n3 > 0 && n2 < 0;
            }
        }
        throw new IllegalStateException("Unknown operation.");
    }

    @Override
    public Class getType(Schema s2) {
        return Boolean.TYPE;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object get(Tuple t2) {
        void var1_1;
        if (((AbstractExpression)this).getBoolean((Tuple)var1_1)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visit(ExpressionVisitor v2) {
        void var1_1;
        v2.visitExpression(this);
        v2.down();
        this.m_left.visit(v2);
        v2.up();
        v2.down();
        this.a.visit(v2);
        v2.up();
        v2.down();
        this.m_right.visit(v2);
        var1_1.up();
    }

    @Override
    protected void addChildListeners() {
        super.addChildListeners();
        this.a.addExpressionListener(this);
    }

    @Override
    protected void removeChildListeners() {
        super.removeChildListeners();
        this.a.removeExpressionListener(this);
    }

    public String toString() {
        String string = "?";
        String string2 = "?";
        switch (this.m_op) {
            case 0: {
                string2 = "<=";
                string = "<=";
                break;
            }
            case 1: {
                string = "<=";
                string2 = "<";
                break;
            }
            case 2: {
                string = "<";
                string2 = "<=";
                break;
            }
            case 3: {
                string2 = "<";
                string = "<";
            }
        }
        return "(" + this.m_left.toString() + " " + string + " " + this.a.toString() + " AND " + this.a.toString() + " " + string2 + " " + this.m_right.toString() + ")";
    }
}

