/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.slider.swing;

import com.macrofocus.helper.LookAndFeelHelper;
import com.macrofocus.slider.RangeSliderEvent;
import com.macrofocus.slider.RangeSliderListener;
import com.macrofocus.slider.RangeSliderModel;
import com.macrofocus.slider.SliderView;
import com.macrofocus.slider.plaf.RangeSliderUI;
import com.macrofocus.slider.plaf.aqua.AquaRangeSliderUI;
import com.macrofocus.slider.plaf.basic.BasicRangeSliderUI;
import com.macrofocus.slider.plaf.metal.MetalRangeSliderUI;
import com.macrofocus.slider.plaf.synth.SynthRangeSliderUI;
import com.macrofocus.slider.plaf.windows.WindowsRangeSliderUI;
import com.macrofocus.slider.swing.HistogramRangeSliderRenderer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JComponent;
import javax.swing.UIManager;

public class JRangeSlider
extends JComponent
implements SliderView {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    private boolean allowOutOfRange = false;
    public static final String uiClassID = "MRangeSliderUI";
    private final RangeSliderListener rangeSliderListener = new RangeSliderListener(){

        public void sliderChanged(RangeSliderEvent e) {
            JRangeSlider.this.updateRectangles();
            JRangeSlider.this.repaint();
        }

        public void sliderScaleChanged(RangeSliderEvent e) {
            JRangeSlider.this.updateRectangles();
            JRangeSlider.this.repaint();
        }
    };
    protected boolean leftToRight = true;
    protected Rectangle thumbBounds = new Rectangle();
    protected Rectangle trackBounds = new Rectangle();
    private int orientation;
    protected RangeSliderModel rangeSliderModel;
    protected Rectangle minRectangle = new Rectangle();
    protected Rectangle maxRectangle = new Rectangle();
    protected Rectangle rangeRectangle = new Rectangle();
    private HistogramRangeSliderRenderer histogramRenderer;

    public JRangeSlider(int orientation) {
        this.updateUI();
        this.orientation = orientation;
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                JRangeSlider.this.updateRectangles();
                JRangeSlider.this.repaint();
            }

            @Override
            public void componentResized(ComponentEvent e) {
                JRangeSlider.this.updateRectangles();
                JRangeSlider.this.repaint();
            }
        });
    }

    public JRangeSlider(RangeSliderModel rangeSliderModel, int orientation) {
        this(orientation);
        this.setModel(rangeSliderModel);
    }

    public void setModel(RangeSliderModel model) {
        this.rangeSliderModel = model;
        this.rangeSliderModel.addSliderListener(this.rangeSliderListener);
        this.updateRectangles();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.updateRectangles();
    }

    public void setUI(RangeSliderUI ui) {
        super.setUI(ui);
    }

    @Override
    public void updateUI() {
        if (UIManager.get(this.getUIClassID()) != null) {
            this.setUI((RangeSliderUI)UIManager.getUI(this));
        } else if (LookAndFeelHelper.isSynth()) {
            this.setUI(new SynthRangeSliderUI());
        } else if (LookAndFeelHelper.isMetal()) {
            this.setUI(new MetalRangeSliderUI());
        } else if (LookAndFeelHelper.isWindows()) {
            this.setUI(new WindowsRangeSliderUI());
        } else if (LookAndFeelHelper.isAqua()) {
            this.setUI(new AquaRangeSliderUI());
        } else {
            this.setUI(new BasicRangeSliderUI());
        }
    }

    @Override
    public RangeSliderUI getUI() {
        return (RangeSliderUI)this.ui;
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public Rectangle getTrackBounds() {
        return this.trackBounds;
    }

    public Rectangle getThumbBounds() {
        return this.thumbBounds;
    }

    public Rectangle getMinBounds() {
        return this.minRectangle;
    }

    public Rectangle getMaxBounds() {
        return this.maxRectangle;
    }

    public void setRangeSliderModel(RangeSliderModel rangeSliderModel) {
        if (this.rangeSliderModel != null) {
            this.rangeSliderModel.removeSliderListener(this.rangeSliderListener);
        }
        this.rangeSliderModel = rangeSliderModel;
        this.rangeSliderModel.addSliderListener(this.rangeSliderListener);
        this.updateRectangles();
    }

    public RangeSliderModel getRangeSliderModel() {
        return this.rangeSliderModel;
    }

    @Override
    public Dimension getMinimumSize() {
        if (UIManager.get("ScrollBar.width") != null) {
            int scrollBarWidth = (Integer)UIManager.get("ScrollBar.width");
            if (this.getOrientation() == 1) {
                return new Dimension(scrollBarWidth, scrollBarWidth * 3 + 10);
            }
            return new Dimension(scrollBarWidth * 3 + 10, scrollBarWidth);
        }
        return this.getOrientation() == 1 ? new Dimension(16, 48) : new Dimension(48, 16);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public void updateRectangles() {
        int screenHeight;
        int screenWidth;
        Dimension size;
        if (this.getOrientation() == 1) {
            int width;
            size = this.getSize();
            screenWidth = size.width;
            screenHeight = size.height;
            boolean x = false;
            int height = width = screenWidth - 0;
            int maxY = this.toScreen(this.getCurrentMaximum());
            int minY = this.rangeSliderModel.getMaximum() != this.rangeSliderModel.getMinimum() ? height + this.toScreen(this.getCurrentMinimum()) : height + this.getScreenRange();
            this.maxRectangle.setBounds(0, maxY, width, height);
            this.minRectangle.setBounds(0, minY, width, height);
        } else {
            int height;
            size = this.getSize();
            screenWidth = size.width;
            screenHeight = size.height;
            boolean y = false;
            int width = height = screenHeight - 0;
            int minX = this.toScreen(this.getCurrentMinimum());
            int maxX = this.rangeSliderModel.getMaximum() != this.rangeSliderModel.getMinimum() ? width + this.toScreen(this.getCurrentMaximum()) : width + this.getScreenRange();
            this.maxRectangle.setBounds(maxX, 0, width, height);
            this.minRectangle.setBounds(minX, 0, width, height);
        }
        if (this.getOrientation() == 1) {
            size = this.getSize();
            this.trackBounds.setBounds(0, this.minRectangle.height, size.width, size.height - this.minRectangle.height - this.maxRectangle.height);
            this.rangeRectangle.setBounds(0, this.maxRectangle.y + this.maxRectangle.height, size.width, this.minRectangle.y - this.maxRectangle.y - this.maxRectangle.height);
            int minY = Math.min(this.maxRectangle.y + this.maxRectangle.height, this.minRectangle.y);
            int maxY = Math.max(this.maxRectangle.y + this.maxRectangle.height, this.minRectangle.y);
            this.thumbBounds.setBounds(0, minY, size.width, maxY - minY);
        } else {
            size = this.getSize();
            this.trackBounds.setBounds(this.minRectangle.width, 0, size.width - this.minRectangle.width - this.maxRectangle.width, size.height);
            this.rangeRectangle.setBounds(this.minRectangle.x + this.minRectangle.width, 0, this.maxRectangle.x - this.minRectangle.x - this.minRectangle.width, size.height);
            int minX = Math.min(this.minRectangle.x + this.minRectangle.width, this.maxRectangle.x);
            int maxX = Math.max(this.minRectangle.x + this.minRectangle.width, this.maxRectangle.x);
            this.thumbBounds.setBounds(minX, 0, maxX - minX, size.height);
        }
    }

    private double getCurrentMaximum() {
        if (!this.allowOutOfRange && (!this.rangeSliderModel.isInvertedScale() && this.rangeSliderModel.getCurrentMaximum() > this.rangeSliderModel.getMaximum() || this.rangeSliderModel.isInvertedScale() && this.rangeSliderModel.getCurrentMaximum() < this.rangeSliderModel.getMaximum())) {
            return this.rangeSliderModel.getMaximum();
        }
        return this.rangeSliderModel.getCurrentMaximum();
    }

    private double getCurrentMinimum() {
        if (!this.allowOutOfRange && (!this.rangeSliderModel.isInvertedScale() && this.rangeSliderModel.getCurrentMinimum() < this.rangeSliderModel.getMinimum() || this.rangeSliderModel.isInvertedScale() && this.rangeSliderModel.getCurrentMinimum() > this.rangeSliderModel.getMinimum())) {
            return this.rangeSliderModel.getMinimum();
        }
        return this.rangeSliderModel.getCurrentMinimum();
    }

    public int toScreen(double value) {
        if (this.getOrientation() == 1) {
            double screenRange = this.getHeight() - 2 * this.getWidth();
            double worldRange = this.rangeSliderModel.getMaximum() - this.rangeSliderModel.getMinimum();
            return (int)Math.round(screenRange * (worldRange - (value - this.rangeSliderModel.getMinimum())) / worldRange);
        }
        double screenRange = this.getWidth() - 2 * this.getHeight();
        double worldRange = Math.abs(this.rangeSliderModel.getMaximum() - this.rangeSliderModel.getMinimum());
        return (int)Math.round(screenRange * (value - this.rangeSliderModel.getMinimum()) / worldRange);
    }

    public double toWorld(int value) {
        if (this.getOrientation() == 1) {
            Dimension size = this.getSize();
            int screenWidth = size.width;
            int screenHeight = size.height;
            double screenRange = screenHeight - 2 * screenWidth;
            double worldRange = this.rangeSliderModel.getMaximum() - this.rangeSliderModel.getMinimum();
            return worldRange * (screenRange - (double)value) / screenRange;
        }
        Dimension size = this.getSize();
        int screenWidth = size.width;
        int screenHeight = size.height;
        double screenRange = screenWidth - 2 * screenHeight;
        double worldRange = this.rangeSliderModel.getMaximum() - this.rangeSliderModel.getMinimum();
        return worldRange * (double)value / screenRange;
    }

    public int getScreenRange() {
        Dimension size = this.getSize();
        int screenWidth = size.width;
        int screenHeight = size.height;
        if (this.getOrientation() == 1) {
            return screenHeight - 2 * screenWidth;
        }
        return screenWidth - 2 * screenHeight;
    }

    public Component getComponent() {
        return this;
    }

    public Rectangle getMinRectangle() {
        return this.minRectangle;
    }

    public Rectangle getMaxRectangle() {
        return this.maxRectangle;
    }

    public Rectangle getRangeRectangle() {
        return this.rangeRectangle;
    }

    public HistogramRangeSliderRenderer getHistogramRenderer() {
        return this.histogramRenderer;
    }

    public void setHistogramRenderer(HistogramRangeSliderRenderer histogramRenderer) {
        this.histogramRenderer = histogramRenderer;
    }

    public boolean isPaintThumb() {
        return true;
    }

    public boolean isPaintTrack() {
        return true;
    }

    public boolean isPaintHandles() {
        return true;
    }
}

