/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.slider.swing;

import com.macrofocus.helper.ColorHelper;
import com.macrofocus.slider.RangeSliderEvent;
import com.macrofocus.slider.RangeSliderListener;
import com.macrofocus.slider.RangeSliderModel;
import com.macrofocus.slider.swing.JRangeSlider;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.JPanel;

public class TrapezoidRangeSlider
extends JPanel {
    private final JRangeSlider slider;

    public TrapezoidRangeSlider(JRangeSlider slider) {
        this.slider = slider;
        RangeSliderModel rangeSliderModel = slider.getRangeSliderModel();
        rangeSliderModel.addSliderListener(new RangeSliderListener(){

            public void sliderChanged(RangeSliderEvent e) {
                TrapezoidRangeSlider.this.repaint();
            }

            public void sliderScaleChanged(RangeSliderEvent e) {
                TrapezoidRangeSlider.this.repaint();
            }
        });
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (ColorHelper.lum((Color)this.getBackground()) > ColorHelper.lum((Color)Color.gray)) {
            this.setForeground(ColorHelper.darker((Color)this.getBackground(), (double)0.95));
        } else {
            this.setForeground(ColorHelper.brighter((Color)this.getBackground(), (double)0.6));
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        RangeSliderModel rangeSliderModel = this.slider.getRangeSliderModel();
        if (rangeSliderModel.getMaximum() != rangeSliderModel.getMinimum()) {
            Polygon poly = new Polygon();
            Rectangle thumbBounds = this.slider.getThumbBounds();
            if (this.slider.getOrientation() == 1) {
                poly.addPoint(0, 0);
                poly.addPoint(0, this.getSize().height);
                poly.addPoint(this.getWidth(), thumbBounds.y + thumbBounds.height);
                poly.addPoint(this.getWidth(), thumbBounds.y);
            } else {
                poly.addPoint(thumbBounds.x, 0);
                poly.addPoint(thumbBounds.x + thumbBounds.width, 0);
                poly.addPoint(this.getSize().width, this.getHeight());
                poly.addPoint(0, this.getHeight());
            }
            Graphics2D g2 = (Graphics2D)g;
            Object oldRenderingHint = g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.fillPolygon(poly);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldRenderingHint);
        }
    }
}

