/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.molap.swing;

import com.macrofocus.common.selection.MutableSingleSelection;
import com.macrofocus.common.selection.SingleSelectionEvent;
import com.macrofocus.common.selection.SingleSelectionListener;
import com.macrofocus.hierarchy.Condition;
import com.macrofocus.molap.dataframe.DataFrame;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultComboBoxModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class ColumnSelectionComboBoxModel<Column>
extends DefaultComboBoxModel {
    private final Map<Column, String> rename;
    private final Map<String, Column> renameReverse;
    private final Condition<Column> condition;

    public ColumnSelectionComboBoxModel(MutableSingleSelection<Column> selection, DataFrame<?, Column, ?> dataFrame, boolean onlyNumerical, boolean includeNull, Condition<Column> condition) {
        this(selection, dataFrame, onlyNumerical, includeNull, null, null, condition);
    }

    public ColumnSelectionComboBoxModel(MutableSingleSelection<Column> selection, DataFrame<?, Column, ?> dataFrame, boolean onlyNumerical, boolean includeNull, Set<Column> exclude, Map<Column, String> rename, Condition<Column> condition) {
        this.rename = rename;
        this.condition = condition;
        if (rename != null) {
            this.renameReverse = new HashMap<String, Column>();
            for (Map.Entry<Object, String> entry : rename.entrySet()) {
                this.renameReverse.put(entry.getValue(), entry.getKey());
            }
        } else {
            this.renameReverse = null;
        }
        if (includeNull) {
            this.addElement(null);
        }
        for (Map.Entry<Object, String> entry : dataFrame.columns()) {
            if (!condition.accept(entry) || exclude != null && exclude.contains(entry)) continue;
            if (rename != null && rename.containsKey(entry)) {
                this.addElement(rename.get(entry));
                continue;
            }
            this.addElement(entry);
        }
        this.init(selection);
    }

    private void init(final MutableSingleSelection<Column> selection) {
        selection.addSingleSelectionListener(new SingleSelectionListener<Column>(){

            public void selectionChanged(SingleSelectionEvent<Column> event) {
                if (ColumnSelectionComboBoxModel.this.rename == null || !ColumnSelectionComboBoxModel.this.rename.containsKey(event.getCurrentSelection())) {
                    ColumnSelectionComboBoxModel.this.setSelectedItem(event.getCurrentSelection());
                } else {
                    ColumnSelectionComboBoxModel.this.setSelectedItem(ColumnSelectionComboBoxModel.this.rename.get(event.getCurrentSelection()));
                }
            }
        });
        if (this.rename == null || !this.rename.containsKey(selection.getSelected())) {
            this.setSelectedItem(selection.getSelected());
        } else {
            this.setSelectedItem(this.rename.get(selection.getSelected()));
        }
        this.addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                if (ColumnSelectionComboBoxModel.this.renameReverse == null || !ColumnSelectionComboBoxModel.this.renameReverse.containsKey(ColumnSelectionComboBoxModel.this.getSelectedItem())) {
                    selection.setSelected(ColumnSelectionComboBoxModel.this.getSelectedItem());
                } else {
                    selection.setSelected(ColumnSelectionComboBoxModel.this.renameReverse.get(ColumnSelectionComboBoxModel.this.getSelectedItem()));
                }
            }
        });
    }
}

