
package elemental.css;
import elemental.dom.*;
import elemental.html.*;

/**
  * $CLASS_JAVADOC
  */
@Deprecated
public interface CSSStyleDeclaration {


  /**
    *  Textual representation of the declaration block. Setting this attribute changes the style.
    */
  String getCssText();

  void setCssText(String arg);


  /**
    *  The number of properties. See the <strong>item</strong> method below.
    */
  int getLength();


  /**
    *  The containing <code><a href="https://developer.mozilla.org/en/DOM/cssRule" rel="internal" title="en/DOM/cssRule">cssRule</a>.</code>
    */
  CSSRule getParentRule();


  /**
    * <span>Only supported via getComputedStyle.<br> </span>Returns a <a class="external" title="http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSValue" rel="external" href="http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-CSSValue" target="_blank">CSSValue</a>, or <code>null</code> for <a title="en/Guide to Shorthand CSS" rel="internal" href="https://developer.mozilla.org/en/Guide_to_Shorthand_CSS">Shorthand properties</a>.<br> Example: <em>cssString</em>= window.getComputedStyle(<em>elem</em>, <code>null</code>).getPropertyCSSValue('color').cssText;<br> Note: Gecko 1.9 returns null unless using <a title="en/DOM/window.getComputedStyle" rel="internal" href="https://developer.mozilla.org/en/DOM/window.getComputedStyle">getComputedStyle()</a>.<br> Note: this method may be <a class="external" title="http://lists.w3.org/Archives/Public/www-style/2003Oct/0347.html" rel="external" href="http://lists.w3.org/Archives/Public/www-style/2003Oct/0347.html" target="_blank">deprecated by the W3C</a>.
    */
  CSSValue getPropertyCSSValue(String propertyName);


  /**
    *  Returns the optional priority, "important".<br> Example: <em>priString</em>= <em>styleObj</em>.getPropertyPriority('color')
    */
  String getPropertyPriority(String propertyName);

  String getPropertyShorthand(String propertyName);


  /**
    *  Returns the property value.<br> Example: <em>valString</em>= <em>styleObj</em>.getPropertyValue('color')
    */
  String getPropertyValue(String propertyName);

  boolean isPropertyImplicit(String propertyName);


  /**
    *  Returns a property name.<br> Example: <em>nameString</em>= <em>styleObj</em>.item(0)<br> Alternative: <em>nameString</em>= <em>styleObj</em>[0]
    */
  String item(int index);


  /**
    *  Returns the value deleted.<br> Example: <em>valString</em>= <em>styleObj</em>.removeProperty('color')
    */
  String removeProperty(String propertyName);


  /**
    *  No return.<br> Example: <em>styleObj</em>.setProperty('color', 'red', 'important')
    */
  void setProperty(String propertyName, String value);


  /**
    *  No return.<br> Example: <em>styleObj</em>.setProperty('color', 'red', 'important')
    */
  void setProperty(String propertyName, String value, String priority);

public interface Unit {
  public static final String PX = "px";
  public static final String PCT = "%";
  public static final String EM = "em";
  public static final String EX = "ex";
  public static final String PT = "pt";
  public static final String PC = "pc";
  public static final String IN = "in";
  public static final String CM = "cm";
  public static final String MM = "mm";
}

String getBackgroundColor();
void setBackgroundColor(String value);
void clearBackgroundColor();
String getBackgroundImage();
void setBackgroundImage(String value);
void clearBackgroundImage();
String getBorderColor();
void setBorderColor(String value);
void clearBorderColor();

@Deprecated
public interface BorderStyle {
  public static final String NONE = "none";
  public static final String HIDDEN = "hidden";
  public static final String DOTTED = "dotted";
  public static final String DASHED = "dashed";
  public static final String SOLID = "solid";
}

String getBorderStyle();
void setBorderStyle(String value);
void clearBorderStyle();
String getBorderWidth();
void setBorderWidth(String value);
void clearBorderWidth();
void setBorderWidth(double value, String unit);
String getBottom();
void setBottom(String value);
void clearBottom();
void setBottom(double value, String unit);
String getColor();
void setColor(String value);
void clearColor();

@Deprecated
public interface Cursor {
  public static final String DEFAULT = "default";
  public static final String AUTO = "auto";
  public static final String CROSSHAIR = "crosshair";
  public static final String POINTER = "pointer";
  public static final String MOVE = "move";
  public static final String E_RESIZE = "e-resize";
  public static final String NE_RESIZE = "ne-resize";
  public static final String NW_RESIZE = "nw-resize";
  public static final String N_RESIZE = "n-resize";
  public static final String SE_RESIZE = "se-resize";
  public static final String SW_RESIZE = "sw-resize";
  public static final String S_RESIZE = "s-resize";
  public static final String W_RESIZE = "w-resize";
  public static final String TEXT = "text";
  public static final String WAIT = "wait";
  public static final String HELP = "help";
  public static final String COL_RESIZE = "col-resize";
  public static final String ROW_RESIZE = "row-resize";
}

String getCursor();
void setCursor(String value);
void clearCursor();

@Deprecated
public interface Display {
  public static final String NONE = "none";
  public static final String BLOCK = "block";
  public static final String INLINE = "inline";
  public static final String INLINE_BLOCK = "inline-block";
}

String getDisplay();
void setDisplay(String value);
void clearDisplay();
String getFontSize();
void setFontSize(String value);
void clearFontSize();
void setFontSize(double value, String unit);

@Deprecated
public interface FontStyle {
  public static final String NORMAL = "normal";
  public static final String ITALIC = "italic";
  public static final String OBLIQUE = "oblique";
}

String getFontStyle();
void setFontStyle(String value);
void clearFontStyle();

@Deprecated
public interface FontWeight {
  public static final String NORMAL = "normal";
  public static final String BOLD = "bold";
  public static final String BOLDER = "bolder";
  public static final String LIGHTER = "lighter";
}

String getFontWeight();
void setFontWeight(String value);
void clearFontWeight();
String getHeight();
void setHeight(String value);
void clearHeight();
void setHeight(double value, String unit);
String getLeft();
void setLeft(String value);
void clearLeft();
void setLeft(double value, String unit);

@Deprecated
public interface ListStyleType {
  public static final String NONE = "none";
  public static final String DISC = "disc";
  public static final String CIRCLE = "circle";
  public static final String SQUARE = "square";
  public static final String DECIMAL = "decimal";
  public static final String LOWER_ALPHA = "lower-alpha";
  public static final String UPPER_ALPHA = "upper-alpha";
  public static final String LOWER_ROMAN = "lower-roman";
  public static final String UPPER_ROMAN = "upper-roman";
}

String getListStyleType();
void setListStyleType(String value);
void clearListStyleType();
String getMargin();
void setMargin(String value);
void clearMargin();
void setMargin(double value, String unit);
String getMarginBottom();
void setMarginBottom(String value);
void clearMarginBottom();
void setMarginBottom(double value, String unit);
String getMarginLeft();
void setMarginLeft(String value);
void clearMarginLeft();
void setMarginLeft(double value, String unit);
String getMarginRight();
void setMarginRight(String value);
void clearMarginRight();
void setMarginRight(double value, String unit);
String getMarginTop();
void setMarginTop(String value);
void clearMarginTop();
void setMarginTop(double value, String unit);
double getOpacity();
void setOpacity(double value);
void clearOpacity();

@Deprecated
public interface Overflow {
  public static final String VISIBLE = "visible";
  public static final String HIDDEN = "hidden";
  public static final String SCROLL = "scroll";
  public static final String AUTO = "auto";
}

String getOverflow();
void setOverflow(String value);
void clearOverflow();

@Deprecated
public interface OverflowX {
  public static final String VISIBLE = "visible";
  public static final String HIDDEN = "hidden";
  public static final String SCROLL = "scroll";
  public static final String AUTO = "auto";
}

String getOverflowX();
void setOverflowX(String value);
void clearOverflowX();

@Deprecated
public interface OverflowY {
  public static final String VISIBLE = "visible";
  public static final String HIDDEN = "hidden";
  public static final String SCROLL = "scroll";
  public static final String AUTO = "auto";
}

String getOverflowY();
void setOverflowY(String value);
void clearOverflowY();
String getPadding();
void setPadding(String value);
void clearPadding();
void setPadding(double value, String unit);
String getPaddingBottom();
void setPaddingBottom(String value);
void clearPaddingBottom();
void setPaddingBottom(double value, String unit);
String getPaddingLeft();
void setPaddingLeft(String value);
void clearPaddingLeft();
void setPaddingLeft(double value, String unit);
String getPaddingRight();
void setPaddingRight(String value);
void clearPaddingRight();
void setPaddingRight(double value, String unit);
String getPaddingTop();
void setPaddingTop(String value);
void clearPaddingTop();
void setPaddingTop(double value, String unit);

@Deprecated
public interface Position {
  public static final String STATIC = "static";
  public static final String RELATIVE = "relative";
  public static final String ABSOLUTE = "absolute";
  public static final String FIXED = "fixed";
}

String getPosition();
void setPosition(String value);
void clearPosition();
String getRight();
void setRight(String value);
void clearRight();
void setRight(double value, String unit);

@Deprecated
public interface TextDecoration {
  public static final String NONE = "none";
  public static final String UNDERLINE = "underline";
  public static final String OVERLINE = "overline";
  public static final String LINE_THROUGH = "line-through";
}

String getTextDecoration();
void setTextDecoration(String value);
void clearTextDecoration();
String getTop();
void setTop(String value);
void clearTop();
void setTop(double value, String unit);

@Deprecated
public interface Visibility {
  public static final String VISIBLE = "visible";
  public static final String HIDDEN = "hidden";
}

String getVisibility();
void setVisibility(String value);
void clearVisibility();

@Deprecated
public interface WhiteSpace {
  public static final String PRE = "pre";
  public static final String NOWRAP = "nowrap";
  public static final String PRE_WRAP = "pre-wrap";
  public static final String PRE_LINE = "pre-line";
}

String getWhiteSpace();
void setWhiteSpace(String value);
void clearWhiteSpace();
String getWidth();
void setWidth(String value);
void clearWidth();
void setWidth(double value, String unit);
int getZIndex();
void setZIndex(int value);
void clearZIndex();
}