import {useEffect, useState} from 'react';
import './Demo.css';
import * as treemap from './macrofocus-treemap.mjs';

function Demo() {
    const [model, setModel] = useState<treemap.DefaultTreeMapModel<number, string>>()

    useEffect(() => {
        const response = fetch('https://public.treemap.com/rest/json/Forbes%20Global%202000%20-%202021.mtm');
        const json = response.then(response => response.text()).then(json => {
                var dataFrame = treemap.JsonDataFrame.fromString(json)
                let treeMapModel = new treemap.DefaultTreeMapModel<number, string>(dataFrame);

                let settings = treeMapModel.settings

                // General
                // settings.rendering = treemap.com.treemap.RenderingFactory.prototype.Companion.FLAT
                settings.rendering = new treemap.FlatRendering()

                // Group by
                settings.groupByColumns = new treemap.JsArrayList(["Sector", "Industry"])

                // Size
                settings.sizeColumn = "Market Value"

                // Color
                settings.colorColumn = "Profits"
                var profitsSettings = settings.getColumnSettings("Profits")
                var negpos = new treemap.PaletteFactory().getPalette("negpos")
                var colorMap = treeMapModel.getColorMap("Profits")
                colorMap.palette = negpos
                colorMap.interval.setValue(-63.93, 127.86)

                // Label
                var companySettings = settings.getColumnSettings("Company")
                // companySettings.setLabelingFont(CPFont("Helvetica", 9.0)) // 9 points is the minimum size that will be displayed
                companySettings.setLabelingMinimumCharactersToDisplay(5)
                companySettings.setLabelingResizeTextToFitShape(true)
                // companySettings.setLabelingVerticalAlignment(treemap.org.mkui.labeling.EnhancedLabel.CENTER)
                // companySettings.setLabelingHorizontalAlignment(treemap.org.mkui.labeling.EnhancedLabel.CENTER)

                setModel(treeMapModel)
            }
        )
    }, [])

    const TreeMap = treemap.getTreeMapComponent();

    return (
        <div className="Demo">
            <TreeMap model={model}/>
        </div>
    );
}

export default Demo;
