type Nullable<T> = T | null | undefined
declare function KtSingleton<T>(): T & (abstract new() => any);
export declare interface KtList<E> /* extends Collection<E> */ {
    asJsReadonlyArrayView(): ReadonlyArray<E>;
    readonly __doNotUseOrImplementIt: {
        readonly "kotlin.collections.KtList": unique symbol;
    };
}
export declare namespace KtList {
    function fromJsArray<E>(array: ReadonlyArray<E>): KtList<E>;
}
export declare interface KtSet<E> /* extends Collection<E> */ {
    asJsReadonlySetView(): ReadonlySet<E>;
    readonly __doNotUseOrImplementIt: {
        readonly "kotlin.collections.KtSet": unique symbol;
    };
}
export declare namespace KtSet {
    function fromJsSet<E>(set: ReadonlySet<E>): KtSet<E>;
}
export declare class Pair<A, B> /* implements Serializable */ {
    constructor(first: A, second: B);
    get first(): A;
    get second(): B;
    toString(): string;
    copy(first?: A, second?: B): Pair<A, B>;
    hashCode(): number;
    equals(other: Nullable<any>): boolean;
}
export declare namespace Pair {
    /** @deprecated $metadata$ is used for internal purposes, please don't use it in your code, because it can be removed at any moment */
    namespace $metadata$ {
        const constructor: abstract new <A, B>() => Pair<A, B>;
    }
}
export declare interface BigDecimal /* extends Comparable<BigDecimal> */ {
    readonly absoluteValue: BigDecimal;
    readonly signum: number;
    readonly scale: number;
    readonly precision: number;
    readonly unscaledValue: BigInteger;
    plus(augend: Nullable<BigDecimal>): BigDecimal;
    plusWithContext(augend: Nullable<BigDecimal>, mc: MathContext): BigDecimal;
    minus(subtrahend: BigDecimal): BigDecimal;
    minusWithContext(subtrahend: BigDecimal, mc: MathContext): BigDecimal;
    times(multiplicand: Nullable<BigDecimal>): BigDecimal;
    timesWithContext(multiplicand: BigDecimal, mc: MathContext): BigDecimal;
    div(divisor: BigDecimal): BigDecimal;
    divWithContext(divisor: BigDecimal, mc: MathContext): Nullable<BigDecimal>;
    divideToIntegralValue(divisor: BigDecimal): BigDecimal;
    divideToIntegralValueWithContext(divisor: BigDecimal, mc: MathContext): BigDecimal;
    rem(divisor: BigDecimal): BigDecimal;
    remWithContext(divisor: BigDecimal, mc: MathContext): BigDecimal;
    divideAndRemainder(divisor: BigDecimal): Pair<BigDecimal, BigDecimal>;
    divideAndRemainderWithContext(divisor: BigDecimal, mc: MathContext): Pair<BigDecimal, BigDecimal>;
    sqrt(mc?: MathContext): BigDecimal;
    pow(n: number): BigDecimal;
    powWithContext(n: number, mc: MathContext): Nullable<BigDecimal>;
    absoluteValueWithContext(mc: MathContext): Nullable<BigDecimal>;
    unaryMinus(): BigDecimal;
    unaryMinusWithContext(mc: MathContext): Nullable<BigDecimal>;
    unaryPlus(): BigDecimal;
    unaryPlusWithContext(mc: MathContext): Nullable<BigDecimal>;
    round(mc: MathContext): Nullable<BigDecimal>;
    setScaleRounding(newScale: number, roundingMode: RoundingMode): BigDecimal;
    /** @deprecated The method {@link #setScale(int, RoundingMode)} should be used in preference to this legacy method. */
    setScaleInt(newScale: number, roundingMode: number): BigDecimal;
    setScale(newScale: number): BigDecimal;
    movePointLeft(n: number): BigDecimal;
    movePointRight(n: number): BigDecimal;
    scaleByPowerOfTen(n: number): BigDecimal;
    stripTrailingZeros(): BigDecimal;
    min(val: BigDecimal): BigDecimal;
    max(val: BigDecimal): BigDecimal;
    toEngineeringString(): string;
    toPlainString(): string;
    toBigInteger(): BigInteger;
    toBigIntegerExact(): BigInteger;
    toLong(): bigint;
    toLongExact(): bigint;
    toInt(): number;
    toByte(): number;
    toChar(): any/* Char */;
    toShort(): number;
    toIntExact(): number;
    toShortExact(): number;
    toByteExact(): number;
    toFloat(): number;
    toDouble(): number;
    ulp(): BigDecimal;
    readonly __doNotUseOrImplementIt: {
        readonly "com.macrofocus.common.math.big.BigDecimal": unique symbol;
    };
}
export declare namespace BigDecimal {
    abstract class Companion extends KtSingleton<Companion.$metadata$.constructor>() {
        private constructor();
    }
    namespace Companion {
        /** @deprecated $metadata$ is used for internal purposes, please don't use it in your code, because it can be removed at any moment */
        namespace $metadata$ {
            abstract class constructor {
                get ZERO(): BigDecimal;
                get ONE(): BigDecimal;
                get TWO(): BigDecimal;
                get TEN(): BigDecimal;
                get ONE_TENTH(): BigDecimal;
                get ONE_HALF(): BigDecimal;
                get PI(): BigDecimal;
                get E(): BigDecimal;
                ofScaledLong(unscaledVal: bigint, scale: number): BigDecimal;
                ofScaledLongWithPrecision(unscaledVal: bigint, scale: number, prec: number): BigDecimal;
                ofInt(val: number): BigDecimal;
                of(val: bigint): BigDecimal;
                ofScaledBigIntegerWithPrecision(intVal: BigInteger, scale: number, prec: number): BigDecimal;
                ofDouble(val: number, ctx?: Nullable<MathContext>): BigDecimal;
                ofFloat(val: number, ctx?: Nullable<MathContext>): BigDecimal;
                parse(val: string, ctx?: Nullable<MathContext>): BigDecimal;
                ofBigInteger(val: BigInteger, ctx?: Nullable<MathContext>): BigDecimal;
                ofIntWithContext(val: number, ctx: MathContext): BigDecimal;
                ofWithContext(val: bigint, ctx: MathContext): BigDecimal;
                private constructor();
            }
        }
    }
}
export declare interface BigInteger /* extends Comparable<BigInteger> */ {
    readonly absoluteValue: BigInteger;
    readonly signum: number;
    readonly bitLength: number;
    readonly bitCount: number;
    rangeTo(endInclusive: BigInteger): BigIntegerRange;
    rangeToInt(endInclusive: number): BigIntegerRange;
    rangeToLong(endInclusive: bigint): BigIntegerRange;
    nextProbablePrime(): BigInteger;
    plus(other: BigInteger): BigInteger;
    plusInt(other: number): BigInteger;
    plusLong(other: bigint): BigInteger;
    minus(other: BigInteger): BigInteger;
    minusInt(other: number): BigInteger;
    minusLong(other: bigint): BigInteger;
    times(other: BigInteger): BigInteger;
    timesInt(other: number): BigInteger;
    timesLong(other: bigint): BigInteger;
    div(other: BigInteger): BigInteger;
    divInt(other: number): BigInteger;
    divLong(other: bigint): BigInteger;
    divideAndRemainder(other: BigInteger): Array<BigInteger>;
    divideAndRemainderInt(other: number): Array<BigInteger>;
    divideAndRemainderLong(other: bigint): Array<BigInteger>;
    reminder(other: BigInteger): BigInteger;
    reminderInt(other: number): BigInteger;
    reminderLong(other: bigint): BigInteger;
    pow(exponent: number): BigInteger;
    sqrt(): BigInteger;
    sqrtAndRemainder(): Array<BigInteger>;
    gcd(other: BigInteger): BigInteger;
    gcdInt(other: number): BigInteger;
    gcdLong(other: bigint): BigInteger;
    unaryMinus(): BigInteger;
    unaryPlus(): BigInteger;
    rem(modulus: BigInteger): BigInteger;
    remInt(modulus: number): BigInteger;
    remLong(modulus: bigint): BigInteger;
    modPow(exponent: BigInteger, modulus: BigInteger): BigInteger;
    modInverse(modulus: BigInteger): BigInteger;
    modInverseInt(modulus: number): BigInteger;
    modInverseLong(modulus: bigint): BigInteger;
    shl(n: number): BigInteger;
    shr(n: number): BigInteger;
    and(other: BigInteger): BigInteger;
    andInt(other: number): BigInteger;
    andLong(other: bigint): BigInteger;
    or(other: BigInteger): BigInteger;
    orInt(other: number): BigInteger;
    orLong(other: bigint): BigInteger;
    xor(other: BigInteger): BigInteger;
    xorInt(other: number): BigInteger;
    xorLong(other: bigint): BigInteger;
    not(): BigInteger;
    andNot(other: BigInteger): BigInteger;
    andNotInt(other: number): BigInteger;
    andNotLong(other: bigint): BigInteger;
    testBit(n: number): boolean;
    get(n: number): boolean;
    set(n: number, b: boolean): BigInteger;
    setBit(n: number): BigInteger;
    clearBit(n: number): BigInteger;
    flipBit(n: number): BigInteger;
    isProbablePrime(certainty: number): boolean;
    equals(other: Nullable<any>): boolean;
    min(other: BigInteger): BigInteger;
    max(other: BigInteger): BigInteger;
    hashCode(): number;
    toStringWithRadix(radix: number): string;
    toString(): string;
    toByteArray(): Int8Array;
    toInt(): number;
    toLong(): bigint;
    toByte(): number;
    toChar(): any/* Char */;
    toShort(): number;
    toFloat(): number;
    toDouble(): number;
    toLongExact(): bigint;
    toIntExact(): number;
    toShortExact(): number;
    toByteExact(): number;
    readonly __doNotUseOrImplementIt: {
        readonly "com.macrofocus.common.math.big.BigInteger": unique symbol;
    };
}
export declare namespace BigInteger {
    abstract class Companion extends KtSingleton<Companion.$metadata$.constructor>() {
        private constructor();
    }
    namespace Companion {
        /** @deprecated $metadata$ is used for internal purposes, please don't use it in your code, because it can be removed at any moment */
        namespace $metadata$ {
            abstract class constructor {
                get ZERO(): BigInteger;
                get ONE(): BigInteger;
                get TWO(): BigInteger;
                get NEGATIVE_ONE(): BigInteger;
                get TEN(): BigInteger;
                probablePrime(bitLength: number, rnd: any/* Random */): BigInteger;
                ofLong(value: bigint): BigInteger;
                of(value: number): BigInteger;
                parse(value: string): BigInteger;
                parseWithRadix(value: string, radix: number): BigInteger;
                ofIntArray(value: Int32Array): BigInteger;
                ofSlideIntArray(signum: number, magnitude: Int8Array, off: number, len: number): BigInteger;
                private constructor();
            }
        }
    }
}
export declare class BigIntegerRange /* implements ClosedRange<BigInteger>, Iterable<BigInteger> */ {
    constructor(start: BigInteger, endInclusive: BigInteger);
    copy(start?: BigInteger, endInclusive?: BigInteger): BigIntegerRange;
    toString(): string;
    hashCode(): number;
    equals(other: Nullable<any>): boolean;
}
export declare namespace BigIntegerRange {
    /** @deprecated $metadata$ is used for internal purposes, please don't use it in your code, because it can be removed at any moment */
    namespace $metadata$ {
        const constructor: abstract new () => BigIntegerRange;
    }
}
export declare class MathContext {
    constructor(precision?: number, roundingMode?: RoundingMode);
    get precision(): number;
    get roundingMode(): RoundingMode;
    copy(precision?: number, roundingMode?: RoundingMode): MathContext;
    toString(): string;
    hashCode(): number;
    equals(other: Nullable<any>): boolean;
}
export declare namespace MathContext {
    /** @deprecated $metadata$ is used for internal purposes, please don't use it in your code, because it can be removed at any moment */
    namespace $metadata$ {
        const constructor: abstract new () => MathContext;
    }
    abstract class Companion extends KtSingleton<Companion.$metadata$.constructor>() {
        private constructor();
    }
    namespace Companion {
        /** @deprecated $metadata$ is used for internal purposes, please don't use it in your code, because it can be removed at any moment */
        namespace $metadata$ {
            abstract class constructor {
                get UNLIMITED(): MathContext;
                get DECIMAL32(): MathContext;
                get DECIMAL64(): MathContext;
                get DECIMAL128(): MathContext;
                private constructor();
            }
        }
    }
}
export declare abstract class RoundingMode {
    private constructor();
    static get UP(): RoundingMode & {
        get name(): "UP";
        get ordinal(): 0;
    };
    static get DOWN(): RoundingMode & {
        get name(): "DOWN";
        get ordinal(): 1;
    };
    static get CEILING(): RoundingMode & {
        get name(): "CEILING";
        get ordinal(): 2;
    };
    static get FLOOR(): RoundingMode & {
        get name(): "FLOOR";
        get ordinal(): 3;
    };
    static get HALF_UP(): RoundingMode & {
        get name(): "HALF_UP";
        get ordinal(): 4;
    };
    static get HALF_DOWN(): RoundingMode & {
        get name(): "HALF_DOWN";
        get ordinal(): 5;
    };
    static get HALF_EVEN(): RoundingMode & {
        get name(): "HALF_EVEN";
        get ordinal(): 6;
    };
    static get UNNECESSARY(): RoundingMode & {
        get name(): "UNNECESSARY";
        get ordinal(): 7;
    };
    get name(): "UP" | "DOWN" | "CEILING" | "FLOOR" | "HALF_UP" | "HALF_DOWN" | "HALF_EVEN" | "UNNECESSARY";
    get ordinal(): 0 | 1 | 2 | 3 | 4 | 5 | 6 | 7;
    get value(): number;
    static values(): Array<RoundingMode>;
    static valueOf(value: string): RoundingMode;
}
export declare namespace RoundingMode {
    /** @deprecated $metadata$ is used for internal purposes, please don't use it in your code, because it can be removed at any moment */
    namespace $metadata$ {
        const constructor: abstract new () => RoundingMode;
    }
    abstract class Companion extends KtSingleton<Companion.$metadata$.constructor>() {
        private constructor();
    }
    namespace Companion {
        /** @deprecated $metadata$ is used for internal purposes, please don't use it in your code, because it can be removed at any moment */
        namespace $metadata$ {
            abstract class constructor {
                valueOfInt(rm: number): RoundingMode;
                private constructor();
            }
        }
    }
}
export declare class PropertyEvent<T> {
    constructor(oldValue: T, newValue: T);
    get oldValue(): T;
    get newValue(): T;
    toString(): string;
    copy(oldValue?: T, newValue?: T): PropertyEvent<T>;
    hashCode(): number;
    equals(other: Nullable<any>): boolean;
}
export declare namespace PropertyEvent {
    /** @deprecated $metadata$ is used for internal purposes, please don't use it in your code, because it can be removed at any moment */
    namespace $metadata$ {
        const constructor: abstract new <T>() => PropertyEvent<T>;
    }
}
export declare class SimpleProperty<T> /* extends AbstractMutableProperty<T> */ /* implements MutableProperty<T> */ {
    constructor(value: T);
    toString(): string;
}
export declare namespace SimpleProperty {
    /** @deprecated $metadata$ is used for internal purposes, please don't use it in your code, because it can be removed at any moment */
    namespace $metadata$ {
        const constructor: abstract new <T>() => SimpleProperty<T>;
    }
    abstract class Companion extends KtSingleton<Companion.$metadata$.constructor>() {
        private constructor();
    }
    namespace Companion {
        /** @deprecated $metadata$ is used for internal purposes, please don't use it in your code, because it can be removed at any moment */
        namespace $metadata$ {
            abstract class constructor {
                newInstance<T>(value: T): SimpleProperty<T>;
                private constructor();
            }
        }
    }
}
export declare class JsArrayList<E> /* extends ArrayList<E> */ implements KtList<E> {
    constructor(elements: Array<E>);
    get size(): number;
    asJsReadonlyArrayView(): ReadonlyArray<E>;
    readonly __doNotUseOrImplementIt: KtList<E>["__doNotUseOrImplementIt"];
}
export declare namespace JsArrayList {
    /** @deprecated $metadata$ is used for internal purposes, please don't use it in your code, because it can be removed at any moment */
    namespace $metadata$ {
        const constructor: abstract new <E>() => JsArrayList<E>;
    }
}
export declare function bigInteger(x: any): BigInteger;
export declare function bigDecimal(x: any): BigDecimal;
export declare class EnhancedLabel {
    constructor();
    get isOpaque(): boolean;
    set isOpaque(value: boolean);
    get properties(): any/* MutableProperties<Nullable<string>> */;
    set properties(value: any/* MutableProperties<Nullable<string>> */);
    static fromString(text: Nullable<string>): EnhancedLabel;
    setName(name: Nullable<string>): void;
    getName(): Nullable<string>;
    getText(): Nullable<string>;
    setText(text: Nullable<string>): void;
    get isHTML(): boolean;
    set isHTML(value: boolean);
    getFont(): Nullable<any>/* Nullable<CPFont> */;
    setFont(font: any/* CPFont */): void;
    getVerticalAlignment(): number;
    setVerticalAlignment(verticalAlignment: number): void;
    getHorizontalAlignment(): number;
    setHorizontalAlignment(horizontalAlignment: number): void;
    getHeight(): Nullable<number>;
    getWidth(): Nullable<number>;
    getBackground(): Nullable<any>/* Nullable<CPColor> */;
    setBackground(background: Nullable<any>/* Nullable<CPColor> */): void;
    getForeground(): Nullable<any>/* Nullable<CPColor> */;
    setForeground(foreground: any/* CPColor */): void;
    isEnabled(): boolean;
    getInsetTop(): number;
    getInsetLeft(): number;
    getInsetBottom(): number;
    getInsetRight(): number;
    setInsetTop(value: number): void;
    setInsetLeft(value: number): void;
    setInsetBottom(value: number): void;
    setInsetRight(value: number): void;
    setInsets(top: number, left: number, bottom: number, right: number): void;
    getEffect(): EnhancedLabel.Effect;
    setEffect(effect: EnhancedLabel.Effect): void;
    getEffectOpacity(): number;
    setEffectOpacity(effectOpacity: number): void;
    getRendering(): EnhancedLabel.Rendering;
    setRendering(rendering: EnhancedLabel.Rendering): void;
    getMinimumCharactersToDisplay(): Nullable<number>;
    setMinimumCharactersToDisplay(minimumCharactersToDisplay: Nullable<number>): void;
    isJustified(): boolean;
    setJustified(justified: boolean): void;
    getAngle(): number;
    setAngle(angle: number): void;
    getDesiredWidth(): number;
    setDesiredWidth(desiredSize: number): void;
    getDesiredHeight(): number;
    setDesiredHeight(desiredSize: number): void;
}
export declare namespace EnhancedLabel {
    /** @deprecated $metadata$ is used for internal purposes, please don't use it in your code, because it can be removed at any moment */
    namespace $metadata$ {
        const constructor: abstract new () => EnhancedLabel;
    }
    abstract class Rendering {
        private constructor();
        static get Truncate(): EnhancedLabel.Rendering & {
            get name(): "Truncate";
            get ordinal(): 0;
        };
        static get Clip(): EnhancedLabel.Rendering & {
            get name(): "Clip";
            get ordinal(): 1;
        };
        static get WordWrap(): EnhancedLabel.Rendering & {
            get name(): "WordWrap";
            get ordinal(): 2;
        };
        get name(): "Truncate" | "Clip" | "WordWrap";
        get ordinal(): 0 | 1 | 2;
        static values(): Array<EnhancedLabel.Rendering>;
        static valueOf(value: string): EnhancedLabel.Rendering;
    }
    namespace Rendering {
        /** @deprecated $metadata$ is used for internal purposes, please don't use it in your code, because it can be removed at any moment */
        namespace $metadata$ {
            const constructor: abstract new () => Rendering;
        }
    }
    abstract class Effect {
        protected constructor();
    }
    namespace Effect {
        /** @deprecated $metadata$ is used for internal purposes, please don't use it in your code, because it can be removed at any moment */
        namespace $metadata$ {
            const constructor: abstract new () => Effect;
        }
        abstract class Plain extends KtSingleton<Plain.$metadata$.constructor>() {
            private constructor();
        }
        namespace Plain {
            /** @deprecated $metadata$ is used for internal purposes, please don't use it in your code, because it can be removed at any moment */
            namespace $metadata$ {
                abstract class constructor extends EnhancedLabel.Effect.$metadata$.constructor {
                    private constructor();
                }
            }
        }
        abstract class Shadow extends KtSingleton<Shadow.$metadata$.constructor>() {
            private constructor();
        }
        namespace Shadow {
            /** @deprecated $metadata$ is used for internal purposes, please don't use it in your code, because it can be removed at any moment */
            namespace $metadata$ {
                abstract class constructor extends EnhancedLabel.Effect.$metadata$.constructor {
                    private constructor();
                }
            }
        }
        abstract class Glow extends KtSingleton<Glow.$metadata$.constructor>() {
            private constructor();
        }
        namespace Glow {
            /** @deprecated $metadata$ is used for internal purposes, please don't use it in your code, because it can be removed at any moment */
            namespace $metadata$ {
                abstract class constructor extends EnhancedLabel.Effect.$metadata$.constructor {
                    private constructor();
                }
            }
        }
        abstract class Outline extends KtSingleton<Outline.$metadata$.constructor>() {
            private constructor();
        }
        namespace Outline {
            /** @deprecated $metadata$ is used for internal purposes, please don't use it in your code, because it can be removed at any moment */
            namespace $metadata$ {
                abstract class constructor extends EnhancedLabel.Effect.$metadata$.constructor {
                    private constructor();
                }
            }
        }
        abstract class Emphasize extends KtSingleton<Emphasize.$metadata$.constructor>() {
            private constructor();
        }
        namespace Emphasize {
            /** @deprecated $metadata$ is used for internal purposes, please don't use it in your code, because it can be removed at any moment */
            namespace $metadata$ {
                abstract class constructor extends EnhancedLabel.Effect.$metadata$.constructor {
                    private constructor();
                }
            }
        }
    }
    abstract class Companion extends KtSingleton<Companion.$metadata$.constructor>() {
        private constructor();
    }
    namespace Companion {
        /** @deprecated $metadata$ is used for internal purposes, please don't use it in your code, because it can be removed at any moment */
        namespace $metadata$ {
            abstract class constructor {
                get CENTER(): number;
                get TOP(): number;
                get LEFT(): number;
                get BOTTOM(): number;
                get RIGHT(): number;
                get HORIZONTAL(): number;
                get VERTICAL(): number;
                get LEADING(): number;
                get TRAILING(): number;
                get NEXT(): number;
                private constructor();
            }
        }
    }
}
export declare class InterpolatedPalette /* extends FixedPalette */ {
    constructor(entries: KtSet<InterpolatedPalette.Entry>/* SortedSet<InterpolatedPalette.Entry> */);
    get entries(): KtSet<InterpolatedPalette.Entry>/* SortedSet<InterpolatedPalette.Entry> */;
    set entries(value: KtSet<InterpolatedPalette.Entry>/* SortedSet<InterpolatedPalette.Entry> */);
    static paletteConstructor(p: any/* Palette */): InterpolatedPalette;
    static entriesConstructor(e: Array<InterpolatedPalette.Entry>): InterpolatedPalette;
    getEntries(): KtSet<InterpolatedPalette.Entry>;
}
export declare namespace InterpolatedPalette {
    /** @deprecated $metadata$ is used for internal purposes, please don't use it in your code, because it can be removed at any moment */
    namespace $metadata$ {
        const constructor: abstract new () => InterpolatedPalette;
    }
    class Entry /* implements Comparable<InterpolatedPalette.Entry> */ {
        constructor(fraction: number, color: any/* CPColor */);
        get fraction(): number;
        getColor(): any/* CPColor */;
        equals(other: Nullable<any>): boolean;
        hashCode(): number;
    }
    namespace Entry {
        /** @deprecated $metadata$ is used for internal purposes, please don't use it in your code, because it can be removed at any moment */
        namespace $metadata$ {
            const constructor: abstract new () => Entry;
        }
    }
}
export declare class PaletteFactory {
    constructor();
    getEntries(): KtList<PaletteFactory.Entry>;
    getPalette(name: string): any/* Palette */;
    add(entry: PaletteFactory.Entry): void;
    get(name: string): Nullable<PaletteFactory.Entry>;
    find(palette: Nullable<any>/* Nullable<Palette> */): Nullable<PaletteFactory.Entry>;
    createDefaultDivergingPalette(): any/* FixedPalette */;
    createDefaultSequentialPalette(): any/* FixedPalette */;
    createDefaultQualititativePalette(): any/* FixedPalette */;
    createColorGradient(name: string): Nullable<any>/* Nullable<MutablePalette> */;
}
export declare namespace PaletteFactory {
    /** @deprecated $metadata$ is used for internal purposes, please don't use it in your code, because it can be removed at any moment */
    namespace $metadata$ {
        const constructor: abstract new () => PaletteFactory;
    }
    class Entry {
        constructor(name: string, type: any/* PaletteType */, colors: any/* FixedPalette */);
        get name(): string;
        get type(): any/* PaletteType */;
        getPalette(): any/* FixedPalette */;
    }
    namespace Entry {
        /** @deprecated $metadata$ is used for internal purposes, please don't use it in your code, because it can be removed at any moment */
        namespace $metadata$ {
            const constructor: abstract new () => Entry;
        }
    }
    abstract class Companion extends KtSingleton<Companion.$metadata$.constructor>() {
        private constructor();
    }
    namespace Companion {
        /** @deprecated $metadata$ is used for internal purposes, please don't use it in your code, because it can be removed at any moment */
        namespace $metadata$ {
            abstract class constructor {
                get instance(): PaletteFactory;
                private constructor();
            }
        }
    }
}
export declare interface Visual<O, C> {
    readonly visualObjects: Nullable<any>/* Nullable<VisualObjects<O>> */;
    readonly probing: any/* MutableSingleSelection<O> */;
    readonly selection: any/* MutableSelection<O> */;
    readonly filter: any/* MutableIndexFilter<O> */;
    readonly colorMapping: any/* MutableColorMapping<O, C> */;
    readonly annotationProbing: any/* MutableSingleSelection<any> */;
    readonly annotationSelection: any/* MutableSelection<any> */;
    readonly coloring: any/* MutableColoring<O> */;
    readonly filtered: any/* VisualLayer<O> */;
    readonly visible: any/* VisualLayer<O> */;
    readonly active: any/* VisualLayer<O> */;
    readonly colorMapped: any/* VisualLayer<O> */;
    readonly colored: any/* VisualLayer<O> */;
    readonly selected: any/* VisualLayer<O> */;
    readonly singleSelected: any/* VisualLayer<O> */;
    readonly multipleSelected: any/* VisualLayer<O> */;
    readonly probed: any/* VisualLayer<O> */;
    readonly probedAnnotation: any/* VisualLayer<any> */;
    readonly selectedAnnotation: any/* VisualLayer<any> */;
    readonly __doNotUseOrImplementIt: {
        readonly "org.mkui.visual.Visual": unique symbol;
    };
}
export declare interface FunctionalReactCanvasProps extends Props {
}
export declare function colorOf(r: number, g: number, b: number, a: number): any/* CPColor */;
export declare class DefaultDataFrame<R, C> /* extends AbstractDataFrame<number, string, Nullable<any>> */ {
    constructor(dataFrame: any/* DataFrame<R, C, Nullable<any>> */);
    get series(): Array<any/* Series<number, Nullable<any>> */>;
    set series(value: Array<any/* Series<number, Nullable<any>> */>);
}
export declare namespace DefaultDataFrame {
    /** @deprecated $metadata$ is used for internal purposes, please don't use it in your code, because it can be removed at any moment */
    namespace $metadata$ {
        const constructor: abstract new <R, C>() => DefaultDataFrame<R, C>;
    }
}
export declare interface Graph<Vertex, Edge> {
    readonly nodes: any/* Iterable<Vertex> */;
    readonly links: any/* Iterable<Edge> */;
    target(link: Edge, node: Vertex): Vertex;
    getFrom(link: Edge): Vertex;
    getTo(link: Edge): Vertex;
    getLink(from: Vertex, to: Vertex): Nullable<Edge>;
    getLinks(from: Vertex): any/* Iterable<Edge> */;
    getNeighbors(from: Vertex): any/* Iterable<Vertex> */;
    readonly __doNotUseOrImplementIt: {
        readonly "org.molap.network.Graph": unique symbol;
    };
}
export declare class JsonDataFrame /* extends AbstractDataFrame<number, string, Nullable<any>> */ {
    constructor(array: Array<Nullable<any>>);
    static fromString(json: string): JsonDataFrame;
}
export declare namespace JsonDataFrame {
    /** @deprecated $metadata$ is used for internal purposes, please don't use it in your code, because it can be removed at any moment */
    namespace $metadata$ {
        const constructor: abstract new () => JsonDataFrame;
    }
}
export declare interface Algorithm {
    readonly properties: Nullable<any>/* Nullable<MutableProperties<Nullable<string>>> */;
    iterator<N, Row, Column>(model: TreeMapModel<N, Row, Column>, root: N): any/* Iterable<N> */;
    startLayout<N, Row, Column>(bounds: Nullable<any>/* Nullable<Rectangle2D> */, model: TreeMapModel<N, Row, Column>, root: N, worker: Nullable<any>/* Nullable<TreeMapWorker> */): void;
    depthFirstLayout<N, Row, Column>(shape: Nullable<any>/* Nullable<Shape> */, parent: N, children: Array<N>, sumSizes: number, horizontalVanishingPoint: number, verticalVanishingPoint: number, accessor: TreeMapAccessor<N>, worker: Nullable<any>/* Nullable<TreeMapWorker> */): boolean;
    breadthFirstLayout<N, Row, Column>(shape: any/* Shape */, parent: N, children: Array<N>, sumSizes: number, horizontalVanishingPoint: number, verticalVanishingPoint: number, accessor: TreeMapAccessor<N>, worker: Nullable<any>/* Nullable<TreeMapWorker> */): boolean;
    finishLayout<N, Row, Column>(bounds: Nullable<any>/* Nullable<Rectangle2D> */, model: Nullable<TreeMapModel<N, Row, Column>>, root: N): void;
    isCompatible(shape: Nullable<any>/* Nullable<Shape> */): boolean;
    readonly isRenderingLeafLabelsSupported: boolean;
    readonly isRenderingParentLabelSupported: boolean;
    readonly isColorParent: boolean;
    readonly isChildContained: boolean;
    readonly isSpaceFilling: boolean;
    readonly __doNotUseOrImplementIt: {
        readonly "com.treemap.Algorithm": unique symbol;
    };
}
export declare class AlgorithmFactory {
    protected constructor(entries: Array<Algorithm>);
    add(entry: Algorithm): void;
    getDefault(): Algorithm;
    getAlgorithms(): KtList<Algorithm>;
    get(name: Nullable<string>): Algorithm;
    find(name: Nullable<any>): Algorithm;
}
export declare namespace AlgorithmFactory {
    /** @deprecated $metadata$ is used for internal purposes, please don't use it in your code, because it can be removed at any moment */
    namespace $metadata$ {
        const constructor: abstract new () => AlgorithmFactory;
    }
    abstract class Companion extends KtSingleton<Companion.$metadata$.constructor>() {
        private constructor();
    }
    namespace Companion {
        /** @deprecated $metadata$ is used for internal purposes, please don't use it in your code, because it can be removed at any moment */
        namespace $metadata$ {
            abstract class constructor {
                get BINARY_TREE(): Algorithm;
                get SLICE(): Algorithm;
                get SQUARIFIED(): Algorithm;
                get SQUARIFIEDPLUS(): Algorithm;
                get STRIP(): Algorithm;
                get PIVOT_BY_SPLIT_SIZE(): Algorithm;
                get SPLIT(): Algorithm;
                get CIRCULAR(): Algorithm;
                get CIRCLEPACKING(): Algorithm;
                get PIE(): Algorithm;
                get BAR(): Algorithm;
                get MATRIX(): Algorithm;
                get SUNBURST(): Algorithm;
                get ICICLE(): Algorithm;
                get instance(): AlgorithmFactory;
                private constructor();
            }
        }
    }
}
export declare class CushionRendering /* extends AbstractRendering */ implements Rendering {
    constructor();
    paintNode<N, Row, Column>(g: any/* TGraphics */, view: any/* TreeMapView<N, Row, Column> */, node: N, pass: number, bounds: any/* Rectangle */, shape: any/* Shape */): boolean;
    paintBorder<N, Row, Column>(g2: any/* TGraphics */, view: any/* TreeMapView<N, Row, Column> */, node: N, pass: number, bounds: any/* Rectangle */, shape: any/* Shape */): void;
    toString(): string;
    getPasses<N, Row, Column>(model: TreeMapModel<N, Row, Column>): number;
    getParentOrder<N, Row, Column>(view: any/* TreeMapView<N, Row, Column> */, root: N, pass: number): any/* Iterable<N> */;
    getOrder<N, Row, Column>(view: any/* TreeMapView<N, Row, Column> */, root: N, pass: number): any/* Iterable<N> */;
    paintParent<N, Row, Column>(g: any/* TGraphics */, view: any/* TreeMapView<N, Row, Column> */, node: N, pass: number, bounds: any/* Rectangle */, shape: any/* Shape */): void;
    getRenderedShape<N, Row, Column>(view: any/* TreeMapView<N, Row, Column> */, model: TreeMapModel<N, Row, Column>, node: N, shape: any/* Shape */): any/* Shape */;
    paintBackground<N, Row, Column>(g: any/* TGraphics */, view: any/* TreeMapView<N, Row, Column> */, node: N, pass: number, passes: number, bounds: any/* Rectangle */, shape: any/* Shape */): void;
    getNestingBackground<N, Row, Column>(node: N, model: TreeMapModel<N, Row, Column>): Nullable<any>/* Nullable<CPColor> */;
    paintLabel<N, Row, Column>(g: any/* TGraphics */, view: any/* TreeMapView<N, Row, Column> */, node: N, pass: number, passes: number, bounds: any/* Rectangle */, shape: any/* Shape */): void;
    paintParentBorder<N, Row, Column>(g: any/* TGraphics */, node: N, bounds: any/* Rectangle */, shape: any/* Shape */, model: TreeMapModel<N, Row, Column>): void;
    paintParentHighlight<N, Row, Column>(g2: any/* TGraphics */, view: any/* TreeMapView<N, Row, Column> */, node: N, pass: number, bounds: any/* Rectangle */, shape: Nullable<any>/* Nullable<Shape> */): void;
    readonly __doNotUseOrImplementIt: Rendering["__doNotUseOrImplementIt"];
}
export declare namespace CushionRendering {
    /** @deprecated $metadata$ is used for internal purposes, please don't use it in your code, because it can be removed at any moment */
    namespace $metadata$ {
        const constructor: abstract new () => CushionRendering;
    }
}
export declare abstract class DefaultAlgorithmFactory {
    static readonly getInstance: () => typeof DefaultAlgorithmFactory.$metadata$.type;
    private constructor();
}
export declare namespace DefaultAlgorithmFactory {
    /** @deprecated $metadata$ is used for internal purposes, please don't use it in your code, because it can be removed at any moment */
    namespace $metadata$ {
        abstract class type extends KtSingleton<constructor>() {
            private constructor();
        }
        abstract class constructor {
            get instance(): AlgorithmFactory;
            private constructor();
        }
    }
}
export declare class DefaultTreeMapColumnSettings /* extends AbstractTreeMapColumnSettings */ implements TreeMapColumnSettings {
    constructor(colorFactory: any/* MkColorFactory */, fontFactory: any/* CPFontFactory */, colorMapFactory: Nullable<any>/* Nullable<ColorMapFactory> */);
    get properties(): any/* MutableProperties<TreeMapColumnPropertyType> */;
    protected get algorithm(): any/* MutableSingleSelection<Nullable<Algorithm>> */;
    protected get borderThickness(): any/* MutableBoundedInterval */;
    get labelingEffect(): any/* MutableProperty<Nullable<EnhancedLabel.Effect>> */;
    set labelingEffect(value: any/* MutableProperty<Nullable<EnhancedLabel.Effect>> */);
    get labelingHorizontalAlignment(): any/* MutableProperty<number> */;
    set labelingHorizontalAlignment(value: any/* MutableProperty<number> */);
    get labelingVerticalAlignment(): any/* MutableProperty<number> */;
    set labelingVerticalAlignment(value: any/* MutableProperty<number> */);
    get labelingRendering(): any/* MutableProperty<Nullable<EnhancedLabel.Rendering>> */;
    set labelingRendering(value: any/* MutableProperty<Nullable<EnhancedLabel.Rendering>> */);
    get headerEffect(): any/* MutableProperty<Nullable<EnhancedLabel.Effect>> */;
    set headerEffect(value: any/* MutableProperty<Nullable<EnhancedLabel.Effect>> */);
    get headerHorizontalAlignment(): any/* MutableProperty<number> */;
    set headerHorizontalAlignment(value: any/* MutableProperty<number> */);
    get headerVerticalAlignment(): any/* MutableProperty<number> */;
    set headerVerticalAlignment(value: any/* MutableProperty<number> */);
    get headerRendering(): any/* MutableProperty<Nullable<EnhancedLabel.Rendering>> */;
    set headerRendering(value: any/* MutableProperty<Nullable<EnhancedLabel.Rendering>> */);
    get tooltipRendering(): any/* MutableProperty<Nullable<EnhancedLabel.Rendering>> */;
    set tooltipRendering(value: any/* MutableProperty<Nullable<EnhancedLabel.Rendering>> */);
    protected get _algorithm(): any/* MutableProperty<Nullable<Algorithm>> */;
    protected set _algorithm(value: any/* MutableProperty<Nullable<Algorithm>> */);
    protected get _aggregation(): any/* MutableProperty<Nullable<Aggregation>> */;
    protected set _aggregation(value: any/* MutableProperty<Nullable<Aggregation>> */);
    protected get _scale(): any/* MutableProperty<Nullable<Scale>> */;
    protected set _scale(value: any/* MutableProperty<Nullable<Scale>> */);
    protected get _nesting(): any/* MutableProperty<Nullable<Nesting>> */;
    protected set _nesting(value: any/* MutableProperty<Nullable<Nesting>> */);
    protected get _ordering(): any/* MutableProperty<Nullable<Ordering>> */;
    protected set _ordering(value: any/* MutableProperty<Nullable<Ordering>> */);
    protected get orderingDirection(): any/* MutableProperty<Nullable<Ordering.SortOrder>> */;
    protected set orderingDirection(value: any/* MutableProperty<Nullable<Ordering.SortOrder>> */);
    protected get orderingHorizontalVanishingPoint(): any/* MutableProperty<number> */;
    protected set orderingHorizontalVanishingPoint(value: any/* MutableProperty<number> */);
    protected get orderingVerticalVanishingPoint(): any/* MutableProperty<number> */;
    protected set orderingVerticalVanishingPoint(value: any/* MutableProperty<number> */);
    protected get _labeling(): any/* MutableProperty<Nullable<Labeling>> */;
    protected set _labeling(value: any/* MutableProperty<Nullable<Labeling>> */);
    protected get _labelingFont(): any/* MutableProperty<Nullable<CPFont>> */;
    protected set _labelingFont(value: any/* MutableProperty<Nullable<CPFont>> */);
    protected get _labelingForeground(): any/* MutableProperty<Nullable<CPColor>> */;
    protected set _labelingForeground(value: any/* MutableProperty<Nullable<CPColor>> */);
    protected get _labelingBackground(): any/* MutableProperty<Nullable<CPColor>> */;
    protected set _labelingBackground(value: any/* MutableProperty<Nullable<CPColor>> */);
    protected get labelingMinimumCharactersToDisplay(): any/* MutableProperty<Nullable<number>> */;
    protected set labelingMinimumCharactersToDisplay(value: any/* MutableProperty<Nullable<number>> */);
    protected get labelingEffectOpacity(): any/* MutableProperty<Nullable<number>> */;
    protected set labelingEffectOpacity(value: any/* MutableProperty<Nullable<number>> */);
    protected get labelingShrinkTextToFitShape(): any/* MutableProperty<boolean> */;
    protected set labelingShrinkTextToFitShape(value: any/* MutableProperty<boolean> */);
    protected get labelingResizeTextToFitShape(): any/* MutableProperty<boolean> */;
    protected set labelingResizeTextToFitShape(value: any/* MutableProperty<boolean> */);
    protected get labelingFloat(): any/* MutableProperty<Nullable<boolean>> */;
    protected set labelingFloat(value: any/* MutableProperty<Nullable<boolean>> */);
    protected get labelingContrastEnhancement(): any/* MutableProperty<Nullable<ContrastEnhancement>> */;
    protected set labelingContrastEnhancement(value: any/* MutableProperty<Nullable<ContrastEnhancement>> */);
    protected get nestingAmount(): any/* MutableProperty<Nullable<number>> */;
    protected set nestingAmount(value: any/* MutableProperty<Nullable<number>> */);
    protected get nestingBackground(): any/* MutableProperty<Nullable<CPColor>> */;
    protected set nestingBackground(value: any/* MutableProperty<Nullable<CPColor>> */);
    protected get _headerFont(): any/* MutableProperty<Nullable<CPFont>> */;
    protected set _headerFont(value: any/* MutableProperty<Nullable<CPFont>> */);
    protected get _headerForeground(): any/* MutableProperty<Nullable<CPColor>> */;
    protected set _headerForeground(value: any/* MutableProperty<Nullable<CPColor>> */);
    protected get _headerEffectColor(): any/* MutableProperty<Nullable<CPColor>> */;
    protected set _headerEffectColor(value: any/* MutableProperty<Nullable<CPColor>> */);
    protected get _headerBackground(): any/* MutableProperty<Nullable<CPColor>> */;
    protected set _headerBackground(value: any/* MutableProperty<Nullable<CPColor>> */);
    protected get headerMinimumCharactersToDisplay(): any/* MutableProperty<Nullable<number>> */;
    protected set headerMinimumCharactersToDisplay(value: any/* MutableProperty<Nullable<number>> */);
    protected get headerEffectOpacity(): any/* MutableProperty<Nullable<number>> */;
    protected set headerEffectOpacity(value: any/* MutableProperty<Nullable<number>> */);
    protected get headerInsets(): any/* MutableProperty<Nullable<Insets>> */;
    protected set headerInsets(value: any/* MutableProperty<Nullable<Insets>> */);
    protected get tooltipFont(): any/* MutableProperty<Nullable<CPFont>> */;
    protected set tooltipFont(value: any/* MutableProperty<Nullable<CPFont>> */);
    protected get tooltipForeground(): any/* MutableProperty<Nullable<CPColor>> */;
    protected set tooltipForeground(value: any/* MutableProperty<Nullable<CPColor>> */);
    protected get tooltipShowLabel(): any/* MutableProperty<boolean> */;
    protected set tooltipShowLabel(value: any/* MutableProperty<boolean> */);
    protected get borderColor(): any/* MutableProperty<Nullable<CPColor>> */;
    protected set borderColor(value: any/* MutableProperty<Nullable<CPColor>> */);
    protected get _borderThickness(): any/* MutableProperty<Nullable<number>> */;
    protected set _borderThickness(value: any/* MutableProperty<Nullable<number>> */);
    protected get format(): Nullable<any>/* Nullable<MutableProperty<Nullable<CPFormat<Nullable<any>>>>> */;
    protected set format(value: Nullable<any>/* Nullable<MutableProperty<Nullable<CPFormat<Nullable<any>>>>> */);
    protected get colorMap(): Nullable<any>/* Nullable<MutableProperty<Nullable<MutableColorMap>>> */;
    protected set colorMap(value: Nullable<any>/* Nullable<MutableProperty<Nullable<MutableColorMap>>> */);
    getAlgorithmProperty(): any/* MutableProperty<Nullable<Algorithm>> */;
    getAlgorithm(): Algorithm;
    setAlgorithm(algorithm: Nullable<Algorithm>): void;
    getAlgorithmSelection(): any/* MutableSingleSelection<Nullable<Algorithm>> */;
    getAggregationProperty(): any/* MutableProperty<Nullable<Aggregation>> */;
    getAggregation(): Nullable<any>/* Nullable<Aggregation> */;
    setAggregation(aggregation: Nullable<any>/* Nullable<Aggregation> */): void;
    getScaleProperty(): any/* MutableProperty<Nullable<Scale>> */;
    getScale(): any/* Scale */;
    setScale(scale: Nullable<any>/* Nullable<Scale> */): void;
    getNestingProperty(): any/* MutableProperty<Nullable<Nesting>> */;
    getNesting(): Nullable<any>/* Nullable<Nesting> */;
    setNesting(nesting: Nullable<any>/* Nullable<Nesting> */): void;
    getOrderingProperty(): any/* MutableProperty<Nullable<Ordering>> */;
    getOrdering(): any/* Ordering */;
    setOrdering(ordering: Nullable<any>/* Nullable<Ordering> */): void;
    getOrderingDirectionProperty(): any/* MutableProperty<Nullable<Ordering.SortOrder>> */;
    getOrderingDirection(): Nullable<any>/* Nullable<Ordering.SortOrder> */;
    setOrderingDirection(sortOrder: Nullable<any>/* Nullable<Ordering.SortOrder> */): void;
    getOrderingVerticalVanishingPointProperty(): any/* MutableProperty<number> */;
    getOrderingVerticalVanishingPoint(): number;
    setOrderingVerticalVanishingPoint(verticalVanishingPoint: number): void;
    getOrderingHorizontalVanishingPointProperty(): any/* MutableProperty<number> */;
    getOrderingHorizontalVanishingPoint(): number;
    setOrderingHorizontalVanishingPoint(horizontalVanishingPoint: number): void;
    getLabelingProperty(): any/* MutableProperty<Nullable<Labeling>> */;
    getLabeling(): Nullable<any>/* Nullable<Labeling> */;
    setLabeling(labeling: Nullable<any>/* Nullable<Labeling> */): void;
    getLabelingFontProperty(): any/* MutableProperty<Nullable<CPFont>> */;
    getLabelingFont(): Nullable<any>/* Nullable<CPFont> */;
    setLabelingFont(font: Nullable<any>/* Nullable<CPFont> */): void;
    getLabelingForegroundProperty(): any/* MutableProperty<Nullable<CPColor>> */;
    getLabelingForeground(): Nullable<any>/* Nullable<CPColor> */;
    setLabelingForeground(color: Nullable<any>/* Nullable<CPColor> */): void;
    getLabelingEffectColorProperty(): any/* MutableProperty<Nullable<CPColor>> */;
    getLabelingEffectColor(): Nullable<any>/* Nullable<CPColor> */;
    setLabelingEffectColor(color: Nullable<any>/* Nullable<CPColor> */): void;
    getLabelingEffectProperty(): any/* MutableProperty<Nullable<EnhancedLabel.Effect>> */;
    getLabelingEffect(): Nullable<EnhancedLabel.Effect>;
    setLabelingEffect(effect: Nullable<EnhancedLabel.Effect>): void;
    getLabelingHorizontalAlignmentProperty(): any/* MutableProperty<number> */;
    getLabelingHorizontalAlignment(): number;
    setLabelingHorizontalAlignment(alignment: number): void;
    getLabelingVerticalAlignmentProperty(): any/* MutableProperty<number> */;
    getLabelingVerticalAlignment(): number;
    setLabelingVerticalAlignment(alignment: number): void;
    getLabelingRenderingProperty(): any/* MutableProperty<Nullable<EnhancedLabel.Rendering>> */;
    getLabelingRendering(): Nullable<EnhancedLabel.Rendering>;
    setLabelingRendering(rendering: Nullable<EnhancedLabel.Rendering>): void;
    getLabelingMinimumCharactersToDisplayProperty(): any/* MutableProperty<Nullable<number>> */;
    getLabelingMinimumCharactersToDisplay(): Nullable<number>;
    setLabelingMinimumCharactersToDisplay(minimumCharactersToDisplay: Nullable<number>): void;
    getLabelingEffectOpacityProperty(): any/* MutableProperty<Nullable<number>> */;
    getLabelingEffectOpacity(): Nullable<number>;
    setLabelingEffectOpacity(opacity: Nullable<number>): void;
    getLabelingShrinkTextToFitShapeProperty(): any/* MutableProperty<boolean> */;
    getLabelingShrinkTextToFitShape(): Nullable<boolean>;
    setLabelingShrinkTextToFitShape(labelingShrinkTextToFitShape: boolean): void;
    getLabelingResizeTextToFitShapeProperty(): any/* MutableProperty<boolean> */;
    getLabelingResizeTextToFitShape(): Nullable<boolean>;
    setLabelingResizeTextToFitShape(labelingResizeTextToFitShape: boolean): void;
    getLabelingFloatProperty(): any/* MutableProperty<Nullable<boolean>> */;
    getLabelingFloat(): Nullable<boolean>;
    setLabelingFloat(labelingFloat: Nullable<boolean>): void;
    getLabelingContrastEnhancementProperty(): any/* MutableProperty<Nullable<ContrastEnhancement>> */;
    getLabelingContrastEnhancement(): Nullable<any>/* Nullable<ContrastEnhancement> */;
    setLabelingContrastEnhancement(contrastEnhancement: Nullable<any>/* Nullable<ContrastEnhancement> */): void;
    getNestingAmountProperty(): any/* MutableProperty<Nullable<number>> */;
    getNestingAmount(): Nullable<number>;
    setNestingAmount(amount: Nullable<number>): void;
    getNestingBackgroundProperty(): any/* MutableProperty<Nullable<CPColor>> */;
    getNestingBackground(): Nullable<any>/* Nullable<CPColor> */;
    setNestingBackground(color: Nullable<any>/* Nullable<CPColor> */): void;
    getHeaderFontProperty(): any/* MutableProperty<Nullable<CPFont>> */;
    getHeaderFont(): Nullable<any>/* Nullable<CPFont> */;
    setHeaderFont(font: Nullable<any>/* Nullable<CPFont> */): void;
    getHeaderForegroundProperty(): any/* MutableProperty<Nullable<CPColor>> */;
    getHeaderForeground(): Nullable<any>/* Nullable<CPColor> */;
    setHeaderForeground(color: Nullable<any>/* Nullable<CPColor> */): void;
    getHeaderBackgroundProperty(): any/* MutableProperty<Nullable<CPColor>> */;
    getHeaderBackground(): Nullable<any>/* Nullable<CPColor> */;
    setHeaderBackground(color: Nullable<any>/* Nullable<CPColor> */): void;
    getHeaderEffectColorProperty(): any/* MutableProperty<Nullable<CPColor>> */;
    getHeaderEffectColor(): Nullable<any>/* Nullable<CPColor> */;
    setHeaderEffectColor(color: Nullable<any>/* Nullable<CPColor> */): void;
    getHeaderEffectProperty(): any/* MutableProperty<Nullable<EnhancedLabel.Effect>> */;
    getHeaderEffect(): Nullable<EnhancedLabel.Effect>;
    setHeaderEffect(effect: Nullable<EnhancedLabel.Effect>): void;
    getHeaderHorizontalAlignmentProperty(): any/* MutableProperty<number> */;
    getHeaderHorizontalAlignment(): number;
    setHeaderHorizontalAlignment(alignment: number): void;
    getHeaderVerticalAlignmentProperty(): any/* MutableProperty<number> */;
    getHeaderVerticalAlignment(): number;
    setHeaderVerticalAlignment(alignment: number): void;
    getHeaderRenderingProperty(): any/* MutableProperty<Nullable<EnhancedLabel.Rendering>> */;
    getHeaderRendering(): Nullable<EnhancedLabel.Rendering>;
    setHeaderRendering(rendering: Nullable<EnhancedLabel.Rendering>): void;
    getHeaderMinimumCharactersToDisplayProperty(): any/* MutableProperty<Nullable<number>> */;
    getHeaderMinimumCharactersToDisplay(): Nullable<number>;
    setHeaderMinimumCharactersToDisplay(minimumCharactersToDisplay: Nullable<number>): void;
    getHeaderEffectOpacityProperty(): any/* MutableProperty<Nullable<number>> */;
    getHeaderEffectOpacity(): Nullable<number>;
    setHeaderEffectOpacity(opacity: Nullable<number>): void;
    getHeaderInsetsProperty(): any/* MutableProperty<Nullable<Insets>> */;
    getHeaderInsets(): Nullable<any>/* Nullable<Insets> */;
    setHeaderInsets(insets: Nullable<any>/* Nullable<Insets> */): void;
    getTooltipFontProperty(): any/* MutableProperty<Nullable<CPFont>> */;
    getTooltipFont(): Nullable<any>/* Nullable<CPFont> */;
    setTooltipFont(font: Nullable<any>/* Nullable<CPFont> */): void;
    getTooltipForegroundProperty(): any/* MutableProperty<Nullable<CPColor>> */;
    getTooltipForeground(): Nullable<any>/* Nullable<CPColor> */;
    setTooltipForeground(color: Nullable<any>/* Nullable<CPColor> */): void;
    getTooltipRenderingProperty(): any/* MutableProperty<Nullable<EnhancedLabel.Rendering>> */;
    getTooltipRendering(): Nullable<EnhancedLabel.Rendering>;
    setTooltipRendering(rendering: Nullable<EnhancedLabel.Rendering>): void;
    getBorderColorProperty(): any/* MutableProperty<Nullable<CPColor>> */;
    getBorderColor(): Nullable<any>/* Nullable<CPColor> */;
    setBorderColor(color: Nullable<any>/* Nullable<CPColor> */): void;
    getBorderThicknessInterval(): any/* MutableBoundedInterval */;
    getBorderThickness(): number;
    setBorderThickness(value: number): void;
    getFormatProperty(): any/* MutableProperty<Nullable<CPFormat<Nullable<any>>>> */;
    getFormat(): Nullable<any>/* Nullable<CPFormat<Nullable<any>>> */;
    setFormat(format: Nullable<any>/* Nullable<CPFormat<Nullable<any>>> */): void;
    getShowLabelProperty(): any/* MutableProperty<boolean> */;
    getShowLabel(): boolean;
    setShowLabel(show: boolean): void;
    getColorMapProperty(): Nullable<any>/* Nullable<MutableProperty<Nullable<MutableColorMap>>> */;
    getColorMap(): Nullable<MutableColorMap>;
    setColorMap(colorMap: Nullable<MutableColorMap>): void;
    getProperty(key: TreeMapColumnPropertyType): any;
    isDefaults(): boolean;
    getOverrideDefaultsProperty(): Nullable<any>/* Nullable<MutableProperty<boolean>> */;
    isOverrideDefaults(): boolean;
    setOverrideDefaults(overrideDefaults: boolean): void;
    getPropertyOverride(key: TreeMapColumnPropertyType): any;
    reset(): void;
    protected createDefaultColorMap(column: Nullable<any>): Nullable<MutableColorMap>;
    setProperty(property: TreeMapColumnPropertyType, value: Nullable<any>): void;
    readonly __doNotUseOrImplementIt: TreeMapColumnSettings["__doNotUseOrImplementIt"];
}
export declare namespace DefaultTreeMapColumnSettings {
    /** @deprecated $metadata$ is used for internal purposes, please don't use it in your code, because it can be removed at any moment */
    namespace $metadata$ {
        const constructor: abstract new () => DefaultTreeMapColumnSettings;
    }
    abstract class Companion extends KtSingleton<Companion.$metadata$.constructor>() {
        private constructor();
    }
    namespace Companion {
        /** @deprecated $metadata$ is used for internal purposes, please don't use it in your code, because it can be removed at any moment */
        namespace $metadata$ {
            abstract class constructor {
                getDefaultTooltipFont(fontFactory: any/* CPFontFactory */): any/* CPFont */;
                getDefaultLabelingFont(fontFactory: any/* CPFontFactory */): any/* CPFont */;
                getDefaultHeaderFont(fontFactory: any/* CPFontFactory */): any/* CPFont */;
                private constructor();
            }
        }
    }
}
export declare class DefaultTreeMapModel<Row, Column> /* extends AbstractTreeMapModel<Row, Column> */ implements TreeMapModel<any/* AbstractTreeMapNode<Row, Column> */, Row, Column> {
    constructor(dataFrame: any/* DataFrame<Row, Column, Nullable<any>> */);
    get dataFrame(): Nullable<any>/* Nullable<DataFrame<Row, Column, Nullable<any>>> */;
    set dataFrame(value: Nullable<any>/* Nullable<DataFrame<Row, Column, Nullable<any>>> */);
    get dataFrameListener(): any/* DataFrameListener<Row, Column> */;
    getLabelName(node: any/* AbstractTreeMapNode<Row, Column> */): Nullable<string>;
    getParent(node: any/* AbstractTreeMapNode<Row, Column> */): Nullable<any>/* Nullable<AbstractTreeMapNode<Row, Column>> */;
    isRoot(node: any/* AbstractTreeMapNode<Row, Column> */): boolean;
    getChildCount(node: any/* AbstractTreeMapNode<Row, Column> */): number;
    getChildren(parent: any/* AbstractTreeMapNode<Row, Column> */): any/* Iterable<AbstractTreeMapNode<Row, Column>> */;
    getChildrenOfTypeParent(parent: any/* AbstractTreeMapNode<Row, Column> */): any/* Iterable<AbstractTreeMapNode<Row, Column>> */;
    getCushionImage(node: any/* AbstractTreeMapNode<Row, Column> */): Nullable<any>/* Nullable<CPImage> */;
    getCushionColor(node: any/* AbstractTreeMapNode<Row, Column> */): Nullable<any>/* Nullable<CPColor> */;
    protected createLeafNode(row: Row): any/* AbstractTreeMapNode<Row, Column> */;
    getNodeForRow(row: Row): any/* AbstractTreeMapNode<Row, Column> */;
    protected createParentNode(name: any, groupByColumn: Column, childrenGroupByColumn: Nullable<Column>): any/* AbstractTreeMapNode<Row, Column> */;
    protected findChild(parent: any/* AbstractTreeMapNode<Row, Column> */, name: Nullable<any>): Nullable<any>/* Nullable<AbstractTreeMapNode<Row, Column>> */;
    protected addChildToParent(parent: any/* AbstractTreeMapNode<Row, Column> */, child: any/* AbstractTreeMapNode<Row, Column> */): void;
    protected addChild(parent: any/* AbstractTreeMapNode<Row, Column> */, path: any/* Iterable<Nullable<any>> */, groupBy: any/* Iterable<Column> */, childrenGroupBy: any/* Iterable<Nullable<Column>> */, row: Row): void;
    getTreeMapColumn(columnIndex: number): Nullable<Column>;
    getTreeMapColumnByName(columnName: Nullable<string>): Nullable<Column>;
    get rowCount(): number;
    get columnCount(): number;
    columns(): any/* Iterable<Column> */;
    getColumnName(columnIndex: Column): Nullable<string>;
    getColumnClass(columnIndex: Column): any/* KClass<UnknownType *> */;
    getValueAt(node: any/* AbstractTreeMapNode<Row, Column> */, columnIndex: Column): Nullable<any>;
    isEveryValueUnique(column: Nullable<Column>): boolean;
    getNumericMax(columnIndex: Nullable<Column>): Nullable<number>;
    getNumericMin(columnIndex: Nullable<Column>): Nullable<number>;
    setNumericMax(columnIndex: Nullable<Column>, max: number): void;
    setNumericMin(columnIndex: Nullable<Column>, min: number): void;
    createDefaultColorMap(column: Column): MutableColorMap;
    get colorFactory(): any/* MkColorFactory */;
    get settings(): TreeMapSettings<Column>;
    get properties(): any/* MutableProperties<Nullable<string>> */;
    get probing(): any/* MutableSingleSelection<Nullable<AbstractTreeMapNode<Row, Column>>> */;
    get highlighting(): any/* MutableSelection<AbstractTreeMapNode<Row, Column>> */;
    get selection(): any/* MutableSelection<AbstractTreeMapNode<Row, Column>> */;
    get filter(): any/* MutableFilter<AbstractTreeMapNode<Row, Column>> */;
    get search(): any/* MutableFilter<AbstractTreeMapNode<Row, Column>> */;
    get isDirty(): boolean;
    get colorProvider(): any/* ColorProvider<AbstractTreeMapNode<Row, Column>> */;
    set colorProvider(value: any/* ColorProvider<AbstractTreeMapNode<Row, Column>> */);
    get groupByColumns(): any/* Iterable<Nullable<Column>> */;
    get sizeColumns(): any/* Iterable<Nullable<Column>> */;
    get colorColumns(): any/* Iterable<Nullable<Column>> */;
    get heightColumns(): any/* Iterable<Nullable<Column>> */;
    get labelsColumns(): any/* Iterable<Nullable<Column>> */;
    get tooltipColumns(): any/* Iterable<Nullable<Column>> */;
    getTreeMapColumnsInclude(includeNone: boolean): any/* Iterable<Nullable<Column>> */;
    getTreeMapColumnsByIndices(columns: Int32Array): KtList<Column>;
    getTreeMapColumns(columns: Array<Column>): KtList<Column>;
    getTreeMapColumnsByNames(columnNames: Array<Nullable<string>>): KtList<Column>;
    isNumericType(column: Column): boolean;
    isTemporalType(column: Column): boolean;
    isVisualType(column: Column): boolean;
    getSumSize(node: any/* AbstractTreeMapNode<Row, Column> */): number;
    getColorMap(column: Nullable<Column>): Nullable<MutableColorMap>;
    getCategoricalColorMap(column: Column): MutableColorMap;
    getPredefinedColorMap(column: Column): MutableColorMap;
    getCustomColorMap(column: Column): MutableColorMap;
    setNestedShape(node: any/* AbstractTreeMapNode<Row, Column> */, shape: Nullable<any>/* Nullable<Shape> */): void;
    getNestedShape(node: any/* AbstractTreeMapNode<Row, Column> */): any/* Shape */;
    getGroupByColumn(node: any/* AbstractTreeMapNode<Row, Column> */): Nullable<Column>;
    getChildrenGroupByColumn(node: any/* AbstractTreeMapNode<Row, Column> */): Nullable<Column>;
    isLeaf(node: any/* AbstractTreeMapNode<Row, Column> */): boolean;
    parentPreorderEnumeration(parent: any/* AbstractTreeMapNode<Row, Column> */): any/* Iterable<AbstractTreeMapNode<Row, Column>> */;
    preorderEnumeration(parent: any/* AbstractTreeMapNode<Row, Column> */): any/* Iterable<AbstractTreeMapNode<Row, Column>> */;
    breadthFirstIterator(parent: any/* AbstractTreeMapNode<Row, Column> */): any/* Iterable<AbstractTreeMapNode<Row, Column>> */;
    depthFirstIterator(parent: any/* AbstractTreeMapNode<Row, Column> */): any/* Iterable<AbstractTreeMapNode<Row, Column>> */;
    getAggregateValue(node: any/* AbstractTreeMapNode<Row, Column> */, column: Nullable<Column>): Nullable<any>;
    getStringValue(node: any/* AbstractTreeMapNode<Row, Column> */, column: Column): Nullable<string>;
    get currentRoot(): Nullable<any>/* Nullable<AbstractTreeMapNode<Row, Column>> */;
    set currentRoot(value: Nullable<any>/* Nullable<AbstractTreeMapNode<Row, Column>> */);
    addListener(treeMapListener: any/* TreeMapListener */): void;
    removeListener(treeMapListener: any/* TreeMapListener */): void;
    getNode(position: Nullable<any>/* Nullable<Point> */): Nullable<any>/* Nullable<AbstractTreeMapNode<Row, Column>> */;
    waitUntilReady(): void;
    getColor(node: any/* AbstractTreeMapNode<Row, Column> */): any/* CPColor */;
    setColor(node: any/* AbstractTreeMapNode<Row, Column> */, color: Nullable<any>/* Nullable<CPColor> */): void;
    progressProperty(): any/* MutableProperty<number> */;
    getFormatPattern(columnIndex: number): Nullable<string>;
    setFormatPattern(columnIndex: number, pattern: Nullable<string>): void;
    readonly __doNotUseOrImplementIt: TreeMapModel<any/* AbstractTreeMapNode<Row, Column> */, Row, Column>["__doNotUseOrImplementIt"];
}
export declare namespace DefaultTreeMapModel {
    /** @deprecated $metadata$ is used for internal purposes, please don't use it in your code, because it can be removed at any moment */
    namespace $metadata$ {
        const constructor: abstract new <Row, Column>() => DefaultTreeMapModel<Row, Column>;
    }
}
export declare class DefaultTreeMapSettings<N extends unknown/* MutableTreeMapNode<Column> */, Column> /* extends AbstractTreeMapSettings<Column> */ implements TreeMapSettings<Column> {
    constructor(model: TreeMapModel<N, any /*UnknownType **/, Column>, colorFactory: any/* MkColorFactory */, fontFactory: any/* CPFontFactory */, colorMapFactory: any/* ColorMapFactory */);
    get properties(): any/* MutableProperties<TreeMapPropertyType> */;
    protected get _model(): TreeMapModel<N, any /*UnknownType **/, Column>;
    protected get groupByFields(): any/* MutableProperty<KtList<Column>> */;
    protected set groupByFields(value: any/* MutableProperty<KtList<Column>> */);
    get groupByColumns(): KtList<Column>;
    set groupByColumns(value: KtList<Column>);
    protected get labelsFields(): any/* MutableProperty<KtList<Column>> */;
    protected set labelsFields(value: any/* MutableProperty<KtList<Column>> */);
    get labelsColumns(): KtList<Column>;
    set labelsColumns(value: KtList<Column>);
    protected get toolTipFields(): any/* MutableProperty<KtList<Column>> */;
    protected set toolTipFields(value: any/* MutableProperty<KtList<Column>> */);
    get toolTipColumns(): KtList<Column>;
    set toolTipColumns(value: KtList<Column>);
    protected get sizeField(): any/* MutableProperty<Nullable<Column>> */;
    protected set sizeField(value: any/* MutableProperty<Nullable<Column>> */);
    get sizeColumn(): Nullable<Column>;
    set sizeColumn(value: Nullable<Column>);
    get colorColumn(): Nullable<Column>;
    set colorColumn(value: Nullable<Column>);
    protected get backgroundField(): any/* MutableProperty<Nullable<Column>> */;
    protected set backgroundField(value: any/* MutableProperty<Nullable<Column>> */);
    get backgroundColumn(): Nullable<Column>;
    set backgroundColumn(value: Nullable<Column>);
    protected get heightField(): any/* MutableProperty<Nullable<Column>> */;
    protected set heightField(value: any/* MutableProperty<Nullable<Column>> */);
    get heightColumn(): Nullable<Column>;
    set heightColumn(value: Nullable<Column>);
    protected get _depth(): any/* MutableProperty<Nullable<Depth>> */;
    protected set _depth(value: any/* MutableProperty<Nullable<Depth>> */);
    protected get _rendering(): any/* MutableProperty<Nullable<Rendering>> */;
    protected set _rendering(value: any/* MutableProperty<Nullable<Rendering>> */);
    get rendering(): Nullable<Rendering>;
    set rendering(value: Nullable<Rendering>);
    protected get groupByVariables(): any/* MutableSelection<Column> */;
    protected get sizeVariable(): any/* MutableSingleSelection<Nullable<Column>> */;
    protected get colorVariable(): any/* MutableSingleSelection<Nullable<Column>> */;
    protected get labelVariable(): any/* MutableSelection<Column> */;
    protected get toolTipVariable(): any/* MutableSelection<Column> */;
    protected get backgroundVariable(): any/* MutableSingleSelection<Nullable<Column>> */;
    protected get heightVariable(): any/* MutableSingleSelection<Nullable<Column>> */;
    protected get progressive(): any/* MutableSingleSelection<Nullable<Progressive>> */;
    protected get depth(): any/* MutableSingleSelection<Nullable<Depth>> */;
    get renderingSelection(): any/* MutableSingleSelection<Nullable<Rendering>> */;
    get maximumHeightInterval(): any/* MutableBoundedInterval */;
    protected get maximumHeight(): any/* MutableProperty<number> */;
    get lightSourceHeightInterval(): any/* MutableBoundedInterval */;
    set lightSourceHeightInterval(value: any/* MutableBoundedInterval */);
    protected get lightSourceHeight(): any/* MutableProperty<number> */;
    get lightSourceAmbientInterval(): any/* MutableBoundedInterval */;
    protected get lightSourceAmbient(): any/* MutableProperty<number> */;
    get lightSourceXInterval(): any/* MutableBoundedInterval */;
    protected get lightSourceX(): any/* MutableProperty<number> */;
    get lightSourceYInterval(): any/* MutableBoundedInterval */;
    protected get lightSourceY(): any/* MutableProperty<number> */;
    get lightSourceZInterval(): any/* MutableBoundedInterval */;
    protected get lightSourceZ(): any/* MutableProperty<number> */;
    protected get _background(): any/* MutableProperty<Nullable<CPColor>> */;
    protected set _background(value: any/* MutableProperty<Nullable<CPColor>> */);
    protected get _tooltipBackground(): any/* MutableProperty<Nullable<CPColor>> */;
    protected set _tooltipBackground(value: any/* MutableProperty<Nullable<CPColor>> */);
    protected get _probingColor(): any/* MutableProperty<Nullable<CPColor>> */;
    protected set _probingColor(value: any/* MutableProperty<Nullable<CPColor>> */);
    protected get _selectionColor(): any/* MutableProperty<Nullable<CPColor>> */;
    protected set _selectionColor(value: any/* MutableProperty<Nullable<CPColor>> */);
    protected get hideSearchResults(): any/* MutableProperty<Nullable<boolean>> */;
    protected set hideSearchResults(value: any/* MutableProperty<Nullable<boolean>> */);
    protected get hideFilterResults(): any/* MutableProperty<Nullable<boolean>> */;
    protected set hideFilterResults(value: any/* MutableProperty<Nullable<boolean>> */);
    getGroupByColumnsSelection(): any/* MutableSelection<Column> */;
    getSizeColumnSelection(): any/* MutableSingleSelection<Nullable<Column>> */;
    getColorColumnSelection(): any/* MutableSingleSelection<Nullable<Column>> */;
    getLabelColumnsSelection(): any/* MutableSelection<Column> */;
    getTooltipColumnsSelection(): any/* MutableSelection<Column> */;
    getBackgroundColumnSelection(): any/* MutableSingleSelection<Nullable<Column>> */;
    getHeightColumnSelection(): any/* MutableSingleSelection<Nullable<Column>> */;
    getDepthSelection(): any/* MutableSingleSelection<Nullable<Depth>> */;
    getProgressiveSelection(): any/* MutableSingleSelection<Nullable<Progressive>> */;
    getHideFilterResultsSelection(): any/* MutableProperty<Nullable<boolean>> */;
    getHideSearchResultsSelection(): any/* MutableProperty<Nullable<boolean>> */;
    protected createDefaultTreeMapColumnSettings(): TreeMapColumnSettings;
    protected createOverridingTreeMapColumnSettings(defaultSettings: TreeMapColumnSettings, model: Nullable<TreeMapModel<N, any /*UnknownType **/, Column>>, field: Nullable<Column>): TreeMapColumnSettings;
    getDefaultColumnSettings(): TreeMapColumnSettings;
    getColumnSettings(field: Nullable<Column>): TreeMapColumnSettings;
    getDimensionFixed(): Nullable<boolean>;
    setDimensionFixed(fixed: Nullable<boolean>): void;
    getDimension(): Nullable<any>/* Nullable<Dimension> */;
    setDimension(dimension: Nullable<any>/* Nullable<Dimension> */): void;
    getProgressive(): Nullable<any>/* Nullable<Progressive> */;
    setProgressive(progressive: Nullable<any>/* Nullable<Progressive> */): void;
    getMaximumHeight(): number;
    setMaximumHeight(height: number): void;
    isHideFilterResults(): Nullable<boolean>;
    isHideSearchResults(): Nullable<boolean>;
    setGroupBy(columns: Int32Array): void;
    setGroupByByNames(columnNames: Array<Nullable<string>>): void;
    setLabels(columns: Int32Array): void;
    setLabelsByNames(columnNames: Array<Nullable<string>>): void;
    setToolTip(columns: Int32Array): void;
    setToolTipByNames(columns: Array<Nullable<string>>): void;
    getShowPopup(field: Nullable<Column>): boolean;
    setShowPopup(field: Nullable<Column>, show: boolean): void;
    setBackground(column: number): void;
    setBackgroundByName(columnName: Nullable<string>): void;
    setSize(column: number): void;
    setSizeByName(columnName: Nullable<string>): void;
    setColor(column: number): void;
    setColorByName(columnName: Nullable<string>): void;
    setHeight(column: number): void;
    setHeightByName(columnName: Nullable<string>): void;
    getDepth(): Nullable<any>/* Nullable<Depth> */;
    setDepth(depth: Nullable<any>/* Nullable<Depth> */): void;
    setHideFilterResults(hideFilterResults: Nullable<boolean>): void;
    setHideSearchResults(hideSearchResults: Nullable<boolean>): void;
    getLightSourceHeight(): number;
    setLightSourceHeight(value: number): void;
    getLightSourceAmbient(): number;
    setLightSourceAmbient(value: number): void;
    getLightSourceX(): number;
    setLightSourceX(value: number): void;
    getLightSourceY(): number;
    setLightSourceY(value: number): void;
    getLightSourceZ(): number;
    setLightSourceZ(value: number): void;
    getBackgroundProperty(): any/* MutableProperty<Nullable<CPColor>> */;
    getBackground(): Nullable<any>/* Nullable<CPColor> */;
    setBackgroundColor(color: Nullable<any>/* Nullable<CPColor> */): void;
    getTooltipBackgroundProperty(): any/* MutableProperty<Nullable<CPColor>> */;
    getTooltipBackground(): Nullable<any>/* Nullable<CPColor> */;
    setTooltipBackground(color: Nullable<any>/* Nullable<CPColor> */): void;
    getProbingColorProperty(): any/* MutableProperty<Nullable<CPColor>> */;
    getProbingColor(): Nullable<any>/* Nullable<CPColor> */;
    setProbingColor(color: Nullable<any>/* Nullable<CPColor> */): void;
    getSelectionColorProperty(): any/* MutableProperty<Nullable<CPColor>> */;
    getSelectionColor(): Nullable<any>/* Nullable<CPColor> */;
    setSelectionColor(color: Nullable<any>/* Nullable<CPColor> */): void;
    getValue(key: TreeMapPropertyType): Nullable<any>;
    resetToDefaults(): void;
    save(dataFrame: any/* DataFrame<Nullable<any>, Column, Nullable<any>> */, elementFactory: any/* ElementFactory */, root: any/* Element */): void;
    addTreeMapSettingsListener(listener: any/* TreeMapSettingsListener */): void;
    removeTreeMapSettingsListener(listener: any/* TreeMapSettingsListener */): void;
    removeTreeMapSettingsListeners(): void;
    readonly __doNotUseOrImplementIt: TreeMapSettings<Column>["__doNotUseOrImplementIt"];
}
export declare namespace DefaultTreeMapSettings {
    /** @deprecated $metadata$ is used for internal purposes, please don't use it in your code, because it can be removed at any moment */
    namespace $metadata$ {
        const constructor: abstract new <N extends unknown/* MutableTreeMapNode<Column> */, Column>() => DefaultTreeMapSettings<N, Column>;
    }
}
export declare class FlatNoBorderRendering extends FlatRendering.$metadata$.constructor {
    constructor();
    toString(): string;
    getPasses<N, Row, Column>(model: TreeMapModel<N, Row, Column>): number;
    getParentOrder<N, Row, Column>(view: any/* TreeMapView<N, Row, Column> */, root: N, pass: number): any/* Iterable<N> */;
    getOrder<N, Row, Column>(view: any/* TreeMapView<N, Row, Column> */, root: N, pass: number): any/* Iterable<N> */;
    paintParent<N, Row, Column>(g: any/* TGraphics */, view: any/* TreeMapView<N, Row, Column> */, node: N, pass: number, bounds: any/* Rectangle */, shape: any/* Shape */): void;
    getRenderedShape<N, Row, Column>(view: any/* TreeMapView<N, Row, Column> */, model: TreeMapModel<N, Row, Column>, node: N, shape: any/* Shape */): any/* Shape */;
    paintBackground<N, Row, Column>(g: any/* TGraphics */, view: any/* TreeMapView<N, Row, Column> */, node: N, pass: number, passes: number, bounds: any/* Rectangle */, shape: any/* Shape */): void;
    getNestingBackground<N, Row, Column>(node: N, model: TreeMapModel<N, Row, Column>): Nullable<any>/* Nullable<CPColor> */;
    paintLabel<N, Row, Column>(g: any/* TGraphics */, view: any/* TreeMapView<N, Row, Column> */, node: N, pass: number, passes: number, bounds: any/* Rectangle */, shape: any/* Shape */): void;
    paintParentBorder<N, Row, Column>(g: any/* TGraphics */, node: N, bounds: any/* Rectangle */, shape: any/* Shape */, model: TreeMapModel<N, Row, Column>): void;
    paintParentHighlight<N, Row, Column>(g2: any/* TGraphics */, view: any/* TreeMapView<N, Row, Column> */, node: N, pass: number, bounds: any/* Rectangle */, shape: Nullable<any>/* Nullable<Shape> */): void;
}
export declare namespace FlatNoBorderRendering {
    /** @deprecated $metadata$ is used for internal purposes, please don't use it in your code, because it can be removed at any moment */
    namespace $metadata$ {
        const constructor: abstract new () => FlatNoBorderRendering;
    }
}
export declare class FlatRendering /* extends AbstractRendering */ implements Rendering {
    constructor();
    get drawBorder(): boolean;
    set drawBorder(value: boolean);
    paintNode<N, Row, Column>(g: any/* TGraphics */, view: any/* TreeMapView<N, Row, Column> */, node: N, pass: number, bounds: any/* Rectangle */, shape: any/* Shape */): boolean;
    paintBorder<N, Row, Column>(g2: any/* TGraphics */, view: any/* TreeMapView<N, Row, Column> */, node: N, pass: number, bounds: any/* Rectangle */, shape: any/* Shape */): void;
    toString(): string;
    getPasses<N, Row, Column>(model: TreeMapModel<N, Row, Column>): number;
    getParentOrder<N, Row, Column>(view: any/* TreeMapView<N, Row, Column> */, root: N, pass: number): any/* Iterable<N> */;
    getOrder<N, Row, Column>(view: any/* TreeMapView<N, Row, Column> */, root: N, pass: number): any/* Iterable<N> */;
    paintParent<N, Row, Column>(g: any/* TGraphics */, view: any/* TreeMapView<N, Row, Column> */, node: N, pass: number, bounds: any/* Rectangle */, shape: any/* Shape */): void;
    getRenderedShape<N, Row, Column>(view: any/* TreeMapView<N, Row, Column> */, model: TreeMapModel<N, Row, Column>, node: N, shape: any/* Shape */): any/* Shape */;
    paintBackground<N, Row, Column>(g: any/* TGraphics */, view: any/* TreeMapView<N, Row, Column> */, node: N, pass: number, passes: number, bounds: any/* Rectangle */, shape: any/* Shape */): void;
    getNestingBackground<N, Row, Column>(node: N, model: TreeMapModel<N, Row, Column>): Nullable<any>/* Nullable<CPColor> */;
    paintLabel<N, Row, Column>(g: any/* TGraphics */, view: any/* TreeMapView<N, Row, Column> */, node: N, pass: number, passes: number, bounds: any/* Rectangle */, shape: any/* Shape */): void;
    paintParentBorder<N, Row, Column>(g: any/* TGraphics */, node: N, bounds: any/* Rectangle */, shape: any/* Shape */, model: TreeMapModel<N, Row, Column>): void;
    paintParentHighlight<N, Row, Column>(g2: any/* TGraphics */, view: any/* TreeMapView<N, Row, Column> */, node: N, pass: number, bounds: any/* Rectangle */, shape: Nullable<any>/* Nullable<Shape> */): void;
    readonly __doNotUseOrImplementIt: Rendering["__doNotUseOrImplementIt"];
}
export declare namespace FlatRendering {
    /** @deprecated $metadata$ is used for internal purposes, please don't use it in your code, because it can be removed at any moment */
    namespace $metadata$ {
        const constructor: abstract new () => FlatRendering;
    }
}
export declare class OverridingTreeMapColumnSettings /* extends AbstractTreeMapColumnSettings */ implements TreeMapColumnSettings {
    constructor(defaultSettings: TreeMapColumnSettings);
    get properties(): any/* OverrideProperties<TreeMapColumnPropertyType> */;
    isDefaults(): boolean;
    isOverrideDefaults(): boolean;
    getOverrideDefaultsProperty(): any/* MutableProperty<boolean> */;
    setOverrideDefaults(overrideDefaults: boolean): void;
    getAlgorithmProperty(): any/* MutableProperty<Nullable<Algorithm>> */;
    getAlgorithm(): Algorithm;
    setAlgorithm(algorithm: Nullable<Algorithm>): void;
    getAggregationProperty(): any/* MutableProperty<Nullable<Aggregation>> */;
    getAggregation(): Nullable<any>/* Nullable<Aggregation> */;
    setAggregation(aggregation: Nullable<any>/* Nullable<Aggregation> */): void;
    getScaleProperty(): any/* MutableProperty<Nullable<Scale>> */;
    getScale(): Nullable<any>/* Nullable<Scale> */;
    setScale(scale: Nullable<any>/* Nullable<Scale> */): void;
    getNestingProperty(): any/* MutableProperty<Nullable<Nesting>> */;
    getNesting(): Nullable<any>/* Nullable<Nesting> */;
    setNesting(nesting: Nullable<any>/* Nullable<Nesting> */): void;
    getOrderingProperty(): any/* MutableProperty<Nullable<Ordering>> */;
    getOrdering(): any/* Ordering */;
    setOrdering(ordering: Nullable<any>/* Nullable<Ordering> */): void;
    getOrderingDirectionProperty(): any/* MutableProperty<Nullable<Ordering.SortOrder>> */;
    getOrderingDirection(): Nullable<any>/* Nullable<Ordering.SortOrder> */;
    setOrderingDirection(ordering: Nullable<any>/* Nullable<Ordering.SortOrder> */): void;
    getOrderingVerticalVanishingPointProperty(): any/* MutableProperty<number> */;
    getOrderingVerticalVanishingPoint(): number;
    setOrderingVerticalVanishingPoint(verticalVanishingPoint: number): void;
    getOrderingHorizontalVanishingPointProperty(): any/* MutableProperty<number> */;
    getOrderingHorizontalVanishingPoint(): number;
    setOrderingHorizontalVanishingPoint(horizontalVanishingPoint: number): void;
    getLabelingProperty(): any/* MutableProperty<Nullable<Labeling>> */;
    getLabeling(): Nullable<any>/* Nullable<Labeling> */;
    setLabeling(labeling: Nullable<any>/* Nullable<Labeling> */): void;
    getLabelingFontProperty(): any/* MutableProperty<Nullable<CPFont>> */;
    getLabelingFont(): any/* CPFont */;
    setLabelingFont(font: Nullable<any>/* Nullable<CPFont> */): void;
    getLabelingForegroundProperty(): any/* MutableProperty<Nullable<CPColor>> */;
    getLabelingForeground(): any/* CPColor */;
    setLabelingForeground(color: Nullable<any>/* Nullable<CPColor> */): void;
    getLabelingEffectColorProperty(): any/* MutableProperty<Nullable<CPColor>> */;
    getLabelingEffectColor(): Nullable<any>/* Nullable<CPColor> */;
    setLabelingEffectColor(color: Nullable<any>/* Nullable<CPColor> */): void;
    getLabelingEffectProperty(): any/* MutableProperty<Nullable<EnhancedLabel.Effect>> */;
    getLabelingEffect(): Nullable<EnhancedLabel.Effect>;
    setLabelingEffect(effect: Nullable<EnhancedLabel.Effect>): void;
    getLabelingHorizontalAlignmentProperty(): any/* MutableProperty<number> */;
    getLabelingHorizontalAlignment(): number;
    setLabelingHorizontalAlignment(alignment: number): void;
    getLabelingVerticalAlignmentProperty(): any/* MutableProperty<number> */;
    getLabelingVerticalAlignment(): number;
    setLabelingVerticalAlignment(alignment: number): void;
    getLabelingRenderingProperty(): any/* MutableProperty<Nullable<EnhancedLabel.Rendering>> */;
    getLabelingRendering(): EnhancedLabel.Rendering;
    setLabelingRendering(rendering: Nullable<EnhancedLabel.Rendering>): void;
    getLabelingMinimumCharactersToDisplayProperty(): any/* MutableProperty<Nullable<number>> */;
    getLabelingMinimumCharactersToDisplay(): number;
    setLabelingMinimumCharactersToDisplay(minimumCharactersToDisplay: Nullable<number>): void;
    getLabelingEffectOpacityProperty(): any/* MutableProperty<Nullable<number>> */;
    getLabelingEffectOpacity(): Nullable<number>;
    setLabelingEffectOpacity(opacity: Nullable<number>): void;
    getLabelingShrinkTextToFitShapeProperty(): any/* MutableProperty<boolean> */;
    getLabelingShrinkTextToFitShape(): boolean;
    setLabelingShrinkTextToFitShape(labelingShrinkTextToFitShape: boolean): void;
    getLabelingResizeTextToFitShapeProperty(): any/* MutableProperty<boolean> */;
    getLabelingResizeTextToFitShape(): boolean;
    setLabelingResizeTextToFitShape(labelingResizeTextToFitShape: boolean): void;
    getLabelingFloatProperty(): any/* MutableProperty<Nullable<boolean>> */;
    getLabelingFloat(): boolean;
    setLabelingFloat(labelingFloat: Nullable<boolean>): void;
    getLabelingContrastEnhancementProperty(): any/* MutableProperty<Nullable<ContrastEnhancement>> */;
    getLabelingContrastEnhancement(): any/* ContrastEnhancement */;
    setLabelingContrastEnhancement(contrastEnhancement: Nullable<any>/* Nullable<ContrastEnhancement> */): void;
    getNestingAmountProperty(): any/* MutableProperty<Nullable<number>> */;
    getNestingAmount(): number;
    setNestingAmount(amount: Nullable<number>): void;
    getNestingBackgroundProperty(): any/* MutableProperty<Nullable<CPColor>> */;
    getNestingBackground(): any/* CPColor */;
    setNestingBackground(color: Nullable<any>/* Nullable<CPColor> */): void;
    getHeaderFontProperty(): any/* MutableProperty<Nullable<CPFont>> */;
    getHeaderFont(): any/* CPFont */;
    setHeaderFont(font: Nullable<any>/* Nullable<CPFont> */): void;
    getHeaderForegroundProperty(): any/* MutableProperty<Nullable<CPColor>> */;
    getHeaderForeground(): any/* CPColor */;
    setHeaderForeground(color: Nullable<any>/* Nullable<CPColor> */): void;
    getHeaderBackgroundProperty(): any/* MutableProperty<Nullable<CPColor>> */;
    getHeaderBackground(): any/* CPColor */;
    setHeaderBackground(color: Nullable<any>/* Nullable<CPColor> */): void;
    getHeaderEffectColorProperty(): any/* MutableProperty<Nullable<CPColor>> */;
    getHeaderEffectColor(): any/* CPColor */;
    setHeaderEffectColor(color: Nullable<any>/* Nullable<CPColor> */): void;
    getHeaderEffectProperty(): any/* MutableProperty<Nullable<EnhancedLabel.Effect>> */;
    getHeaderEffect(): Nullable<EnhancedLabel.Effect>;
    setHeaderEffect(effect: Nullable<EnhancedLabel.Effect>): void;
    getHeaderHorizontalAlignmentProperty(): any/* MutableProperty<number> */;
    getHeaderHorizontalAlignment(): number;
    setHeaderHorizontalAlignment(alignment: number): void;
    getHeaderVerticalAlignmentProperty(): any/* MutableProperty<number> */;
    getHeaderVerticalAlignment(): number;
    setHeaderVerticalAlignment(alignment: number): void;
    getHeaderRenderingProperty(): any/* MutableProperty<Nullable<EnhancedLabel.Rendering>> */;
    getHeaderRendering(): Nullable<EnhancedLabel.Rendering>;
    setHeaderRendering(rendering: Nullable<EnhancedLabel.Rendering>): void;
    getHeaderMinimumCharactersToDisplayProperty(): any/* MutableProperty<Nullable<number>> */;
    getHeaderMinimumCharactersToDisplay(): Nullable<number>;
    setHeaderMinimumCharactersToDisplay(minimumCharactersToDisplay: Nullable<number>): void;
    getHeaderEffectOpacityProperty(): any/* MutableProperty<Nullable<number>> */;
    getHeaderEffectOpacity(): Nullable<number>;
    setHeaderEffectOpacity(opacity: Nullable<number>): void;
    getHeaderInsetsProperty(): any/* MutableProperty<Nullable<Insets>> */;
    getHeaderInsets(): Nullable<any>/* Nullable<Insets> */;
    setHeaderInsets(insets: Nullable<any>/* Nullable<Insets> */): void;
    getTooltipFontProperty(): any/* MutableProperty<Nullable<CPFont>> */;
    getTooltipFont(): any/* CPFont */;
    setTooltipFont(font: Nullable<any>/* Nullable<CPFont> */): void;
    getTooltipForegroundProperty(): any/* MutableProperty<Nullable<CPColor>> */;
    getTooltipForeground(): Nullable<any>/* Nullable<CPColor> */;
    setTooltipForeground(color: Nullable<any>/* Nullable<CPColor> */): void;
    getTooltipRenderingProperty(): any/* MutableProperty<Nullable<EnhancedLabel.Rendering>> */;
    getTooltipRendering(): Nullable<EnhancedLabel.Rendering>;
    setTooltipRendering(rendering: Nullable<EnhancedLabel.Rendering>): void;
    getBorderColorProperty(): any/* MutableProperty<Nullable<CPColor>> */;
    getBorderColor(): Nullable<any>/* Nullable<CPColor> */;
    setBorderColor(color: Nullable<any>/* Nullable<CPColor> */): void;
    getBorderThicknessInterval(): Nullable<any>/* Nullable<MutableBoundedInterval> */;
    getBorderThicknessProperty(): any/* MutableProperty<number> */;
    getBorderThickness(): number;
    setBorderThickness(value: number): void;
    getShowLabelProperty(): any/* MutableProperty<boolean> */;
    getShowLabel(): boolean;
    getFormatProperty(): any/* MutableProperty<Nullable<CPFormat<Nullable<any>>>> */;
    setShowLabel(show: boolean): void;
    getFormat(): Nullable<any>/* Nullable<CPFormat<Nullable<any>>> */;
    getColorMapProperty(): any/* MutableProperty<Nullable<MutableColorMap>> */;
    setFormat(format: Nullable<any>/* Nullable<CPFormat<Nullable<any>>> */): void;
    getColorMap(): Nullable<MutableColorMap>;
    setColorMap(colorMap: Nullable<MutableColorMap>): void;
    getProperty(key: TreeMapColumnPropertyType): Nullable<any>;
    getPropertyOverride(key: TreeMapColumnPropertyType): Nullable<any>;
    setProperty(key: TreeMapColumnPropertyType, value: Nullable<any>): void;
    setPropertyOverride(key: TreeMapColumnPropertyType, value: Nullable<any>): void;
    reset(): void;
    readonly __doNotUseOrImplementIt: TreeMapColumnSettings["__doNotUseOrImplementIt"];
}
export declare namespace OverridingTreeMapColumnSettings {
    /** @deprecated $metadata$ is used for internal purposes, please don't use it in your code, because it can be removed at any moment */
    namespace $metadata$ {
        const constructor: abstract new () => OverridingTreeMapColumnSettings;
    }
}
export declare interface Rendering {
    getPasses<N, Row, Column>(model: TreeMapModel<N, Row, Column>): number;
    paintParent<N, Row, Column>(g: any/* TGraphics */, view: any/* TreeMapView<N, Row, Column> */, node: N, pass: number, bounds: any/* Rectangle */, shape: any/* Shape */): void;
    paintParentBorder<N, Row, Column>(g: any/* TGraphics */, node: N, bounds: any/* Rectangle */, shape: any/* Shape */, model: TreeMapModel<N, Row, Column>): void;
    paintNode<N, Row, Column>(g: any/* TGraphics */, view: any/* TreeMapView<N, Row, Column> */, node: N, pass: number, bounds: any/* Rectangle */, shape: any/* Shape */): boolean;
    paintBackground<N, Row, Column>(g: any/* TGraphics */, view: any/* TreeMapView<N, Row, Column> */, node: N, pass: number, passes: number, bounds: any/* Rectangle */, shape: any/* Shape */): void;
    paintLabel<N, Row, Column>(g: any/* TGraphics */, view: any/* TreeMapView<N, Row, Column> */, node: N, pass: number, passes: number, bounds: any/* Rectangle */, shape: any/* Shape */): void;
    paintParentHighlight<N, Row, Column>(g2: any/* TGraphics */, view: any/* TreeMapView<N, Row, Column> */, node: N, pass: number, bounds: any/* Rectangle */, shape: Nullable<any>/* Nullable<Shape> */): void;
    paintBorder<N, Row, Column>(g2: any/* TGraphics */, view: any/* TreeMapView<N, Row, Column> */, node: N, pass: number, bounds: any/* Rectangle */, shape: any/* Shape */): void;
    getParentOrder<N, Row, Column>(view: any/* TreeMapView<N, Row, Column> */, root: N, pass: number): any/* Iterable<N> */;
    getOrder<N, Row, Column>(view: any/* TreeMapView<N, Row, Column> */, root: N, pass: number): any/* Iterable<N> */;
    getRenderedShape<N, Row, Column>(view: any/* TreeMapView<N, Row, Column> */, model: TreeMapModel<N, Row, Column>, node: N, shape: any/* Shape */): any/* Shape */;
    getNestingBackground<N, Row, Column>(node: N, model: TreeMapModel<N, Row, Column>): Nullable<any>/* Nullable<CPColor> */;
    readonly __doNotUseOrImplementIt: {
        readonly "com.treemap.Rendering": unique symbol;
    };
}
export declare class RenderingFactory {
    private constructor();
    add(entry: Rendering): void;
    getDefault(): Rendering;
    getRenderings(): KtList<Rendering>;
    get(name: Nullable<string>): Rendering;
}
export declare namespace RenderingFactory {
    /** @deprecated $metadata$ is used for internal purposes, please don't use it in your code, because it can be removed at any moment */
    namespace $metadata$ {
        const constructor: abstract new () => RenderingFactory;
    }
    abstract class Companion extends KtSingleton<Companion.$metadata$.constructor>() {
        private constructor();
    }
    namespace Companion {
        /** @deprecated $metadata$ is used for internal purposes, please don't use it in your code, because it can be removed at any moment */
        namespace $metadata$ {
            abstract class constructor {
                get CUSHION(): Rendering;
                get FLAT(): Rendering;
                get FLAT_NO_BORDER(): Rendering;
                get instance(): RenderingFactory;
                private constructor();
            }
        }
    }
}
export declare interface TreeMap<N, Row, Column> {
    readonly component: any/* CPComponent */;
    model: Nullable<TreeMapModel<N, Row, Column>>;
    view: Nullable<any>/* Nullable<TreeMapView<N, Row, Column>> */;
    controller: Nullable<any>/* Nullable<TreeMapController<N, Row, Column>> */;
    setGroupBy(columns: Int32Array): void;
    setGroupByByNames(columnNames: Array<Nullable<string>>): void;
    setLabels(columns: Int32Array): void;
    setLabelsByNames(columnNames: Array<Nullable<string>>): void;
    setBackground(column: number): void;
    setBackgroundByName(columnName: Nullable<string>): void;
    setSize(column: number): void;
    setSizeByName(columnName: Nullable<string>): void;
    setColor(column: number): void;
    setColorByName(columnName: Nullable<string>): void;
    setHeight(column: number): void;
    setHeightByName(columnName: Nullable<string>): void;
    setToolTip(columns: Int32Array): void;
    setToolTipByNames(columnNames: Array<Nullable<string>>): void;
    setAlgorithm(algorithm: Nullable<Algorithm>): void;
    setAggregation(aggregation: Nullable<any>/* Nullable<Aggregation> */): void;
    setScale(scale: Nullable<any>/* Nullable<Scale> */): void;
    setNesting(nesting: Nullable<any>/* Nullable<Nesting> */): void;
    setOrdering(ordering: Nullable<any>/* Nullable<Ordering> */): void;
    setDepth(depth: Nullable<any>/* Nullable<Depth> */): void;
    setLabeling(labeling: Nullable<any>/* Nullable<Labeling> */): void;
    setRendering(rendering: Nullable<Rendering>): void;
    setLightSourceHeight(value: number): void;
    setLightSourceAmbient(value: number): void;
    setLightSourceX(value: number): void;
    setLightSourceY(value: number): void;
    setLightSourceZ(value: number): void;
    setLabelingFont(font: Nullable<any>/* Nullable<CPFont> */): void;
    setLabelingForegroundColor(color: Nullable<any>/* Nullable<CPColor> */): void;
    setLabelingBackgroundColor(color: Nullable<any>/* Nullable<CPColor> */): void;
    setHeaderFont(font: Nullable<any>/* Nullable<CPFont> */): void;
    setHeaderForegroundColor(color: Nullable<any>/* Nullable<CPColor> */): void;
    setHeaderBackgroundColor(color: Nullable<any>/* Nullable<CPColor> */): void;
    readonly __doNotUseOrImplementIt: {
        readonly "com.treemap.TreeMap": unique symbol;
    };
}
export declare abstract class TreeMapColumnPropertyType {
    private constructor();
    static get algorithm(): TreeMapColumnPropertyType & {
        get name(): "algorithm";
        get ordinal(): 0;
    };
    static get aggregation(): TreeMapColumnPropertyType & {
        get name(): "aggregation";
        get ordinal(): 1;
    };
    static get scale(): TreeMapColumnPropertyType & {
        get name(): "scale";
        get ordinal(): 2;
    };
    static get nesting(): TreeMapColumnPropertyType & {
        get name(): "nesting";
        get ordinal(): 3;
    };
    static get ordering(): TreeMapColumnPropertyType & {
        get name(): "ordering";
        get ordinal(): 4;
    };
    static get orderingDirection(): TreeMapColumnPropertyType & {
        get name(): "orderingDirection";
        get ordinal(): 5;
    };
    static get orderingVerticalVanishingPoint(): TreeMapColumnPropertyType & {
        get name(): "orderingVerticalVanishingPoint";
        get ordinal(): 6;
    };
    static get orderingHorizontalVanishingPoint(): TreeMapColumnPropertyType & {
        get name(): "orderingHorizontalVanishingPoint";
        get ordinal(): 7;
    };
    static get labeling(): TreeMapColumnPropertyType & {
        get name(): "labeling";
        get ordinal(): 8;
    };
    static get labelingForeground(): TreeMapColumnPropertyType & {
        get name(): "labelingForeground";
        get ordinal(): 9;
    };
    static get labelingEffectColor(): TreeMapColumnPropertyType & {
        get name(): "labelingEffectColor";
        get ordinal(): 10;
    };
    static get labelingFont(): TreeMapColumnPropertyType & {
        get name(): "labelingFont";
        get ordinal(): 11;
    };
    static get labelingEffect(): TreeMapColumnPropertyType & {
        get name(): "labelingEffect";
        get ordinal(): 12;
    };
    static get labelingHorizontalAlignment(): TreeMapColumnPropertyType & {
        get name(): "labelingHorizontalAlignment";
        get ordinal(): 13;
    };
    static get labelingVerticalAlignment(): TreeMapColumnPropertyType & {
        get name(): "labelingVerticalAlignment";
        get ordinal(): 14;
    };
    static get labelingRendering(): TreeMapColumnPropertyType & {
        get name(): "labelingRendering";
        get ordinal(): 15;
    };
    static get labelingMinimumCharactersToDisplay(): TreeMapColumnPropertyType & {
        get name(): "labelingMinimumCharactersToDisplay";
        get ordinal(): 16;
    };
    static get labelingEffectOpacity(): TreeMapColumnPropertyType & {
        get name(): "labelingEffectOpacity";
        get ordinal(): 17;
    };
    static get labelingShrinkTextToFitShape(): TreeMapColumnPropertyType & {
        get name(): "labelingShrinkTextToFitShape";
        get ordinal(): 18;
    };
    static get labelingResizeTextToFitShape(): TreeMapColumnPropertyType & {
        get name(): "labelingResizeTextToFitShape";
        get ordinal(): 19;
    };
    static get labelingFloat(): TreeMapColumnPropertyType & {
        get name(): "labelingFloat";
        get ordinal(): 20;
    };
    static get labelingContrastEnhancement(): TreeMapColumnPropertyType & {
        get name(): "labelingContrastEnhancement";
        get ordinal(): 21;
    };
    static get nestingAmount(): TreeMapColumnPropertyType & {
        get name(): "nestingAmount";
        get ordinal(): 22;
    };
    static get nestingBackground(): TreeMapColumnPropertyType & {
        get name(): "nestingBackground";
        get ordinal(): 23;
    };
    static get headerForeground(): TreeMapColumnPropertyType & {
        get name(): "headerForeground";
        get ordinal(): 24;
    };
    static get headerEffectColor(): TreeMapColumnPropertyType & {
        get name(): "headerEffectColor";
        get ordinal(): 25;
    };
    static get headerBackground(): TreeMapColumnPropertyType & {
        get name(): "headerBackground";
        get ordinal(): 26;
    };
    static get headerFont(): TreeMapColumnPropertyType & {
        get name(): "headerFont";
        get ordinal(): 27;
    };
    static get headerEffect(): TreeMapColumnPropertyType & {
        get name(): "headerEffect";
        get ordinal(): 28;
    };
    static get headerHorizontalAlignment(): TreeMapColumnPropertyType & {
        get name(): "headerHorizontalAlignment";
        get ordinal(): 29;
    };
    static get headerVerticalAlignment(): TreeMapColumnPropertyType & {
        get name(): "headerVerticalAlignment";
        get ordinal(): 30;
    };
    static get headerRendering(): TreeMapColumnPropertyType & {
        get name(): "headerRendering";
        get ordinal(): 31;
    };
    static get headerMinimumCharactersToDisplay(): TreeMapColumnPropertyType & {
        get name(): "headerMinimumCharactersToDisplay";
        get ordinal(): 32;
    };
    static get headerEffectOpacity(): TreeMapColumnPropertyType & {
        get name(): "headerEffectOpacity";
        get ordinal(): 33;
    };
    static get headerInsets(): TreeMapColumnPropertyType & {
        get name(): "headerInsets";
        get ordinal(): 34;
    };
    static get tooltipForeground(): TreeMapColumnPropertyType & {
        get name(): "tooltipForeground";
        get ordinal(): 35;
    };
    static get tooltipFont(): TreeMapColumnPropertyType & {
        get name(): "tooltipFont";
        get ordinal(): 36;
    };
    static get tooltipRendering(): TreeMapColumnPropertyType & {
        get name(): "tooltipRendering";
        get ordinal(): 37;
    };
    static get borderColor(): TreeMapColumnPropertyType & {
        get name(): "borderColor";
        get ordinal(): 38;
    };
    static get borderThickness(): TreeMapColumnPropertyType & {
        get name(): "borderThickness";
        get ordinal(): 39;
    };
    static get format(): TreeMapColumnPropertyType & {
        get name(): "format";
        get ordinal(): 40;
    };
    static get showLabel(): TreeMapColumnPropertyType & {
        get name(): "showLabel";
        get ordinal(): 41;
    };
    static get colormap(): TreeMapColumnPropertyType & {
        get name(): "colormap";
        get ordinal(): 42;
    };
    static get overrideDefaults(): TreeMapColumnPropertyType & {
        get name(): "overrideDefaults";
        get ordinal(): 43;
    };
    get name(): "algorithm" | "aggregation" | "scale" | "nesting" | "ordering" | "orderingDirection" | "orderingVerticalVanishingPoint" | "orderingHorizontalVanishingPoint" | "labeling" | "labelingForeground" | "labelingEffectColor" | "labelingFont" | "labelingEffect" | "labelingHorizontalAlignment" | "labelingVerticalAlignment" | "labelingRendering" | "labelingMinimumCharactersToDisplay" | "labelingEffectOpacity" | "labelingShrinkTextToFitShape" | "labelingResizeTextToFitShape" | "labelingFloat" | "labelingContrastEnhancement" | "nestingAmount" | "nestingBackground" | "headerForeground" | "headerEffectColor" | "headerBackground" | "headerFont" | "headerEffect" | "headerHorizontalAlignment" | "headerVerticalAlignment" | "headerRendering" | "headerMinimumCharactersToDisplay" | "headerEffectOpacity" | "headerInsets" | "tooltipForeground" | "tooltipFont" | "tooltipRendering" | "borderColor" | "borderThickness" | "format" | "showLabel" | "colormap" | "overrideDefaults";
    get ordinal(): 0 | 1 | 2 | 3 | 4 | 5 | 6 | 7 | 8 | 9 | 10 | 11 | 12 | 13 | 14 | 15 | 16 | 17 | 18 | 19 | 20 | 21 | 22 | 23 | 24 | 25 | 26 | 27 | 28 | 29 | 30 | 31 | 32 | 33 | 34 | 35 | 36 | 37 | 38 | 39 | 40 | 41 | 42 | 43;
    static values(): Array<TreeMapColumnPropertyType>;
    static valueOf(value: string): TreeMapColumnPropertyType;
}
export declare namespace TreeMapColumnPropertyType {
    /** @deprecated $metadata$ is used for internal purposes, please don't use it in your code, because it can be removed at any moment */
    namespace $metadata$ {
        const constructor: abstract new () => TreeMapColumnPropertyType;
    }
}
export declare interface TreeMapColumnSettings {
    readonly properties: any/* MutableProperties<TreeMapColumnPropertyType> */;
    getAlgorithmProperty(): any/* MutableProperty<Nullable<Algorithm>> */;
    getAlgorithm(): Algorithm;
    setAlgorithm(algorithm: Nullable<Algorithm>): void;
    getAggregationProperty(): any/* MutableProperty<Nullable<Aggregation>> */;
    getAggregation(): Nullable<any>/* Nullable<Aggregation> */;
    setAggregation(aggregation: Nullable<any>/* Nullable<Aggregation> */): void;
    getScaleProperty(): any/* MutableProperty<Nullable<Scale>> */;
    getScale(): Nullable<any>/* Nullable<Scale> */;
    setScale(scale: Nullable<any>/* Nullable<Scale> */): void;
    getNestingProperty(): any/* MutableProperty<Nullable<Nesting>> */;
    getNesting(): Nullable<any>/* Nullable<Nesting> */;
    setNesting(nesting: Nullable<any>/* Nullable<Nesting> */): void;
    getOrderingProperty(): any/* MutableProperty<Nullable<Ordering>> */;
    getOrdering(): any/* Ordering */;
    setOrdering(ordering: Nullable<any>/* Nullable<Ordering> */): void;
    getOrderingDirectionProperty(): any/* MutableProperty<Nullable<Ordering.SortOrder>> */;
    getOrderingDirection(): Nullable<any>/* Nullable<Ordering.SortOrder> */;
    setOrderingDirection(ordering: Nullable<any>/* Nullable<Ordering.SortOrder> */): void;
    getOrderingVerticalVanishingPointProperty(): any/* MutableProperty<number> */;
    getOrderingVerticalVanishingPoint(): number;
    setOrderingVerticalVanishingPoint(verticalVanishingPoint: number): void;
    getOrderingHorizontalVanishingPointProperty(): any/* MutableProperty<number> */;
    getOrderingHorizontalVanishingPoint(): number;
    setOrderingHorizontalVanishingPoint(alignment: number): void;
    getLabelingProperty(): any/* MutableProperty<Nullable<Labeling>> */;
    getLabeling(): Nullable<any>/* Nullable<Labeling> */;
    setLabeling(labeling: Nullable<any>/* Nullable<Labeling> */): void;
    getLabelingFontProperty(): any/* MutableProperty<Nullable<CPFont>> */;
    getLabelingFont(): Nullable<any>/* Nullable<CPFont> */;
    setLabelingFont(font: Nullable<any>/* Nullable<CPFont> */): void;
    getLabelingForegroundProperty(): any/* MutableProperty<Nullable<CPColor>> */;
    getLabelingForeground(): Nullable<any>/* Nullable<CPColor> */;
    setLabelingForeground(color: Nullable<any>/* Nullable<CPColor> */): void;
    getLabelingEffectColorProperty(): any/* MutableProperty<Nullable<CPColor>> */;
    getLabelingEffectColor(): Nullable<any>/* Nullable<CPColor> */;
    setLabelingEffectColor(color: Nullable<any>/* Nullable<CPColor> */): void;
    getLabelingEffectProperty(): any/* MutableProperty<Nullable<EnhancedLabel.Effect>> */;
    getLabelingEffect(): Nullable<EnhancedLabel.Effect>;
    setLabelingEffect(effect: Nullable<EnhancedLabel.Effect>): void;
    getLabelingHorizontalAlignmentProperty(): any/* MutableProperty<number> */;
    getLabelingHorizontalAlignment(): number;
    setLabelingHorizontalAlignment(alignment: number): void;
    getLabelingVerticalAlignmentProperty(): any/* MutableProperty<number> */;
    getLabelingVerticalAlignment(): number;
    setLabelingVerticalAlignment(alignment: number): void;
    getLabelingRenderingProperty(): any/* MutableProperty<Nullable<EnhancedLabel.Rendering>> */;
    getLabelingRendering(): Nullable<EnhancedLabel.Rendering>;
    setLabelingRendering(rendering: Nullable<EnhancedLabel.Rendering>): void;
    getLabelingMinimumCharactersToDisplayProperty(): any/* MutableProperty<Nullable<number>> */;
    getLabelingMinimumCharactersToDisplay(): Nullable<number>;
    setLabelingMinimumCharactersToDisplay(minimumCharactersToDisplay: Nullable<number>): void;
    getLabelingEffectOpacityProperty(): any/* MutableProperty<Nullable<number>> */;
    getLabelingEffectOpacity(): Nullable<number>;
    setLabelingEffectOpacity(opacity: Nullable<number>): void;
    getLabelingShrinkTextToFitShapeProperty(): any/* MutableProperty<boolean> */;
    getLabelingShrinkTextToFitShape(): Nullable<boolean>;
    setLabelingShrinkTextToFitShape(labelingShrinkTextToFitShape: boolean): void;
    getLabelingResizeTextToFitShapeProperty(): any/* MutableProperty<boolean> */;
    getLabelingResizeTextToFitShape(): Nullable<boolean>;
    setLabelingResizeTextToFitShape(labelingResizeTextToFitShape: boolean): void;
    getLabelingFloatProperty(): any/* MutableProperty<Nullable<boolean>> */;
    getLabelingFloat(): Nullable<boolean>;
    setLabelingFloat(labelingFloat: Nullable<boolean>): void;
    getLabelingContrastEnhancementProperty(): any/* MutableProperty<Nullable<ContrastEnhancement>> */;
    getLabelingContrastEnhancement(): Nullable<any>/* Nullable<ContrastEnhancement> */;
    setLabelingContrastEnhancement(contrastEnhancement: Nullable<any>/* Nullable<ContrastEnhancement> */): void;
    getNestingAmountProperty(): any/* MutableProperty<Nullable<number>> */;
    getNestingAmount(): Nullable<number>;
    setNestingAmount(amount: Nullable<number>): void;
    getNestingBackgroundProperty(): any/* MutableProperty<Nullable<CPColor>> */;
    getNestingBackground(): Nullable<any>/* Nullable<CPColor> */;
    setNestingBackground(color: Nullable<any>/* Nullable<CPColor> */): void;
    getHeaderFontProperty(): any/* MutableProperty<Nullable<CPFont>> */;
    getHeaderFont(): Nullable<any>/* Nullable<CPFont> */;
    setHeaderFont(font: Nullable<any>/* Nullable<CPFont> */): void;
    getHeaderForegroundProperty(): any/* MutableProperty<Nullable<CPColor>> */;
    getHeaderForeground(): Nullable<any>/* Nullable<CPColor> */;
    setHeaderForeground(color: Nullable<any>/* Nullable<CPColor> */): void;
    getHeaderBackgroundProperty(): any/* MutableProperty<Nullable<CPColor>> */;
    getHeaderBackground(): Nullable<any>/* Nullable<CPColor> */;
    setHeaderBackground(color: Nullable<any>/* Nullable<CPColor> */): void;
    getHeaderEffectColorProperty(): any/* MutableProperty<Nullable<CPColor>> */;
    getHeaderEffectColor(): Nullable<any>/* Nullable<CPColor> */;
    setHeaderEffectColor(color: Nullable<any>/* Nullable<CPColor> */): void;
    getHeaderEffectProperty(): any/* MutableProperty<Nullable<EnhancedLabel.Effect>> */;
    getHeaderEffect(): Nullable<EnhancedLabel.Effect>;
    setHeaderEffect(effect: Nullable<EnhancedLabel.Effect>): void;
    getHeaderHorizontalAlignmentProperty(): any/* MutableProperty<number> */;
    getHeaderHorizontalAlignment(): number;
    setHeaderHorizontalAlignment(alignment: number): void;
    getHeaderVerticalAlignmentProperty(): any/* MutableProperty<number> */;
    getHeaderVerticalAlignment(): number;
    setHeaderVerticalAlignment(alignment: number): void;
    getHeaderRenderingProperty(): any/* MutableProperty<Nullable<EnhancedLabel.Rendering>> */;
    getHeaderRendering(): Nullable<EnhancedLabel.Rendering>;
    setHeaderRendering(rendering: Nullable<EnhancedLabel.Rendering>): void;
    getHeaderMinimumCharactersToDisplayProperty(): any/* MutableProperty<Nullable<number>> */;
    getHeaderMinimumCharactersToDisplay(): Nullable<number>;
    setHeaderMinimumCharactersToDisplay(minimumCharactersToDisplay: Nullable<number>): void;
    getHeaderEffectOpacityProperty(): any/* MutableProperty<Nullable<number>> */;
    getHeaderEffectOpacity(): Nullable<number>;
    setHeaderEffectOpacity(opacity: Nullable<number>): void;
    getHeaderInsetsProperty(): any/* MutableProperty<Nullable<Insets>> */;
    getHeaderInsets(): Nullable<any>/* Nullable<Insets> */;
    setHeaderInsets(insets: Nullable<any>/* Nullable<Insets> */): void;
    getTooltipFontProperty(): any/* MutableProperty<Nullable<CPFont>> */;
    getTooltipFont(): Nullable<any>/* Nullable<CPFont> */;
    setTooltipFont(font: Nullable<any>/* Nullable<CPFont> */): void;
    getTooltipForegroundProperty(): any/* MutableProperty<Nullable<CPColor>> */;
    getTooltipForeground(): Nullable<any>/* Nullable<CPColor> */;
    setTooltipForeground(color: Nullable<any>/* Nullable<CPColor> */): void;
    getTooltipRenderingProperty(): Nullable<any>/* Nullable<MutableProperty<Nullable<EnhancedLabel.Rendering>>> */;
    getTooltipRendering(): Nullable<EnhancedLabel.Rendering>;
    setTooltipRendering(rendering: Nullable<EnhancedLabel.Rendering>): void;
    getBorderColorProperty(): any/* MutableProperty<Nullable<CPColor>> */;
    getBorderColor(): Nullable<any>/* Nullable<CPColor> */;
    setBorderColor(color: Nullable<any>/* Nullable<CPColor> */): void;
    getBorderThicknessInterval(): Nullable<any>/* Nullable<MutableBoundedInterval> */;
    getBorderThickness(): number;
    setBorderThickness(value: number): void;
    getFormatProperty(): any/* MutableProperty<Nullable<CPFormat<Nullable<any>>>> */;
    getFormat(): Nullable<any>/* Nullable<CPFormat<Nullable<any>>> */;
    setFormat(format: Nullable<any>/* Nullable<CPFormat<Nullable<any>>> */): void;
    getShowLabelProperty(): any/* MutableProperty<boolean> */;
    getShowLabel(): boolean;
    setShowLabel(show: boolean): void;
    getColorMapProperty(): Nullable<any>/* Nullable<MutableProperty<Nullable<MutableColorMap>>> */;
    getColorMap(): Nullable<MutableColorMap>;
    setColorMap(colorMap: Nullable<MutableColorMap>): void;
    getProperty(key: TreeMapColumnPropertyType): Nullable<any>;
    setProperty(property: TreeMapColumnPropertyType, value: Nullable<any>): void;
    isDefaults(): boolean;
    isOverrideDefaults(): boolean;
    getOverrideDefaultsProperty(): Nullable<any>/* Nullable<MutableProperty<boolean>> */;
    setOverrideDefaults(overrideDefaults: boolean): void;
    getPropertyOverride(key: TreeMapColumnPropertyType): Nullable<any>;
    reset(): void;
    readonly __doNotUseOrImplementIt: {
        readonly "com.treemap.TreeMapColumnSettings": unique symbol;
    };
}
export declare interface TreeMapModel<N, Row, Column> extends TreeMapAccessor<N> {
    readonly dataFrame: Nullable<any>/* Nullable<DataFrame<Row, Column, UnknownType *>> */;
    readonly properties: any/* MutableProperties<Nullable<string>> */;
    readonly groupByColumns: any/* Iterable<Nullable<Column>> */;
    readonly sizeColumns: any/* Iterable<Nullable<Column>> */;
    readonly colorColumns: any/* Iterable<Nullable<Column>> */;
    readonly heightColumns: any/* Iterable<Nullable<Column>> */;
    readonly labelsColumns: any/* Iterable<Nullable<Column>> */;
    readonly tooltipColumns: any/* Iterable<Nullable<Column>> */;
    isNumericType(column: Column): boolean;
    isTemporalType(column: Column): boolean;
    isVisualType(column: Column): boolean;
    getColorMap(column: Nullable<Column>): Nullable<MutableColorMap>;
    getCategoricalColorMap(column: Column): MutableColorMap;
    getPredefinedColorMap(column: Column): MutableColorMap;
    getCustomColorMap(column: Column): MutableColorMap;
    createDefaultColorMap(column: Column): Nullable<MutableColorMap>;
    readonly maximumSize: number;
    setNestedShape(node: N, shape: Nullable<any>/* Nullable<Shape> */): void;
    getNestedShape(node: N): Nullable<any>/* Nullable<Shape> */;
    getGroupByColumn(node: N): Nullable<Column>;
    getChildrenGroupByColumn(node: N): Nullable<Column>;
    getLabelName(node: N): Nullable<string>;
    colorProvider: any/* ColorProvider<N> */;
    setColor(node: N, color: Nullable<any>/* Nullable<CPColor> */): void;
    getColor(node: N): Nullable<any>/* Nullable<CPColor> */;
    isLeaf(node: N): boolean;
    getParent(node: N): Nullable<N>;
    isRoot(node: N): boolean;
    getChildren(parent: N): any/* Iterable<N> */;
    getChildrenOfTypeParent(parent: N): any/* Iterable<N> */;
    getChildCount(node: N): number;
    getCushionImage(node: N): Nullable<any>/* Nullable<CPImage> */;
    getCushionColor(node: N): Nullable<any>/* Nullable<CPColor> */;
    parentPreorderEnumeration(parent: N): any/* Iterable<N> */;
    preorderEnumeration(parent: N): any/* Iterable<N> */;
    breadthFirstIterator(parent: N): any/* Iterable<N> */;
    depthFirstIterator(parent: N): any/* Iterable<N> */;
    getNodeForRow(row: Row): N;
    getTreeMapColumn(columnIndex: number): Nullable<Column>;
    getTreeMapColumnByName(columnName: Nullable<string>): Nullable<Column>;
    getTreeMapColumnsInclude(includeNone: boolean): any/* Iterable<Nullable<Column>> */;
    getTreeMapColumnsByIndices(columns: Int32Array): KtList<Column>;
    getTreeMapColumns(columns: Array<Column>): KtList<Column>;
    getTreeMapColumnsByNames(columnNames: Array<Nullable<string>>): KtList<Column>;
    getNumericMax(columnIndex: Nullable<Column>): Nullable<number>;
    getNumericMin(columnIndex: Nullable<Column>): Nullable<number>;
    setNumericMax(columnIndex: Nullable<Column>, max: number): void;
    setNumericMin(columnIndex: Nullable<Column>, min: number): void;
    readonly normalizedLightSourceX: number;
    readonly normalizedLightSourceY: number;
    readonly normalizedLightSourceZ: number;
    readonly rowCount: number;
    readonly columnCount: number;
    columns(): Nullable<any>/* Nullable<Iterable<Column>> */;
    getColumnName(columnIndex: Column): Nullable<string>;
    getColumnClass(columnIndex: Column): Nullable<any>/* Nullable<KClass<UnknownType *>> */;
    getValueAt(node: N, columnIndex: Column): Nullable<any>;
    isEveryValueUnique(column: Nullable<Column>): boolean;
    getAggregateValue(node: N, column: Nullable<Column>): Nullable<any>;
    getStringValue(node: N, column: Column): Nullable<string>;
    readonly root: Nullable<N>;
    currentRoot: Nullable<N>;
    readonly probing: any/* MutableSingleSelection<Nullable<N>> */;
    readonly highlighting: any/* MutableSelection<N> */;
    readonly selection: any/* MutableSelection<N> */;
    readonly filter: any/* MutableFilter<N> */;
    readonly search: any/* MutableFilter<N> */;
    readonly settings: TreeMapSettings<Column>;
    readonly worker: Nullable<any>/* Nullable<TreeMapWorker> */;
    readonly workerFuture: Nullable<any>/* Nullable<Future<UnknownType *>> */;
    addListener(treeMapListener: any/* TreeMapListener */): void;
    removeListener(treeMapListener: any/* TreeMapListener */): void;
    getNode(position: Nullable<any>/* Nullable<Point> */): Nullable<N>;
    readonly isDirty: boolean;
    waitUntilReady(): void;
    getSumSize(node: N): number;
    progressProperty(): any/* MutableProperty<number> */;
    getFormatPattern(columnIndex: number): Nullable<string>;
    setFormatPattern(columnIndex: number, pattern: Nullable<string>): void;
    readonly colorFactory: any/* MkColorFactory */;
    readonly __doNotUseOrImplementIt: {
        readonly "com.treemap.TreeMapModel": unique symbol;
    };
}
export declare abstract class TreeMapPropertyType {
    private constructor();
    static get sizeField(): TreeMapPropertyType & {
        get name(): "sizeField";
        get ordinal(): 0;
    };
    static get colorField(): TreeMapPropertyType & {
        get name(): "colorField";
        get ordinal(): 1;
    };
    static get labelsField(): TreeMapPropertyType & {
        get name(): "labelsField";
        get ordinal(): 2;
    };
    static get toolTipField(): TreeMapPropertyType & {
        get name(): "toolTipField";
        get ordinal(): 3;
    };
    static get backgroundField(): TreeMapPropertyType & {
        get name(): "backgroundField";
        get ordinal(): 4;
    };
    static get heightField(): TreeMapPropertyType & {
        get name(): "heightField";
        get ordinal(): 5;
    };
    static get groupByField(): TreeMapPropertyType & {
        get name(): "groupByField";
        get ordinal(): 6;
    };
    static get depth(): TreeMapPropertyType & {
        get name(): "depth";
        get ordinal(): 7;
    };
    static get rendering(): TreeMapPropertyType & {
        get name(): "rendering";
        get ordinal(): 8;
    };
    static get background(): TreeMapPropertyType & {
        get name(): "background";
        get ordinal(): 9;
    };
    static get tooltipBackground(): TreeMapPropertyType & {
        get name(): "tooltipBackground";
        get ordinal(): 10;
    };
    static get probingColor(): TreeMapPropertyType & {
        get name(): "probingColor";
        get ordinal(): 11;
    };
    static get selectionColor(): TreeMapPropertyType & {
        get name(): "selectionColor";
        get ordinal(): 12;
    };
    static get hideSearchResults(): TreeMapPropertyType & {
        get name(): "hideSearchResults";
        get ordinal(): 13;
    };
    static get hideFilterResults(): TreeMapPropertyType & {
        get name(): "hideFilterResults";
        get ordinal(): 14;
    };
    static get dimension(): TreeMapPropertyType & {
        get name(): "dimension";
        get ordinal(): 15;
    };
    static get dimensionFixed(): TreeMapPropertyType & {
        get name(): "dimensionFixed";
        get ordinal(): 16;
    };
    static get maximumHeight(): TreeMapPropertyType & {
        get name(): "maximumHeight";
        get ordinal(): 17;
    };
    static get lightSourceHeight(): TreeMapPropertyType & {
        get name(): "lightSourceHeight";
        get ordinal(): 18;
    };
    static get lightSourceAmbient(): TreeMapPropertyType & {
        get name(): "lightSourceAmbient";
        get ordinal(): 19;
    };
    static get lightSourceX(): TreeMapPropertyType & {
        get name(): "lightSourceX";
        get ordinal(): 20;
    };
    static get lightSourceY(): TreeMapPropertyType & {
        get name(): "lightSourceY";
        get ordinal(): 21;
    };
    static get lightSourceZ(): TreeMapPropertyType & {
        get name(): "lightSourceZ";
        get ordinal(): 22;
    };
    static get progressive(): TreeMapPropertyType & {
        get name(): "progressive";
        get ordinal(): 23;
    };
    get name(): "sizeField" | "colorField" | "labelsField" | "toolTipField" | "backgroundField" | "heightField" | "groupByField" | "depth" | "rendering" | "background" | "tooltipBackground" | "probingColor" | "selectionColor" | "hideSearchResults" | "hideFilterResults" | "dimension" | "dimensionFixed" | "maximumHeight" | "lightSourceHeight" | "lightSourceAmbient" | "lightSourceX" | "lightSourceY" | "lightSourceZ" | "progressive";
    get ordinal(): 0 | 1 | 2 | 3 | 4 | 5 | 6 | 7 | 8 | 9 | 10 | 11 | 12 | 13 | 14 | 15 | 16 | 17 | 18 | 19 | 20 | 21 | 22 | 23;
    static values(): Array<TreeMapPropertyType>;
    static valueOf(value: string): TreeMapPropertyType;
}
export declare namespace TreeMapPropertyType {
    /** @deprecated $metadata$ is used for internal purposes, please don't use it in your code, because it can be removed at any moment */
    namespace $metadata$ {
        const constructor: abstract new () => TreeMapPropertyType;
    }
}
export declare interface TreeMapSettings<Column> {
    readonly properties: any/* MutableProperties<TreeMapPropertyType> */;
    getDimensionFixed(): Nullable<boolean>;
    setDimensionFixed(fixed: Nullable<boolean>): void;
    getDimension(): Nullable<any>/* Nullable<Dimension> */;
    setDimension(dimension: Nullable<any>/* Nullable<Dimension> */): void;
    getProgressive(): Nullable<any>/* Nullable<Progressive> */;
    setProgressive(progressive: Nullable<any>/* Nullable<Progressive> */): void;
    groupByColumns: KtList<Column>;
    sizeColumn: Nullable<Column>;
    colorColumn: Nullable<Column>;
    labelsColumns: KtList<Column>;
    toolTipColumns: KtList<Column>;
    backgroundColumn: Nullable<Column>;
    heightColumn: Nullable<Column>;
    isHideFilterResults(): Nullable<boolean>;
    setHideFilterResults(hideFilterResults: Nullable<boolean>): void;
    isHideSearchResults(): Nullable<boolean>;
    setHideSearchResults(hideSearchResults: Nullable<boolean>): void;
    getMaximumHeight(): number;
    setMaximumHeight(height: number): void;
    setGroupBy(columns: Int32Array): void;
    setGroupByByNames(columnNames: Array<Nullable<string>>): void;
    setLabels(columns: Int32Array): void;
    setLabelsByNames(columnNames: Array<Nullable<string>>): void;
    setToolTip(columns: Int32Array): void;
    setToolTipByNames(columnNames: Array<Nullable<string>>): void;
    setBackground(column: number): void;
    setBackgroundByName(columnName: Nullable<string>): void;
    setSize(column: number): void;
    setSizeByName(columnName: Nullable<string>): void;
    setColor(column: number): void;
    setColorByName(columnName: Nullable<string>): void;
    setHeight(column: number): void;
    setHeightByName(columnName: Nullable<string>): void;
    getDepth(): Nullable<any>/* Nullable<Depth> */;
    setDepth(depth: Nullable<any>/* Nullable<Depth> */): void;
    rendering: Nullable<Rendering>;
    getLightSourceHeight(): number;
    setLightSourceHeight(value: number): void;
    getLightSourceAmbient(): number;
    setLightSourceAmbient(value: number): void;
    getLightSourceX(): number;
    setLightSourceX(value: number): void;
    getLightSourceY(): number;
    setLightSourceY(value: number): void;
    getLightSourceZ(): number;
    setLightSourceZ(value: number): void;
    getBackgroundProperty(): any/* MutableProperty<Nullable<CPColor>> */;
    getBackground(): Nullable<any>/* Nullable<CPColor> */;
    setBackgroundColor(color: Nullable<any>/* Nullable<CPColor> */): void;
    getTooltipBackgroundProperty(): any/* MutableProperty<Nullable<CPColor>> */;
    getTooltipBackground(): Nullable<any>/* Nullable<CPColor> */;
    setTooltipBackground(color: Nullable<any>/* Nullable<CPColor> */): void;
    getProbingColorProperty(): any/* MutableProperty<Nullable<CPColor>> */;
    getProbingColor(): Nullable<any>/* Nullable<CPColor> */;
    setProbingColor(color: Nullable<any>/* Nullable<CPColor> */): void;
    getSelectionColorProperty(): any/* MutableProperty<Nullable<CPColor>> */;
    getSelectionColor(): Nullable<any>/* Nullable<CPColor> */;
    setSelectionColor(color: Nullable<any>/* Nullable<CPColor> */): void;
    getShowPopup(field: Nullable<Column>): boolean;
    setShowPopup(field: Nullable<Column>, show: boolean): void;
    getValue(key: TreeMapPropertyType): Nullable<any>;
    addTreeMapSettingsListener(listener: any/* TreeMapSettingsListener */): void;
    removeTreeMapSettingsListener(listener: any/* TreeMapSettingsListener */): void;
    removeTreeMapSettingsListeners(): void;
    getGroupByColumnsSelection(): any/* MutableSelection<Column> */;
    getSizeColumnSelection(): any/* MutableSingleSelection<Nullable<Column>> */;
    getColorColumnSelection(): any/* MutableSingleSelection<Nullable<Column>> */;
    getLabelColumnsSelection(): any/* MutableSelection<Column> */;
    getTooltipColumnsSelection(): any/* MutableSelection<Column> */;
    getBackgroundColumnSelection(): any/* MutableSingleSelection<Nullable<Column>> */;
    getHeightColumnSelection(): any/* MutableSingleSelection<Nullable<Column>> */;
    getDepthSelection(): any/* MutableSingleSelection<Nullable<Depth>> */;
    readonly renderingSelection: any/* MutableSingleSelection<Nullable<Rendering>> */;
    getProgressiveSelection(): any/* MutableSingleSelection<Nullable<Progressive>> */;
    getHideFilterResultsSelection(): any/* MutableProperty<Nullable<boolean>> */;
    getHideSearchResultsSelection(): any/* MutableProperty<Nullable<boolean>> */;
    getDefaultColumnSettings(): TreeMapColumnSettings;
    getColumnSettings(field: Nullable<Column>): TreeMapColumnSettings;
    readonly maximumHeightInterval: any/* MutableBoundedInterval */;
    readonly lightSourceHeightInterval: any/* MutableBoundedInterval */;
    readonly lightSourceAmbientInterval: any/* MutableBoundedInterval */;
    readonly lightSourceXInterval: any/* MutableBoundedInterval */;
    readonly lightSourceYInterval: any/* MutableBoundedInterval */;
    readonly lightSourceZInterval: any/* MutableBoundedInterval */;
    resetToDefaults(): void;
    save(dataFrame: any/* DataFrame<Nullable<any>, Column, Nullable<any>> */, elementFactory: any/* ElementFactory */, root: any/* Element */): void;
    readonly __doNotUseOrImplementIt: {
        readonly "com.treemap.TreeMapSettings": unique symbol;
    };
}
export declare class JsTreeMap /* extends DefaultTreeMap<number, string> */ implements TreeMap<any/* AbstractTreeMapNode<number, string> */, number, string> {
    constructor(elementId: string, model: Nullable<DefaultTreeMapModel<number, string>>);
    get component(): any/* CPComponent */;
    get view(): Nullable<any>/* Nullable<TreeMapView<AbstractTreeMapNode<number, string>, number, string>> */;
    set view(value: Nullable<any>/* Nullable<TreeMapView<AbstractTreeMapNode<number, string>, number, string>> */);
    get controller(): Nullable<any>/* Nullable<TreeMapController<AbstractTreeMapNode<number, string>, number, string>> */;
    set controller(value: Nullable<any>/* Nullable<TreeMapController<AbstractTreeMapNode<number, string>, number, string>> */);
    get model(): Nullable<TreeMapModel<any/* AbstractTreeMapNode<number, string> */, number, string>>;
    set model(value: Nullable<TreeMapModel<any/* AbstractTreeMapNode<number, string> */, number, string>>);
    setGroupBy(columns: Int32Array): void;
    setGroupByByNames(columnNames: Array<Nullable<string>>): void;
    setLabels(columns: Int32Array): void;
    setLabelsByNames(columnNames: Array<Nullable<string>>): void;
    setBackground(column: number): void;
    setBackgroundByName(columnName: Nullable<string>): void;
    setSize(column: number): void;
    setSizeByName(columnName: Nullable<string>): void;
    setColor(column: number): void;
    setColorByName(columnName: Nullable<string>): void;
    setHeight(column: number): void;
    setHeightByName(columnName: Nullable<string>): void;
    setToolTip(columns: Int32Array): void;
    setToolTipByNames(columnNames: Array<Nullable<string>>): void;
    setAlgorithm(algorithm: Nullable<Algorithm>): void;
    setAggregation(aggregation: Nullable<any>/* Nullable<Aggregation> */): void;
    setScale(scale: Nullable<any>/* Nullable<Scale> */): void;
    setNesting(nesting: Nullable<any>/* Nullable<Nesting> */): void;
    setOrdering(ordering: Nullable<any>/* Nullable<Ordering> */): void;
    setDepth(depth: Nullable<any>/* Nullable<Depth> */): void;
    setLabeling(labeling: Nullable<any>/* Nullable<Labeling> */): void;
    setRendering(rendering: Nullable<Rendering>): void;
    setLightSourceHeight(value: number): void;
    setLightSourceAmbient(value: number): void;
    setLightSourceX(value: number): void;
    setLightSourceY(value: number): void;
    setLightSourceZ(value: number): void;
    setLabelingFont(font: Nullable<any>/* Nullable<CPFont> */): void;
    setLabelingForegroundColor(color: Nullable<any>/* Nullable<CPColor> */): void;
    setLabelingBackgroundColor(color: Nullable<any>/* Nullable<CPColor> */): void;
    setHeaderFont(font: Nullable<any>/* Nullable<CPFont> */): void;
    setHeaderForegroundColor(color: Nullable<any>/* Nullable<CPColor> */): void;
    setHeaderBackgroundColor(color: Nullable<any>/* Nullable<CPColor> */): void;
    readonly __doNotUseOrImplementIt: TreeMap<any/* AbstractTreeMapNode<number, string> */, number, string>["__doNotUseOrImplementIt"];
}
export declare namespace JsTreeMap {
    /** @deprecated $metadata$ is used for internal purposes, please don't use it in your code, because it can be removed at any moment */
    namespace $metadata$ {
        const constructor: abstract new () => JsTreeMap;
    }
}
export declare interface TreeMapProps extends Props {
    model?: Nullable<DefaultTreeMapModel<number, string>>;
}
export declare const TreeMapComponent: { get(): ComponentType<TreeMapProps>; };
export declare function getTreeMapComponent(): any;