/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.platform.win32;

import com.install4j.api.Util;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.comm.ExecutionContext;
import com.install4j.runtime.installer.helper.comm.HelperCommunication;
import com.install4j.runtime.installer.platform.win32.Common;
import com.install4j.runtime.installer.platform.win32.Win32UserInfo;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class FolderInfo {
    public static final int DRIVE_UNKNOWN = 0;
    public static final int DRIVE_NO_ROOT_DIR = 1;
    public static final int DRIVE_REMOVABLE = 2;
    public static final int DRIVE_FIXED = 3;
    public static final int DRIVE_REMOTE = 4;
    public static final int DRIVE_CDROM = 5;
    public static final int DRIVE_RAMDISK = 6;
    public static final int FOLDER_DESKTOP = 1;
    public static final int FOLDER_STARTMENU = 2;
    public static final int FOLDER_PROGRAMS = 3;
    public static final int FOLDER_STARTUP = 4;
    public static final int FOLDER_SENDTO = 5;
    public static final int FOLDER_FONTS = 6;
    public static final int FOLDER_APPDATA = 7;
    public static final int FOLDER_DOCS = 8;
    public static final int FOLDER_TEMPLATES = 9;
    public static final int FOLDER_FAVORITES = 10;
    public static final int FOLDER_LOCAL_APPDATA = 11;
    private static final int KNOWN_FOLDER = 1000;
    public static final int KNOWN_FOLDER_DOWNLOAD = 1001;
    public static final int KNOWN_FOLDER_USER_PROGRAM_FILES = 1002;
    public static final int KNOWN_FOLDER_USER_PROGRAM_FILES_COMMON = 1003;
    public static final int KNOWN_FOLDER_LOCAL_APP_DATA_LOW = 1004;
    private static final String PROGRAM_FILES_DIR_NAME = "ProgramFilesDir";
    private static final String COMMON_FILES_DIR_NAME = "CommonFilesDir";
    private static Map<Integer, File> originalUserFolderCache;

    private static synchronized native String getSpecialFolder0(int var0, boolean var1);

    private static native String getPathFromRegistry0(String var0);

    private static native String getWindowsDirectory0();

    private static native String getSystemDirectory0();

    private static native int getDriveType0(String var0);

    private static native String getShortPathName0(String var0);

    private static synchronized native String getUniversalPathName0(String var0);

    public static int getDriveType(String rootPathName) {
        if (!Util.isWindows()) {
            return 0;
        }
        return FolderInfo.getDriveType0(rootPathName);
    }

    public static String getShortPathName(String longPathName) {
        if (!Util.isWindows()) {
            return longPathName;
        }
        return FolderInfo.getShortPathName0(longPathName);
    }

    public static String getUniversalPathName(String mappedPathName) {
        if (!Util.isWindows()) {
            return mappedPathName;
        }
        String ret = FolderInfo.getUniversalPathName0(mappedPathName);
        if (ret.startsWith(";")) {
            if (Boolean.getBoolean("install4j.debugUNC")) {
                Logger.getInstance().info(null, mappedPathName + " could not be converted to universal: " + ret.substring(1));
            }
            return mappedPathName;
        }
        if (ret == mappedPathName && Boolean.getBoolean("install4j.debugUNC")) {
            Logger.getInstance().info(null, mappedPathName + " could not be converted to universal, function could not be loaded");
        }
        return ret;
    }

    public static File getSpecialFolder(int folderType, boolean allUsers) {
        String fileName;
        if (!Util.isWindows()) {
            return null;
        }
        if (!allUsers && HelperCommunication.getInstance().isElevatedHelper()) {
            File file = originalUserFolderCache.get(folderType);
            if (file == null) {
                file = HelperCommunication.getInstance().fetchObject(ExecutionContext.UNELEVATED, context -> FolderInfo.getSpecialFolder(folderType, false));
                originalUserFolderCache.put(folderType, file);
            }
            if (file != null) {
                return file;
            }
        }
        if (allUsers) {
            if (folderType == 1002) {
                return FolderInfo.getProgramFilesDirectory();
            }
            if (folderType == 1003) {
                return FolderInfo.getCommonFilesDirectory();
            }
        }
        if ((fileName = FolderInfo.getSpecialFolder0(folderType, allUsers)) == null) {
            boolean bl = allUsers = !allUsers;
            if (!Win32UserInfo.isAdminUser()) {
                allUsers = false;
            }
            fileName = FolderInfo.getSpecialFolder0(folderType, allUsers);
        }
        return fileName == null ? null : new File(fileName);
    }

    public static File getProgramFilesDirectory() {
        if (!Util.isWindows()) {
            return null;
        }
        return new File(FolderInfo.getPathFromRegistry0(PROGRAM_FILES_DIR_NAME));
    }

    public static File getCommonFilesDirectory() {
        if (!Util.isWindows()) {
            return null;
        }
        return new File(FolderInfo.getPathFromRegistry0(COMMON_FILES_DIR_NAME));
    }

    public static File getWindowsDirectory() {
        if (!Util.isWindows()) {
            return null;
        }
        return new File(FolderInfo.getWindowsDirectory0());
    }

    public static File getSystemDirectory() {
        if (!Util.isWindows()) {
            return null;
        }
        return new File(FolderInfo.getSystemDirectory0());
    }

    public static File getProgramDataDirectory() {
        if (!Util.isWindows()) {
            return null;
        }
        return FolderInfo.getSpecialFolder(7, true);
    }

    public static synchronized File getDownloadsDirectory() {
        if (!Util.isWindows()) {
            return null;
        }
        File dir = FolderInfo.getSpecialFolder(1001, false);
        if (dir != null) {
            return dir;
        }
        File docsDir = FolderInfo.getSpecialFolder(8, false);
        if (docsDir != null) {
            return docsDir;
        }
        return new File(System.getProperty("user.home"));
    }

    static {
        Common.init();
        originalUserFolderCache = Collections.synchronizedMap(new HashMap());
    }
}

