/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.application.document.swing;

import com.macrofocus.application.document.swing.VerticalFlowLayout;
import com.macrofocus.application.root.AbstractDragDropHere;
import com.macrofocus.application.root.CPDragDropHere;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.io.IOException;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.TransferHandler;
import javax.swing.UIManager;

public class SwingDragDropHere
extends AbstractDragDropHere<JComponent> {
    private final JComponent nativeComponent;
    private final JPanel content;

    public SwingDragDropHere(JComponent target) {
        JLabel icon = new JLabel(new DragHereIcon());
        JLabel label = new JLabel();
        label.setText("<html>Drag <b>file</b> here");
        label.setVerticalTextPosition(3);
        label.setHorizontalTextPosition(0);
        label.setForeground(Color.GRAY);
        label.setFont(new Font("Monospace", 0, 24));
        this.content = new JPanel();
        this.content.setLayout(new VerticalFlowLayout());
        this.content.add(label);
        this.content.add(icon);
        this.nativeComponent = new JPanel(new BorderLayout());
        this.nativeComponent.add((Component)this.content, "Center");
        this.nativeComponent.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        this.configure(target);
    }

    public void configure(JComponent target) {
        target.setTransferHandler(new TransferHandler(){

            @Override
            public boolean canImport(TransferHandler.TransferSupport supp) {
                if (!supp.isDrop()) {
                    return false;
                }
                return supp.isDataFlavorSupported(DataFlavor.javaFileListFlavor);
            }

            @Override
            public boolean importData(TransferHandler.TransferSupport support) {
                if (!this.canImport(support)) {
                    return false;
                }
                Transferable t = support.getTransferable();
                try {
                    Object data = t.getTransferData(DataFlavor.javaFileListFlavor);
                    List fileList = (List)data;
                    for (CPDragDropHere.Listener listener : SwingDragDropHere.this.listeners) {
                        listener.filesDropped((Iterable)fileList);
                    }
                }
                catch (UnsupportedFlavorException e) {
                    return false;
                }
                catch (IOException e) {
                    return false;
                }
                return true;
            }
        });
    }

    public void addComponent(JComponent component) {
        this.content.add(component);
    }

    public JComponent getNativeComponent() {
        return this.nativeComponent;
    }

    public class DragHereIcon
    implements Icon {
        private int size = 80;
        private float a = 4.0f;
        private float b = 8.0f;
        private int r = 16;
        private int f = this.size / 4;
        private Font font = new Font("Monospace", 0, this.size);
        private FontRenderContext frc = new FontRenderContext(null, true, true);
        private Shape s = new TextLayout("\u21e9", this.font, this.frc).getOutline(null);
        private Color linec = Color.GRAY;

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.translate(x, y);
            g2.setStroke(new BasicStroke(this.a));
            g2.setPaint(this.linec);
            g2.draw(new RoundRectangle2D.Float(this.a, this.a, (float)this.size - 2.0f * this.a - 1.0f, (float)this.size - 2.0f * this.a - 1.0f, this.r, this.r));
            g2.setStroke(new BasicStroke(this.b));
            g2.setColor(UIManager.getColor("Panel.background"));
            g2.drawLine(1 * this.f, 0 * this.f, 1 * this.f, 4 * this.f);
            g2.drawLine(2 * this.f, 0 * this.f, 2 * this.f, 4 * this.f);
            g2.drawLine(3 * this.f, 0 * this.f, 3 * this.f, 4 * this.f);
            g2.drawLine(0 * this.f, 1 * this.f, 4 * this.f, 1 * this.f);
            g2.drawLine(0 * this.f, 2 * this.f, 4 * this.f, 2 * this.f);
            g2.drawLine(0 * this.f, 3 * this.f, 4 * this.f, 3 * this.f);
            g2.setPaint(this.linec);
            Rectangle b = this.s.getBounds();
            Point2D.Double p = new Point2D.Double(((RectangularShape)b).getX() + ((RectangularShape)b).getWidth() / 2.0, ((RectangularShape)b).getY() + ((RectangularShape)b).getHeight() / 2.0);
            AffineTransform toCenterAT = AffineTransform.getTranslateInstance((double)this.size / 2.0 - p.getX(), (double)this.size / 2.0 - p.getY());
            g2.fill(toCenterAT.createTransformedShape(this.s));
            g2.translate(-x, -y);
            g2.dispose();
        }

        @Override
        public int getIconWidth() {
            return this.size;
        }

        @Override
        public int getIconHeight() {
            return this.size;
        }
    }
}

