/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.synthetica.simple2d;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.SyntheticaState;
import de.javasoft.plaf.synthetica.util.Synthetica2DUtils;
import de.javasoft.synthetica.simple2d.SyntheticaSimple2DLookAndFeel;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.plaf.synth.SynthContext;

public class ButtonPainter
extends de.javasoft.plaf.synthetica.painter.ButtonPainter {
    private static final float ARC = SyntheticaSimple2DLookAndFeel.ARC;

    public void paintButtonBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        if (!this.paintCheck(sc) || (float)h <= this.getScale() * 2.0f + 1.0f || (float)w <= this.getScale() * 2.0f + 1.0f) {
            return;
        }
        this.paintButtonBackground(sc.getComponent(), new SyntheticaState(sc.getComponentState()), (String)sc.getComponent().getClientProperty("JButton.segmentPosition"), g, x, y, w, h);
    }

    public void paintButtonBackground(JComponent c, SyntheticaState state, String segmentPosition, int angle, Graphics g, int x, int y, int w, int h) {
        if (!this.paintCheck(c, state) || (float)h <= this.getScale() * 2.0f + 1.0f || (float)w <= this.getScale() * 2.0f + 1.0f) {
            return;
        }
        if (!c.getComponentOrientation().isLeftToRight() && segmentPosition != null) {
            if ("first".equals(segmentPosition)) {
                segmentPosition = "last";
            } else if ("last".equals(segmentPosition)) {
                segmentPosition = "first";
            }
        }
        if (SyntheticaLookAndFeel.isOpaque((JComponent)c)) {
            float[] fractions;
            Color[] gradient;
            Color bg = ButtonPainter.getSyntheticaBackgroundColor((JComponent)c);
            Synthetica2DUtils.BlendMode bm = ButtonPainter.getSyntheticaBackgroundBlendMode((JComponent)c);
            if (angle == 90 || angle == -90) {
                int w_ = w;
                w = h;
                h = w_;
            }
            Graphics2D g2 = this.prepareGraphics2D(null, g, x, y, false);
            Shape shape = this.createShape(0.0f, 0.0f, ButtonPainter.calcRelativeLength((Graphics2D)g2, (float)w, (float)0.0f), ButtonPainter.calcRelativeLength((Graphics2D)g2, (float)h, (float)0.0f), this.scaleArc(ARC), segmentPosition, false, false);
            float borderWidth = 1.0f;
            if (state.isSet(SyntheticaState.State.DISABLED)) {
                g2.setPaint(new Color(0xEFEFEF));
            } else {
                gradient = new Color[]{ButtonPainter.blend((Color)new Color(0xF0F0F0), (Color)bg, (Synthetica2DUtils.BlendMode)bm), ButtonPainter.blend((Color)new Color(0xE7E7E7), (Color)bg, (Synthetica2DUtils.BlendMode)bm), ButtonPainter.blend((Color)new Color(0xE1E1E1), (Color)bg, (Synthetica2DUtils.BlendMode)bm), ButtonPainter.blend((Color)new Color(0xD2D2D2), (Color)bg, (Synthetica2DUtils.BlendMode)bm)};
                fractions = new float[]{0.0f, 0.5f, 0.75f, 1.0f};
                if (angle == -90) {
                    g2.setPaint(this.createLinearGradientPaint(this.calcRelativeGradientPos(g2, 0.0f, borderWidth), 0.0f, this.calcRelativeGradientPos(g2, w - 1, -borderWidth), 0.0f, fractions, gradient));
                } else if (angle == 90) {
                    g2.setPaint(this.createLinearGradientPaint(this.calcRelativeGradientPos(g2, 0.0f, borderWidth), 0.0f, this.calcRelativeGradientPos(g2, w - 1, -borderWidth), 0.0f, fractions, new Color[]{gradient[3], gradient[2], gradient[1], gradient[0]}));
                } else {
                    g2.setPaint(this.createLinearGradientPaint(0.0f, this.calcRelativeGradientPos(g2, 0.0f, borderWidth), 0.0f, this.calcRelativeGradientPos(g2, h - 1, -borderWidth), fractions, gradient));
                }
            }
            g2.fill(ButtonPainter.subtractStroke((Graphics2D)g2, (Shape)shape));
            if (state.isSet(SyntheticaState.State.HOVER) && !state.isSet(SyntheticaState.State.PRESSED)) {
                g2.setPaint(SyntheticaSimple2DLookAndFeel.getHoverColor());
                g2.fill(ButtonPainter.subtractStroke((Graphics2D)g2, (Shape)shape));
            }
            if (state.isSet(SyntheticaState.State.DEFAULT)) {
                gradient = new Color[]{new Color(0xDDF5FF), new Color(13692666), new Color(12510711), new Color(12639723)};
                fractions = new float[]{0.0f, 0.5f, 0.75f, 1.0f};
                if (angle == -90) {
                    g2.setPaint(this.createLinearGradientPaint(this.calcRelativeGradientPos(g2, 0.0f, borderWidth), 0.0f, this.calcRelativeGradientPos(g2, w - 1, -borderWidth), 0.0f, fractions, gradient));
                } else if (angle == 90) {
                    g2.setPaint(this.createLinearGradientPaint(this.calcRelativeGradientPos(g2, 0.0f, borderWidth), 0.0f, this.calcRelativeGradientPos(g2, w - 1, -borderWidth), 0.0f, fractions, new Color[]{gradient[3], gradient[2], gradient[1], gradient[0]}));
                } else {
                    g2.setPaint(this.createLinearGradientPaint(0.0f, this.calcRelativeGradientPos(g2, 0.0f, borderWidth), 0.0f, this.calcRelativeGradientPos(g2, h - 1, -borderWidth), fractions, gradient));
                }
                g2.fill(ButtonPainter.subtractStroke((Graphics2D)g2, (Shape)shape));
            }
            this.restoreGraphics2D(g2);
        }
        Graphics2D g2 = this.prepareGraphics2D(null, g, x, y, true);
        float arc = this.scaleArc(ARC);
        if (SyntheticaLookAndFeel.isOpaque((JComponent)c)) {
            this.paintBorder(c, state, segmentPosition, angle, g2, x, y, w, h, arc);
        }
        this.paintFocus(c, state, segmentPosition, angle, g2, x, y, w, h, arc);
        this.restoreGraphics2D(g2);
    }

    private void paintBorder(JComponent c, SyntheticaState state, String segmentPosition, int angle, Graphics2D g2, int x, int y, int w, int h, float arc) {
        if (state.isSet(SyntheticaState.State.DISABLED)) {
            g2.setPaint(new Color(0xC4C4C4));
        } else {
            Color[] colorArray;
            if (state.isSet(SyntheticaState.State.PRESSED)) {
                Color[] colorArray2 = new Color[2];
                colorArray2[0] = new Color(0x808080);
                colorArray = colorArray2;
                colorArray2[1] = new Color(0xC0C0C0);
            } else {
                Color[] colorArray3 = new Color[2];
                colorArray3[0] = new Color(0xCCCCCC);
                colorArray = colorArray3;
                colorArray3[1] = new Color(0x808080);
            }
            Color[] gradient = colorArray;
            float[] fractions = new float[]{0.0f, 1.0f};
            if (angle == -90) {
                g2.setPaint(this.createLinearGradientPaint(this.calcRelativeGradientPos(g2, 0.0f, 0.0f), 0.0f, this.calcRelativeGradientPos(g2, w - 1, 0.0f), 0.0f, fractions, gradient));
            } else if (angle == 90) {
                g2.setPaint(this.createLinearGradientPaint(this.calcRelativeGradientPos(g2, 0.0f, 0.0f), 0.0f, this.calcRelativeGradientPos(g2, w - 1, 0.0f), 0.0f, fractions, new Color[]{gradient[1], gradient[0]}));
            } else {
                g2.setPaint(this.createLinearGradientPaint(0.0f, this.calcRelativeGradientPos(g2, 0.0f, 0.0f), 0.0f, this.calcRelativeGradientPos(g2, h - 1, 0.0f), fractions, gradient));
            }
        }
        Shape shape = this.createShape(0.0f, 0.0f, ButtonPainter.calcRelativeLength((Graphics2D)g2, (float)w, (float)0.0f), ButtonPainter.calcRelativeLength((Graphics2D)g2, (float)h, (float)0.0f), arc, segmentPosition, true, false);
        g2.draw(shape);
        if (!state.isSet(SyntheticaState.State.DISABLED)) {
            Color[] gradient = new Color[]{new Color(Integer.MAX_VALUE, true), new Color(0x3FFFFFFF, true)};
            float[] fractions = new float[]{0.0f, 1.0f};
            if (angle == -90) {
                g2.setPaint(this.createLinearGradientPaint(this.calcRelativeGradientPos(g2, 0.0f, 0.0f), 0.0f, this.calcRelativeGradientPos(g2, w - 1, 0.0f), 0.0f, fractions, gradient));
            } else if (angle == 90) {
                g2.setPaint(this.createLinearGradientPaint(this.calcRelativeGradientPos(g2, 0.0f, 0.0f), 0.0f, this.calcRelativeGradientPos(g2, w - 1, 0.0f), 0.0f, fractions, new Color[]{gradient[1], gradient[0]}));
            } else {
                g2.setPaint(this.createLinearGradientPaint(0.0f, this.calcRelativeGradientPos(g2, 0.0f, 0.0f), 0.0f, this.calcRelativeGradientPos(g2, h - 1, 0.0f), fractions, gradient));
            }
            shape = this.createShape(this.calcRelativePos(g2, 0.0f, 1.0f), this.calcRelativePos(g2, 0.0f, 1.0f), ButtonPainter.calcRelativeLength((Graphics2D)g2, (float)w, (float)-2.0f), ButtonPainter.calcRelativeLength((Graphics2D)g2, (float)h, (float)-2.0f), this.calcRelativeArc(g2, arc, -2.0f), segmentPosition, true, false);
            g2.draw(shape);
        }
    }

    private void paintFocus(JComponent c, SyntheticaState state, String segmentPosition, int angle, Graphics2D g2, int x, int y, int w, int h, float arc) {
        boolean paintFocus = (Boolean)SyntheticaLookAndFeel.getClientProperty((String)"Synthetica.paintFocus", (JComponent)c, (Object)true);
        if (state.isSet(SyntheticaState.State.FOCUSED) && ((AbstractButton)c).isFocusPainted() && paintFocus) {
            g2.setPaint(SyntheticaSimple2DLookAndFeel.getFocusColor());
            Shape shape = this.createShape(0.0f, 0.0f, ButtonPainter.calcRelativeLength((Graphics2D)g2, (float)w, (float)0.0f), ButtonPainter.calcRelativeLength((Graphics2D)g2, (float)h, (float)0.0f), arc, segmentPosition, true, true);
            g2.draw(shape);
            shape = this.createShape(this.getScale(), this.getScale(), ButtonPainter.calcRelativeLength((Graphics2D)g2, (float)w, (float)-2.0f), ButtonPainter.calcRelativeLength((Graphics2D)g2, (float)h, (float)-2.0f), this.calcRelativeArc(g2, arc, -2.0f), segmentPosition, true, true);
            g2.draw(shape);
        }
    }

    Shape createShape(float x, float y, float w, float h, float arc, String segmentPosition, boolean isBorder, boolean hasFocus) {
        if (segmentPosition == null || segmentPosition.length() == 0 || segmentPosition.equals("only")) {
            return new RoundRectangle2D.Float(x, y, w, h, arc, arc);
        }
        arc /= 2.0f;
        if (segmentPosition.equals("first")) {
            if (hasFocus) {
                w -= 1.0f;
            }
            GeneralPath path = new GeneralPath();
            path.moveTo(x + w, y + h);
            path.lineTo(x + arc, y + h);
            path.quadTo(x, y + h, x, y + h - arc);
            path.lineTo(x, y + arc);
            path.quadTo(x, y, x + arc, y);
            path.lineTo(x + w, y);
            path.closePath();
            return path;
        }
        if (segmentPosition.equals("middle")) {
            if (!isBorder) {
                x -= 1.0f;
                w += 1.0f;
            }
            if (hasFocus) {
                w -= 1.0f;
            }
            GeneralPath path = new GeneralPath();
            path.moveTo(x, y);
            path.lineTo(x + w, y);
            path.lineTo(x + w, y + h);
            path.lineTo(x, y + h);
            if (hasFocus) {
                path.closePath();
            }
            return path;
        }
        if (segmentPosition.equals("last")) {
            if (!isBorder) {
                x -= 1.0f;
                w += 1.0f;
            }
            GeneralPath path = new GeneralPath();
            path.moveTo(x, y);
            path.lineTo(x + w - arc, y);
            path.quadTo(x + w, y, x + w, y + arc);
            path.lineTo(x + w, y + h - arc);
            path.quadTo(x + w, y + h, x + w - arc, y + h);
            path.lineTo(x, y + h);
            if (hasFocus) {
                path.closePath();
            }
            return path;
        }
        return new Rectangle2D.Float(0.0f, 0.0f, w, h);
    }
}

