/*
 * Decompiled with CFR 0.152.
 */
package com.treemap;

import com.macrofocus.colormap.ColorMapFactory;
import com.macrofocus.colormap.MutableColorMap;
import com.macrofocus.colormapping.DataFrameColorMapFactory;
import com.macrofocus.crossplatform.CPFactory;
import com.macrofocus.igraphics.CPColor;
import com.macrofocus.igraphics.CPImage;
import com.macrofocus.igraphics.CPImageFactory;
import com.macrofocus.molap.dataframe.DataFrame;
import com.macrofocus.molap.dataframe.DataFrameEvent;
import com.macrofocus.molap.dataframe.DataFrameHelper;
import com.macrofocus.molap.dataframe.DataFrameListener;
import com.macrofocus.molap.series.Series;
import com.treemap.AbstractTreeMapModel;
import com.treemap.AbstractTreeMapNode;
import com.treemap.DefaultTreeMapField;
import com.treemap.LeafTreeMapNode;
import com.treemap.NoTreeMapField;
import com.treemap.ParentTreeMapNode;
import com.treemap.TreeMapField;
import com.treemap.TreeMapWorker;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DefaultTreeMapModel<N extends AbstractTreeMapNode<N, Row, Column, Color, Font>, Row, Column, Color, Font>
extends AbstractTreeMapModel<N, Row, Column, Color, Font> {
    protected DataFrame<Row, Column, ?> dataFrame;
    private final Map<Column, TreeMapField> d = new HashMap<Column, TreeMapField>();
    private final Map<TreeMapField, Double> e = new HashMap<TreeMapField, Double>();
    private final Map<TreeMapField, Double> f = new HashMap<TreeMapField, Double>();
    final DataFrameListener<Row, Column> b = new DataFrameListener<Row, Column>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dataFrameChanged(DataFrameEvent<Row, Column> event) {
            TreeMapField<N, Column>[] treeMapFieldArray = DefaultTreeMapModel.this._settings.getGroupByTreeMapFields();
            TreeMapField<N, Column>[] treeMapFieldArray2 = DefaultTreeMapModel.this.f;
            synchronized (DefaultTreeMapModel.this.f) {
                DefaultTreeMapModel.this.f.clear();
                DefaultTreeMapModel.this.e.clear();
                // ** MonitorExit[var3_3] (shouldn't be in output)
                DefaultTreeMapModel.this.clearAggregationCache();
                DefaultTreeMapModel.this.fireTableModelChanged();
                if (event.getAffectedColumns() == null) {
                    DefaultTreeMapModel.this.scheduleUpdateGroupBy();
                    return;
                }
                for (TreeMapField treeMapField : treeMapFieldArray) {
                    if (!treeMapField.isValid()) continue;
                    for (Object t2 : event.getAffectedColumns()) {
                        if (treeMapField.getIndex() != t2) continue;
                        DefaultTreeMapModel.this.scheduleUpdateGroupBy();
                        return;
                    }
                }
                DefaultTreeMapModel.this.scheduleUpdateLayout();
                return;
            }
        }
    };

    public DefaultTreeMapModel(DataFrame<Row, Column, ?> dataFrame, CPFactory<?, Font, ?, Color> cpFactory, ColorMapFactory<Color> colorMapFactory, CPImageFactory imageFactory) {
        super(cpFactory, colorMapFactory, imageFactory);
        this.setDataFrame(dataFrame);
        this.initDefaults();
    }

    public synchronized void setDataFrame(DataFrame<Row, Column, ?> dataFrame) {
        if (this.dataFrame != dataFrame) {
            if (dataFrame != null) {
                dataFrame.removeDataFrameListener(this.b);
            }
            this.dataFrame = dataFrame;
            this.dataFrame.addWeakDataFrameListener(this.b);
            this.fireTableModelChanged();
            this.scheduleUpdateGroupBy();
        }
    }

    @Override
    public String getLabelName(AbstractTreeMapNode node) {
        return node.getLabelName();
    }

    @Override
    public N getParent(N node) {
        return ((AbstractTreeMapNode)node).getParent();
    }

    @Override
    public boolean isRoot(AbstractTreeMapNode node) {
        return node.isRoot();
    }

    @Override
    public int getChildCount(AbstractTreeMapNode node) {
        return node.getChildCount();
    }

    @Override
    public Iterable<N> getChildren(N parent) {
        return ((AbstractTreeMapNode)parent).getChildren();
    }

    @Override
    public Iterable<N> getChildrenOfTypeParent(N parent) {
        return ((AbstractTreeMapNode)parent).getChildrenOfTypeParent();
    }

    @Override
    public CPImage getCushionImage(AbstractTreeMapNode node) {
        return node.getCushionImage();
    }

    @Override
    public CPColor<Color> getCushionColor(AbstractTreeMapNode node) {
        return node.getCushionColor();
    }

    @Override
    protected AbstractTreeMapNode createRootNode(TreeMapField<N, Column> childrenGroupByField) {
        return new ParentTreeMapNode("root", this, null, childrenGroupByField);
    }

    protected AbstractTreeMapNode createLeafNode(Row row) {
        if (this.rowNode.containsKey(row)) {
            return (AbstractTreeMapNode)this.rowNode.get(row);
        }
        LeafTreeMapNode leafTreeMapNode = new LeafTreeMapNode(row, this);
        this.rowNode.put(row, leafTreeMapNode);
        return leafTreeMapNode;
    }

    @Override
    public N getNode(Row row) {
        return (N)((AbstractTreeMapNode)this.rowNode.get(row));
    }

    protected AbstractTreeMapNode createParentNode(Object name, TreeMapField<N, Column> groupByField, TreeMapField<N, Column> childrenGroupByField) {
        return new ParentTreeMapNode(name, this, groupByField, childrenGroupByField);
    }

    protected AbstractTreeMapNode findChild(AbstractTreeMapNode parent, Object name) {
        return parent.findChild(name);
    }

    protected void addChild(N parent, AbstractTreeMapNode child) {
        parent.add((AbstractTreeMapNode)child);
    }

    @Override
    protected boolean doGroupBy(N parent, TreeMapWorker worker) {
        Object object;
        TreeMapField<N, Column>[] treeMapFieldArray;
        if (this._settings.getGroupByTreeMapFields() != null) {
            int n2;
            int n3 = 0;
            for (n2 = 0; n2 < this._settings.getGroupByTreeMapFields().length; ++n2) {
                TreeMapField treeMapField = this._settings.getGroupByTreeMapFields()[n2];
                if (treeMapField == null || !treeMapField.isValid()) continue;
                ++n3;
            }
            if (n3 == this._settings.getGroupByTreeMapFields().length) {
                treeMapFieldArray = this._settings.getGroupByTreeMapFields();
            } else {
                treeMapFieldArray = new TreeMapField[n3];
                n2 = 0;
                for (int i2 = 0; i2 < this._settings.getGroupByTreeMapFields().length; ++i2) {
                    object = this._settings.getGroupByTreeMapFields()[i2];
                    if (object == null || !object.isValid()) continue;
                    treeMapFieldArray[n2] = object;
                    ++n2;
                }
            }
        } else {
            treeMapFieldArray = this._settings.getGroupByTreeMapFields();
        }
        if (this.dataFrame != null) {
            for (Object t2 : this.dataFrame.rows()) {
                if (!worker.isCancelled()) {
                    List<TreeMapField> list;
                    List<Object> list2;
                    if (treeMapFieldArray == null || treeMapFieldArray.length == 0) {
                        list2 = Collections.emptyList();
                        object = Collections.emptyList();
                        list = Collections.emptyList();
                    } else {
                        list2 = new ArrayList(treeMapFieldArray.length);
                        object = new ArrayList(treeMapFieldArray.length);
                        list = new ArrayList<TreeMapField>(treeMapFieldArray.length);
                        for (int i3 = 0; i3 < treeMapFieldArray.length; ++i3) {
                            Object[] objectArray;
                            TreeMapField treeMapField = treeMapFieldArray[i3];
                            TreeMapField treeMapField2 = i3 < treeMapFieldArray.length - 1 ? treeMapFieldArray[i3 + 1] : null;
                            Object Column = treeMapField.getIndex();
                            Object object2 = this.dataFrame.getValueAt(t2, Column);
                            if (object2 != null && object2.getClass().isArray()) {
                                objectArray = (Object[])object2;
                                list2.addAll(Arrays.asList(objectArray));
                                for (int i4 = 0; i4 < objectArray.length; ++i4) {
                                    object.add(treeMapField);
                                    list.add(treeMapField2);
                                }
                                continue;
                            }
                            objectArray = this.getSettings().getFieldSettings(treeMapField);
                            if (object2 == null) continue;
                            if (objectArray.getFormat() != null) {
                                list2.add(objectArray.getFormat().formatHtml(object2, false));
                            } else {
                                list2.add(object2);
                            }
                            object.add(treeMapField);
                            list.add(treeMapField2);
                        }
                    }
                    this.addChild(parent, (Iterable<Object>)list2, (Iterable<TreeMapField>)object, (Iterable<TreeMapField>)list, (Row)t2);
                    continue;
                }
                return true;
            }
        }
        return false;
    }

    protected void addChild(N parent, Iterable<Object> path, Iterable<TreeMapField> groupBy, Iterable<TreeMapField> childrenGroupBy, Row row) {
        Iterator<TreeMapField> iterator = groupBy.iterator();
        Iterator<TreeMapField> iterator2 = childrenGroupBy.iterator();
        for (Object object : path) {
            AbstractTreeMapNode abstractTreeMapNode;
            TreeMapField treeMapField = iterator.next();
            TreeMapField treeMapField2 = iterator2.next();
            if (this.hasNoChildren(parent) || this.findChild((AbstractTreeMapNode)parent, object) == null) {
                abstractTreeMapNode = this.createParentNode(object, treeMapField, treeMapField2);
                this.addChild(parent, abstractTreeMapNode);
            } else {
                abstractTreeMapNode = this.findChild((AbstractTreeMapNode)parent, object);
            }
            parent = abstractTreeMapNode;
        }
        this.addChild(parent, this.createLeafNode(row));
    }

    @Override
    public TreeMapField getTreeMapField(int columnIndex) {
        if (columnIndex >= 0 && columnIndex <= this.dataFrame.getColumnCount()) {
            return this.getTreeMapField(this.dataFrame.getColumnKey(columnIndex));
        }
        return new NoTreeMapField();
    }

    @Override
    public TreeMapField getTreeMapField(Column columnIndex) {
        if (columnIndex != null) {
            TreeMapField treeMapField;
            if (this.d.containsKey(columnIndex)) {
                treeMapField = this.d.get(columnIndex);
            } else {
                treeMapField = this.createTreeMapField(columnIndex);
                this.d.put(columnIndex, treeMapField);
            }
            return treeMapField;
        }
        return new NoTreeMapField();
    }

    protected TreeMapField createTreeMapField(Column columnIndex) {
        return new DefaultTreeMapField(this, columnIndex);
    }

    @Override
    public TreeMapField getTreeMapFieldByName(String columnName) {
        assert (this.dataFrame != null);
        assert (this.dataFrame.columns() != null);
        for (Object t2 : this.dataFrame.columns()) {
            if (!this.dataFrame.getColumnName(t2).equals(columnName)) continue;
            return this.getTreeMapField(this.dataFrame.getColumnAddress(t2));
        }
        return null;
    }

    @Override
    public DataFrame<Row, Column, ?> getDataFrame() {
        return this.dataFrame;
    }

    @Override
    public int getRowCount() {
        return this.dataFrame != null ? this.dataFrame.getRowCount() : 0;
    }

    @Override
    public int getColumnCount() {
        return this.dataFrame != null ? this.dataFrame.getColumnCount() : 0;
    }

    @Override
    public Iterable<Column> columns() {
        return this.dataFrame.columns();
    }

    @Override
    public String getColumnName(Column columnIndex) {
        return this.dataFrame != null ? this.dataFrame.getColumnName(columnIndex) : null;
    }

    @Override
    public Class<?> getColumnClass(Column columnIndex) {
        return this.dataFrame.getColumnClass(columnIndex);
    }

    @Override
    public synchronized Object getValueAt(N node, Column columnIndex) {
        Object Row = ((AbstractTreeMapNode)node).getRow();
        if (Row != null) {
            return this.dataFrame.getValueAt(Row, columnIndex);
        }
        return null;
    }

    @Override
    public boolean isEveryValueUnique(TreeMapField<N, Column> field) {
        boolean bl;
        boolean bl2 = bl = field.getType() == Float.class || field.getType() == Double.class;
        if (!bl) {
            bl = Boolean.TRUE;
            HashSet<Object> hashSet = new HashSet<Object>();
            Series series = this.dataFrame.getColumn(field.getIndex());
            for (Object t2 : this.dataFrame.rows()) {
                Object object = series.get(t2);
                if (hashSet.contains(object)) {
                    bl = Boolean.FALSE;
                    break;
                }
                hashSet.add(object);
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Double getNumericMax(TreeMapField<N, Column> columnIndex) {
        if (columnIndex != null && columnIndex.isValid()) {
            Map<TreeMapField, Double> map = this.e;
            synchronized (map) {
                if (!this.e.containsKey(columnIndex)) {
                    Number number = DataFrameHelper.getColumnStatistics(this.dataFrame, columnIndex.getIndex()).getMax();
                    if (number != null) {
                        this.e.put(columnIndex, number.doubleValue());
                    } else {
                        this.e.put(columnIndex, null);
                    }
                }
                return this.e.get(columnIndex);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Double getNumericMin(TreeMapField<N, Column> columnIndex) {
        if (columnIndex != null && columnIndex.isValid()) {
            Map<TreeMapField, Double> map = this.f;
            synchronized (map) {
                if (!this.f.containsKey(columnIndex)) {
                    Number number = DataFrameHelper.getColumnStatistics(this.dataFrame, columnIndex.getIndex()).getMin();
                    if (number != null) {
                        this.f.put(columnIndex, number.doubleValue());
                    } else {
                        this.f.put(columnIndex, null);
                    }
                }
                return this.f.get(columnIndex);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNumericMax(TreeMapField columnIndex, double max) {
        Map<TreeMapField, Double> map = this.f;
        synchronized (map) {
            this.e.put(columnIndex, max);
        }
        this.scheduleUpdateLayout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNumericMin(TreeMapField columnIndex, double min) {
        Map<TreeMapField, Double> map = this.f;
        synchronized (map) {
            this.f.put(columnIndex, min);
        }
        this.scheduleUpdateLayout();
    }

    @Override
    public MutableColorMap createDefaultColorMap(TreeMapField<N, Column> field) {
        DataFrameHelper.ColumnStatistics columnStatistics = DataFrameHelper.getColumnStatistics(this.dataFrame, field.getIndex());
        return DataFrameColorMapFactory.createColorMap((ColorMapFactory)this.colorMapFactory, this.dataFrame, field.getIndex(), (Number)columnStatistics.getMin(), (Number)columnStatistics.getMax());
    }

    @Override
    protected MutableColorMap<Color> createCategoricalColorMap(TreeMapField<N, Column> field) {
        return DataFrameColorMapFactory.createQualitativeColorMap((ColorMapFactory)this.colorMapFactory, this.dataFrame, field.getIndex());
    }
}

