/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.SystemFunctionCall;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.elab.Elaborator;
import net.sf.saxon.expr.elab.ItemElaborator;
import net.sf.saxon.expr.elab.ItemEvaluator;
import net.sf.saxon.functions.Round;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.NumericValue;

public final class RoundHalfToEven
extends SystemFunction {
    @Override
    public int getCardinality(Expression[] arguments) {
        return arguments[0].getCardinality();
    }

    @Override
    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        NumericValue scaleVal;
        NumericValue val0 = (NumericValue)arguments[0].head();
        if (val0 == null) {
            return EmptySequence.getInstance();
        }
        int scale = 0;
        if (arguments.length == 2 && (scaleVal = (NumericValue)arguments[1].head()) != null) {
            if (scaleVal.compareTo(Integer.MAX_VALUE) > 0) {
                return val0;
            }
            scale = scaleVal.compareTo(Integer.MIN_VALUE) < 0 ? Integer.MIN_VALUE : (int)scaleVal.longValue();
        }
        return val0.round(scale, Round.RoundingRule.HALF_TO_EVEN);
    }

    @Override
    public Elaborator getElaborator() {
        return new RoundHalfToEvenElaborator();
    }

    public static class RoundHalfToEvenElaborator
    extends ItemElaborator {
        @Override
        public ItemEvaluator elaborateForItem() {
            SystemFunctionCall fnc = (SystemFunctionCall)this.getExpression();
            ItemEvaluator arg0eval = fnc.getArg(0).makeElaborator().elaborateForItem();
            boolean nullable = Cardinality.allowsZero(fnc.getArg(0).getCardinality());
            if (fnc.getArity() == 1) {
                if (nullable) {
                    return context -> {
                        NumericValue result = (NumericValue)arg0eval.eval(context);
                        if (result == null) {
                            return null;
                        }
                        return result.round(0, Round.RoundingRule.HALF_TO_EVEN);
                    };
                }
                return context -> ((NumericValue)arg0eval.eval(context)).round(0, Round.RoundingRule.HALF_TO_EVEN);
            }
            if (fnc.getArg(1) instanceof Literal && ((Literal)fnc.getArg(1)).getGroundedValue() instanceof NumericValue) {
                NumericValue scaleVal = (NumericValue)((Literal)fnc.getArg(1)).getGroundedValue();
                if (scaleVal.compareTo(Integer.MAX_VALUE) > 0) {
                    return arg0eval;
                }
                try {
                    int scale = scaleVal.compareTo(Integer.MIN_VALUE) < 0 ? Integer.MIN_VALUE : (int)scaleVal.longValue();
                    return context -> {
                        NumericValue result = (NumericValue)arg0eval.eval(context);
                        if (result == null) {
                            return null;
                        }
                        return result.round(scale, Round.RoundingRule.HALF_TO_EVEN);
                    };
                }
                catch (XPathException e) {
                    return context -> {
                        throw e;
                    };
                }
            }
            ItemEvaluator scaleArg = fnc.getArg(1).makeElaborator().elaborateForItem();
            return context -> {
                NumericValue result = (NumericValue)arg0eval.eval(context);
                if (result == null) {
                    return null;
                }
                NumericValue scaleVal = (NumericValue)scaleArg.eval(context);
                int scale = 0;
                if (scaleVal != null) {
                    if (scaleVal.compareTo(Integer.MAX_VALUE) > 0) {
                        return result;
                    }
                    scale = scaleVal.compareTo(Integer.MIN_VALUE) < 0 ? Integer.MIN_VALUE : (int)scaleVal.longValue();
                }
                return result.round(scale, Round.RoundingRule.HALF_TO_EVEN);
            };
        }
    }
}

