/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.common;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.UnmarshallerHandler;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLFilter;
import org.xml.sax.XMLReader;

public final class UnmarshalHelper {
    public static final Object unmarshal(JAXBContext context, InputStream stream) throws JAXBException, SAXException, ParserConfigurationException {
        return context.createUnmarshaller().unmarshal((Source)new SAXSource(UnmarshalHelper.createXmlReader(), new InputSource(stream)));
    }

    public static final Object unmarshal(JAXBContext context, InputStream stream, XMLFilter filter) throws JAXBException, SAXException, ParserConfigurationException, IOException {
        return UnmarshalHelper.unmarshal(context, new InputSource(stream), filter, false);
    }

    public static final Object unmarshal(JAXBContext context, InputSource source, XMLFilter filter, boolean ignoreValidationErrors) throws JAXBException, SAXException, ParserConfigurationException, IOException {
        Unmarshaller unmarshaller = context.createUnmarshaller();
        if (ignoreValidationErrors) {
            unmarshaller.setEventHandler(new ValidationEventHandler(){

                public boolean handleEvent(ValidationEvent event) {
                    return true;
                }
            });
        }
        UnmarshallerHandler unmarshallerHandler = unmarshaller.getUnmarshallerHandler();
        filter.setParent(UnmarshalHelper.createXmlReader());
        filter.setContentHandler((ContentHandler)unmarshallerHandler);
        filter.parse(source);
        return unmarshallerHandler.getResult();
    }

    public static final XMLReader createXmlReader() throws SAXException, ParserConfigurationException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        factory.setNamespaceAware(true);
        return factory.newSAXParser().getXMLReader();
    }
}

