/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpx;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import net.sf.mpxj.AccrueType;
import net.sf.mpxj.ConstraintType;
import net.sf.mpxj.DataType;
import net.sf.mpxj.DateRange;
import net.sf.mpxj.Day;
import net.sf.mpxj.DayType;
import net.sf.mpxj.Duration;
import net.sf.mpxj.EventManager;
import net.sf.mpxj.Priority;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectCalendarException;
import net.sf.mpxj.ProjectCalendarHours;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectProperties;
import net.sf.mpxj.Rate;
import net.sf.mpxj.RecurrenceType;
import net.sf.mpxj.RecurringTask;
import net.sf.mpxj.Relation;
import net.sf.mpxj.RelationType;
import net.sf.mpxj.Resource;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.ResourceAssignmentWorkgroupFields;
import net.sf.mpxj.ResourceField;
import net.sf.mpxj.Task;
import net.sf.mpxj.TaskField;
import net.sf.mpxj.TaskType;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.common.DateHelper;
import net.sf.mpxj.common.NumberHelper;
import net.sf.mpxj.mpx.LocaleData;
import net.sf.mpxj.mpx.LocaleUtility;
import net.sf.mpxj.mpx.MPXConstants;
import net.sf.mpxj.mpx.MPXJFormats;
import net.sf.mpxj.mpx.MPXResourceField;
import net.sf.mpxj.mpx.MPXTaskField;
import net.sf.mpxj.mpx.RecurrenceUtility;
import net.sf.mpxj.mpx.ResourceModel;
import net.sf.mpxj.mpx.TaskModel;
import net.sf.mpxj.writer.AbstractProjectWriter;

public final class MPXWriter
extends AbstractProjectWriter {
    private ProjectFile m_projectFile;
    private EventManager m_eventManager;
    private OutputStreamWriter m_writer;
    private ResourceModel m_resourceModel;
    private TaskModel m_taskModel;
    private char m_delimiter;
    private Locale m_locale = Locale.ENGLISH;
    private boolean m_useLocaleDefaults = true;
    private StringBuilder m_buffer;
    private MPXJFormats m_formats;

    @Override
    public void write(ProjectFile projectFile, OutputStream out) throws IOException {
        this.m_projectFile = projectFile;
        this.m_eventManager = projectFile.getEventManager();
        if (this.m_useLocaleDefaults) {
            LocaleUtility.setLocale(this.m_projectFile.getProjectProperties(), this.m_locale);
        }
        this.m_delimiter = projectFile.getProjectProperties().getMpxDelimiter();
        this.m_writer = new OutputStreamWriter((OutputStream)new BufferedOutputStream(out), projectFile.getProjectProperties().getMpxCodePage().getCharset());
        this.m_buffer = new StringBuilder();
        this.m_formats = new MPXJFormats(this.m_locale, LocaleData.getString(this.m_locale, "NA"), this.m_projectFile);
        try {
            this.write();
        }
        finally {
            this.m_writer = null;
            this.m_projectFile = null;
            this.m_resourceModel = null;
            this.m_taskModel = null;
            this.m_buffer = null;
            this.m_locale = null;
            this.m_formats = null;
        }
    }

    private void write() throws IOException {
        this.m_projectFile.validateUniqueIDsForMicrosoftProject();
        this.writeFileCreationRecord();
        this.writeProjectHeader(this.m_projectFile.getProjectProperties());
        if (!this.m_projectFile.getResources().isEmpty()) {
            this.m_resourceModel = new ResourceModel(this.m_projectFile, this.m_locale);
            this.m_writer.write(this.m_resourceModel.toString());
            for (Resource resource : this.m_projectFile.getResources()) {
                this.writeResource(resource);
            }
        }
        if (!this.m_projectFile.getTasks().isEmpty()) {
            this.m_taskModel = new TaskModel(this.m_projectFile, this.m_locale);
            this.m_writer.write(this.m_taskModel.toString());
            this.writeTasks(this.m_projectFile.getChildTasks());
        }
        this.m_writer.flush();
    }

    private void writeFileCreationRecord() throws IOException {
        ProjectProperties properties = this.m_projectFile.getProjectProperties();
        this.m_buffer.setLength(0);
        this.m_buffer.append("MPX");
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(properties.getMpxProgramName());
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(properties.getMpxFileVersion());
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append((Object)properties.getMpxCodePage());
        this.m_buffer.append("\r\n");
        this.m_writer.write(this.m_buffer.toString());
    }

    private void writeProjectHeader(ProjectProperties properties) throws IOException {
        this.m_buffer.setLength(0);
        this.m_buffer.append(10);
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(properties.getCurrencySymbol()));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(properties.getSymbolPosition()));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(properties.getCurrencyDigits()));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(Character.valueOf(properties.getThousandsSeparator())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(Character.valueOf(properties.getDecimalSeparator())));
        this.stripTrailingDelimiters(this.m_buffer);
        this.m_buffer.append("\r\n");
        this.m_buffer.append(11);
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(properties.getDefaultDurationUnits().getValue()));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(properties.getDefaultDurationIsFixed() ? "1" : "0");
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(properties.getDefaultWorkUnits().getValue()));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatDecimal(NumberHelper.getDouble(properties.getMinutesPerDay()) / 60.0)));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatDecimal(NumberHelper.getDouble(properties.getMinutesPerWeek()) / 60.0)));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatRate(properties.getDefaultStandardRate())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatRate(properties.getDefaultOvertimeRate())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(properties.getUpdatingTaskStatusUpdatesResourceStatus() ? "1" : "0");
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(properties.getSplitInProgressTasks() ? "1" : "0");
        this.stripTrailingDelimiters(this.m_buffer);
        this.m_buffer.append("\r\n");
        this.m_buffer.append(12);
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(properties.getDateOrder()));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(properties.getTimeFormat()));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.getIntegerTimeInMinutes(properties.getDefaultStartTime())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(Character.valueOf(properties.getDateSeparator())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(Character.valueOf(properties.getTimeSeparator())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(properties.getAMText()));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(properties.getPMText()));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(properties.getDateFormat()));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(properties.getBarTextDateFormat()));
        this.stripTrailingDelimiters(this.m_buffer);
        this.m_buffer.append("\r\n");
        this.m_writer.write(this.m_buffer.toString());
        for (ProjectCalendar cal : this.m_projectFile.getCalendars()) {
            if (cal.getResource() != null) continue;
            this.writeCalendar(cal);
        }
        this.m_buffer.setLength(0);
        this.m_buffer.append(30);
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(properties.getProjectTitle()));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(properties.getCompany()));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(properties.getManager()));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(properties.getDefaultCalendarName()));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatDateTime(properties.getStartDate())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatDateTime(properties.getFinishDate())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(properties.getScheduleFrom()));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatDateTime(properties.getCurrentDate())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(properties.getComments()));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatCurrency(properties.getCost())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatCurrency(properties.getBaselineCost())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatCurrency(properties.getActualCost())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatDuration(properties.getWork())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatDuration(properties.getBaselineWork())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatDuration(properties.getActualWork())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatPercentage(properties.getWork2())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatDuration(properties.getDuration())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatDuration(properties.getBaselineDuration())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatDuration(properties.getActualDuration())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatPercentage(properties.getPercentageComplete())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatDateTime(properties.getBaselineStart())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatDateTime(properties.getBaselineFinish())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatDateTime(properties.getActualStart())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatDateTime(properties.getActualFinish())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatDuration(properties.getStartVariance())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatDuration(properties.getFinishVariance())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(properties.getSubject()));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(properties.getAuthor()));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(properties.getKeywords()));
        this.stripTrailingDelimiters(this.m_buffer);
        this.m_buffer.append("\r\n");
        this.m_writer.write(this.m_buffer.toString());
    }

    private void writeCalendar(ProjectCalendar record) throws IOException {
        if (record.getParent() == null || record.getResource() != null) {
            this.m_buffer.setLength(0);
            if (record.getParent() == null) {
                this.m_buffer.append(20);
                this.m_buffer.append(this.m_delimiter);
                if (record.getName() != null) {
                    this.m_buffer.append(record.getName());
                }
            } else {
                this.m_buffer.append(55);
                this.m_buffer.append(this.m_delimiter);
                this.m_buffer.append(record.getParent().getName());
            }
            for (DayType day : record.getDays()) {
                if (day == null) {
                    day = DayType.DEFAULT;
                }
                this.m_buffer.append(this.m_delimiter);
                this.m_buffer.append(day.getValue());
            }
            this.m_buffer.append("\r\n");
            this.m_writer.write(this.m_buffer.toString());
            ProjectCalendarHours[] hours = record.getHours();
            for (int loop = 0; loop < hours.length; ++loop) {
                if (hours[loop] == null) continue;
                this.writeCalendarHours(record, hours[loop]);
            }
            if (!record.getCalendarExceptions().isEmpty()) {
                for (ProjectCalendarException ex : record.getCalendarExceptions()) {
                    this.writeCalendarException(record, ex);
                }
            }
            this.m_eventManager.fireCalendarWrittenEvent(record);
        }
    }

    private void writeCalendarHours(ProjectCalendar parentCalendar, ProjectCalendarHours record) throws IOException {
        DateRange range3;
        DateRange range2;
        this.m_buffer.setLength(0);
        int recordNumber = !parentCalendar.isDerived() ? 25 : 56;
        DateRange range1 = record.getRange(0);
        if (range1 == null) {
            range1 = DateRange.EMPTY_RANGE;
        }
        if ((range2 = record.getRange(1)) == null) {
            range2 = DateRange.EMPTY_RANGE;
        }
        if ((range3 = record.getRange(2)) == null) {
            range3 = DateRange.EMPTY_RANGE;
        }
        this.m_buffer.append(recordNumber);
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(record.getDay()));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatTime(range1.getStart())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatTime(range1.getEnd())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatTime(range2.getStart())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatTime(range2.getEnd())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatTime(range3.getStart())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatTime(range3.getEnd())));
        this.stripTrailingDelimiters(this.m_buffer);
        this.m_buffer.append("\r\n");
        this.m_writer.write(this.m_buffer.toString());
    }

    private void writeCalendarException(ProjectCalendar parentCalendar, ProjectCalendarException record) throws IOException {
        this.m_buffer.setLength(0);
        if (!parentCalendar.isDerived()) {
            this.m_buffer.append(26);
        } else {
            this.m_buffer.append(57);
        }
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatDate(record.getFromDate())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatDate(record.getToDate())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(record.getWorking() ? "1" : "0");
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatTime(record.getRange(0).getStart())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatTime(record.getRange(0).getEnd())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatTime(record.getRange(1).getStart())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatTime(record.getRange(1).getEnd())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatTime(record.getRange(2).getStart())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatTime(record.getRange(2).getEnd())));
        this.stripTrailingDelimiters(this.m_buffer);
        this.m_buffer.append("\r\n");
        this.m_writer.write(this.m_buffer.toString());
    }

    private void writeResource(Resource record) throws IOException {
        int mpxFieldType;
        this.m_buffer.setLength(0);
        int[] fields = this.m_resourceModel.getModel();
        this.m_buffer.append(50);
        for (int loop = 0; loop < fields.length && (mpxFieldType = fields[loop]) != -1; ++loop) {
            ResourceField resourceField = MPXResourceField.getMpxjField(mpxFieldType);
            Object value = record.getCachedValue(resourceField);
            value = this.formatType(resourceField.getDataType(), value);
            this.m_buffer.append(this.m_delimiter);
            this.m_buffer.append(this.format(value));
        }
        this.stripTrailingDelimiters(this.m_buffer);
        this.m_buffer.append("\r\n");
        this.m_writer.write(this.m_buffer.toString());
        String notes = record.getNotes();
        if (notes.length() != 0) {
            this.writeNotes(51, notes);
        }
        if (record.getResourceCalendar() != null) {
            this.writeCalendar(record.getResourceCalendar());
        }
        this.m_eventManager.fireResourceWrittenEvent(record);
    }

    private void writeNotes(int recordNumber, String text) throws IOException {
        this.m_buffer.setLength(0);
        this.m_buffer.append(recordNumber);
        this.m_buffer.append(this.m_delimiter);
        if (text != null) {
            String note = this.stripLineBreaks(text, MPXConstants.EOL_PLACEHOLDER_STRING);
            boolean quote = note.indexOf(this.m_delimiter) != -1 || note.indexOf(34) != -1;
            int length = note.length();
            if (quote) {
                this.m_buffer.append('\"');
            }
            block3: for (int loop = 0; loop < length; ++loop) {
                char c = note.charAt(loop);
                switch (c) {
                    case '\"': {
                        this.m_buffer.append("\"\"");
                        continue block3;
                    }
                    default: {
                        this.m_buffer.append(c);
                    }
                }
            }
            if (quote) {
                this.m_buffer.append('\"');
            }
        }
        this.m_buffer.append("\r\n");
        this.m_writer.write(this.m_buffer.toString());
    }

    private void writeTask(Task record) throws IOException {
        int field;
        this.m_buffer.setLength(0);
        int[] fields = this.m_taskModel.getModel();
        this.m_buffer.append(70);
        for (int loop = 0; loop < fields.length && (field = fields[loop]) != -1; ++loop) {
            TaskField taskField = MPXTaskField.getMpxjField(field);
            Object value = record.getCachedValue(taskField);
            value = this.formatType(taskField.getDataType(), value);
            this.m_buffer.append(this.m_delimiter);
            this.m_buffer.append(this.format(value));
        }
        this.stripTrailingDelimiters(this.m_buffer);
        this.m_buffer.append("\r\n");
        this.m_writer.write(this.m_buffer.toString());
        String notes = record.getNotes();
        if (notes.length() != 0) {
            this.writeNotes(71, notes);
        }
        if (record.getRecurringTask() != null) {
            this.writeRecurringTask(record.getRecurringTask());
        }
        if (!record.getResourceAssignments().isEmpty()) {
            for (ResourceAssignment assignment : record.getResourceAssignments()) {
                this.writeResourceAssignment(assignment);
            }
        }
        this.m_eventManager.fireTaskWrittenEvent(record);
    }

    private void writeRecurringTask(RecurringTask record) throws IOException {
        this.m_buffer.setLength(0);
        this.m_buffer.append(72);
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append("1");
        if (record.getRecurrenceType() != null) {
            boolean monthlyRelative = record.getRecurrenceType() == RecurrenceType.MONTHLY && record.getRelative();
            boolean monthlyAbsolute = record.getRecurrenceType() == RecurrenceType.MONTHLY && !record.getRelative();
            boolean yearlyRelative = record.getRecurrenceType() == RecurrenceType.YEARLY && record.getRelative();
            boolean yearlyAbsolute = record.getRecurrenceType() == RecurrenceType.YEARLY && !record.getRelative();
            this.m_buffer.append(this.m_delimiter);
            this.m_buffer.append(this.format(this.formatDateTime(record.getStartDate())));
            this.m_buffer.append(this.m_delimiter);
            this.m_buffer.append(this.format(this.formatDateTime(record.getFinishDate())));
            this.m_buffer.append(this.m_delimiter);
            this.m_buffer.append(this.format(RecurrenceUtility.getDurationValue(this.m_projectFile.getProjectProperties(), record.getDuration())));
            this.m_buffer.append(this.m_delimiter);
            this.m_buffer.append(this.format(RecurrenceUtility.getDurationUnits(record)));
            this.m_buffer.append(this.m_delimiter);
            this.m_buffer.append(this.format(record.getOccurrences()));
            this.m_buffer.append(this.m_delimiter);
            this.m_buffer.append(this.format(RecurrenceUtility.getRecurrenceValue(record.getRecurrenceType())));
            this.m_buffer.append(this.m_delimiter);
            this.m_buffer.append("0");
            this.m_buffer.append(this.m_delimiter);
            this.m_buffer.append(record.getUseEndDate() ? "1" : "0");
            this.m_buffer.append(this.m_delimiter);
            this.m_buffer.append(record.isWorkingDaysOnly() ? "1" : "0");
            this.m_buffer.append(this.m_delimiter);
            this.m_buffer.append(this.format(RecurrenceUtility.getDays(record)));
            this.m_buffer.append(this.m_delimiter);
            this.m_buffer.append(monthlyRelative ? "1" : "0");
            this.m_buffer.append(this.m_delimiter);
            this.m_buffer.append(yearlyAbsolute ? "1" : "0");
            this.m_buffer.append(this.m_delimiter);
            this.m_buffer.append(this.format(record.getRecurrenceType() == RecurrenceType.DAILY ? record.getFrequency() : "1"));
            this.m_buffer.append(this.m_delimiter);
            this.m_buffer.append(this.format(record.getRecurrenceType() == RecurrenceType.WEEKLY ? record.getFrequency() : "1"));
            this.m_buffer.append(this.m_delimiter);
            this.m_buffer.append(this.format(monthlyRelative ? record.getDayNumber() : "1"));
            this.m_buffer.append(this.m_delimiter);
            this.m_buffer.append(this.format(RecurrenceUtility.getDay(monthlyRelative ? record.getDayOfWeek() : Day.MONDAY)));
            this.m_buffer.append(this.m_delimiter);
            this.m_buffer.append(this.format(monthlyRelative ? record.getFrequency() : "1"));
            this.m_buffer.append(this.m_delimiter);
            this.m_buffer.append(this.format(monthlyAbsolute ? record.getDayNumber() : "1"));
            this.m_buffer.append(this.m_delimiter);
            this.m_buffer.append(this.format(monthlyAbsolute ? record.getFrequency() : "1"));
            this.m_buffer.append(this.m_delimiter);
            this.m_buffer.append(this.format(yearlyRelative ? record.getDayNumber() : "1"));
            this.m_buffer.append(this.m_delimiter);
            this.m_buffer.append(this.format(RecurrenceUtility.getDay(yearlyRelative ? record.getDayOfWeek() : Day.MONDAY)));
            this.m_buffer.append(this.m_delimiter);
            this.m_buffer.append(this.format(record.getMonthNumber()));
            this.m_buffer.append(this.m_delimiter);
            this.m_buffer.append(this.format(this.formatDateTime(RecurrenceUtility.getYearlyAbsoluteAsDate(record))));
            this.stripTrailingDelimiters(this.m_buffer);
        }
        this.m_buffer.append("\r\n");
        this.m_writer.write(this.m_buffer.toString());
    }

    private void writeResourceAssignment(ResourceAssignment record) throws IOException {
        this.m_buffer.setLength(0);
        this.m_buffer.append(75);
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.formatResource(record.getResource()));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatUnits(record.getUnits())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatDuration(record.getWork())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatDuration(record.getBaselineWork())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatDuration(record.getActualWork())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatDuration(record.getOvertimeWork())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatCurrency(record.getCost())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatCurrency(record.getBaselineCost())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatCurrency(record.getActualCost())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatDateTime(record.getStart())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatDateTime(record.getFinish())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatDuration(record.getDelay())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(record.getResourceUniqueID()));
        this.stripTrailingDelimiters(this.m_buffer);
        this.m_buffer.append("\r\n");
        this.m_writer.write(this.m_buffer.toString());
        ResourceAssignmentWorkgroupFields workgroup = record.getWorkgroupAssignment();
        if (workgroup == null) {
            workgroup = ResourceAssignmentWorkgroupFields.EMPTY;
        }
        this.writeResourceAssignmentWorkgroupFields(workgroup);
        this.m_eventManager.fireAssignmentWrittenEvent(record);
    }

    private void writeResourceAssignmentWorkgroupFields(ResourceAssignmentWorkgroupFields record) throws IOException {
        this.m_buffer.setLength(0);
        this.m_buffer.append(76);
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(record.getMessageUniqueID()));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(record.getConfirmed() ? "1" : "0");
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(record.getResponsePending() ? "1" : "0");
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatDateTimeNull(record.getUpdateStart())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatDateTimeNull(record.getUpdateFinish())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(record.getScheduleID()));
        this.stripTrailingDelimiters(this.m_buffer);
        this.m_buffer.append("\r\n");
        this.m_writer.write(this.m_buffer.toString());
    }

    private void writeTasks(List<Task> tasks) throws IOException {
        for (Task task : tasks) {
            this.writeTask(task);
            this.writeTasks(task.getChildTasks());
        }
    }

    private Integer getIntegerTimeInMinutes(Date date) {
        Integer result = null;
        if (date != null) {
            Calendar cal = DateHelper.popCalendar(date);
            int time = cal.get(11) * 60;
            DateHelper.pushCalendar(cal);
            result = time += cal.get(12);
        }
        return result;
    }

    private String escapeQuotes(String value) {
        StringBuilder sb = new StringBuilder();
        int length = value.length();
        sb.append('\"');
        for (int index = 0; index < length; ++index) {
            char c = value.charAt(index);
            sb.append(c);
            if (c != '\"') continue;
            sb.append('\"');
        }
        sb.append('\"');
        return sb.toString();
    }

    private String stripLineBreaks(String text, String replacement) {
        if (text.indexOf(13) != -1 || text.indexOf(10) != -1) {
            int index;
            StringBuilder sb = new StringBuilder(text);
            while ((index = sb.indexOf("\r\n")) != -1) {
                sb.replace(index, index + 2, replacement);
            }
            while ((index = sb.indexOf("\n\r")) != -1) {
                sb.replace(index, index + 2, replacement);
            }
            while ((index = sb.indexOf("\r")) != -1) {
                sb.replace(index, index + 1, replacement);
            }
            while ((index = sb.indexOf("\n")) != -1) {
                sb.replace(index, index + 1, replacement);
            }
            text = sb.toString();
        }
        return text;
    }

    private String format(Object o) {
        String result;
        if (o == null) {
            result = "";
        } else {
            result = o instanceof Boolean ? LocaleData.getString(this.m_locale, (Boolean)o == true ? "YES" : "NO") : (o instanceof Float || o instanceof Double ? this.m_formats.getDecimalFormat().format(((Number)o).doubleValue()) : (o instanceof Day ? Integer.toString(((Day)o).getValue()) : o.toString()));
            if ((result = this.stripLineBreaks(result, MPXConstants.EOL_PLACEHOLDER_STRING)).indexOf(34) != -1) {
                result = this.escapeQuotes(result);
            } else if (result.indexOf(this.m_delimiter) != -1) {
                result = '\"' + result + '\"';
            }
        }
        return result;
    }

    private void stripTrailingDelimiters(StringBuilder buffer) {
        int index;
        for (index = buffer.length() - 1; index > 0 && buffer.charAt(index) == this.m_delimiter; --index) {
        }
        buffer.setLength(index + 1);
    }

    private String formatTime(Date value) {
        return value == null ? null : this.m_formats.getTimeFormat().format(value);
    }

    private String formatCurrency(Number value) {
        return value == null ? null : this.m_formats.getCurrencyFormat().format(value);
    }

    private String formatUnits(Number value) {
        return value == null ? null : this.m_formats.getUnitsDecimalFormat().format(value.doubleValue() / 100.0);
    }

    private String formatDateTime(Object value) {
        String result = null;
        if (value instanceof Date) {
            result = this.m_formats.getDateTimeFormat().format(value);
        }
        return result;
    }

    private String formatDateTimeNull(Date value) {
        return value == null ? this.m_formats.getNullText() : this.m_formats.getDateTimeFormat().format(value);
    }

    private String formatDate(Date value) {
        return value == null ? null : this.m_formats.getDateFormat().format(value);
    }

    private String formatPercentage(Number value) {
        return value == null ? null : this.m_formats.getPercentageDecimalFormat().format(value) + "%";
    }

    private String formatAccrueType(AccrueType type) {
        return type == null ? null : LocaleData.getStringArray(this.m_locale, "ACCRUE_TYPES")[type.getValue() - 1];
    }

    private String formatConstraintType(ConstraintType type) {
        if (type == null) {
            return null;
        }
        switch (type) {
            case MANDATORY_START: 
            case START_ON: {
                type = ConstraintType.MUST_START_ON;
                break;
            }
            case MANDATORY_FINISH: 
            case FINISH_ON: {
                type = ConstraintType.MUST_FINISH_ON;
                break;
            }
        }
        return LocaleData.getStringArray(this.m_locale, "CONSTRAINT_TYPES")[type.getValue()];
    }

    private String formatDuration(Object value) {
        String result = null;
        if (value instanceof Duration) {
            Duration duration = (Duration)value;
            result = this.m_formats.getDurationDecimalFormat().format(duration.getDuration()) + this.formatTimeUnit(duration.getUnits());
        }
        return result;
    }

    private String formatRate(Rate value) {
        String result = null;
        if (value != null) {
            StringBuilder buffer = new StringBuilder(this.m_formats.getCurrencyFormat().format(value.getAmount()));
            buffer.append("/");
            buffer.append(this.formatTimeUnit(value.getUnits()));
            result = buffer.toString();
        }
        return result;
    }

    private String formatPriority(Priority value) {
        String result = null;
        if (value != null) {
            String[] priorityTypes = LocaleData.getStringArray(this.m_locale, "PRIORITY_TYPES");
            int priority = value.getValue();
            if (priority < 100) {
                priority = 100;
            } else if (priority > 1000) {
                priority = 1000;
            }
            result = priorityTypes[(priority /= 100) - 1];
        }
        return result;
    }

    private String formatTaskType(TaskType value) {
        return LocaleData.getString(this.m_locale, value == TaskType.FIXED_DURATION ? "YES" : "NO");
    }

    private String formatRelationList(List<Relation> value) {
        String result = null;
        if (value != null && value.size() != 0) {
            StringBuilder sb = new StringBuilder();
            for (Relation relation : value) {
                if (sb.length() != 0) {
                    sb.append(this.m_delimiter);
                }
                sb.append(this.formatRelation(relation));
            }
            result = sb.toString();
        }
        return result;
    }

    private String formatRelation(Relation relation) {
        String result = null;
        if (relation != null) {
            StringBuilder sb = new StringBuilder(relation.getTargetTask().getID().toString());
            Duration duration = relation.getLag();
            RelationType type = relation.getType();
            double durationValue = duration.getDuration();
            if (durationValue != 0.0 || type != RelationType.FINISH_START) {
                String[] typeNames = LocaleData.getStringArray(this.m_locale, "RELATION_TYPES");
                sb.append(typeNames[type.getValue()]);
            }
            if (durationValue != 0.0) {
                if (durationValue > 0.0) {
                    sb.append('+');
                }
                sb.append(this.formatDuration(duration));
            }
            result = sb.toString();
        }
        this.m_eventManager.fireRelationWrittenEvent(relation);
        return result;
    }

    private String formatTimeUnit(TimeUnit timeUnit) {
        int units = timeUnit.getValue();
        String[][] unitNames = LocaleData.getStringArrays(this.m_locale, "TIME_UNITS_ARRAY");
        String result = units < 0 || units >= unitNames.length ? "" : unitNames[units][0];
        return result;
    }

    private String formatDecimal(double value) {
        return this.m_formats.getDecimalFormat().format(value);
    }

    private Object formatType(DataType type, Object value) {
        switch (type) {
            case DATE: {
                value = this.formatDateTime(value);
                break;
            }
            case CURRENCY: {
                value = this.formatCurrency((Number)value);
                break;
            }
            case UNITS: {
                value = this.formatUnits((Number)value);
                break;
            }
            case PERCENTAGE: {
                value = this.formatPercentage((Number)value);
                break;
            }
            case ACCRUE: {
                value = this.formatAccrueType((AccrueType)value);
                break;
            }
            case CONSTRAINT: {
                value = this.formatConstraintType((ConstraintType)value);
                break;
            }
            case WORK: 
            case DURATION: {
                value = this.formatDuration(value);
                break;
            }
            case RATE: {
                value = this.formatRate((Rate)value);
                break;
            }
            case PRIORITY: {
                value = this.formatPriority((Priority)value);
                break;
            }
            case RELATION_LIST: {
                value = this.formatRelationList((List)value);
                break;
            }
            case TASK_TYPE: {
                value = this.formatTaskType((TaskType)value);
                break;
            }
        }
        return value;
    }

    private String formatResource(Resource resource) {
        return resource == null ? "-65535" : this.format(resource.getID());
    }

    public Locale getLocale() {
        return this.m_locale;
    }

    public void setLocale(Locale locale) {
        this.m_locale = locale;
    }

    public boolean getUseLocaleDefaults() {
        return this.m_useLocaleDefaults;
    }

    public void setUseLocaleDefaults(boolean useLocaleDefaults) {
        this.m_useLocaleDefaults = useLocaleDefaults;
    }

    public Locale[] getSupportedLocales() {
        return LocaleUtility.getSupportedLocales();
    }
}

