/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.app.swing.configuration;

import com.jidesoft.swing.JideBoxLayout;
import com.macrofocus.combobox.MMultiSelectListComboBox;
import com.macrofocus.helper.WeakActionListeners;
import com.treemap.TreeMapField;
import com.treemap.app.swing.configuration.FilterPanel;
import com.treemap.app.swing.configuration.InnerFiltersPanel;
import com.treemap.app.swing.v4.model.MTreeMapModel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.Set;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JLabel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class CategoricalFilterPanel
extends FilterPanel {
    private DefaultComboBoxModel model;
    private MMultiSelectListComboBox comboBox;
    private Set selected;
    private MTreeMapModel tmm;
    private InnerFiltersPanel filtersPanel;
    private final WeakActionListeners actionListeners = new WeakActionListeners();

    public CategoricalFilterPanel(InnerFiltersPanel filtersPanel, MTreeMapModel tmm, TreeMapField variable) {
        this.filtersPanel = filtersPanel;
        this.tmm = tmm;
        this.selected = new HashSet();
        String sliderName = variable.getName();
        JLabel field = new JLabel(sliderName){

            @Override
            public Dimension getMinimumSize() {
                return new Dimension(0, 0);
            }
        };
        field.setToolTipText(sliderName);
        field.setHorizontalAlignment(0);
        this.model = new DefaultComboBoxModel();
        this.comboBox = new MMultiSelectListComboBox(true);
        this.comboBox.setModel((ComboBoxModel)this.model);
        this.comboBox.setEditable(false);
        this.comboBox.setPopupType(0);
        this.comboBox.setStretchToFit(true);
        this.comboBox.setUpdateOnChange(true);
        this.fill(this.comboBox, variable);
        this.comboBox.setSelectedItem(null);
        this.model.addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                CategoricalFilterPanel.this.updateSelected();
            }
        });
        this.comboBox.addActionListener(this.actionListeners.create(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CategoricalFilterPanel.this.updateSelected();
            }
        }, (Object)this.comboBox));
        this.setLayout((LayoutManager)new JideBoxLayout((Container)((Object)this), 1));
        this.add(field, "fix");
        this.add((Component)this.comboBox, "flexible");
    }

    private void updateSelected() {
        Object[] array = this.comboBox.getSelectedObjects();
        this.selected.clear();
        for (Object o : array) {
            this.selected.add(o);
        }
        this.filtersPanel.applyFilters();
    }

    public void setFilter(Object[] array) {
        this.comboBox.getModel().setSelectedItem(array);
        this.updateSelected();
    }

    @Override
    public Boolean applyFilters(Object object) {
        return this.selected.size() > 0 && !this.selected.contains(object);
    }

    @Override
    public void reset() {
        this.comboBox.setSelectedItem(null);
    }

    void fill(MMultiSelectListComboBox choice, TreeMapField variable) {
        Set set = this.tmm.getValues(variable);
        for (Object o : set) {
            this.model.addElement(o);
        }
    }
}

