/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.app.swing.document;

import com.jidesoft.status.ProgressStatusBarItem;
import com.jidesoft.status.ResizeStatusBarItem;
import com.jidesoft.status.StatusBar;
import com.macrofocus.application.status.CPStatusBar;
import com.macrofocus.common.properties.MutableProperty;
import com.macrofocus.common.properties.PropertyEvent;
import com.macrofocus.common.properties.PropertyListener;
import com.macrofocus.helper.ComponentCleaner;
import com.macrofocus.resources.ResourcesModel;
import com.macrofocus.util.java2d.RenderingHintsModel;
import com.macrofocus.util.swing.logo.Java2DLogoView;
import com.treemap.TreeMapModel;
import com.treemap.TreeMapWorker;
import com.treemap.app.swing.presentation.implementation.PathPanel;
import de.javasoft.syntheticaaddons.SystemMonitor;
import de.javasoft.syntheticaaddons.systemmonitor.CollectorFactory;
import de.javasoft.syntheticaaddons.systemmonitor.ModelChangedListener;
import de.javasoft.syntheticaaddons.systemmonitor.SystemMonitorModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;

public class SwingTreeMapStatusBar
extends StatusBar
implements CPStatusBar<JComponent> {
    private Java2DLogoView logoView;
    private final ProgressStatusBarItem progress;
    private final PathPanel pathPanel;
    private SystemMonitor monitor;
    private static SystemMonitorModel systemMonitorModel;
    private TreeMapModel<?, ?, ?, Color, Font> treeMapModel;
    private final Timer timer;
    private final PropertyListener<Integer> listener = new PropertyListener<Integer>(){

        public void propertyChanged(PropertyEvent<Integer> event) {
            SwingTreeMapStatusBar.this.updateProgress();
        }
    };

    private void updateProgress() {
        final int p = (Integer)this.treeMapModel.progressProperty().getValue();
        if (p < 100) {
            final JProgressBar progressBar = this.getProgress().getProgressBar();
            if (p == 0) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        progressBar.setIndeterminate(true);
                    }
                });
            } else {
                if (progressBar.isIndeterminate()) {
                    try {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                progressBar.setIndeterminate(false);
                            }
                        });
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SwingTreeMapStatusBar.this.getProgress().setProgress(p);
                    }
                });
            }
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SwingTreeMapStatusBar.this.getProgress().setProgress(p);
                }
            });
        }
    }

    public SwingTreeMapStatusBar(Action aboutAction, ResourcesModel resourcesModel, RenderingHintsModel renderingHintsModel) {
        this.timer = new Timer(30, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingTreeMapStatusBar.this.updateProgress();
            }
        });
        this.timer.setRepeats(false);
        this.timer.setCoalesce(true);
        this.progress = new ProgressStatusBarItem();
        this.progress.setCancelCallback(new ProgressStatusBarItem.CancelCallback(){

            public void cancelPerformed() {
                TreeMapWorker worker;
                if (SwingTreeMapStatusBar.this.treeMapModel != null && (worker = SwingTreeMapStatusBar.this.treeMapModel.getWorker()) != null) {
                    worker.cancel();
                }
            }
        });
        this.getProgress().setProgress(100);
        this.add((Component)this.progress, "flexible");
        this.pathPanel = new PathPanel();
        this.add(this.pathPanel, "vary");
        this.logoView = new Java2DLogoView(aboutAction, renderingHintsModel, resourcesModel != null ? resourcesModel.getPropertiesModel() : null);
        this.logoView.setBorder(BorderFactory.createEmptyBorder(2, 5, 2, 5));
        this.logoView.setPreferredSize(new Dimension(100, 100));
        this.add((Component)this.logoView, "flexible");
        try {
            JComponent gc = this.createSyntheticaSystemMonitor();
            this.add(gc, "flexible");
        }
        catch (ExceptionInInitializerError | NoClassDefFoundError gc) {
            // empty catch block
        }
        ResizeStatusBarItem resize = new ResizeStatusBarItem();
        this.add((Component)resize, "flexible");
    }

    private JComponent createSyntheticaSystemMonitor() {
        SystemMonitorModel model = SwingTreeMapStatusBar.getSystemMonitorModel();
        this.monitor = new SyntheticaSystemMonitor(model);
        return this.monitor;
    }

    private static SystemMonitorModel getSystemMonitorModel() {
        if (systemMonitorModel == null) {
            systemMonitorModel = new SystemMonitorModel();
            int collectorDelay = 500;
            int collectorBufferSize = 400;
            systemMonitorModel.addCollector(CollectorFactory.CollectorID.HEAP_MEMORY_USAGE.id, collectorBufferSize, collectorDelay, CollectorFactory.getFactory().createCollector(CollectorFactory.CollectorID.HEAP_MEMORY_USAGE.id));
            systemMonitorModel.addCollector(CollectorFactory.CollectorID.CPU_USAGE.id, collectorBufferSize, collectorDelay, CollectorFactory.getFactory().createCollector(CollectorFactory.CollectorID.CPU_USAGE.id));
            systemMonitorModel.setColor(CollectorFactory.CollectorID.CPU_USAGE.id, new Color(240, 192, 192));
            systemMonitorModel.setColor(CollectorFactory.CollectorID.HEAP_MEMORY_USAGE.id, new Color(192, 192, 240));
        }
        return systemMonitorModel;
    }

    public void setModel(TreeMapModel<?, ?, ?, Color, Font> treeMapModel) {
        if (this.treeMapModel != null) {
            this.treeMapModel.progressProperty().removePropertyListener(this.listener);
        }
        this.treeMapModel = treeMapModel;
        if (this.treeMapModel != null) {
            this.treeMapModel.progressProperty().addPropertyListener(this.listener);
        }
        this.getPathPanel().setModel(treeMapModel);
    }

    public PathPanel getPathPanel() {
        return this.pathPanel;
    }

    public void setLogoVisible(boolean visible) {
        this.logoView.setVisible(visible);
    }

    public ProgressStatusBarItem getProgress() {
        return this.progress;
    }

    public JComponent getNativeComponent() {
        return this;
    }

    public void setStatus(MutableProperty<String> status) {
    }

    public void setStatusComponent(JComponent component) {
    }

    public void dispose() {
        this.setModel(null);
        if (this.logoView != null) {
            this.logoView.setAction(null);
            this.remove((Component)this.logoView);
            ComponentCleaner.cleanComponent((Component)this.logoView);
            this.logoView = null;
        }
        if (this.monitor != null) {
            this.monitor.getModel().removeModelChangedListener((ModelChangedListener)this.monitor);
            this.monitor.stopRepaintThread();
            this.monitor.setModel(null);
            this.remove((Component)this.monitor);
            ComponentCleaner.cleanComponent((Component)this.monitor);
            this.monitor = null;
        }
        ComponentCleaner.cleanComponent((Component)((Object)this));
    }

    private static class SyntheticaSystemMonitor
    extends SystemMonitor {
        public SyntheticaSystemMonitor(SystemMonitorModel model) {
            super(false);
            this.setOpaque(false);
            this.setBackground(UIManager.getColor("Panel.background"));
            this.setGridColor(new Color(127, 127, 127, 15));
            this.setGridSize(10);
            this.setBorder(BorderFactory.createEmptyBorder());
            this.setPreferredSize(new Dimension(40, 0));
            this.setModel(model);
            this.addCaption(CollectorFactory.CollectorID.CPU_USAGE.id, "CPU Usage:", "%{percentValue}.0f%%", true);
            this.addCaption(CollectorFactory.CollectorID.HEAP_MEMORY_USAGE.id, "Heap Usage:", "%{value},.2fMB / %{maxValue},.2fMB", true);
            this.setSpotlightEnabled(false);
            this.setPopupEnabled(true);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (e.getClickCount() > 1) {
                        System.gc();
                    }
                }
            });
        }

        public void updateUI() {
            super.updateUI();
            this.setBackground(UIManager.getColor("Panel.background"));
        }
    }
}

