/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.app.swing.presentation.implementation;

import com.jidesoft.grid.AbstractExpandableRow;
import com.jidesoft.grid.Expandable;
import com.jidesoft.grid.Row;
import com.macrofocus.geom.Shape;
import com.treemap.AbstractLabeling;
import com.treemap.AbstractTreeMapNode;
import com.treemap.TreeMapModel;
import com.treemap.app.swing.presentation.implementation.treetable.TreeMapTreeTableModel;
import java.awt.Color;
import java.util.List;

public class TreeMapRow
extends AbstractExpandableRow {
    private final AbstractTreeMapNode node;
    private final TreeMapModel model;
    private final boolean expertMode;
    private List<?> _children;

    public TreeMapRow(AbstractTreeMapNode node, TreeMapModel model, boolean expertMode) {
        this.node = node;
        this.model = model;
        this.expertMode = expertMode;
    }

    public AbstractTreeMapNode getNode() {
        return this.node;
    }

    public List<?> getChildren() {
        if (this._children != null) {
            return this._children;
        }
        List<?> list = TreeMapTreeTableModel.getChildrenList(this.node, this.model, this.expertMode);
        this.setChildren(list);
        return list;
    }

    public void setChildren(List<?> children) {
        this._children = children;
        if (this._children != null) {
            for (Object row : this._children) {
                if (!(row instanceof Row)) continue;
                ((Row)row).setParent((Expandable)this);
            }
        }
    }

    public boolean hasChildren() {
        return this.getChildrenCount() > 0;
    }

    public Object getValueAt(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                break;
            }
            case 1: {
                double v = this.model.getSize((Object)this.node) / this.model.getSumSize(this.model.getParent((Object)this.node));
                if (!Double.isNaN(v) && !Double.isInfinite(v)) {
                    return v;
                }
                return null;
            }
            case 2: {
                return this.model.getColor((Object)this.node).getNativeColor();
            }
            case 3: {
                if (this.expertMode) {
                    double screenArea = Math.abs(AbstractLabeling.getArea((Shape)this.model.getNestedShape(this.model.getParent((Object)this.node))));
                    double shapeArea = Math.abs(AbstractLabeling.getArea((Shape)this.model.getShape((Object)this.node)));
                    if (shapeArea > 0.0) {
                        double screenRatio = shapeArea / screenArea;
                        return screenRatio;
                    }
                    return Double.NaN;
                }
            }
            case 4: {
                if (this.expertMode) {
                    double screenArea = Math.abs(AbstractLabeling.getArea((Shape)this.model.getNestedShape(this.model.getParent((Object)this.node))));
                    double shapeArea = Math.abs(AbstractLabeling.getArea((Shape)this.model.getShape((Object)this.node)));
                    if (shapeArea > 0.0) {
                        double worldSize = this.model.getSumSize(this.model.getParent((Object)this.node));
                        double screenRatio = shapeArea / screenArea;
                        double worldRatio = this.model.getSize((Object)this.node) / worldSize;
                        double error = screenRatio / worldRatio - 1.0;
                        error = (double)Math.round(error * 100000.0) / 100000.0;
                        return error;
                    }
                    return Double.NaN;
                }
            }
            case 5: {
                if (this.expertMode) {
                    double screenArea = Math.abs(AbstractLabeling.getArea((Shape)this.model.getNestedShape(this.model.getParent((Object)this.node))));
                    double shapeArea = Math.abs(AbstractLabeling.getArea((Shape)this.model.getShape((Object)this.node)));
                    if (shapeArea > 0.0) {
                        double worldSize = this.model.getSumSize(this.model.getParent((Object)this.node));
                        double screenRatio = shapeArea / screenArea;
                        double worldRatio = this.model.getSize((Object)this.node) / worldSize;
                        double expectedShapeArea = screenArea * worldRatio;
                        double error = Math.abs(shapeArea - expectedShapeArea);
                        double errorRatio = error / screenArea;
                        return 1.0 - errorRatio;
                    }
                    return Double.NaN;
                }
            }
            default: {
                columnIndex -= this.expertMode ? 5 : 2;
            }
        }
        if (this.node.hasNoChildren()) {
            switch (columnIndex) {
                case 0: {
                    if (this.node.hasNoChildren()) {
                        return this.model.getValueAt((Object)this.node, this.model.getDataFrame().getColumnKey(columnIndex));
                    }
                    return this.node.getLabelName();
                }
            }
            return this.model.getValueAt((Object)this.node, this.model.getDataFrame().getColumnKey(columnIndex));
        }
        switch (columnIndex) {
            case 0: {
                return this.node.getLabelName();
            }
        }
        return this.model.getAggregateValue((Object)this.node, this.model.getTreeMapField(columnIndex));
    }

    public Class<?> getCellClassAt(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                break;
            }
            case 1: {
                return Double.class;
            }
            case 2: {
                return Color.class;
            }
            case 3: {
                if (this.expertMode) {
                    return Double.class;
                }
            }
            case 4: {
                if (this.expertMode) {
                    return Double.class;
                }
            }
            case 5: {
                if (this.expertMode) {
                    return Double.class;
                }
            }
            default: {
                columnIndex -= this.expertMode ? 5 : 2;
            }
        }
        if (this.node.hasNoChildren()) {
            return this.model.getDataFrame().getColumnClass(this.model.getDataFrame().getColumnKey(columnIndex));
        }
        switch (columnIndex) {
            case 0: {
                return String.class;
            }
        }
        return this.model.getDataFrame().getColumnClass(this.model.getDataFrame().getColumnKey(columnIndex));
    }
}

