/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.app.swing.presentation.implementation.treetable;

import com.jidesoft.grid.NavigationTreeTable;
import com.jidesoft.grid.RowStripeTableStyleProvider;
import com.jidesoft.grid.TableStyleProvider;
import com.jidesoft.swing.NavigationComponentHelper;
import com.macrofocus.helper.ColorHelper;
import com.treemap.TreeMapModel;
import com.treemap.app.swing.presentation.implementation.treetable.TreeMapNavigationComponentHelper;
import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.security.AccessControlException;

public class RowStripeTreeTable
extends NavigationTreeTable {
    private TreeMapModel<?, ?, ?, Color, Font> treeMapModel;

    public void updateUI() {
        try {
            super.updateUI();
            if (ColorHelper.lum((Color)this.getBackground()) > ColorHelper.lum((Color)Color.gray)) {
                this.setTableStyleProvider((TableStyleProvider)new RowStripeTableStyleProvider(new Color[]{this.getBackground(), ColorHelper.darker((Color)this.getBackground(), (double)0.93)}));
            } else {
                this.setTableStyleProvider((TableStyleProvider)new RowStripeTableStyleProvider(new Color[]{this.getBackground(), ColorHelper.brighter((Color)this.getBackground(), (double)0.93)}));
            }
        }
        catch (AccessControlException e) {
            e.printStackTrace();
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
    }

    protected NavigationComponentHelper createNavigationHelper() {
        return new TreeMapNavigationComponentHelper(){

            @Override
            protected Color getSelectionColor() {
                if (RowStripeTreeTable.this.treeMapModel != null) {
                    return (Color)RowStripeTreeTable.this.treeMapModel.getSettings().getSelectionColor().getNativeColor();
                }
                return super.getSelectionColor();
            }

            @Override
            protected Color getProbingColor() {
                if (RowStripeTreeTable.this.treeMapModel != null) {
                    return (Color)RowStripeTreeTable.this.treeMapModel.getSettings().getProbingColor().getNativeColor();
                }
                return super.getProbingColor();
            }

            protected Rectangle getRowBounds(int row) {
                return RowStripeTreeTable.this.getCellRect(row, 0, false).union(RowStripeTreeTable.this.getCellRect(row, RowStripeTreeTable.this.getColumnCount() - 1, false));
            }

            protected int rowAtPoint(Point p) {
                return RowStripeTreeTable.this.rowAtPoint(p);
            }

            protected int[] getSelectedRows() {
                return RowStripeTreeTable.this.getSelectedRows();
            }
        };
    }

    public void setTreeMapModel(TreeMapModel treeMapModel) {
        this.treeMapModel = treeMapModel;
    }
}

