/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.app.swing.screenshots;

import com.macrofocus.colormap.editor.ColorMapPanel;
import com.macrofocus.crossplatform.swing.SwingFactory;
import com.macrofocus.docking.Dockable;
import com.macrofocus.docking.DockingPanel;
import com.macrofocus.docking.swing.SwingDockingPanel;
import com.macrofocus.igraphics.CPFont;
import com.macrofocus.igraphics.swing.SwingFont;
import com.macrofocus.labeling.EnhancedLabel;
import com.macrofocus.palette.MutablePalette;
import com.macrofocus.palette.swing.SwingPaletteFactory;
import com.macrofocus.util.file.filter.PngFileFilter;
import com.treemap.Algorithm;
import com.treemap.AlgorithmFactory;
import com.treemap.PieAlgorithm;
import com.treemap.RenderingFactory;
import com.treemap.TreeMapField;
import com.treemap.TreeMapFieldSettings;
import com.treemap.TreeMapModel;
import com.treemap.TreeMapNode;
import com.treemap.app.java.document.JavaTreeMapDocument;
import com.treemap.app.swing.TreeMap;
import com.treemap.app.swing.document.SwingTreeMapApplication;
import com.treemap.app.swing.document.SwingTreeMapView;
import com.treemap.app.swing.screenshots.ScreenShotsHelper;
import com.treemap.app.swing.v4.settings.algorithm.MAlgorithmFactory;
import com.treemap.swing.tagcloud.SwingTagCloudAlgorithm;
import com.treemap.swing.voronoi.VoronoiAlgorithm;
import com.treemap.tagcloud.TagCloudAlgorithm;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import net.coobird.thumbnailator.Thumbnailator;
import net.coobird.thumbnailator.Thumbnails;
import net.coobird.thumbnailator.name.Rename;

public class ScreenShots<Row, Column> {
    private static boolean DOCUMENTATION = false;

    public ScreenShots() {
        try {
            SwingTreeMapView treeMapDataView;
            String home = System.getProperty("user.home");
            File datasets = new File(home, "/macrofocus/dataset/treemap");
            File output = new File(home, "/build/treemap/screenshots");
            if (!output.exists()) {
                output.mkdirs();
            }
            System.setProperty("macrofocus.laf.useScreenMenuBar", "false");
            TreeMap app = new TreeMap();
            SwingTreeMapApplication application = TreeMap.init("synthetica-whitevision");
            application.start(null);
            String GROUP_BY = "Industry";
            File documentation = new File(home, "/java/macrofocus/www/web/public/products/treemap/documentation");
            if (DOCUMENTATION) {
                treeMapDataView = (SwingTreeMapView)ScreenShotsHelper.open(new File(datasets, "Forbes Global 2000 - 2025.mtm"), application);
                ((JavaTreeMapDocument)treeMapDataView.getDocument()).getTreeMapModel().getSettings().setGroupByByNames(new String[]{"Industry"});
                ((JavaTreeMapDocument)treeMapDataView.getDocument()).getTreeMapModel().getSettings().getDefaultFieldSettings().setNestingBackground(SwingFactory.getInstance().createRGBColor(240, 240, 240));
                TreeMapFieldSettings company = ((JavaTreeMapDocument)treeMapDataView.getDocument()).getTreeMapModel().getSettings().getFieldSettings(((JavaTreeMapDocument)treeMapDataView.getDocument()).getTreeMapModel().getTreeMapField((Object)"Company"));
                company.setOverrideDefaults(true);
                company.setLabelingShrinkTextToFitShape(Boolean.valueOf(true));
                company.setLabelingResizeTextToFitShape(Boolean.valueOf(false));
                company.setLabelingContrastEnhancement(EnhancedLabel.ContrastEnhancement.Complement);
                company.setLabelingRendering(EnhancedLabel.Rendering.WordWrap);
                company.setLabelingHorizontalAlignment(0);
                company.setLabelingVerticalAlignment(0);
                ((JavaTreeMapDocument)treeMapDataView.getDocument()).getTreeMapModel().getSettings().setRendering(RenderingFactory.CUSHION);
                ((JavaTreeMapDocument)treeMapDataView.getDocument()).getTreeMapModel().getSettings().getDefaultFieldSettings().setBorderThickness(0.1);
                ((JavaTreeMapDocument)treeMapDataView.getDocument()).getTreeMapModel().getSettings().setLightSourceAmbient(0.8);
                treeMapDataView.waitUntilReady();
                final TreeMapModel model = treeMapDataView.getTreeMapModel();
                for (Object node : model.depthFirstIterator(model.getRoot())) {
                    String name = model.getLabelName(node);
                    if (!name.equals("Coca-Cola")) continue;
                    model.getProbing().setSelected(node);
                    break;
                }
                ScreenShotsHelper.saveForDocumentation(application, new File(documentation, "ui/TreeMap"), application.getRootWindow());
                ScreenShotsHelper.saveForDocumentation(application, new File(documentation, "treemap/treemapview"), (Component)treeMapDataView.getTreeMapPanel().getNativeComponent());
                SwingDockingPanel innerComponent = (SwingDockingPanel)treeMapDataView.getDockingManager().getInnerComponent();
                innerComponent.getSouthDockingBar().setActive((Dockable)innerComponent.getSouthDockingBar().getDockables().get(1), true);
                ScreenShotsHelper.saveForDocumentation(application, new File(documentation, "treeplot/treeplotview"), (Component)innerComponent);
                innerComponent.getSouthDockingBar().setActive((Dockable)innerComponent.getSouthDockingBar().getDockables().get(2), true);
                ScreenShotsHelper.saveForDocumentation(application, new File(documentation, "treetable/treetableview"), (Component)innerComponent);
                innerComponent.getSouthDockingBar().setActive((Dockable)innerComponent.getSouthDockingBar().getDockables().get(0), true);
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                        }
                    });
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                SwingTreeMapView focusedView = application.getFocusedView();
                model.getProbing().clearSelection();
                ScreenShotsHelper.saveForDocumentation(application, new File(documentation, "configuration/configuration"), (Component)focusedView.getConfiguration().getMainPanel());
                focusedView.getConfiguration().setAnimated(false);
                focusedView.getConfiguration().getLayoutExpandButton().getAction().actionPerformed(new ActionEvent(this, 0, null));
                focusedView.getConfiguration().getSizeExpandButton().getAction().actionPerformed(new ActionEvent(this, 0, null));
                focusedView.getConfiguration().getColorExpandButton().getAction().actionPerformed(new ActionEvent(this, 0, null));
                focusedView.getConfiguration().getHeightExpandButton().getAction().actionPerformed(new ActionEvent(this, 0, null));
                focusedView.getConfiguration().getLabelsExpandButton().getAction().actionPerformed(new ActionEvent(this, 0, null));
                focusedView.getConfiguration().getToolTipExpandButton().getAction().actionPerformed(new ActionEvent(this, 0, null));
                focusedView.getConfiguration().getRenderingExpandButton().getAction().actionPerformed(new ActionEvent(this, 0, null));
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                ScreenShotsHelper.saveForDocumentation(application, new File(documentation, "configuration/layout"), focusedView.getConfiguration().getLayoutGroupPanel());
                ScreenShotsHelper.saveForDocumentation(application, new File(documentation, "configuration/groupby"), focusedView.getConfiguration().getGroupByGroupPanel());
                focusedView.getConfiguration().getGroupByPanel().expand();
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                ScreenShotsHelper.saveForDocumentation(application, new File(documentation, "configuration/groupby-expanded"), focusedView.getConfiguration().getGroupByGroupPanel());
                ScreenShotsHelper.saveForDocumentation(application, new File(documentation, "configuration/size"), focusedView.getConfiguration().getSizeGroupPanel());
                ScreenShotsHelper.saveForDocumentation(application, new File(documentation, "configuration/color-predefined"), focusedView.getConfiguration().getColorGroupPanel());
                focusedView.getConfiguration().getColorMapPanel().setType(ColorMapPanel.Type.Custom);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                ScreenShotsHelper.saveForDocumentation(application, new File(documentation, "configuration/color-custom"), focusedView.getConfiguration().getColorGroupPanel());
                ScreenShotsHelper.saveForDocumentation(application, new File(documentation, "configuration/legend"), focusedView.getConfiguration().getLegend());
                model.getSettings().setColorByName("Country");
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                ScreenShotsHelper.saveForDocumentation(application, new File(documentation, "configuration/color-categorical"), focusedView.getConfiguration().getColorGroupPanel());
                ScreenShotsHelper.saveForDocumentation(application, new File(documentation, "configuration/height"), focusedView.getConfiguration().getHeightGroupPanel());
                ScreenShotsHelper.saveForDocumentation(application, new File(documentation, "configuration/labels"), focusedView.getConfiguration().getLabelsGroupPanel());
                ScreenShotsHelper.saveForDocumentation(application, new File(documentation, "configuration/tooltip"), focusedView.getConfiguration().getTooltipGroupPanel());
                ScreenShotsHelper.saveForDocumentation(application, new File(documentation, "configuration/rendering"), focusedView.getConfiguration().getRenderingGroupPanel());
                DockingPanel leftDockingPanel = focusedView.getConfiguration().getDockingPanel();
                leftDockingPanel.getSouthDockingBar().setActive((Dockable)leftDockingPanel.getSouthDockingBar().getDockables().get(0), true);
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            for (Object node : model.depthFirstIterator(model.getRoot())) {
                                String name = model.getLabelName(node);
                                if (!name.equals("Coca-Cola")) continue;
                                model.getProbing().setSelected(node);
                                break;
                            }
                        }
                    });
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                ScreenShotsHelper.saveForDocumentation(application, new File(documentation, "variables/variables"), (Component)((Dockable)leftDockingPanel.getSouthDockingBar().getDockables().get(0)).getComponent());
                focusedView.getDockingManager().getWestDockingBar().setActive((Dockable)focusedView.getDockingManager().getWestDockingBar().getDockables().get(1), true);
                ScreenShotsHelper.saveForDocumentation(application, new File(documentation, "filters/filters"), (Component)((Dockable)focusedView.getDockingManager().getWestDockingBar().getDockables().get(1)).getComponent());
                focusedView.getDockingManager().getWestDockingBar().setActive((Dockable)focusedView.getDockingManager().getWestDockingBar().getDockables().get(2), true);
                ScreenShotsHelper.saveForDocumentation(application, new File(documentation, "details/details"), (Component)((Dockable)focusedView.getDockingManager().getWestDockingBar().getDockables().get(2)).getComponent());
                model.getProbing().clearSelection();
                model.getSettings().setColorByName("Profits");
                focusedView.getConfiguration().getColorMapPanel().setType(ColorMapPanel.Type.Predefined);
                model.getSettings().setDimensionFixed(Boolean.valueOf(true));
                model.getSettings().setDimension(new com.macrofocus.common.geom.Dimension(463, 308));
                ((JComponent)treeMapDataView.getTreeMapView().getNativeComponent()).setSize(new Dimension(463, 308));
                model.getSettings().getDefaultFieldSettings().setAlgorithm(MAlgorithmFactory.BINARY_TREE);
                ScreenShotsHelper.saveForDocumentation(application, new File(documentation, "configuration/layout-binary-tree"), (Component)focusedView.getTreeMapView().getNativeComponent());
                model.getSettings().getDefaultFieldSettings().setAlgorithm(MAlgorithmFactory.SLICE);
                ScreenShotsHelper.saveForDocumentation(application, new File(documentation, "configuration/layout-slice-and-dice"), (Component)focusedView.getTreeMapView().getNativeComponent());
                model.getSettings().getDefaultFieldSettings().setAlgorithm(MAlgorithmFactory.SQUARIFIED);
                ScreenShotsHelper.saveForDocumentation(application, new File(documentation, "configuration/layout-squarified"), (Component)focusedView.getTreeMapView().getNativeComponent());
                model.getSettings().getDefaultFieldSettings().setAlgorithm(MAlgorithmFactory.SQUARIFIEDPLUS);
                ScreenShotsHelper.saveForDocumentation(application, new File(documentation, "configuration/layout-squarifiedplus"), (Component)focusedView.getTreeMapView().getNativeComponent());
                model.getSettings().getDefaultFieldSettings().setAlgorithm(MAlgorithmFactory.STRIP);
                ScreenShotsHelper.saveForDocumentation(application, new File(documentation, "configuration/layout-strip"), (Component)focusedView.getTreeMapView().getNativeComponent());
                model.getSettings().getDefaultFieldSettings().setAlgorithm(MAlgorithmFactory.PIVOT_BY_SPLIT_SIZE);
                ScreenShotsHelper.saveForDocumentation(application, new File(documentation, "configuration/layout-pivot-by-split-size"), (Component)focusedView.getTreeMapView().getNativeComponent());
                model.getSettings().getDefaultFieldSettings().setAlgorithm(MAlgorithmFactory.SPLIT);
                ScreenShotsHelper.saveForDocumentation(application, new File(documentation, "configuration/layout-split"), (Component)focusedView.getTreeMapView().getNativeComponent());
                model.getSettings().getDefaultFieldSettings().setAlgorithm(MAlgorithmFactory.CIRCULAR);
                ScreenShotsHelper.saveForDocumentation(application, new File(documentation, "configuration/layout-circular"), (Component)focusedView.getTreeMapView().getNativeComponent());
                model.getSettings().getDefaultFieldSettings().setAlgorithm(MAlgorithmFactory.PIE);
                ScreenShotsHelper.saveForDocumentation(application, new File(documentation, "configuration/layout-pie-chart"), (Component)focusedView.getTreeMapView().getNativeComponent());
                model.getSettings().getDefaultFieldSettings().setAlgorithm(MAlgorithmFactory.VORONOI);
                ScreenShotsHelper.saveForDocumentation(application, new File(documentation, "configuration/layout-voronoi"), (Component)focusedView.getTreeMapView().getNativeComponent());
                model.getSettings().getDefaultFieldSettings().setAlgorithm(MAlgorithmFactory.MATRIX);
                ScreenShotsHelper.saveForDocumentation(application, new File(documentation, "configuration/layout-matrix"), (Component)focusedView.getTreeMapView().getNativeComponent());
                model.getSettings().getDefaultFieldSettings().setAlgorithm(MAlgorithmFactory.BAR);
                model.getSettings().getFieldSettings(model.getTreeMapField((Object)"Industry")).setAlgorithm(MAlgorithmFactory.SLICE);
                ScreenShotsHelper.saveForDocumentation(application, new File(documentation, "configuration/layout-bar-chart"), (Component)focusedView.getTreeMapView().getNativeComponent());
                model.getSettings().getDefaultFieldSettings().setAlgorithm(MAlgorithmFactory.CIRCULAR);
                model.getSettings().getFieldSettings(model.getTreeMapField((Object)"Industry")).setAlgorithm(MAlgorithmFactory.PIE);
                ScreenShotsHelper.saveForDocumentation(application, new File(documentation, "configuration/layout-circular-pie"), (Component)focusedView.getTreeMapView().getNativeComponent());
                model.getSettings().getDefaultFieldSettings().setAlgorithm(MAlgorithmFactory.CIRCULAR);
                model.getSettings().getFieldSettings(model.getTreeMapField((Object)"Industry")).setAlgorithm(MAlgorithmFactory.VORONOI);
                ScreenShotsHelper.saveForDocumentation(application, new File(documentation, "configuration/layout-circular-voronoi"), (Component)focusedView.getTreeMapView().getNativeComponent());
                model.getSettings().getDefaultFieldSettings().setAlgorithm(MAlgorithmFactory.SQUARIFIED);
                model.getSettings().getFieldSettings(model.getTreeMapField((Object)"Industry")).setAlgorithm(MAlgorithmFactory.VORONOI);
                ScreenShotsHelper.saveForDocumentation(application, new File(documentation, "configuration/layout-squarified-voronoi"), (Component)focusedView.getTreeMapView().getNativeComponent());
                model.getSettings().getDefaultFieldSettings().setAlgorithm(MAlgorithmFactory.STRIP);
                model.getSettings().getFieldSettings(model.getTreeMapField((Object)"Industry")).setAlgorithm(MAlgorithmFactory.PIE);
                ScreenShotsHelper.saveForDocumentation(application, new File(documentation, "configuration/layout-strip-pie"), (Component)focusedView.getTreeMapView().getNativeComponent());
                model.getSettings().setGroupBy(new int[0]);
                model.getSettings().getDefaultFieldSettings().setAlgorithm((Algorithm)new SwingTagCloudAlgorithm(TagCloudAlgorithm.OrientationMode.HorizontalAndVertical, TagCloudAlgorithm.Spiral.Rectangular, (CPFont)new SwingFont(new Font("Calibri", 1, 20))));
                model.getSettings().setRendering(RenderingFactory.FLAT);
                ScreenShotsHelper.saveForDocumentation(application, new File(documentation, "configuration/layout-tag-cloud"), (Component)focusedView.getTreeMapView().getNativeComponent());
                ScreenShotsHelper.close(application);
            }
            ScreenShotsHelper.open(new File(datasets, "UN GDP.mtm"), application);
            treeMapDataView = application.getFocusedView();
            final TreeMapModel model = treeMapDataView.getTreeMapModel();
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        for (TreeMapNode node : model.depthFirstIterator((Object)((TreeMapNode)model.getRoot()))) {
                            TreeMapField treeMapField;
                            String name = model.getStringValue((Object)node, treeMapField = model.getTreeMapFieldByName("Country or area"), model.getSettings().getFieldSettings(treeMapField));
                            if (!name.equals("China, People's Republic of")) continue;
                            model.getProbing().setSelected((Object)node);
                        }
                    }
                });
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            ScreenShotsHelper.takeScreenShot(output, "UN GDP", application);
            ScreenShotsHelper.close(application);
            ScreenShotsHelper.open(new File(datasets, "Forbes Global 2000 - 2025.mtm"), application);
            treeMapDataView = application.getFocusedView();
            model = treeMapDataView.getTreeMapModel();
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        for (TreeMapNode node : model.depthFirstIterator((Object)((TreeMapNode)model.getRoot()))) {
                            String name = model.getLabelName((Object)node);
                            if (!name.equals("Coca-Cola")) continue;
                            model.getProbing().setSelected((Object)node);
                            break;
                        }
                    }
                });
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            ScreenShotsHelper.takeScreenShot(output, "Forbes Global 2000 - 2025-3d", application);
            model.getSettings().getDefaultFieldSettings().setAlgorithm(AlgorithmFactory.CIRCULAR);
            model.getSettings().setLabels(new int[0]);
            model.getSettings().setBackgroundByName("Company");
            model.getSettings().getDefaultFieldSettings().setLabelingVerticalAlignment(0);
            model.getSettings().setHeight(-1);
            model.getSettings().getDefaultFieldSettings().setLabelingFont(model.getSettings().getDefaultFieldSettings().getLabelingFont().deriveFontSize(10.0));
            model.getSettings().getDefaultFieldSettings().setLabelingMinimumCharactersToDisplay(4);
            ScreenShotsHelper.takeScreenShot(output, "Forbes Global 2000 - 2025-circular", application);
            model.getSettings().getDefaultFieldSettings().setAlgorithm((Algorithm)new PieAlgorithm());
            ScreenShotsHelper.takeScreenShot(output, "Forbes Global 2000 - 2025-pie", application);
            long start = System.currentTimeMillis();
            model.getSettings().getDefaultFieldSettings().setAlgorithm((Algorithm)new VoronoiAlgorithm());
            application.waitUntilReady();
            long voronoi = System.currentTimeMillis() - start;
            ScreenShotsHelper.takeScreenShot(output, "Forbes Global 2000 - 2025-voronoi", application);
            start = System.currentTimeMillis();
            model.getSettings().getDefaultFieldSettings().setAlgorithm((Algorithm)new VoronoiAlgorithm());
            application.waitUntilReady();
            long voronoi2 = System.currentTimeMillis() - start;
            ScreenShotsHelper.takeScreenShot(output, "Forbes Global 2000 - 2025-voronoi2", application);
            System.out.println("Voronoi old: " + voronoi / 1000L + " seconds, new: " + voronoi2 / 1000L + " seconds");
            model.getSettings().getDefaultFieldSettings().setAlgorithm(AlgorithmFactory.STRIP);
            model.getSettings().getFieldSettings(model.getTreeMapField(1)).setAlgorithm((Algorithm)new PieAlgorithm());
            ScreenShotsHelper.takeScreenShot(output, "Forbes Global 2000 - 2025-strip-pie", application);
            model.getSettings().getDefaultFieldSettings().setAlgorithm(AlgorithmFactory.CIRCULAR);
            model.getSettings().getFieldSettings(model.getTreeMapField(1)).setAlgorithm((Algorithm)new PieAlgorithm());
            ScreenShotsHelper.takeScreenShot(output, "Forbes Global 2000 - 2025-circular-pie", application);
            model.getSettings().getFieldSettings(model.getTreeMapField(1)).setAlgorithm((Algorithm)new VoronoiAlgorithm());
            ScreenShotsHelper.takeScreenShot(output, "Forbes Global 2000 - 2025-circular-voronoi", application);
            model.getSettings().setLabelsByNames(new String[]{"Company"});
            model.getSettings().setBackground(-1);
            model.getSettings().setRendering(RenderingFactory.FLAT_NO_BORDER);
            model.getColorMap(model.getTreeMapFieldByName("Profits")).setPalette((MutablePalette)SwingPaletteFactory.getInstance().get("composite").getPalette());
            model.getSettings().getDefaultFieldSettings().setAlgorithm(AlgorithmFactory.SQUARIFIED);
            model.getSettings().getFieldSettings(model.getTreeMapField(1)).setAlgorithm((Algorithm)new SwingTagCloudAlgorithm(TagCloudAlgorithm.OrientationMode.AllHorizontal, TagCloudAlgorithm.Spiral.Rectangular, (CPFont)new SwingFont(new Font("Calibri", 1, 20))));
            ScreenShotsHelper.takeScreenShot(output, "Forbes Global 2000 - 2025-squarified-tagcloud", application);
            model.getSettings().getDefaultFieldSettings().setAlgorithm((Algorithm)new SwingTagCloudAlgorithm(TagCloudAlgorithm.OrientationMode.HorizontalAndVertical, TagCloudAlgorithm.Spiral.Rectangular, (CPFont)new SwingFont(new Font("Calibri", 1, 20))));
            model.getSettings().setGroupBy(new int[0]);
            ScreenShotsHelper.takeScreenShot(output, "Forbes Global 2000 - 2025-tagcloud", application);
            ScreenShotsHelper.close(application);
            ScreenShotsHelper.open(new File(datasets, "US Presidential Elections - 2012.mtm"), application);
            ScreenShotsHelper.takeScreenShot(output, "US Presidential Elections - 2012", application);
            ScreenShotsHelper.close(application);
            ScreenShotsHelper.open(new File(datasets, "TOP500 Supercomputing Sites - 201206.mtm"), application);
            ScreenShotsHelper.takeScreenShot(output, "TOP500 Supercomputing Sites - 201206", application);
            ScreenShotsHelper.close(application);
            ScreenShotsHelper.open(new File(datasets, "UNOPS Procurements 2007-2011.mtm"), application);
            ScreenShotsHelper.takeScreenShot(output, "UNOPS Procurements 2007-2011", application);
            ScreenShotsHelper.close(application);
            ScreenShotsHelper.open(new File(datasets, "Lipper Ch120501.mtm"), application);
            ScreenShotsHelper.takeScreenShot(output, "Lipper Ch120501", application);
            ScreenShotsHelper.close(application);
            ScreenShotsHelper.open(new File(datasets, "Top 10 Swiss Companies.xls"), application);
            ScreenShotsHelper.takeScreenShot(output, "Top 10 Swiss Companies", application);
            ScreenShotsHelper.close(application);
            ScreenShotsHelper.open(new File(datasets, "Subramanian & Wei Imports - 2000.mtm"), application);
            treeMapDataView = application.getFocusedView();
            model = treeMapDataView.getTreeMapModel();
            ScreenShotsHelper.takeScreenShot(output, "Subramanian & Wei Imports - 2000", application);
            model.getSettings().getDefaultFieldSettings().setAlgorithm(AlgorithmFactory.CIRCULAR);
            ScreenShotsHelper.takeScreenShot(output, "Subramanian & Wei Imports - 2000-circular", application);
            ScreenShotsHelper.close(application);
            ScreenShotsHelper.open(new File(datasets, "UNHCR Refugees.mtm"), application);
            treeMapDataView = application.getFocusedView();
            model = treeMapDataView.getTreeMapModel();
            ScreenShotsHelper.takeScreenShot(output, "UNHCR Refugees", application);
            ScreenShotsHelper.close(application);
            ScreenShotsHelper.open(new File(datasets, "US Budget Program Assessment Rating Tool 2008.mtm"), application);
            ScreenShotsHelper.takeScreenShot(output, "US Budget Program Assessment Rating Tool 2008", application);
            ScreenShotsHelper.close(application);
            ScreenShotsHelper.open(new File(datasets, "IEEE Spectrum Top R&D Spenders.mtm"), application);
            ScreenShotsHelper.takeScreenShot(output, "IEEE Spectrum Top R&D Spenders", application);
            ScreenShotsHelper.close(application);
            ScreenShotsHelper.open(new File(datasets, "Forbes World's Billionaires 2024.mtm"), application);
            ScreenShotsHelper.takeScreenShot(output, "Forbes World's Billionaires 2024", application);
            ScreenShotsHelper.close(application);
            ScreenShotsHelper.open(new File(datasets, "Dolores Labs Color Names Data Set.mtm"), application);
            ScreenShotsHelper.takeScreenShot(output, "Dolores Labs Color Names Data Set", application);
            ScreenShotsHelper.close(application);
            ScreenShotsHelper.open(new File(datasets, "EM-DAT v. 12.07.mtm"), application);
            ScreenShotsHelper.takeScreenShot(output, "EM-DAT v. 12.07", application);
            ScreenShotsHelper.close(application);
            ScreenShotsHelper.open(new File(datasets, "The Numbers Movie Budgets.mtm"), application);
            ScreenShotsHelper.takeScreenShot(output, "The Numbers Movie Budgets", application);
            ScreenShotsHelper.close(application);
            ScreenShotsHelper.open(new File(datasets, "Lipper FundFile 2012-08 EUR.mtm"), application);
            ScreenShotsHelper.takeScreenShot(output, "Lipper FundFile 2012-08 EUR", application);
            ScreenShotsHelper.close(application);
            ScreenShotsHelper.open(new File(datasets, "Lipper FundFile Sector-Market - 2012-08 EUR.mtm"), application);
            ScreenShotsHelper.takeScreenShot(output, "Lipper FundFile Sector-Market - 2012-08 EUR", application);
            ScreenShotsHelper.close(application);
            File www = new File(home, "/java/macrofocus/www/web/public/products/treemap");
            try {
                ScreenShotsHelper.copyFile(new File(output, "application/72dpi/Forbes World's Billionaires 2024-72dpi.png"), new File(www, "datasets/billionaires/Forbes World's Billionaires 2024-72dpi.png"));
                ScreenShotsHelper.copyFile(new File(output, "application/72dpi/Dolores Labs Color Names Data Set-72dpi.png"), new File(www, "datasets/colornames/Dolores Labs Color Names Data Set-72dpi.png"));
                ScreenShotsHelper.copyFile(new File(output, "application/72dpi/EM-DAT v. 12.07-72dpi.png"), new File(www, "datasets/emdat/EM-DAT v. 12.07-72dpi.png"));
                ScreenShotsHelper.copyFile(new File(output, "application/72dpi/Forbes Global 2000 - 2025-72dpi.png"), new File(www, "datasets/global2000/Forbes Global 2000 - 2025-72dpi.png"));
                ScreenShotsHelper.copyFile(new File(output, "application/72dpi/The Numbers Movie Budgets-72dpi.png"), new File(www, "datasets/movies/The Numbers Movie Budgets-72dpi.png"));
                ScreenShotsHelper.copyFile(new File(output, "application/72dpi/US Budget Program Assessment Rating Tool 2008-72dpi.png"), new File(www, "datasets/part/US Budget Program Assessment Rating Tool 2008-72dpi.png"));
                ScreenShotsHelper.copyFile(new File(output, "application/72dpi/IEEE Spectrum Top R&D Spenders-72dpi.png"), new File(www, "datasets/rdspenders/IEEE Spectrum Top R&D Spenders-72dpi.png"));
                ScreenShotsHelper.copyFile(new File(output, "application/72dpi/UNHCR Refugees-72dpi.png"), new File(www, "datasets/refugees/UNHCR Refugees-72dpi.png"));
                ScreenShotsHelper.copyFile(new File(output, "application/72dpi/TOP500 Supercomputing Sites - 201206-72dpi.png"), new File(www, "datasets/supercomputing/TOP500 Supercomputing Sites - 201206-72dpi.png"));
                ScreenShotsHelper.copyFile(new File(output, "application/72dpi/UNOPS Procurements 2007-2011-72dpi.png"), new File(www, "datasets/unprocurements/UNOPS Procurements 2007-2011-72dpi.png"));
                ScreenShotsHelper.copyFile(new File(output, "application/72dpi/US Presidential Elections - 2012-72dpi.png"), new File(www, "datasets/uselections/US Presidential Elections - 2012-72dpi.png"));
                Thumbnailator.createThumbnail((File)new File(www, "datasets/billionaires/Forbes World's Billionaires 2024-72dpi.png"), (File)new File(www, "datasets/billionaires/treemap-billionaires.png"), (int)450, (int)324);
                Thumbnailator.createThumbnail((File)new File(www, "datasets/colornames/Dolores Labs Color Names Data Set-72dpi.png"), (File)new File(www, "datasets/colornames/treemap-colornames.png"), (int)450, (int)324);
                Thumbnailator.createThumbnail((File)new File(www, "datasets/emdat/EM-DAT v. 12.07-72dpi.png"), (File)new File(www, "datasets/emdat/treemap-emdat.png"), (int)450, (int)324);
                Thumbnailator.createThumbnail((File)new File(www, "datasets/global2000/Forbes Global 2000 - 2025-72dpi.png"), (File)new File(www, "datasets/global2000/treemap-global2000.png"), (int)450, (int)324);
                Thumbnailator.createThumbnail((File)new File(www, "datasets/movies/The Numbers Movie Budgets-72dpi.png"), (File)new File(www, "datasets/movies/treemap-movies.png"), (int)450, (int)324);
                Thumbnailator.createThumbnail((File)new File(www, "datasets/part/US Budget Program Assessment Rating Tool 2008-72dpi.png"), (File)new File(www, "datasets/part/treemap-part.png"), (int)450, (int)324);
                Thumbnailator.createThumbnail((File)new File(www, "datasets/rdspenders/IEEE Spectrum Top R&D Spenders-72dpi.png"), (File)new File(www, "datasets/rdspenders/treemap-rdspenders.png"), (int)450, (int)324);
                Thumbnailator.createThumbnail((File)new File(www, "datasets/refugees/UNHCR Refugees-72dpi.png"), (File)new File(www, "datasets/refugees/treemap-refugees.png"), (int)450, (int)324);
                Thumbnailator.createThumbnail((File)new File(www, "datasets/supercomputing/TOP500 Supercomputing Sites - 201206-72dpi.png"), (File)new File(www, "datasets/supercomputing/treemap-supercomputing.png"), (int)450, (int)324);
                Thumbnailator.createThumbnail((File)new File(www, "datasets/unprocurements/UNOPS Procurements 2007-2011-72dpi.png"), (File)new File(www, "datasets/unprocurements/treemap-unprocurements.png"), (int)450, (int)324);
                Thumbnailator.createThumbnail((File)new File(www, "datasets/uselections/US Presidential Elections - 2012-72dpi.png"), (File)new File(www, "datasets/uselections/treemap-uselections.png"), (int)450, (int)324);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                Thumbnails.of((File[])new File(documentation, "configuration").listFiles((FileFilter)new PngFileFilter(){

                    public boolean accept(File f) {
                        boolean accept = super.accept(f) && f.getName().startsWith("layout-") && !f.getName().endsWith("-thumbnail.png");
                        return accept;
                    }
                })).size(189, 126).toFiles(Rename.SUFFIX_HYPHEN_THUMBNAIL);
                Thumbnails.of((File[])new File(documentation, "gettingstarted").listFiles((FileFilter)new PngFileFilter(){

                    public boolean accept(File f) {
                        boolean accept = super.accept(f) && !f.getName().endsWith("-thumbnail.png");
                        return accept;
                    }
                })).scale(0.7).toFiles(Rename.SUFFIX_HYPHEN_THUMBNAIL);
                return;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.exit(0);
    }

    public static void main(String[] args) {
        new ScreenShots();
    }
}

