/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.app.swing.v4.settings.algorithm.tagcloud;

import com.macrofocus.geom.AffineTransform;
import com.macrofocus.geom.Rectangle2D;
import com.macrofocus.geom.Shape;
import com.treemap.AbstractAlgorithm;
import com.treemap.Algorithm;
import com.treemap.AlgorithmFactory;
import com.treemap.MutableTreeMapNode;
import com.treemap.TreeMapModel;
import com.treemap.TreeMapNode;
import com.treemap.TreeMapWorker;
import com.treemap.swing.tagcloud.SwingWord;
import com.treemap.tagcloud.Orientation;
import com.treemap.tagcloud.Point2d;
import com.treemap.tagcloud.PositionIterator;
import com.treemap.tagcloud.TextShape;
import com.treemap.tagcloud.Word;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class HierarchicalTagCloudAlgorithm<N, Row, Column, Color, Font>
extends AbstractAlgorithm<N, Row, Column, Color, Font> {
    private final List<SwingWord> words = new ArrayList<SwingWord>();
    private final Map<TreeMapNode, List<SwingWord>> parentNodePlacedWordsMap = new HashMap<TreeMapNode, List<SwingWord>>();
    private SwingWord lastIntersectedWord;
    private double minimumScale = Double.MAX_VALUE;
    private final OrientationMode orientationMode;
    private BufferedImage imageToHaveGraphics = new BufferedImage(1, 1, 10);
    private int nSubdivisions = 4;

    public HierarchicalTagCloudAlgorithm(OrientationMode orientationMode) {
        this.orientationMode = orientationMode;
    }

    public boolean breadthFirstLayout(Shape shape, MutableTreeMapNode parent, MutableTreeMapNode[] children, double sumSizes, int horizontalVanishingPoint, int verticalVanishingPoint, TreeMapWorker worker) {
        boolean isLowestHierarchy;
        long startMillis = System.currentTimeMillis();
        this.words.clear();
        ArrayList<SwingWord> placedWords = new ArrayList<SwingWord>();
        Random random = new Random(1L);
        Graphics2D g = (Graphics2D)this.imageToHaveGraphics.getGraphics();
        boolean bl = isLowestHierarchy = children.length > 0 && children[0] != null && children[0].hasNoChildren();
        if (parent.toString().equals("root") && !isLowestHierarchy) {
            Algorithm algorithm = AlgorithmFactory.SQUARIFIED;
            algorithm.breadthFirstLayout(shape, parent, children, sumSizes, 4, 3, worker);
            return false;
        }
        for (MutableTreeMapNode child : children) {
            boolean vertical;
            String text = child.toString();
            switch (this.orientationMode.ordinal()) {
                case 0: {
                    vertical = false;
                    break;
                }
                case 1: {
                    vertical = random.nextBoolean();
                    break;
                }
                default: {
                    vertical = false;
                }
            }
            Orientation orientation = vertical ? Orientation.Vertical : Orientation.Horizontal;
            this.words.add(new SwingWord(g, text, child.getSize(), child, orientation, this.nSubdivisions));
        }
        Collections.sort(this.words);
        Collections.reverse(this.words);
        Point2d position = new Point2d(0.0, 0.0);
        PositionIterator positionIterator = new PositionIterator(shape);
        double totalMaximumSideLength = 0.0;
        this.lastIntersectedWord = null;
        int counter = 0;
        for (SwingWord word : this.words) {
            double wordWidth = word.getShapeForLayout().getBounds2D().getWidth();
            double wordHeight = word.getShapeForLayout().getBounds2D().getHeight();
            double minSideLength = Math.min(wordWidth, wordHeight);
            double maxSideLength = Math.max(wordWidth, wordHeight);
            totalMaximumSideLength = Math.max(maxSideLength, totalMaximumSideLength);
            double stepSize = maxSideLength / 10.0;
            stepSize = Math.max(stepSize, totalMaximumSideLength / 20.0);
            positionIterator.resetIterator(stepSize);
            int stepIncreaseCounter = 0;
            boolean debug = false;
            while (this.newWordIntersectsPlacedWords(word, placedWords)) {
                if (stepIncreaseCounter > 100) {
                    positionIterator.doubleStepSize();
                    stepIncreaseCounter = 0;
                }
                positionIterator.getNextPosition(position);
                word.setLocation(position);
                ++counter;
            }
            placedWords.add(word);
            ++counter;
        }
        this.parentNodePlacedWordsMap.put((TreeMapNode)parent, placedWords);
        this.minimumScale = Math.min(this.minimumScale, this.getLayoutScale(shape, placedWords));
        long endMillis = System.currentTimeMillis();
        System.out.println(String.format("time: %.3f", (double)(endMillis - startMillis) / 1000.0));
        return false;
    }

    public void finishLayout(Rectangle2D bounds, TreeMapModel<N, Row, Column, Color, Font> model, N root) {
        Iterable childrenIterator = model.getChildren(root);
        if (!childrenIterator.iterator().hasNext()) {
            return;
        }
        Object firstChild = childrenIterator.iterator().next();
        if (firstChild == null) {
            return;
        }
        boolean firstChildIsLeaf = model.hasNoChildren(firstChild);
        if (!firstChildIsLeaf) {
            Iterable secondHierarchyIterator = model.getChildren(root);
            for (Object n2 : secondHierarchyIterator) {
                TreeMapNode secondHierarchyNode = (TreeMapNode)n2;
                List<SwingWord> placedWords = this.parentNodePlacedWordsMap.get(secondHierarchyNode);
                this.createDiagramShapes(secondHierarchyNode.getShape(), this.minimumScale, placedWords);
            }
        } else {
            List<SwingWord> placedWords = this.parentNodePlacedWordsMap.get(root);
            this.createDiagramShapes(((TreeMapNode)root).getShape(), this.minimumScale, placedWords);
        }
        this.minimumScale = Double.MAX_VALUE;
    }

    private double getLayoutScale(Shape domain, List<SwingWord> placedWords) {
        Rectangle2D.Double diagramBoundsNormed = new Rectangle2D.Double();
        for (SwingWord placedWord : placedWords) {
            Rectangle2D b = placedWord.getShapeForLayout().getBounds2D();
            diagramBoundsNormed.add(new Rectangle2D.Double(b.getX(), b.getY(), b.getWidth(), b.getHeight()));
        }
        Rectangle2D domainBoundsAbsolute = domain.getBounds2D();
        double domainAspect = domainBoundsAbsolute.getWidth() / domainBoundsAbsolute.getHeight();
        double diagramAspect = ((RectangularShape)diagramBoundsNormed).getWidth() / ((RectangularShape)diagramBoundsNormed).getHeight();
        double widthDiff = 0.0;
        double heightDiff = 0.0;
        double scale = diagramAspect > domainAspect ? domainBoundsAbsolute.getWidth() / ((RectangularShape)diagramBoundsNormed).getWidth() : domainBoundsAbsolute.getHeight() / ((RectangularShape)diagramBoundsNormed).getHeight();
        return scale;
    }

    private void createDiagramShapes(Shape domain, double scale, List<SwingWord> placedWords) {
        Rectangle2D.Double diagramBoundsNormed = new Rectangle2D.Double();
        for (SwingWord placedWord : placedWords) {
            Rectangle2D b = placedWord.getShapeForLayout().getBounds2D();
            diagramBoundsNormed.add(new Rectangle2D.Double(b.getX(), b.getY(), b.getWidth(), b.getHeight()));
        }
        Rectangle2D domainBoundsAbsolute = domain.getBounds2D();
        double widthDiff = domainBoundsAbsolute.getWidth() - ((RectangularShape)diagramBoundsNormed).getWidth() * scale;
        double heightDiff = domainBoundsAbsolute.getHeight() - ((RectangularShape)diagramBoundsNormed).getHeight() * scale;
        Point2d offsetAbsolute = new Point2d(domainBoundsAbsolute.getX() - ((RectangularShape)diagramBoundsNormed).getX() * scale + widthDiff / 2.0, domainBoundsAbsolute.getY() - ((RectangularShape)diagramBoundsNormed).getY() * scale + heightDiff / 2.0);
        boolean allInside = true;
        for (SwingWord word : placedWords) {
            Shape shape = this.getShape(offsetAbsolute, scale, word.getShapeForLayout());
            word.getTreeMapNode().setShape(shape);
            Rectangle2D r = shape.getBounds2D();
            boolean inside = domainBoundsAbsolute.contains(r.getX(), r.getY(), r.getWidth(), r.getHeight());
            if (inside) continue;
            allInside = false;
        }
        System.out.println("All Inside: " + allInside);
    }

    public Shape getShape(Point2d offsetAbsolute, double scale, TextShape shape) {
        AffineTransform transform = new AffineTransform(scale, 0.0, 0.0, scale, offsetAbsolute.x, offsetAbsolute.y);
        Shape transformedShape = shape.createTransformedShape(transform);
        return transformedShape;
    }

    public boolean newWordIntersectsPlacedWords(SwingWord word, List<SwingWord> placedWords) {
        if (this.lastIntersectedWord != null && word.intersects((Word)this.lastIntersectedWord)) {
            return true;
        }
        for (SwingWord placedWord : placedWords) {
            if (placedWord == this.lastIntersectedWord || !word.intersects((Word)placedWord)) continue;
            this.lastIntersectedWord = placedWord;
            return true;
        }
        return false;
    }

    public boolean isCompatible(Shape shape) {
        return shape instanceof Rectangle2D;
    }

    public boolean isRenderingLeafLabelsSupported() {
        return false;
    }

    public boolean isSpaceFilling() {
        return false;
    }

    public String toString() {
        return "Hierarchical Tag Cloud";
    }

    public static enum OrientationMode {
        AllHorizontal,
        HorizontalAndVertical;

    }
}

