/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.x3d.jsail.NURBS;

import java.util.ArrayList;
import java.util.Arrays;
import org.web3d.x3d.jsail.ConfigurationProperties;
import org.web3d.x3d.jsail.Core.CommentsBlock;
import org.web3d.x3d.jsail.Core.IS;
import org.web3d.x3d.jsail.Core.ProtoInstance;
import org.web3d.x3d.jsail.Core.connect;
import org.web3d.x3d.jsail.X3DConcreteElement;
import org.web3d.x3d.jsail.X3DConcreteNode;
import org.web3d.x3d.jsail.fields.MFDouble;
import org.web3d.x3d.jsail.fields.MFString;
import org.web3d.x3d.jsail.fields.SFBool;
import org.web3d.x3d.jsail.fields.SFDouble;
import org.web3d.x3d.jsail.fields.SFInt32;
import org.web3d.x3d.jsail.fields.SFString;
import org.web3d.x3d.sai.Core.X3DMetadataObject;
import org.web3d.x3d.sai.InvalidFieldException;
import org.web3d.x3d.sai.InvalidFieldValueException;
import org.web3d.x3d.sai.InvalidProtoException;
import org.web3d.x3d.sai.Rendering.X3DCoordinateNode;

public class NurbsCurve
extends X3DConcreteNode
implements org.web3d.x3d.sai.NURBS.NurbsCurve {
    private ArrayList<String> commentsList;
    private boolean closed;
    private X3DCoordinateNode controlPoint;
    private ProtoInstance controlPointProtoInstance;
    private IS IS;
    private ArrayList<Double> knot = new ArrayList();
    private X3DMetadataObject metadata;
    private ProtoInstance metadataProtoInstance;
    private int order;
    private int tessellation;
    private ArrayList<Double> weight = new ArrayList();
    public static final String NAME = "NurbsCurve";
    public static final String COMPONENT = "NURBS";
    public static final int LEVEL = 1;
    public static final boolean CLOSED_DEFAULT_VALUE = false;
    public static final X3DCoordinateNode CONTROLPOINT_DEFAULT_VALUE = null;
    public static final IS IS_DEFAULT_VALUE = null;
    public static final ArrayList<Double> KNOT_DEFAULT_VALUE = new ArrayList<Double>(Arrays.asList(new Double[0]));
    public static final X3DMetadataObject METADATA_DEFAULT_VALUE = null;
    public static final int ORDER_DEFAULT_VALUE = 3;
    public static final int TESSELLATION_DEFAULT_VALUE = 0;
    public static final ArrayList<Double> WEIGHT_DEFAULT_VALUE = new ArrayList<Double>(Arrays.asList(new Double[0]));
    public static final String containerField_DEFAULT_VALUE = "geometry";
    public static final String fromField_CONTROLPOINT = "controlPoint";
    public static final String toField_CONTROLPOINT = "controlPoint";
    public static final String fromField_IS = "IS";
    public static final String fromField_METADATA = "metadata";
    public static final String toField_METADATA = "metadata";
    public static final String fromField_TESSELLATION = "tessellation";
    public static final String toField_TESSELLATION = "tessellation";
    public static final String fromField_WEIGHT = "weight";
    public static final String toField_WEIGHT = "weight";

    @Override
    public final String getElementName() {
        return NAME;
    }

    @Override
    public final String getComponent() {
        return COMPONENT;
    }

    @Override
    public final int getComponentLevel() {
        return 1;
    }

    @Override
    public String getFieldType(String fieldName) {
        String result;
        switch (fieldName) {
            case "containerField": {
                result = "SFString";
                break;
            }
            case "closed": {
                result = "SFBool";
                break;
            }
            case "controlPoint": {
                result = "SFNode";
                break;
            }
            case "IS": {
                result = "SFNode";
                break;
            }
            case "knot": {
                result = "MFDouble";
                break;
            }
            case "metadata": {
                result = "SFNode";
                break;
            }
            case "order": {
                result = "SFInt32";
                break;
            }
            case "tessellation": {
                result = "SFInt32";
                break;
            }
            case "weight": {
                result = "MFDouble";
                break;
            }
            case "DEF": {
                result = "SFString";
                break;
            }
            case "USE": {
                result = "SFString";
                break;
            }
            case "class": {
                result = "SFString";
                break;
            }
            default: {
                result = fieldName.trim().startsWith("set_") ? this.getFieldType(fieldName.trim().substring(4)) : (fieldName.trim().endsWith("_changed") ? this.getFieldType(fieldName.trim().substring(0, fieldName.length() - 8)) : "ERROR_UNKNOWN_FIELD_TYPE");
            }
        }
        return result;
    }

    @Override
    public String getAccessType(String fieldName) {
        String result;
        switch (fieldName) {
            case "closed": {
                result = "initializeOnly";
                break;
            }
            case "controlPoint": {
                result = "inputOutput";
                break;
            }
            case "IS": {
                result = "inputOutput";
                break;
            }
            case "knot": {
                result = "initializeOnly";
                break;
            }
            case "metadata": {
                result = "inputOutput";
                break;
            }
            case "order": {
                result = "initializeOnly";
                break;
            }
            case "tessellation": {
                result = "inputOutput";
                break;
            }
            case "weight": {
                result = "inputOutput";
                break;
            }
            case "DEF": {
                result = "inputOutput";
                break;
            }
            case "USE": {
                result = "inputOutput";
                break;
            }
            case "class": {
                result = "inputOutput";
                break;
            }
            default: {
                result = fieldName.trim().startsWith("set_") ? this.getAccessType(fieldName.trim().substring(4)) : (fieldName.trim().endsWith("_changed") ? this.getAccessType(fieldName.trim().substring(0, fieldName.length() - 8)) : "ERROR_UNKNOWN_FIELD_ACCESSTYPE");
            }
        }
        return result;
    }

    @Override
    public final String getContainerFieldDefault() {
        return containerField_DEFAULT_VALUE;
    }

    public NurbsCurve() {
        this.initialize();
    }

    @Override
    public final void initialize() {
        super.initialize();
        this.setContainerFieldOverride("");
        this.containerField_ALTERNATE_VALUES = new String[]{containerField_DEFAULT_VALUE};
        this.closed = false;
        this.controlPoint = null;
        this.controlPointProtoInstance = null;
        this.IS = null;
        this.knot = new ArrayList();
        this.metadata = null;
        this.metadataProtoInstance = null;
        this.order = 3;
        this.tessellation = 0;
        this.weight = new ArrayList();
        this.commentsList = new ArrayList();
    }

    @Override
    public boolean getClosed() {
        return this.closed;
    }

    @Override
    public NurbsCurve setClosed(boolean newValue) {
        this.closed = newValue;
        return this;
    }

    public NurbsCurve setClosed(SFBool newValue) {
        this.setClosed(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public X3DCoordinateNode getControlPoint() {
        return this.controlPoint;
    }

    @Override
    public NurbsCurve setControlPoint(X3DCoordinateNode newValue) {
        this.controlPoint = newValue;
        if (newValue != null) {
            ((X3DConcreteElement)((Object)this.controlPoint)).setParent(this);
        }
        if (this.controlPointProtoInstance != null) {
            this.controlPointProtoInstance.setParent(null);
            this.controlPointProtoInstance = null;
        }
        return this;
    }

    public NurbsCurve clearControlPoint() {
        ((X3DConcreteElement)((Object)this.controlPoint)).clearParent();
        this.controlPoint = null;
        return this;
    }

    public NurbsCurve setControlPoint(ProtoInstance newValue) {
        if (this.controlPointProtoInstance != null) {
            this.controlPointProtoInstance.setParent(null);
        }
        this.controlPointProtoInstance = newValue;
        if (newValue != null) {
            this.controlPointProtoInstance.setParent(this);
            this.controlPointProtoInstance.setContainerField("controlPoint");
        }
        if (this.controlPoint != null) {
            ((X3DConcreteElement)((Object)this.controlPoint)).setParent(null);
            this.controlPoint = null;
        }
        return this;
    }

    private ProtoInstance getControlPointProtoInstance() {
        return this.controlPointProtoInstance;
    }

    public boolean hasControlPoint() {
        return this.controlPoint != null || this.controlPointProtoInstance != null;
    }

    @Override
    public IS getIS() {
        return this.IS;
    }

    @Override
    public NurbsCurve setIS(IS newValue) {
        this.IS = newValue;
        if (newValue != null) {
            this.IS.setParent(this);
        }
        return this;
    }

    public NurbsCurve clearIS() {
        this.IS.clearParent();
        this.IS = null;
        return this;
    }

    public boolean hasIS() {
        return this.IS != null;
    }

    @Override
    public double[] getKnot() {
        double[] valuesArray = new double[this.knot.size()];
        int i = 0;
        for (Double arrayElement : this.knot) {
            valuesArray[i++] = arrayElement;
        }
        return valuesArray;
    }

    public ArrayList<Double> getKnotList() {
        return this.knot;
    }

    public String getKnotString() {
        StringBuilder result = new StringBuilder();
        for (Double arrayElement : this.knot) {
            result.append(arrayElement.toString());
            result.append(" ");
        }
        return result.toString().trim();
    }

    @Override
    public NurbsCurve setKnot(double[] newValue) {
        if (newValue == null) {
            this.clearKnot();
            return this;
        }
        this.clearKnot();
        for (int i = 0; i < newValue.length; ++i) {
            this.knot.add(newValue[i]);
        }
        return this;
    }

    public NurbsCurve setKnot(MFDouble newValue) {
        if (newValue == null) {
            this.clearKnot();
            return this;
        }
        this.setKnot(newValue.getPrimitiveValue());
        return this;
    }

    public NurbsCurve setKnot(ArrayList<Double> newValue) {
        if (newValue == null) {
            this.clearKnot();
            return this;
        }
        if (newValue.isEmpty()) {
            this.clearKnot();
        } else {
            double[] newArray = new double[newValue.size()];
            for (int i = 0; i < newValue.size(); ++i) {
                newArray[i] = newValue.get(i);
            }
            this.setKnot(newArray);
        }
        return this;
    }

    public NurbsCurve clearKnot() {
        this.knot.clear();
        return this;
    }

    public NurbsCurve setKnot(int[] newValue) {
        if (newValue == null) {
            this.clearKnot();
            return this;
        }
        double[] holdArray = new double[newValue.length];
        for (int i = 0; i < newValue.length; ++i) {
            holdArray[i] = newValue[i];
        }
        this.setKnot(holdArray);
        return this;
    }

    public NurbsCurve addKnot(double newValue) {
        this.knot.add(newValue);
        return this;
    }

    public NurbsCurve addKnot(SFDouble newValue) {
        if (newValue == null) {
            return this;
        }
        this.knot.add(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public X3DMetadataObject getMetadata() {
        return this.metadata;
    }

    @Override
    public NurbsCurve setMetadata(X3DMetadataObject newValue) {
        this.metadata = newValue;
        if (newValue != null) {
            ((X3DConcreteElement)((Object)this.metadata)).setParent(this);
        }
        if (this.metadataProtoInstance != null) {
            this.metadataProtoInstance.setParent(null);
            this.metadataProtoInstance = null;
        }
        return this;
    }

    public NurbsCurve clearMetadata() {
        ((X3DConcreteElement)((Object)this.metadata)).clearParent();
        this.metadata = null;
        return this;
    }

    @Override
    public NurbsCurve setMetadata(ProtoInstance newValue) {
        if (this.metadataProtoInstance != null) {
            this.metadataProtoInstance.setParent(null);
        }
        this.metadataProtoInstance = newValue;
        if (newValue != null) {
            this.metadataProtoInstance.setParent(this);
            this.metadataProtoInstance.setContainerField("metadata");
        }
        if (this.metadata != null) {
            ((X3DConcreteElement)((Object)this.metadata)).setParent(null);
            this.metadata = null;
        }
        return this;
    }

    private ProtoInstance getMetadataProtoInstance() {
        return this.metadataProtoInstance;
    }

    public boolean hasMetadata() {
        return this.metadata != null || this.metadataProtoInstance != null;
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    @Override
    public NurbsCurve setOrder(int newValue) {
        if (newValue < 2) {
            throw new InvalidFieldValueException("NurbsCurve order newValue=" + newValue + " has component value less than restriction minInclusive=2");
        }
        this.order = newValue;
        return this;
    }

    public NurbsCurve setOrder(SFInt32 newValue) {
        this.setOrder(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public int getTessellation() {
        return this.tessellation;
    }

    @Override
    public NurbsCurve setTessellation(int newValue) {
        this.tessellation = newValue;
        return this;
    }

    public NurbsCurve setTessellation(SFInt32 newValue) {
        this.setTessellation(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public double[] getWeight() {
        double[] valuesArray = new double[this.weight.size()];
        int i = 0;
        for (Double arrayElement : this.weight) {
            valuesArray[i++] = arrayElement;
        }
        return valuesArray;
    }

    public ArrayList<Double> getWeightList() {
        return this.weight;
    }

    public String getWeightString() {
        StringBuilder result = new StringBuilder();
        for (Double arrayElement : this.weight) {
            result.append(arrayElement.toString());
            result.append(" ");
        }
        return result.toString().trim();
    }

    @Override
    public NurbsCurve setWeight(double[] newValue) {
        if (newValue == null) {
            this.clearWeight();
            return this;
        }
        this.clearWeight();
        for (int i = 0; i < newValue.length; ++i) {
            this.weight.add(newValue[i]);
        }
        return this;
    }

    public NurbsCurve setWeight(MFDouble newValue) {
        if (newValue == null) {
            this.clearWeight();
            return this;
        }
        this.setWeight(newValue.getPrimitiveValue());
        return this;
    }

    public NurbsCurve setWeight(ArrayList<Double> newValue) {
        if (newValue == null) {
            this.clearWeight();
            return this;
        }
        if (newValue.isEmpty()) {
            this.clearWeight();
        } else {
            double[] newArray = new double[newValue.size()];
            for (int i = 0; i < newValue.size(); ++i) {
                newArray[i] = newValue.get(i);
            }
            this.setWeight(newArray);
        }
        return this;
    }

    public NurbsCurve clearWeight() {
        this.weight.clear();
        return this;
    }

    public NurbsCurve setWeight(int[] newValue) {
        if (newValue == null) {
            this.clearWeight();
            return this;
        }
        double[] holdArray = new double[newValue.length];
        for (int i = 0; i < newValue.length; ++i) {
            holdArray[i] = newValue[i];
        }
        this.setWeight(holdArray);
        return this;
    }

    public NurbsCurve addWeight(double newValue) {
        this.weight.add(newValue);
        return this;
    }

    public NurbsCurve addWeight(SFDouble newValue) {
        if (newValue == null) {
            return this;
        }
        this.weight.add(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public String getDEF() {
        return super.getDEF();
    }

    @Override
    public final NurbsCurve setDEF(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        if (!newValue.isEmpty() && !SFString.isNMTOKEN(newValue)) {
            throw new InvalidFieldValueException("NurbsCurve DEF newValue='" + newValue + "' has illegal name value, cannot be empty and must be defined with valid NMTOKEN name string (with legal characters and no embedded whitespace).");
        }
        this.setConcreteUSE("");
        this.setConcreteDEF(newValue);
        return this;
    }

    public NurbsCurve setDEF(SFString newValue) {
        this.setDEF(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public String getUSE() {
        return super.getUSE();
    }

    @Override
    public final NurbsCurve setUSE(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        if (!newValue.isEmpty() && !SFString.isNMTOKEN(newValue)) {
            throw new InvalidFieldValueException("NurbsCurve USE newValue='" + newValue + "' has illegal name value, cannot be empty and must be defined with valid NMTOKEN name string (with legal characters and no embedded whitespace).");
        }
        this.setConcreteDEF("");
        this.setConcreteUSE(newValue);
        return this;
    }

    public NurbsCurve setUSE(SFString newValue) {
        this.setUSE(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public String getCssClass() {
        return super.getCssClass();
    }

    @Override
    public final NurbsCurve setCssClass(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        this.setConcreteCssClass(newValue);
        return this;
    }

    public NurbsCurve setCssClass(SFString newValue) {
        this.setCssClass(newValue.getPrimitiveValue());
        return this;
    }

    public NurbsCurve setUSE(NurbsCurve DEFnode) {
        if (DEFnode.getDEF().isEmpty()) {
            String errorNotice = "setUSE(DEFnode) invoked on NurbsCurve that has no DEF name defined, thus a copy cannot be referenced as a USE node";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.setUSE(DEFnode.getDEF());
        return this;
    }

    public NurbsCurve(String DEFlabel) {
        this.initialize();
        this.setDEF(DEFlabel);
    }

    @Override
    public NurbsCurve addComments(String newComment) {
        if (this.isUSE()) {
            String errorNotice = "addComments(\"" + newComment + "\")\ncannot be applied to a USE node (USE='" + this.getUSE() + "') which only contains a reference to a DEF node";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.commentsList.add(newComment);
        return this;
    }

    @Override
    public NurbsCurve addComments(String[] newComments) {
        if (this.isUSE()) {
            String errorNotice = "addComments(" + Arrays.toString(newComments) + ")\ncannot be applied to a USE node (USE='" + this.getUSE() + "') which only contains a reference to a DEF node";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.commentsList.addAll(Arrays.asList(newComments));
        return this;
    }

    @Override
    public NurbsCurve addComments(CommentsBlock newCommentsBlock) {
        if (this.isUSE()) {
            String errorNotice = "addComments(CommentsBlock) cannot be applied to a USE node (USE='" + this.getUSE() + "') which only contains a reference to a DEF node";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.commentsList.addAll(newCommentsBlock.toStringList());
        return this;
    }

    @Override
    public String toStringX3D(int indentLevel) {
        boolean hasChild;
        boolean hasAttributes = true;
        boolean bl = hasChild = this.IS != null || this.controlPoint != null || this.controlPointProtoInstance != null || this.IS != null || this.metadata != null || this.metadataProtoInstance != null || !this.commentsList.isEmpty();
        if (this.isUSE()) {
            hasChild = false;
        }
        StringBuilder indent = new StringBuilder();
        int indentIncrement = ConfigurationProperties.getIndentIncrement();
        char indentCharacter = ConfigurationProperties.getIndentCharacter();
        for (int i = 0; i < indentLevel; ++i) {
            indent.append(indentCharacter);
        }
        StringBuilder stringX3D = new StringBuilder();
        stringX3D.append((CharSequence)indent).append("<NurbsCurve");
        if (hasAttributes) {
            if (!this.getDEF().equals("") && !this.isUSE()) {
                stringX3D.append(" DEF='").append(SFString.toString(this.getDEF())).append("'");
            }
            if (!this.getUSE().equals("")) {
                stringX3D.append(" USE='").append(SFString.toString(this.getUSE())).append("'");
            }
            if (!this.getContainerFieldOverride().isEmpty() && !this.getContainerFieldOverride().equals(this.getContainerFieldDefault())) {
                stringX3D.append(" containerField='").append(this.getContainerFieldOverride()).append("'");
            }
            if (!(this.getCssClass().equals("") && ConfigurationProperties.getStripDefaultAttributes() || this.isUSE())) {
                stringX3D.append(" class='").append(new SFString(this.getCssClass()).toStringX3D()).append("'");
            }
            if (!(!this.getClosed() && ConfigurationProperties.getStripDefaultAttributes() || this.isUSE())) {
                stringX3D.append(" closed='").append(SFBool.toString(this.getClosed())).append("'");
            }
            if (!(this.getKnot().length <= 0 && ConfigurationProperties.getStripDefaultAttributes() || this.isUSE())) {
                stringX3D.append(" knot='").append(MFDouble.toString(this.getKnot())).append("'");
            }
            if (!(this.getOrder() == 3 && ConfigurationProperties.getStripDefaultAttributes() || this.isUSE())) {
                stringX3D.append(" order='").append(SFInt32.toString(this.getOrder())).append("'");
            }
            if (!(this.getTessellation() == 0 && ConfigurationProperties.getStripDefaultAttributes() || this.isUSE())) {
                stringX3D.append(" tessellation='").append(SFInt32.toString(this.getTessellation())).append("'");
            }
            if (!(this.getWeight().length <= 0 && ConfigurationProperties.getStripDefaultAttributes() || this.isUSE())) {
                stringX3D.append(" weight='").append(MFDouble.toString(this.getWeight())).append("'");
            }
        }
        if (hasChild && !this.isUSE()) {
            stringX3D.append(">").append("\n");
            if (!this.commentsList.isEmpty()) {
                CommentsBlock commentsBlock = new CommentsBlock(this.commentsList);
                stringX3D.append(commentsBlock.toStringX3D(indentLevel + indentIncrement));
            }
            if (this.metadata != null) {
                stringX3D.append(((X3DConcreteElement)((Object)this.metadata)).toStringX3D(indentLevel + indentIncrement));
            } else if (this.metadataProtoInstance != null) {
                stringX3D.append(((X3DConcreteElement)this.metadataProtoInstance).toStringX3D(indentLevel + indentIncrement));
            }
            if (this.IS != null) {
                stringX3D.append(((X3DConcreteElement)this.IS).toStringX3D(indentLevel + indentIncrement));
            }
            if (this.controlPoint != null) {
                stringX3D.append(((X3DConcreteElement)((Object)this.controlPoint)).toStringX3D(indentLevel + indentIncrement));
            } else if (this.controlPointProtoInstance != null) {
                stringX3D.append(((X3DConcreteElement)this.controlPointProtoInstance).toStringX3D(indentLevel + indentIncrement));
            }
            stringX3D.append((CharSequence)indent).append("</NurbsCurve>").append("\n");
        } else {
            stringX3D.append("/>").append("\n");
        }
        return stringX3D.toString();
    }

    @Override
    public String toStringClassicVRML(int indentLevel) {
        boolean hasChild;
        StringBuilder stringClassicVRML = new StringBuilder();
        boolean hasAttributes = true;
        boolean bl = hasChild = this.IS != null || this.controlPoint != null || this.controlPointProtoInstance != null || this.IS != null || this.metadata != null || this.metadataProtoInstance != null || !this.commentsList.isEmpty();
        if (this.isUSE()) {
            hasAttributes = false;
            hasChild = false;
        }
        StringBuilder indent = new StringBuilder();
        char indentCharacter = ConfigurationProperties.getIndentCharacter();
        int indentIncrement = ConfigurationProperties.getIndentIncrement();
        for (int i = 0; i < indentLevel; ++i) {
            indent.append(indentCharacter);
        }
        if (!this.getDEF().equals("")) {
            stringClassicVRML.append("DEF ").append(SFString.toString(this.getDEF())).append(" ");
        }
        if (!this.getUSE().equals("")) {
            stringClassicVRML.append("USE ").append(SFString.toString(this.getUSE())).append("\n");
        } else {
            stringClassicVRML.append(NAME).append(" { ");
            if (hasAttributes || hasChild) {
                stringClassicVRML.append("\n").append((CharSequence)indent).append(indentCharacter);
            }
            if (hasAttributes) {
                boolean hasISconnect;
                boolean bl2 = hasISconnect = this.getIS() != null && !this.getIS().getConnectList().isEmpty();
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("class")) continue;
                        stringClassicVRML.append(indentCharacter).append("class").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!this.getCssClass().equals("") || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("# class ").append("\"").append(SFString.toString(this.getCssClass())).append("\"").append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("closed")) continue;
                        stringClassicVRML.append(indentCharacter).append("closed").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (this.getClosed() || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("closed ").append(SFBool.toString(this.getClosed())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("knot")) continue;
                        stringClassicVRML.append(indentCharacter).append("knot").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (this.getKnot().length > 0 || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("knot ").append("[ ").append(MFDouble.toString(this.getKnot())).append(" ]").append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("order")) continue;
                        stringClassicVRML.append(indentCharacter).append("order").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (this.getOrder() != 3 || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("order ").append(SFInt32.toString(this.getOrder())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("tessellation")) continue;
                        stringClassicVRML.append(indentCharacter).append("tessellation").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (this.getTessellation() != 0 || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("tessellation ").append(SFInt32.toString(this.getTessellation())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("weight")) continue;
                        stringClassicVRML.append(indentCharacter).append("weight").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (this.getWeight().length > 0 || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("weight ").append("[ ").append(MFDouble.toString(this.getWeight())).append(" ]").append("\n").append((CharSequence)indent).append(indentCharacter);
                }
            }
        }
        if (hasChild) {
            if (this.metadata != null) {
                stringClassicVRML.append(indentCharacter).append("metadata").append(" ");
                stringClassicVRML.append(((X3DConcreteElement)((Object)this.metadata)).toStringClassicVRML(indentLevel + indentIncrement));
                stringClassicVRML.append((CharSequence)indent);
            } else if (this.metadataProtoInstance != null) {
                stringClassicVRML.append(indentCharacter).append("metadata").append(" ");
                stringClassicVRML.append(((X3DConcreteElement)this.metadataProtoInstance).toStringClassicVRML(indentLevel + indentIncrement));
                stringClassicVRML.append((CharSequence)indent);
            }
            if (this.IS != null) {
                stringClassicVRML.append(((X3DConcreteElement)this.IS).toStringClassicVRML(indentLevel));
            }
            if (this.controlPoint != null) {
                stringClassicVRML.append(indentCharacter).append("controlPoint").append(" ");
                stringClassicVRML.append(((X3DConcreteElement)((Object)this.controlPoint)).toStringClassicVRML(indentLevel + indentIncrement));
                stringClassicVRML.append((CharSequence)indent);
            } else if (this.controlPointProtoInstance != null) {
                stringClassicVRML.append(indentCharacter).append("controlPoint").append(" ");
                stringClassicVRML.append(((X3DConcreteElement)this.controlPointProtoInstance).toStringClassicVRML(indentLevel + indentIncrement));
                stringClassicVRML.append((CharSequence)indent);
            }
            if (!this.commentsList.isEmpty()) {
                CommentsBlock commentsBlock = new CommentsBlock(this.commentsList);
                stringClassicVRML.append(commentsBlock.toStringClassicVRML(indentLevel));
                stringClassicVRML.append((CharSequence)indent);
            }
        }
        if (hasAttributes || hasChild) {
            stringClassicVRML.append("}").append("\n");
        }
        return stringClassicVRML.toString();
    }

    @Override
    public String toStringVRML97(int indentLevel) {
        return this.toStringClassicVRML(indentLevel);
    }

    @Override
    public X3DConcreteElement findElementByNameValue(String nameValue) {
        return this.findElementByNameValue(nameValue, "");
    }

    @Override
    public X3DConcreteElement findElementByNameValue(String nameValue, String elementName) {
        X3DConcreteElement referenceElement;
        if (nameValue == null || nameValue.isEmpty()) {
            String errorNotice = "findElementByNameValue(\"\", " + elementName + ") cannot use empty string to find a name attribute";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        if (this.controlPoint != null && (referenceElement = ((X3DConcreteElement)((Object)this.controlPoint)).findElementByNameValue(nameValue, elementName)) != null) {
            return referenceElement;
        }
        if (this.controlPointProtoInstance != null && (referenceElement = ((X3DConcreteElement)this.controlPointProtoInstance).findElementByNameValue(nameValue, elementName)) != null) {
            return referenceElement;
        }
        if (this.IS != null && (referenceElement = ((X3DConcreteElement)this.IS).findElementByNameValue(nameValue, elementName)) != null) {
            return referenceElement;
        }
        if (this.metadata != null && (referenceElement = ((X3DConcreteElement)((Object)this.metadata)).findElementByNameValue(nameValue, elementName)) != null) {
            return referenceElement;
        }
        if (this.metadataProtoInstance != null && (referenceElement = ((X3DConcreteElement)this.metadataProtoInstance).findElementByNameValue(nameValue, elementName)) != null) {
            return referenceElement;
        }
        return null;
    }

    public boolean hasElementByNameValue(String nameValue, String elementName) {
        return this.findElementByNameValue(nameValue, elementName) != null;
    }

    @Override
    public X3DConcreteNode findNodeByDEF(String DEFvalue) {
        X3DConcreteNode referenceNode;
        if (DEFvalue == null || DEFvalue.isEmpty()) {
            String errorNotice = "findNodeByDEF(\"\") cannot use empty string to find a name";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        if (this.getDEF().equals(DEFvalue)) {
            return this;
        }
        if (this.controlPoint != null && (referenceNode = ((X3DConcreteElement)((Object)this.controlPoint)).findNodeByDEF(DEFvalue)) != null) {
            return referenceNode;
        }
        if (this.controlPointProtoInstance != null && (referenceNode = ((X3DConcreteElement)this.controlPointProtoInstance).findNodeByDEF(DEFvalue)) != null) {
            return referenceNode;
        }
        if (this.IS != null && (referenceNode = ((X3DConcreteElement)this.IS).findNodeByDEF(DEFvalue)) != null) {
            return referenceNode;
        }
        if (this.metadata != null && (referenceNode = ((X3DConcreteElement)((Object)this.metadata)).findNodeByDEF(DEFvalue)) != null) {
            return referenceNode;
        }
        if (this.metadataProtoInstance != null && (referenceNode = ((X3DConcreteElement)this.metadataProtoInstance).findNodeByDEF(DEFvalue)) != null) {
            return referenceNode;
        }
        return null;
    }

    public boolean hasNodeByDEF(String DEFvalue) {
        return this.findNodeByDEF(DEFvalue) != null;
    }

    @Override
    public String validate() {
        this.validationResult = new StringBuilder();
        this.setClosed(this.getClosed());
        this.setKnot(this.getKnot());
        this.setOrder(this.getOrder());
        this.setTessellation(this.getTessellation());
        this.setWeight(this.getWeight());
        if (!this.isUSE()) {
            this.setDEF(this.getDEF());
        }
        if (this.isUSE()) {
            this.setUSE(this.getUSE());
        }
        this.setCssClass(this.getCssClass());
        if (this.controlPoint != null) {
            this.setControlPoint(this.getControlPoint());
            ((X3DConcreteElement)((Object)this.controlPoint)).validate();
            this.validationResult.append(((X3DConcreteElement)((Object)this.controlPoint)).getValidationResult());
        }
        if (this.controlPointProtoInstance != null) {
            this.setControlPoint(this.getControlPointProtoInstance());
            ((X3DConcreteElement)this.controlPointProtoInstance).validate();
            this.validationResult.append(this.controlPointProtoInstance.getValidationResult());
        }
        if (this.controlPoint != null && this.controlPointProtoInstance != null) {
            String errorNotice = "Internal X3DJSAIL error: incorrect handling of contained SFNode field, both controlPoint and controlPointProtoInstance are set simultaneously";
            this.validationResult.append(errorNotice);
            throw new InvalidProtoException(errorNotice);
        }
        if (this.isUSE() && this.hasControlPoint()) {
            String errorNotice = "NurbsCurve USE='" + this.getUSE() + "' is not allowed to have contained SFNode controlPoint";
            this.validationResult.append(errorNotice);
            throw new InvalidFieldValueException(errorNotice);
        }
        if (this.isUSE() && !this.commentsList.isEmpty()) {
            String errorNotice = "NurbsCurve USE='" + this.getUSE() + "' is not allowed to have contained comments";
            this.validationResult.append(errorNotice);
            throw new InvalidFieldValueException(errorNotice);
        }
        if (this.IS != null) {
            this.setIS(this.getIS());
            ((X3DConcreteElement)this.IS).validate();
            this.validationResult.append(this.IS.getValidationResult());
        }
        if (this.isUSE() && this.hasIS()) {
            String errorNotice = "NurbsCurve USE='" + this.getUSE() + "' is not allowed to have contained SFNode IS";
            this.validationResult.append(errorNotice);
            throw new InvalidFieldValueException(errorNotice);
        }
        if (this.isUSE() && !this.commentsList.isEmpty()) {
            String errorNotice = "NurbsCurve USE='" + this.getUSE() + "' is not allowed to have contained comments";
            this.validationResult.append(errorNotice);
            throw new InvalidFieldValueException(errorNotice);
        }
        if (this.metadata != null) {
            this.setMetadata(this.getMetadata());
            ((X3DConcreteElement)((Object)this.metadata)).validate();
            this.validationResult.append(((X3DConcreteElement)((Object)this.metadata)).getValidationResult());
        }
        if (this.metadataProtoInstance != null) {
            this.setMetadata(this.getMetadataProtoInstance());
            ((X3DConcreteElement)this.metadataProtoInstance).validate();
            this.validationResult.append(this.metadataProtoInstance.getValidationResult());
        }
        if (this.metadata != null && this.metadataProtoInstance != null) {
            String errorNotice = "Internal X3DJSAIL error: incorrect handling of contained SFNode field, both metadata and metadataProtoInstance are set simultaneously";
            this.validationResult.append(errorNotice);
            throw new InvalidProtoException(errorNotice);
        }
        if (this.isUSE() && this.hasMetadata()) {
            String errorNotice = "NurbsCurve USE='" + this.getUSE() + "' is not allowed to have contained SFNode metadata";
            this.validationResult.append(errorNotice);
            throw new InvalidFieldValueException(errorNotice);
        }
        if (this.isUSE() && !this.commentsList.isEmpty()) {
            String errorNotice = "NurbsCurve USE='" + this.getUSE() + "' is not allowed to have contained comments";
            this.validationResult.append(errorNotice);
            throw new InvalidFieldValueException(errorNotice);
        }
        if (this.getIS() != null && this.getIS().getConnectList().isEmpty()) {
            String errorNotice = "IS statement present, but contains no connect statements";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidProtoException(errorNotice);
        }
        if (!this.getContainerFieldOverride().isEmpty() && !Arrays.asList(this.containerField_ALTERNATE_VALUES).contains(this.getContainerFieldOverride())) {
            String errorNotice = "ERROR_ILLEGAL_VALUE: illegal value encountered, containerField='" + this.getContainerFieldOverride() + "' but allowed values are containerField_ALTERNATE_VALUES='" + new MFString(this.containerField_ALTERNATE_VALUES).toStringX3D() + "'.";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldException(errorNotice);
        }
        if (this.findAncestorX3D() != null) {
            String modelProfile = this.findAncestorX3D().getProfile();
            boolean hasSatisfactorySupport = this.findAncestorX3D().supportsX3dComponent(COMPONENT, 1);
            if (!hasSatisfactorySupport) {
                String errorNotice = "ERROR_ILLEGAL_VALUE insufficient X3D profile='" + modelProfile + "' for parent X3D model containing 'NurbsCurve' node, add head statement <component name='NURBS' level='1'/>\nor Java source-code assignment:  findAncestorX3D().getHead().addComponent(\"NURBS\").setLevel(1);";
                this.validationResult.append(errorNotice).append("\n");
                throw new InvalidFieldException(errorNotice);
            }
        }
        return this.validationResult.toString();
    }
}

