/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.x3d.jsail.Navigation;

import java.util.ArrayList;
import java.util.Arrays;
import org.web3d.x3d.jsail.ConfigurationProperties;
import org.web3d.x3d.jsail.Core.CommentsBlock;
import org.web3d.x3d.jsail.Core.IS;
import org.web3d.x3d.jsail.Core.ProtoInstance;
import org.web3d.x3d.jsail.Core.connect;
import org.web3d.x3d.jsail.X3DConcreteElement;
import org.web3d.x3d.jsail.X3DConcreteNode;
import org.web3d.x3d.jsail.fields.MFFloat;
import org.web3d.x3d.jsail.fields.MFString;
import org.web3d.x3d.jsail.fields.SFBool;
import org.web3d.x3d.jsail.fields.SFFloat;
import org.web3d.x3d.jsail.fields.SFString;
import org.web3d.x3d.jsail.fields.SFTime;
import org.web3d.x3d.sai.Core.X3DMetadataObject;
import org.web3d.x3d.sai.InvalidFieldException;
import org.web3d.x3d.sai.InvalidFieldValueException;
import org.web3d.x3d.sai.InvalidProtoException;

public class NavigationInfo
extends X3DConcreteNode
implements org.web3d.x3d.sai.Navigation.NavigationInfo {
    private ArrayList<String> commentsList;
    private ArrayList<Float> avatarSize = new ArrayList();
    private double bindTime;
    private boolean headlight;
    private IS IS;
    private boolean isBound;
    private X3DMetadataObject metadata;
    private ProtoInstance metadataProtoInstance;
    private boolean bind;
    private float speed;
    private boolean transitionComplete;
    private double transitionTime;
    private ArrayList<String> transitionType = new ArrayList();
    private ArrayList<String> type = new ArrayList();
    private float visibilityLimit;
    public static final String TRANSITIONTYPE_TELEPORT = "TELEPORT";
    public static final String TRANSITIONTYPE_LINEAR = "LINEAR";
    public static final String TRANSITIONTYPE_ANIMATE = "ANIMATE";
    public static final String TYPE_ANY = "ANY";
    public static final String TYPE_WALK = "WALK";
    public static final String TYPE_EXAMINE = "EXAMINE";
    public static final String TYPE_FLY = "FLY";
    public static final String TYPE_LOOKAT = "LOOKAT";
    public static final String TYPE_NONE = "NONE";
    public static final String TYPE_EXPLORE = "EXPLORE";
    public static final String NAME = "NavigationInfo";
    public static final String COMPONENT = "Navigation";
    public static final int LEVEL = 1;
    public static final ArrayList<Float> AVATARSIZE_DEFAULT_VALUE = new ArrayList<Float>(Arrays.asList(Float.valueOf(0.25f), Float.valueOf(1.6f), Float.valueOf(0.75f)));
    public static final boolean HEADLIGHT_DEFAULT_VALUE = true;
    public static final IS IS_DEFAULT_VALUE = null;
    public static final X3DMetadataObject METADATA_DEFAULT_VALUE = null;
    public static final float SPEED_DEFAULT_VALUE = 1.0f;
    public static final double TRANSITIONTIME_DEFAULT_VALUE = 1.0;
    public static final ArrayList<String> TRANSITIONTYPE_DEFAULT_VALUE = new ArrayList<String>(Arrays.asList("LINEAR"));
    public static final ArrayList<String> TYPE_DEFAULT_VALUE = new ArrayList<String>(Arrays.asList("EXAMINE", "ANY"));
    public static final float VISIBILITYLIMIT_DEFAULT_VALUE = 0.0f;
    public static final String containerField_DEFAULT_VALUE = "children";
    public static final String fromField_AVATARSIZE = "avatarSize";
    public static final String toField_AVATARSIZE = "avatarSize";
    public static final String fromField_BINDTIME = "bindTime";
    public static final String fromField_HEADLIGHT = "headlight";
    public static final String toField_HEADLIGHT = "headlight";
    public static final String fromField_IS = "IS";
    public static final String fromField_ISBOUND = "isBound";
    public static final String fromField_METADATA = "metadata";
    public static final String toField_METADATA = "metadata";
    public static final String toField_SET_BIND = "set_bind";
    public static final String fromField_SPEED = "speed";
    public static final String toField_SPEED = "speed";
    public static final String fromField_TRANSITIONCOMPLETE = "transitionComplete";
    public static final String fromField_TRANSITIONTIME = "transitionTime";
    public static final String toField_TRANSITIONTIME = "transitionTime";
    public static final String fromField_TRANSITIONTYPE = "transitionType";
    public static final String toField_TRANSITIONTYPE = "transitionType";
    public static final String fromField_TYPE = "type";
    public static final String toField_TYPE = "type";
    public static final String fromField_VISIBILITYLIMIT = "visibilityLimit";
    public static final String toField_VISIBILITYLIMIT = "visibilityLimit";

    @Override
    public final String getElementName() {
        return NAME;
    }

    @Override
    public final String getComponent() {
        return COMPONENT;
    }

    @Override
    public final int getComponentLevel() {
        return 1;
    }

    @Override
    public String getFieldType(String fieldName) {
        String result;
        switch (fieldName) {
            case "containerField": {
                result = "SFString";
                break;
            }
            case "avatarSize": {
                result = "MFFloat";
                break;
            }
            case "bindTime": {
                result = "SFTime";
                break;
            }
            case "headlight": {
                result = "SFBool";
                break;
            }
            case "IS": {
                result = "SFNode";
                break;
            }
            case "isBound": {
                result = "SFBool";
                break;
            }
            case "metadata": {
                result = "SFNode";
                break;
            }
            case "bind": {
                result = "SFBool";
                break;
            }
            case "speed": {
                result = "SFFloat";
                break;
            }
            case "transitionComplete": {
                result = "SFBool";
                break;
            }
            case "transitionTime": {
                result = "SFTime";
                break;
            }
            case "transitionType": {
                result = "MFString";
                break;
            }
            case "type": {
                result = "MFString";
                break;
            }
            case "visibilityLimit": {
                result = "SFFloat";
                break;
            }
            case "DEF": {
                result = "SFString";
                break;
            }
            case "USE": {
                result = "SFString";
                break;
            }
            case "class": {
                result = "SFString";
                break;
            }
            default: {
                result = fieldName.trim().startsWith("set_") ? this.getFieldType(fieldName.trim().substring(4)) : (fieldName.trim().endsWith("_changed") ? this.getFieldType(fieldName.trim().substring(0, fieldName.length() - 8)) : "ERROR_UNKNOWN_FIELD_TYPE");
            }
        }
        return result;
    }

    @Override
    public String getAccessType(String fieldName) {
        String result;
        switch (fieldName) {
            case "avatarSize": {
                result = "inputOutput";
                break;
            }
            case "bindTime": {
                result = "outputOnly";
                break;
            }
            case "headlight": {
                result = "inputOutput";
                break;
            }
            case "IS": {
                result = "inputOutput";
                break;
            }
            case "isBound": {
                result = "outputOnly";
                break;
            }
            case "metadata": {
                result = "inputOutput";
                break;
            }
            case "set_bind": {
                result = "inputOnly";
                break;
            }
            case "speed": {
                result = "inputOutput";
                break;
            }
            case "transitionComplete": {
                result = "outputOnly";
                break;
            }
            case "transitionTime": {
                result = "inputOutput";
                break;
            }
            case "transitionType": {
                result = "inputOutput";
                break;
            }
            case "type": {
                result = "inputOutput";
                break;
            }
            case "visibilityLimit": {
                result = "inputOutput";
                break;
            }
            case "DEF": {
                result = "inputOutput";
                break;
            }
            case "USE": {
                result = "inputOutput";
                break;
            }
            case "class": {
                result = "inputOutput";
                break;
            }
            default: {
                result = fieldName.trim().startsWith("set_") ? this.getAccessType(fieldName.trim().substring(4)) : (fieldName.trim().endsWith("_changed") ? this.getAccessType(fieldName.trim().substring(0, fieldName.length() - 8)) : "ERROR_UNKNOWN_FIELD_ACCESSTYPE");
            }
        }
        return result;
    }

    @Override
    public final String getContainerFieldDefault() {
        return containerField_DEFAULT_VALUE;
    }

    public NavigationInfo() {
        this.initialize();
    }

    @Override
    public final void initialize() {
        super.initialize();
        this.setContainerFieldOverride("");
        this.containerField_ALTERNATE_VALUES = new String[]{containerField_DEFAULT_VALUE};
        this.avatarSize = AVATARSIZE_DEFAULT_VALUE;
        this.headlight = true;
        this.IS = null;
        this.metadata = null;
        this.metadataProtoInstance = null;
        this.speed = 1.0f;
        this.transitionTime = 1.0;
        this.transitionType = new ArrayList<String>(TRANSITIONTYPE_DEFAULT_VALUE);
        this.type = new ArrayList<String>(TYPE_DEFAULT_VALUE);
        this.visibilityLimit = 0.0f;
        this.commentsList = new ArrayList();
    }

    @Override
    public float[] getAvatarSize() {
        float[] valuesArray = new float[this.avatarSize.size()];
        int i = 0;
        for (Float arrayElement : this.avatarSize) {
            valuesArray[i++] = arrayElement.floatValue();
        }
        return valuesArray;
    }

    public ArrayList<Float> getAvatarSizeList() {
        return this.avatarSize;
    }

    public String getAvatarSizeString() {
        StringBuilder result = new StringBuilder();
        for (Float arrayElement : this.avatarSize) {
            result.append(arrayElement.toString());
            result.append(" ");
        }
        return result.toString().trim();
    }

    @Override
    public NavigationInfo setAvatarSize(float[] newValue) {
        if (newValue == null) {
            this.clearAvatarSize();
            return this;
        }
        this.clearAvatarSize();
        for (int i = 0; i < newValue.length; ++i) {
            this.avatarSize.add(Float.valueOf(newValue[i]));
        }
        return this;
    }

    public NavigationInfo setAvatarSize(MFFloat newValue) {
        if (newValue == null) {
            this.clearAvatarSize();
            return this;
        }
        this.setAvatarSize(newValue.getPrimitiveValue());
        return this;
    }

    public NavigationInfo setAvatarSize(ArrayList<Float> newValue) {
        if (newValue == null) {
            this.clearAvatarSize();
            return this;
        }
        if (newValue.isEmpty()) {
            this.clearAvatarSize();
        } else {
            float[] newArray = new float[newValue.size()];
            for (int i = 0; i < newValue.size(); ++i) {
                newArray[i] = newValue.get(i).floatValue();
            }
            this.setAvatarSize(newArray);
        }
        return this;
    }

    public NavigationInfo clearAvatarSize() {
        this.avatarSize.clear();
        return this;
    }

    public NavigationInfo setAvatarSize(int[] newValue) {
        if (newValue == null) {
            this.clearAvatarSize();
            return this;
        }
        float[] holdArray = new float[newValue.length];
        for (int i = 0; i < newValue.length; ++i) {
            holdArray[i] = newValue[i];
        }
        this.setAvatarSize(holdArray);
        return this;
    }

    public NavigationInfo addAvatarSize(float newValue) {
        this.avatarSize.add(Float.valueOf(newValue));
        return this;
    }

    public NavigationInfo addAvatarSize(SFFloat newValue) {
        if (newValue == null) {
            return this;
        }
        this.avatarSize.add(Float.valueOf(newValue.getPrimitiveValue()));
        return this;
    }

    public NavigationInfo setAvatarSize(double[] newArray) {
        return this.setAvatarSize(new MFFloat(newArray));
    }

    @Override
    public double getBindTime() {
        return this.bindTime;
    }

    @Override
    public boolean getHeadlight() {
        return this.headlight;
    }

    @Override
    public NavigationInfo setHeadlight(boolean newValue) {
        this.headlight = newValue;
        return this;
    }

    public NavigationInfo setHeadlight(SFBool newValue) {
        this.setHeadlight(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public IS getIS() {
        return this.IS;
    }

    @Override
    public NavigationInfo setIS(IS newValue) {
        this.IS = newValue;
        if (newValue != null) {
            this.IS.setParent(this);
        }
        return this;
    }

    public NavigationInfo clearIS() {
        this.IS.clearParent();
        this.IS = null;
        return this;
    }

    public boolean hasIS() {
        return this.IS != null;
    }

    @Override
    public boolean getIsBound() {
        return this.isBound;
    }

    @Override
    public X3DMetadataObject getMetadata() {
        return this.metadata;
    }

    @Override
    public NavigationInfo setMetadata(X3DMetadataObject newValue) {
        this.metadata = newValue;
        if (newValue != null) {
            ((X3DConcreteElement)((Object)this.metadata)).setParent(this);
        }
        if (this.metadataProtoInstance != null) {
            this.metadataProtoInstance.setParent(null);
            this.metadataProtoInstance = null;
        }
        return this;
    }

    public NavigationInfo clearMetadata() {
        ((X3DConcreteElement)((Object)this.metadata)).clearParent();
        this.metadata = null;
        return this;
    }

    @Override
    public NavigationInfo setMetadata(ProtoInstance newValue) {
        if (this.metadataProtoInstance != null) {
            this.metadataProtoInstance.setParent(null);
        }
        this.metadataProtoInstance = newValue;
        if (newValue != null) {
            this.metadataProtoInstance.setParent(this);
            this.metadataProtoInstance.setContainerField("metadata");
        }
        if (this.metadata != null) {
            ((X3DConcreteElement)((Object)this.metadata)).setParent(null);
            this.metadata = null;
        }
        return this;
    }

    private ProtoInstance getMetadataProtoInstance() {
        return this.metadataProtoInstance;
    }

    public boolean hasMetadata() {
        return this.metadata != null || this.metadataProtoInstance != null;
    }

    @Override
    public float getSpeed() {
        return this.speed;
    }

    @Override
    public NavigationInfo setSpeed(float newValue) {
        if (newValue < 0.0f) {
            throw new InvalidFieldValueException("NavigationInfo speed newValue=" + newValue + " has component value less than restriction minInclusive=0");
        }
        this.speed = newValue;
        return this;
    }

    public NavigationInfo setSpeed(SFFloat newValue) {
        this.setSpeed(newValue.getPrimitiveValue());
        return this;
    }

    public NavigationInfo setSpeed(double newValue) {
        return this.setSpeed((float)newValue);
    }

    @Override
    public boolean getTransitionComplete() {
        return this.transitionComplete;
    }

    @Override
    public double getTransitionTime() {
        return this.transitionTime;
    }

    @Override
    public NavigationInfo setTransitionTime(double newValue) {
        if (newValue < 0.0) {
            throw new InvalidFieldValueException("NavigationInfo transitionTime newValue=" + newValue + " has component value less than restriction minInclusive=0");
        }
        this.transitionTime = newValue;
        return this;
    }

    public NavigationInfo setTransitionTime(SFTime newValue) {
        this.setTransitionTime(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public String[] getTransitionType() {
        String[] valuesArray = new String[this.transitionType.size()];
        int i = 0;
        for (String arrayElement : this.transitionType) {
            valuesArray[i++] = arrayElement;
        }
        return valuesArray;
    }

    public ArrayList<String> getTransitionTypeList() {
        return this.transitionType;
    }

    public String getTransitionTypeString() {
        StringBuilder result = new StringBuilder();
        for (String arrayElement : this.transitionType) {
            result.append("\"");
            result.append(arrayElement);
            result.append("\"");
            result.append(" ");
        }
        return result.toString().trim();
    }

    @Override
    public NavigationInfo setTransitionType(String[] newValue) {
        int i;
        if (newValue == null) {
            this.clearTransitionType();
            return this;
        }
        for (i = 0; i < newValue.length; ++i) {
            if (newValue.length == 0 || newValue[i].equals(TRANSITIONTYPE_TELEPORT) || newValue[i].equals(TRANSITIONTYPE_LINEAR) || newValue[i].equals(TRANSITIONTYPE_ANIMATE)) continue;
            String warningMessage = "Warning: NavigationInfo transitionType newValue=\"" + Arrays.toString(newValue) + "\" has an unrecognized value not matching any of the optional string tokens.";
            if (newValue[i].contains(" ")) {
                warningMessage = warningMessage + " Note that enumeration value \"" + newValue[i] + "\" contains embedded whitespace, need to check necessary quoting of individual MFString values.";
            }
            System.out.println(warningMessage);
        }
        if (newValue == null) {
            this.clearTransitionType();
            return this;
        }
        this.clearTransitionType();
        for (i = 0; i < newValue.length; ++i) {
            this.transitionType.add(newValue[i]);
        }
        return this;
    }

    public NavigationInfo setTransitionType(MFString newValue) {
        if (newValue == null) {
            this.clearTransitionType();
            return this;
        }
        this.setTransitionType(newValue.getPrimitiveValue());
        return this;
    }

    public NavigationInfo setTransitionType(SFString newValue) {
        if (newValue == null) {
            this.clearTransitionType();
            return this;
        }
        if (newValue == null) {
            this.clearTransitionType();
            return this;
        }
        if (!(newValue.getValue().isEmpty() || newValue.equals(TRANSITIONTYPE_TELEPORT) || newValue.equals(TRANSITIONTYPE_LINEAR) || newValue.equals(TRANSITIONTYPE_ANIMATE))) {
            String warningMessage = "Warning: NavigationInfo transitionType newValue=\"" + newValue + "\" has an unrecognized value not matching any of the optional string tokens.";
            System.out.println(warningMessage);
        }
        this.setTransitionType(MFString.cleanupEnumerationValues(newValue.toString()));
        return this;
    }

    public NavigationInfo setTransitionType(String newValue) {
        if (newValue == null) {
            this.clearTransitionType();
            return this;
        }
        if (newValue == null) {
            this.clearTransitionType();
            return this;
        }
        if (!(newValue.isEmpty() || newValue.equals(TRANSITIONTYPE_TELEPORT) || newValue.equals(TRANSITIONTYPE_LINEAR) || newValue.equals(TRANSITIONTYPE_ANIMATE))) {
            String warningMessage = "Warning: NavigationInfo transitionType newValue=\"" + newValue + "\" has an unrecognized value not matching any of the optional string tokens.";
            System.out.println(warningMessage);
        }
        this.setTransitionType(MFString.cleanupEnumerationValues(newValue));
        return this;
    }

    public NavigationInfo setTransitionType(ArrayList<String> newValue) {
        if (newValue == null) {
            this.clearTransitionType();
            return this;
        }
        if (newValue == null) {
            this.clearTransitionType();
            return this;
        }
        if (!(newValue.size() == 0 || newValue.equals(TRANSITIONTYPE_TELEPORT) || newValue.equals(TRANSITIONTYPE_LINEAR) || newValue.equals(TRANSITIONTYPE_ANIMATE))) {
            String warningMessage = "Warning: NavigationInfo transitionType newValue=\"" + newValue + "\" has an unrecognized value not matching any of the optional string tokens.";
            System.out.println(warningMessage);
        }
        if (newValue.isEmpty()) {
            this.clearTransitionType();
        } else {
            String[] newArray = new String[newValue.size()];
            for (int i = 0; i < newValue.size(); ++i) {
                newArray[i] = newValue.get(i);
            }
            this.setTransitionType(newArray);
        }
        return this;
    }

    public NavigationInfo clearTransitionType() {
        this.transitionType.clear();
        return this;
    }

    public NavigationInfo addTransitionType(String newValue) {
        if (newValue == null) {
            return this;
        }
        if (!(newValue = MFString.cleanupEnumerationValue(newValue)).isEmpty() && !this.transitionType.contains(newValue)) {
            this.transitionType.add(newValue);
        }
        return this;
    }

    public NavigationInfo addTransitionType(SFString newValue) {
        if (newValue == null) {
            return this;
        }
        newValue.setValue(MFString.cleanupEnumerationValue(newValue.getValue()));
        if (!newValue.getValue().isEmpty() && !this.transitionType.contains(newValue.getValue())) {
            this.transitionType.add(newValue.getValue());
        }
        return this;
    }

    @Override
    public String[] getType() {
        String[] valuesArray = new String[this.type.size()];
        int i = 0;
        for (String arrayElement : this.type) {
            valuesArray[i++] = arrayElement;
        }
        return valuesArray;
    }

    public ArrayList<String> getTypeList() {
        return this.type;
    }

    public String getTypeString() {
        StringBuilder result = new StringBuilder();
        for (String arrayElement : this.type) {
            result.append("\"");
            result.append(arrayElement);
            result.append("\"");
            result.append(" ");
        }
        return result.toString().trim();
    }

    @Override
    public NavigationInfo setType(String[] newValue) {
        int i;
        if (newValue == null) {
            this.clearType();
            return this;
        }
        for (i = 0; i < newValue.length; ++i) {
            if (newValue.length == 0 || newValue[i].equals(TYPE_ANY) || newValue[i].equals(TYPE_WALK) || newValue[i].equals(TYPE_EXAMINE) || newValue[i].equals(TYPE_FLY) || newValue[i].equals(TYPE_LOOKAT) || newValue[i].equals(TYPE_NONE) || newValue[i].equals(TYPE_EXPLORE)) continue;
            String warningMessage = "Warning: NavigationInfo type newValue=\"" + Arrays.toString(newValue) + "\" has an unrecognized value not matching any of the optional string tokens.";
            if (newValue[i].contains(" ")) {
                warningMessage = warningMessage + " Note that enumeration value \"" + newValue[i] + "\" contains embedded whitespace, need to check necessary quoting of individual MFString values.";
            }
            System.out.println(warningMessage);
        }
        if (newValue == null) {
            this.clearType();
            return this;
        }
        this.clearType();
        for (i = 0; i < newValue.length; ++i) {
            this.type.add(newValue[i]);
        }
        return this;
    }

    public NavigationInfo setType(MFString newValue) {
        if (newValue == null) {
            this.clearType();
            return this;
        }
        this.setType(newValue.getPrimitiveValue());
        return this;
    }

    public NavigationInfo setType(SFString newValue) {
        if (newValue == null) {
            this.clearType();
            return this;
        }
        if (newValue == null) {
            this.clearType();
            return this;
        }
        if (!(newValue.getValue().isEmpty() || newValue.equals(TYPE_ANY) || newValue.equals(TYPE_WALK) || newValue.equals(TYPE_EXAMINE) || newValue.equals(TYPE_FLY) || newValue.equals(TYPE_LOOKAT) || newValue.equals(TYPE_NONE) || newValue.equals(TYPE_EXPLORE))) {
            String warningMessage = "Warning: NavigationInfo type newValue=\"" + newValue + "\" has an unrecognized value not matching any of the optional string tokens.";
            System.out.println(warningMessage);
        }
        this.setType(MFString.cleanupEnumerationValues(newValue.toString()));
        return this;
    }

    public NavigationInfo setType(String newValue) {
        if (newValue == null) {
            this.clearType();
            return this;
        }
        if (newValue == null) {
            this.clearType();
            return this;
        }
        if (!(newValue.isEmpty() || newValue.equals(TYPE_ANY) || newValue.equals(TYPE_WALK) || newValue.equals(TYPE_EXAMINE) || newValue.equals(TYPE_FLY) || newValue.equals(TYPE_LOOKAT) || newValue.equals(TYPE_NONE) || newValue.equals(TYPE_EXPLORE))) {
            String warningMessage = "Warning: NavigationInfo type newValue=\"" + newValue + "\" has an unrecognized value not matching any of the optional string tokens.";
            System.out.println(warningMessage);
        }
        this.setType(MFString.cleanupEnumerationValues(newValue));
        return this;
    }

    public NavigationInfo setType(ArrayList<String> newValue) {
        if (newValue == null) {
            this.clearType();
            return this;
        }
        if (newValue == null) {
            this.clearType();
            return this;
        }
        if (!(newValue.size() == 0 || newValue.equals(TYPE_ANY) || newValue.equals(TYPE_WALK) || newValue.equals(TYPE_EXAMINE) || newValue.equals(TYPE_FLY) || newValue.equals(TYPE_LOOKAT) || newValue.equals(TYPE_NONE) || newValue.equals(TYPE_EXPLORE))) {
            String warningMessage = "Warning: NavigationInfo type newValue=\"" + newValue + "\" has an unrecognized value not matching any of the optional string tokens.";
            System.out.println(warningMessage);
        }
        if (newValue.isEmpty()) {
            this.clearType();
        } else {
            String[] newArray = new String[newValue.size()];
            for (int i = 0; i < newValue.size(); ++i) {
                newArray[i] = newValue.get(i);
            }
            this.setType(newArray);
        }
        return this;
    }

    public NavigationInfo clearType() {
        this.type.clear();
        return this;
    }

    public NavigationInfo addType(String newValue) {
        if (newValue == null) {
            return this;
        }
        if (!(newValue = MFString.cleanupEnumerationValue(newValue)).isEmpty() && !this.type.contains(newValue)) {
            this.type.add(newValue);
        }
        return this;
    }

    public NavigationInfo addType(SFString newValue) {
        if (newValue == null) {
            return this;
        }
        newValue.setValue(MFString.cleanupEnumerationValue(newValue.getValue()));
        if (!newValue.getValue().isEmpty() && !this.type.contains(newValue.getValue())) {
            this.type.add(newValue.getValue());
        }
        return this;
    }

    @Override
    public float getVisibilityLimit() {
        return this.visibilityLimit;
    }

    @Override
    public NavigationInfo setVisibilityLimit(float newValue) {
        if (newValue < 0.0f) {
            throw new InvalidFieldValueException("NavigationInfo visibilityLimit newValue=" + newValue + " has component value less than restriction minInclusive=0");
        }
        this.visibilityLimit = newValue;
        return this;
    }

    public NavigationInfo setVisibilityLimit(SFFloat newValue) {
        this.setVisibilityLimit(newValue.getPrimitiveValue());
        return this;
    }

    public NavigationInfo setVisibilityLimit(double newValue) {
        return this.setVisibilityLimit((float)newValue);
    }

    @Override
    public String getDEF() {
        return super.getDEF();
    }

    @Override
    public final NavigationInfo setDEF(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        if (!newValue.isEmpty() && !SFString.isNMTOKEN(newValue)) {
            throw new InvalidFieldValueException("NavigationInfo DEF newValue='" + newValue + "' has illegal name value, cannot be empty and must be defined with valid NMTOKEN name string (with legal characters and no embedded whitespace).");
        }
        this.setConcreteUSE("");
        this.setConcreteDEF(newValue);
        return this;
    }

    public NavigationInfo setDEF(SFString newValue) {
        this.setDEF(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public String getUSE() {
        return super.getUSE();
    }

    @Override
    public final NavigationInfo setUSE(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        if (!newValue.isEmpty() && !SFString.isNMTOKEN(newValue)) {
            throw new InvalidFieldValueException("NavigationInfo USE newValue='" + newValue + "' has illegal name value, cannot be empty and must be defined with valid NMTOKEN name string (with legal characters and no embedded whitespace).");
        }
        this.setConcreteDEF("");
        this.setConcreteUSE(newValue);
        return this;
    }

    public NavigationInfo setUSE(SFString newValue) {
        this.setUSE(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public String getCssClass() {
        return super.getCssClass();
    }

    @Override
    public final NavigationInfo setCssClass(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        this.setConcreteCssClass(newValue);
        return this;
    }

    public NavigationInfo setCssClass(SFString newValue) {
        this.setCssClass(newValue.getPrimitiveValue());
        return this;
    }

    public NavigationInfo setUSE(NavigationInfo DEFnode) {
        if (DEFnode.getDEF().isEmpty()) {
            String errorNotice = "setUSE(DEFnode) invoked on NavigationInfo that has no DEF name defined, thus a copy cannot be referenced as a USE node";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.setUSE(DEFnode.getDEF());
        return this;
    }

    public NavigationInfo(String DEFlabel) {
        this.initialize();
        this.setDEF(DEFlabel);
    }

    @Override
    public NavigationInfo addComments(String newComment) {
        if (this.isUSE()) {
            String errorNotice = "addComments(\"" + newComment + "\")\ncannot be applied to a USE node (USE='" + this.getUSE() + "') which only contains a reference to a DEF node";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.commentsList.add(newComment);
        return this;
    }

    @Override
    public NavigationInfo addComments(String[] newComments) {
        if (this.isUSE()) {
            String errorNotice = "addComments(" + Arrays.toString(newComments) + ")\ncannot be applied to a USE node (USE='" + this.getUSE() + "') which only contains a reference to a DEF node";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.commentsList.addAll(Arrays.asList(newComments));
        return this;
    }

    @Override
    public NavigationInfo addComments(CommentsBlock newCommentsBlock) {
        if (this.isUSE()) {
            String errorNotice = "addComments(CommentsBlock) cannot be applied to a USE node (USE='" + this.getUSE() + "') which only contains a reference to a DEF node";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.commentsList.addAll(newCommentsBlock.toStringList());
        return this;
    }

    @Override
    public String toStringX3D(int indentLevel) {
        boolean hasChild;
        boolean hasAttributes = true;
        boolean bl = hasChild = this.IS != null || this.IS != null || this.metadata != null || this.metadataProtoInstance != null || !this.commentsList.isEmpty();
        if (this.isUSE()) {
            hasChild = false;
        }
        StringBuilder indent = new StringBuilder();
        int indentIncrement = ConfigurationProperties.getIndentIncrement();
        char indentCharacter = ConfigurationProperties.getIndentCharacter();
        for (int i = 0; i < indentLevel; ++i) {
            indent.append(indentCharacter);
        }
        StringBuilder stringX3D = new StringBuilder();
        stringX3D.append((CharSequence)indent).append("<NavigationInfo");
        if (hasAttributes) {
            if (!this.getDEF().equals("") && !this.isUSE()) {
                stringX3D.append(" DEF='").append(SFString.toString(this.getDEF())).append("'");
            }
            if (!this.getUSE().equals("")) {
                stringX3D.append(" USE='").append(SFString.toString(this.getUSE())).append("'");
            }
            if (!this.getContainerFieldOverride().isEmpty() && !this.getContainerFieldOverride().equals(this.getContainerFieldDefault())) {
                stringX3D.append(" containerField='").append(this.getContainerFieldOverride()).append("'");
            }
            if (!(this.getAvatarSize().length <= 0 && ConfigurationProperties.getStripDefaultAttributes() || this.isUSE())) {
                stringX3D.append(" avatarSize='").append(MFFloat.toString(this.getAvatarSize())).append("'");
            }
            if (!(this.getCssClass().equals("") && ConfigurationProperties.getStripDefaultAttributes() || this.isUSE())) {
                stringX3D.append(" class='").append(new SFString(this.getCssClass()).toStringX3D()).append("'");
            }
            if (!(this.getHeadlight() && ConfigurationProperties.getStripDefaultAttributes() || this.isUSE())) {
                stringX3D.append(" headlight='").append(SFBool.toString(this.getHeadlight())).append("'");
            }
            if (!(this.getSpeed() == 1.0f && ConfigurationProperties.getStripDefaultAttributes() || this.isUSE())) {
                stringX3D.append(" speed='").append(SFFloat.toString(this.getSpeed())).append("'");
            }
            if (!(this.getTransitionTime() == 1.0 && ConfigurationProperties.getStripDefaultAttributes() || this.isUSE())) {
                stringX3D.append(" transitionTime='").append(SFTime.toString(this.getTransitionTime())).append("'");
            }
            if (!(this.getTransitionType().length <= 0 && ConfigurationProperties.getStripDefaultAttributes() || this.isUSE())) {
                stringX3D.append(" transitionType='").append(new MFString(this.getTransitionType()).toStringX3D()).append("'");
            }
            if (!(this.getType().length <= 0 && ConfigurationProperties.getStripDefaultAttributes() || this.isUSE())) {
                stringX3D.append(" type='").append(new MFString(this.getType()).toStringX3D()).append("'");
            }
            if (!(this.getVisibilityLimit() == 0.0f && ConfigurationProperties.getStripDefaultAttributes() || this.isUSE())) {
                stringX3D.append(" visibilityLimit='").append(SFFloat.toString(this.getVisibilityLimit())).append("'");
            }
        }
        if (hasChild && !this.isUSE()) {
            stringX3D.append(">").append("\n");
            if (!this.commentsList.isEmpty()) {
                CommentsBlock commentsBlock = new CommentsBlock(this.commentsList);
                stringX3D.append(commentsBlock.toStringX3D(indentLevel + indentIncrement));
            }
            if (this.metadata != null) {
                stringX3D.append(((X3DConcreteElement)((Object)this.metadata)).toStringX3D(indentLevel + indentIncrement));
            } else if (this.metadataProtoInstance != null) {
                stringX3D.append(((X3DConcreteElement)this.metadataProtoInstance).toStringX3D(indentLevel + indentIncrement));
            }
            if (this.IS != null) {
                stringX3D.append(((X3DConcreteElement)this.IS).toStringX3D(indentLevel + indentIncrement));
            }
            stringX3D.append((CharSequence)indent).append("</NavigationInfo>").append("\n");
        } else {
            stringX3D.append("/>").append("\n");
        }
        return stringX3D.toString();
    }

    @Override
    public String toStringClassicVRML(int indentLevel) {
        boolean hasChild;
        StringBuilder stringClassicVRML = new StringBuilder();
        boolean hasAttributes = true;
        boolean bl = hasChild = this.IS != null || this.IS != null || this.metadata != null || this.metadataProtoInstance != null || !this.commentsList.isEmpty();
        if (this.isUSE()) {
            hasAttributes = false;
            hasChild = false;
        }
        StringBuilder indent = new StringBuilder();
        char indentCharacter = ConfigurationProperties.getIndentCharacter();
        int indentIncrement = ConfigurationProperties.getIndentIncrement();
        for (int i = 0; i < indentLevel; ++i) {
            indent.append(indentCharacter);
        }
        if (!this.getDEF().equals("")) {
            stringClassicVRML.append("DEF ").append(SFString.toString(this.getDEF())).append(" ");
        }
        if (!this.getUSE().equals("")) {
            stringClassicVRML.append("USE ").append(SFString.toString(this.getUSE())).append("\n");
        } else {
            stringClassicVRML.append(NAME).append(" { ");
            if (hasAttributes || hasChild) {
                stringClassicVRML.append("\n").append((CharSequence)indent).append(indentCharacter);
            }
            if (hasAttributes) {
                boolean hasISconnect;
                boolean bl2 = hasISconnect = this.getIS() != null && !this.getIS().getConnectList().isEmpty();
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("avatarSize")) continue;
                        stringClassicVRML.append(indentCharacter).append("avatarSize").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (this.getAvatarSize().length > 0 || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("avatarSize ").append("[ ").append(MFFloat.toString(this.getAvatarSize())).append(" ]").append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("class")) continue;
                        stringClassicVRML.append(indentCharacter).append("class").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!this.getCssClass().equals("") || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("# class ").append("\"").append(SFString.toString(this.getCssClass())).append("\"").append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("headlight")) continue;
                        stringClassicVRML.append(indentCharacter).append("headlight").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!this.getHeadlight() || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("headlight ").append(SFBool.toString(this.getHeadlight())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("speed")) continue;
                        stringClassicVRML.append(indentCharacter).append("speed").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (this.getSpeed() != 1.0f || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("speed ").append(SFFloat.toString(this.getSpeed())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("transitionTime")) continue;
                        stringClassicVRML.append(indentCharacter).append("transitionTime").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (this.getTransitionTime() != 1.0 || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("transitionTime ").append(SFTime.toString(this.getTransitionTime())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("transitionType")) continue;
                        stringClassicVRML.append(indentCharacter).append("transitionType").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (this.getTransitionType().length > 0 || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("transitionType ").append("[ ").append(MFString.toString(this.getTransitionType())).append(" ]").append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("type")) continue;
                        stringClassicVRML.append(indentCharacter).append("type").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (this.getType().length > 0 || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("type ").append("[ ").append(MFString.toString(this.getType())).append(" ]").append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("visibilityLimit")) continue;
                        stringClassicVRML.append(indentCharacter).append("visibilityLimit").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (this.getVisibilityLimit() != 0.0f || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("visibilityLimit ").append(SFFloat.toString(this.getVisibilityLimit())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
            }
        }
        if (hasChild) {
            if (this.metadata != null) {
                stringClassicVRML.append(indentCharacter).append("metadata").append(" ");
                stringClassicVRML.append(((X3DConcreteElement)((Object)this.metadata)).toStringClassicVRML(indentLevel + indentIncrement));
                stringClassicVRML.append((CharSequence)indent);
            } else if (this.metadataProtoInstance != null) {
                stringClassicVRML.append(indentCharacter).append("metadata").append(" ");
                stringClassicVRML.append(((X3DConcreteElement)this.metadataProtoInstance).toStringClassicVRML(indentLevel + indentIncrement));
                stringClassicVRML.append((CharSequence)indent);
            }
            if (this.IS != null) {
                stringClassicVRML.append(((X3DConcreteElement)this.IS).toStringClassicVRML(indentLevel));
            }
            if (!this.commentsList.isEmpty()) {
                CommentsBlock commentsBlock = new CommentsBlock(this.commentsList);
                stringClassicVRML.append(commentsBlock.toStringClassicVRML(indentLevel));
                stringClassicVRML.append((CharSequence)indent);
            }
        }
        if (hasAttributes || hasChild) {
            stringClassicVRML.append("}").append("\n");
        }
        return stringClassicVRML.toString();
    }

    @Override
    public String toStringVRML97(int indentLevel) {
        return this.toStringClassicVRML(indentLevel);
    }

    @Override
    public X3DConcreteElement findElementByNameValue(String nameValue) {
        return this.findElementByNameValue(nameValue, "");
    }

    @Override
    public X3DConcreteElement findElementByNameValue(String nameValue, String elementName) {
        X3DConcreteElement referenceElement;
        if (nameValue == null || nameValue.isEmpty()) {
            String errorNotice = "findElementByNameValue(\"\", " + elementName + ") cannot use empty string to find a name attribute";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        if (this.IS != null && (referenceElement = ((X3DConcreteElement)this.IS).findElementByNameValue(nameValue, elementName)) != null) {
            return referenceElement;
        }
        if (this.metadata != null && (referenceElement = ((X3DConcreteElement)((Object)this.metadata)).findElementByNameValue(nameValue, elementName)) != null) {
            return referenceElement;
        }
        if (this.metadataProtoInstance != null && (referenceElement = ((X3DConcreteElement)this.metadataProtoInstance).findElementByNameValue(nameValue, elementName)) != null) {
            return referenceElement;
        }
        return null;
    }

    public boolean hasElementByNameValue(String nameValue, String elementName) {
        return this.findElementByNameValue(nameValue, elementName) != null;
    }

    @Override
    public X3DConcreteNode findNodeByDEF(String DEFvalue) {
        X3DConcreteNode referenceNode;
        if (DEFvalue == null || DEFvalue.isEmpty()) {
            String errorNotice = "findNodeByDEF(\"\") cannot use empty string to find a name";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        if (this.getDEF().equals(DEFvalue)) {
            return this;
        }
        if (this.IS != null && (referenceNode = ((X3DConcreteElement)this.IS).findNodeByDEF(DEFvalue)) != null) {
            return referenceNode;
        }
        if (this.metadata != null && (referenceNode = ((X3DConcreteElement)((Object)this.metadata)).findNodeByDEF(DEFvalue)) != null) {
            return referenceNode;
        }
        if (this.metadataProtoInstance != null && (referenceNode = ((X3DConcreteElement)this.metadataProtoInstance).findNodeByDEF(DEFvalue)) != null) {
            return referenceNode;
        }
        return null;
    }

    public boolean hasNodeByDEF(String DEFvalue) {
        return this.findNodeByDEF(DEFvalue) != null;
    }

    @Override
    public String validate() {
        this.validationResult = new StringBuilder();
        this.setAvatarSize(this.getAvatarSize());
        this.setHeadlight(this.getHeadlight());
        this.setSpeed(this.getSpeed());
        this.setTransitionTime(this.getTransitionTime());
        this.setTransitionType(this.getTransitionType());
        this.setType(this.getType());
        this.setVisibilityLimit(this.getVisibilityLimit());
        if (!this.isUSE()) {
            this.setDEF(this.getDEF());
        }
        if (this.isUSE()) {
            this.setUSE(this.getUSE());
        }
        this.setCssClass(this.getCssClass());
        if (this.IS != null) {
            this.setIS(this.getIS());
            ((X3DConcreteElement)this.IS).validate();
            this.validationResult.append(this.IS.getValidationResult());
        }
        if (this.isUSE() && this.hasIS()) {
            String errorNotice = "NavigationInfo USE='" + this.getUSE() + "' is not allowed to have contained SFNode IS";
            this.validationResult.append(errorNotice);
            throw new InvalidFieldValueException(errorNotice);
        }
        if (this.isUSE() && !this.commentsList.isEmpty()) {
            String errorNotice = "NavigationInfo USE='" + this.getUSE() + "' is not allowed to have contained comments";
            this.validationResult.append(errorNotice);
            throw new InvalidFieldValueException(errorNotice);
        }
        if (this.metadata != null) {
            this.setMetadata(this.getMetadata());
            ((X3DConcreteElement)((Object)this.metadata)).validate();
            this.validationResult.append(((X3DConcreteElement)((Object)this.metadata)).getValidationResult());
        }
        if (this.metadataProtoInstance != null) {
            this.setMetadata(this.getMetadataProtoInstance());
            ((X3DConcreteElement)this.metadataProtoInstance).validate();
            this.validationResult.append(this.metadataProtoInstance.getValidationResult());
        }
        if (this.metadata != null && this.metadataProtoInstance != null) {
            String errorNotice = "Internal X3DJSAIL error: incorrect handling of contained SFNode field, both metadata and metadataProtoInstance are set simultaneously";
            this.validationResult.append(errorNotice);
            throw new InvalidProtoException(errorNotice);
        }
        if (this.isUSE() && this.hasMetadata()) {
            String errorNotice = "NavigationInfo USE='" + this.getUSE() + "' is not allowed to have contained SFNode metadata";
            this.validationResult.append(errorNotice);
            throw new InvalidFieldValueException(errorNotice);
        }
        if (this.isUSE() && !this.commentsList.isEmpty()) {
            String errorNotice = "NavigationInfo USE='" + this.getUSE() + "' is not allowed to have contained comments";
            this.validationResult.append(errorNotice);
            throw new InvalidFieldValueException(errorNotice);
        }
        if (this.getIS() != null && this.getIS().getConnectList().isEmpty()) {
            String errorNotice = "IS statement present, but contains no connect statements";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidProtoException(errorNotice);
        }
        if (!this.getContainerFieldOverride().isEmpty() && !Arrays.asList(this.containerField_ALTERNATE_VALUES).contains(this.getContainerFieldOverride())) {
            String errorNotice = "ERROR_ILLEGAL_VALUE: illegal value encountered, containerField='" + this.getContainerFieldOverride() + "' but allowed values are containerField_ALTERNATE_VALUES='" + new MFString(this.containerField_ALTERNATE_VALUES).toStringX3D() + "'.";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldException(errorNotice);
        }
        if (this.findAncestorX3D() != null) {
            String modelProfile = this.findAncestorX3D().getProfile();
            boolean hasSatisfactorySupport = this.findAncestorX3D().supportsX3dComponent(COMPONENT, 1);
            if (!hasSatisfactorySupport) {
                String errorNotice = "ERROR_ILLEGAL_VALUE insufficient X3D profile='" + modelProfile + "' for parent X3D model containing 'NavigationInfo' node, add head statement <component name='Navigation' level='1'/>\nor Java source-code assignment:  findAncestorX3D().getHead().addComponent(\"Navigation\").setLevel(1);";
                this.validationResult.append(errorNotice).append("\n");
                throw new InvalidFieldException(errorNotice);
            }
        }
        return this.validationResult.toString();
    }
}

