/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.x3d.jsail.fields;

import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.web3d.x3d.jsail.fields.SFInt32;
import org.web3d.x3d.jsail.fields.X3DConcreteField;
import org.web3d.x3d.sai.InvalidFieldValueException;

public class MFInt32
extends X3DConcreteField
implements org.web3d.x3d.sai.MFInt32 {
    public static final String NAME = "MFInt32";
    public static final int[] DEFAULT_VALUE = new int[0];
    public static final String DEFAULT_VALUE_STRING = "";
    public static final int TUPLE_SIZE = 1;
    public static final String REGEX = "(\\s)*([+-]?(0|[1-9][0-9]*)([Ee][+-]?[0-9]+)?\\s*,?\\s*)*";
    public static final Pattern PATTERN = Pattern.compile("(\\s)*([+-]?(0|[1-9][0-9]*)([Ee][+-]?[0-9]+)?\\s*,?\\s*)*");
    private static boolean priorRegexStackOverflowFound = false;
    private int[] MFInt32 = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);

    public static final boolean isArray() {
        return true;
    }

    public MFInt32() {
        this.initialize();
    }

    @Override
    public final void initialize() {
        this.MFInt32 = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
    }

    public boolean equals(MFInt32 comparisonMFInt32) {
        return this.getPrimitiveValue() == comparisonMFInt32.getPrimitiveValue();
    }

    public final String validate() {
        MFInt32 tempHold = new MFInt32(this.getPrimitiveValue());
        if (!this.equals(tempHold)) {
            return "MFInt32 validate() error: failed get/set round-trip test";
        }
        return DEFAULT_VALUE_STRING;
    }

    public final String validateRegex() {
        try {
            Matcher m = PATTERN.matcher(this.toString());
            if (!m.matches()) {
                String errorNotice = "*** Regular expression (regex) failure, new MFInt32 PATTERN mismatch (\"" + this.toString() + "\")";
                return errorNotice;
            }
        }
        catch (StackOverflowError soe) {
            String validationMessage = "java.lang.StackOverflow warning: regular expression (regex) unable to evaluate large corresponding String value for MFInt32 array";
            validationResult.append(validationMessage).append("\n");
            System.out.println("*** " + validationMessage);
            return validationMessage;
        }
        return DEFAULT_VALUE_STRING;
    }

    public final boolean matches() {
        try {
            Matcher m = PATTERN.matcher(this.toString());
            return m.matches();
        }
        catch (StackOverflowError soe) {
            String validationMessage = "java.lang.StackOverflow warning: regular expression (regex) unable to evaluate large corresponding String value for MFInt32 array";
            validationResult.append(validationMessage).append("\n");
            System.out.println("*** " + validationMessage);
            return false;
        }
    }

    public static final boolean matches(String value) {
        Matcher m = PATTERN.matcher(value);
        return m.matches();
    }

    public MFInt32 setValueByString(String newValue) throws InvalidFieldValueException {
        if (newValue == null) {
            newValue = new String();
        }
        if (!org.web3d.x3d.jsail.fields.MFInt32.matches(newValue)) {
            String errorNotice = "*** Regular expression (regex) failure, new MFInt32(" + newValue + ")";
            validationResult.append(errorNotice).append("\n");
        }
        if (newValue.trim().isEmpty()) {
            this.MFInt32 = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
            return this;
        }
        try {
            String[] newValues = newValue.replace(",", " ").trim().split("\\s+");
            this.MFInt32 = new int[newValues.length];
            for (int i = 0; i < newValues.length; ++i) {
                this.MFInt32[i] = newValues[i].startsWith("0x") ? Integer.decode(newValues[i]) : Integer.parseInt(newValues[i]);
            }
        }
        catch (NumberFormatException e) {
            String errorNotice = "new MFInt32(" + newValue + ") " + e.getMessage();
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        return this;
    }

    public MFInt32(int newValue) {
        this.setValue(new SFInt32(newValue));
    }

    public MFInt32(SFInt32 newValue) {
        if (newValue == null) {
            this.MFInt32 = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
            return;
        }
        this.MFInt32 = new int[1];
        this.MFInt32[0] = newValue.getValue();
    }

    public MFInt32(MFInt32 newValue) {
        if (newValue == null) {
            this.MFInt32 = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
            return;
        }
        this.MFInt32 = newValue.getPrimitiveValue();
    }

    public MFInt32(int[] newValue) {
        if (newValue == null) {
            newValue = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
        }
        this.MFInt32 = newValue;
    }

    public static String toString(int[] value) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < value.length; ++i) {
            result.append(value[i]).append(" ");
        }
        return result.toString().trim();
    }

    @Override
    public void getValue(int[] valueDestination) {
        valueDestination = this.MFInt32;
    }

    public int[] getPrimitiveValue() {
        return this.MFInt32;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < this.MFInt32.length; ++i) {
            result.append(String.valueOf(this.MFInt32[i]));
            if (i >= this.MFInt32.length - 1) continue;
            result.append(" ");
        }
        return result.toString();
    }

    public String toStringHexadecimal() {
        StringBuilder resultBuilder = new StringBuilder();
        for (int i = 0; i < this.MFInt32.length; ++i) {
            resultBuilder.append("0x").append(Integer.toHexString(this.MFInt32[i]));
            if (i >= this.MFInt32.length - 1) continue;
            resultBuilder.append(" ");
        }
        return resultBuilder.toString();
    }

    @Override
    public int get1Value(int index) {
        if (index < 0) {
            String errorNotice = "Index value is negative, thus cannot get1Value at index=" + index + ".";
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        if (this.MFInt32.length == 0) {
            String errorNotice = "Value array is empty, thus cannot get1Value at index=" + index + ".";
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        if (index >= this.MFInt32.length / 1) {
            String errorNotice = "Provided array index=" + index + " must be less than MFInt32 array length=" + this.MFInt32.length / 1;
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        return this.MFInt32[index];
    }

    @Override
    public void setValue(int size, int[] newValue) {
        if (newValue == null) {
            throw new InvalidFieldValueException(" newValue is null and cannot be set");
        }
        if (size < 0) {
            throw new InvalidFieldValueException("requested setValue() array-copy size=" + size + " is negative");
        }
        if (size > newValue.length) {
            throw new InvalidFieldValueException("requested setValue() array-copy size=" + size + " is greater than newValue.length()=" + newValue.length);
        }
        this.MFInt32 = Arrays.copyOf(newValue, size);
    }

    public void setValue(int[] newValue) {
        if (newValue == null) {
            newValue = new int[]{};
        }
        this.MFInt32 = new int[newValue.length];
        this.MFInt32 = newValue;
    }

    public void setValue(int newValue) {
        this.MFInt32 = new int[1];
        this.MFInt32[0] = newValue;
    }

    public MFInt32 setValue(SFInt32 newValue) {
        if (newValue == null) {
            this.MFInt32 = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
            return this;
        }
        this.MFInt32 = new int[1];
        this.MFInt32[0] = newValue.getValue();
        return this;
    }

    @Override
    public void set1Value(int index, int newValue) throws ArrayIndexOutOfBoundsException {
        if (index < 0) {
            String errorNotice = "Index value is negative, thus cannot set1Value at index=" + index + ".";
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        if (this.MFInt32.length == 0) {
            String errorNotice = "Value array is empty, thus cannot set1Value at index=" + index + ".";
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        if (index >= this.MFInt32.length / 1) {
            String errorNotice = "Provided array index=" + index + " must be less than MFInt32 array length=" + this.MFInt32.length / 1;
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        this.MFInt32[index] = newValue;
    }

    @Override
    public void append(int newValue) {
        this.MFInt32 = Arrays.copyOf(this.MFInt32, this.MFInt32.length + 1);
        this.MFInt32[this.MFInt32.length - 1] = newValue;
    }

    public void append(int[] newValue) {
        if (newValue.length % 1 != 0) {
            String errorNotice = "illegal number of values (" + newValue.length + ") in initialization array, must be multiple of 4 when declaring new MFVec4f(" + newValue + ")";
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        int originalLength = this.MFInt32.length;
        this.MFInt32 = Arrays.copyOf(this.MFInt32, this.MFInt32.length + newValue.length);
        for (int i = 0; i < newValue.length; ++i) {
            this.MFInt32[originalLength + i] = newValue[i];
        }
    }

    public MFInt32 append(SFInt32 newValue) {
        this.append(newValue.getPrimitiveValue());
        return this;
    }

    public MFInt32 append(MFInt32 newValue) {
        this.append(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public void insertValue(int index, int newValue) {
        if (index < 0) {
            String errorNotice = "Index value is negative, thus cannot insertValue at index=" + index + ".";
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        if (index >= this.MFInt32.length) {
            String errorNotice = "Provided array index=" + index + " must be less than MFInt32 array length=" + this.MFInt32.length;
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        int sliceLength = this.MFInt32.length - index;
        this.MFInt32 = Arrays.copyOf(this.MFInt32, this.MFInt32.length + 1);
        System.arraycopy(this.MFInt32, index, this.MFInt32, index + 1, sliceLength);
        this.MFInt32[index] = newValue;
    }

    @Override
    public int size() {
        return this.MFInt32.length;
    }

    @Override
    public void clear() {
        this.MFInt32 = new int[0];
    }

    @Override
    public void remove(int index) {
        if (index < 0) {
            String errorNotice = "Index value is negative, thus cannot remove() value at index=" + index + ".";
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        if (this.MFInt32.length == 0) {
            String errorNotice = "Value array is empty, thus cannot remove value at index=" + index + ".";
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        if (index >= this.MFInt32.length) {
            String errorNotice = "Provided array index=" + index + " must be less than MFInt32 array length=" + this.MFInt32.length;
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        int offsetLength = this.MFInt32.length - (index + 1) * 1;
        System.arraycopy(this.MFInt32, (index + 1) * 1, this.MFInt32, index * 1, offsetLength);
        this.MFInt32 = Arrays.copyOfRange(this.MFInt32, 0, this.MFInt32.length - 1);
    }

    public MFInt32 setValue(MFInt32 newValue) {
        if (newValue == null) {
            this.MFInt32 = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
            return this;
        }
        this.MFInt32 = newValue.getPrimitiveValue();
        return this;
    }

    public MFInt32 multiply(int scaleFactor) {
        int i = 0;
        while (i < this.MFInt32.length) {
            int n = i++;
            this.MFInt32[n] = this.MFInt32[n] * scaleFactor;
        }
        return this;
    }

    public boolean isDefaultValue() {
        return Arrays.equals(this.MFInt32, DEFAULT_VALUE);
    }

    static {
        try {
            Pattern.compile(REGEX);
            if (!new MFInt32(DEFAULT_VALUE).matches()) {
                System.out.println("MFInt32.initialize() problem: failed to match DEFAULT_VALUE=" + Arrays.toString(DEFAULT_VALUE));
            }
        }
        catch (PatternSyntaxException exception) {
            System.out.println("Exception in MFInt32 initialization testing, regex pattern compilation failure.");
            System.out.println("REGEX=\"(\\s)*([+-]?(0|[1-9][0-9]*)([Ee][+-]?[0-9]+)?\\s*,?\\s*)*\"");
            System.out.println(exception.getDescription());
        }
    }
}

